function DATA = bst_extractmarkersctf(DS_FOLDER, MARKER_RANGE, CHANNELS, MARKERS, MARKERPARAM, VERBOSE);
%BST_EXTRACTMARKERSCTF - Extract signal block from a .ds CTF data set
% function DATA = bst_extractmarkersctf(DS_FOLDER, MARKER_RANGE, CHANNELS, MARKERS, MARKERPARAM, VERBOSE);
%
% EXTRACT_MARKERS
% Extract signal block from a .ds CTF data set based on the Markers information in the Markerfile

%<autobegin> ---------------------- 14-Jun-2004 17:09:51 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Data Processing
%
% Alphabetical list of external functions (non-Matlab):
%   toolbox\ds2brainstorm.m
%
% At Check-in: $Author: Mosher $  $Revision: 17 $  $Date: 6/14/04 3:37p $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 14-Jun-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 14-Jun-2004 17:09:51 -----------------------

% History ---------------------------------------
% -- Sylvain Baillet, Ph.D.
% Cognitive Neuroscience & Brain Imagin Laboratory - CNRS - Paris France
% March 2001
% JCM 08-Sep-2003 commenting
% -----------------------------------------------

% MARKER_RANGE = [0 .128];
% CHANNELS = [31:181]; % Channels to extract
% DS_FOLDER = 'D:\Users\Silvin\BrainStorm\studies\IRCAM\steady3.ds';
% 
 ONLINE_AV = 0; % if set to 1, runs the online average of each trial and does not return the original data.
 ONLINE_SW_AV = 0; % Same thing but for sample-weighted average 
% MARKERS = [2]; % Array of markers to be read from the file - if empty, reads out all trials from all markers
% 
% VERBOSE = 1;

% [MARKERPARAM.names,MARKERPARAM.nsamples ,MARKERPARAM.trial_time] = bst_readmarkerfilectf(DS_FOLDER);

n_markers = length(MARKERPARAM.nsamples);

if isempty(MARKERS)
    MARKERS = 1:n_markers;
end

n_markers = length(MARKERS);

for i = MARKERS

    % Are there several time from sync points for this marker ? 
    utime = unique(MARKERPARAM.trial_time{i}(:,2));
    if length(utime) == 1 % NO
        % Read all trials at once
        %F = ds2brainstorm(DS_FOLDER,VERBOSE,0,CHANNELS,MARKER_RANGE,MARKERPARAM.trial_time{i}(:,1)');
        F = ds2brainstorm(DS_FOLDER,VERBOSE,0,CHANNELS,MARKERPARAM.trial_time{i}(2)+MARKER_RANGE,MARKERPARAM.trial_time{i}(1));

        % F is a MARKERPARAM.trial_time{i}(:,1)-long cell array
        %        DATA{i}  = zeros(length(CHANNELS),size(F{1},2),MARKERPARAM.nsamples(i)));
        for k = 1:length(MARKERPARAM.trial_time{i}(:,1))
            DATA{i}(:,:,k) = F{k};
            F{k} = [];
        end
        clear F
        
    else % YES
        % Read trial by trial
        for k = 1:MARKERPARAM.nsamples(i)
            F = ds2brainstorm(DS_FOLDER,VERBOSE,0,CHANNELS,MARKERPARAM.trial_time{i}(k,2)+MARKER_RANGE,MARKERPARAM.trial_time{i}(k,1));
            if k>1
                if size(F{1},2) < size(DATA{i},2)
                    error('Please check the duration of MARKER_RANGE')
                else
                    F{1} = F{1}(:,1:size(DATA{i},2));
                end
            else
                if ONLINE_AV == 0;
                    DATA{i} = zeros(length(CHANNELS),size(F{1},2),MARKERPARAM.nsamples(i));
                else
                    DATA{i} = zeros(length(CHANNELS),size(F{1},2));
                end
                
            end

            if ONLINE_AV == 0
                DATA{i}(:,:,k) = F{1};
            else
                DATA{i} = DATA{i}+F{1}/MARKERPARAM.nsamples(i);
            end
            
            
            if VERBOSE
                fprintf('Trial %d\n',k);
            end
            
            clear F
        end
        
    end
    
end

% This part for averaging only

% 
% for i = 1:n_markers
%     data_av{i} = mean(DATA{i},3);
%     figure, plot(MARKER_RANGE(1):1/SAMPLING_RATE:MARKER_RANGE(2),data_av{i}')
%     title(['Marker ',num2str(i)])
% end



