function [marker_names,n_samples ,trial_time] = bst_readmarkerfilectf(DS_FOLDER);
%BST_READMARKERFILECTF - read_markerf reads the CTF markerfile MarkerFile.mrk
% function [marker_names,n_samples ,trial_time] = bst_readmarkerfilectf(DS_FOLDER);
% function trial_time = read_markerf(DS_FOLDER);
% read_markerf reads the CTF markerfile MarkerFile.mrk located in the DS_FOLDER folder
% (a .ds CTF data set  folder) and returns
% 
% marker_names is a cell array of strings containing the name of the markers
% n_samples a corresponding cell array; each cell containing the number of events per marker
% trial_time, a cell array - The content of each cell, trial_time{i}, is a N x 2 matrix related to the occurences of marker i  
% trial_time{i}(:,1) contains the trial numbers where marker i occured
% trial_time{i}(:,2) contains the corresponding time from sync point in the corresponding trial
% 
% 
% -- Sylvain Baillet, Ph.D.
% Cognitive Neuroscience & Brain Imagin Laboratory - CNRS UPR640- Paris France
% March 2001

%<autobegin> ---------------------- 26-May-2004 11:29:44 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Data Processing
%
% At Check-in: $Author: Mosher $  $Revision: 15 $  $Date: 5/26/04 9:59a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:29:44 -----------------------



VERBOSE = 1;

if ~exist(fullfile(DS_FOLDER,'MarkerFile.mrk'),'file');
    error(['MarkerFile MarkerFile.mrk does not exist in directory ',DS_FOLDER]);
    return
end

mrkr =  textread(fullfile(DS_FOLDER,'MarkerFile.mrk'),'%s','delimiter','\n'); % Store everything in a cell array of string

id = find(strcmp(mrkr,'NUMBER OF MARKERS:'));
n_markers  = str2num(mrkr{id+1});

id = find(strcmp(mrkr,'NAME:'));
marker_names = mrkr(id+1);

id = find(strcmp(mrkr,'NUMBER OF SAMPLES:'));
n_samples  = str2num(char(mrkr(id+1)));

mrkr_info = strmatch('TRIAL NUMBER',mrkr)+1; % Lines  where the marker times/trial info start

for i = 1:n_markers
    trial_time{i} = str2num(char(mrkr(mrkr_info(i):mrkr_info(i)+n_samples(i)))); 
    trial_time{i}(:,1) = trial_time{i}(:,1) + 1; 
end
