function varargout = bst_splashscreen(varargin)
%BST_SPLASHSCREEN - GUI app for license information and agreement
% function varargout = bst_splashscreen(varargin)
%    FIG = BST_SPLASHSCREEN launch bst_splashscreen GUI.
%    BST_SPLASHSCREEN('callback_name', ...) invoke the named callback.
%
% Main operation is to set or clear the group 'BrainStorm' preference 
%  'DateofAgreement' to be today's date. Startup.m then checks this preference
%  and continues or denies BrainStorm execution

%<autobegin> ---------------------- 26-May-2004 11:29:47 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: GUI and Related
%
% Alphabetical list of external functions (non-Matlab):
%   toolbox\bst_color_scheme.m
%   toolbox\bst_layout.m
%   toolbox\bst_message_window.m
%
% Subfunctions in this file, in order of occurrence in file:
%   initialize_gui(fig,eventdata,handles);
%   small_message_window;
%   varargout = pushbutton_agree_Callback(h, eventdata, handles, varargin)
%   varargout = pushbutton_disagree_Callback(h, eventdata, handles, varargin)
%   varargout = pushbutton_more_info_Callback(h, eventdata, handles, varargin)
%
% Group : Preference data and their calls in this file:
%   'BrainStorm' : 'DateofAgreement'
%   
%   setpref('BrainStorm','DateofAgreement',' ');
%   setpref('BrainStorm','DateofAgreement',datestr(floor(now)));
%   
%   L = getpref('BrainStorm','Layout');
%
% Application data and their calls in this file:
%   'TileType'
%   
%   setappdata(fig,'TileType','T');
%   
%   fig = getappdata(0,'BrainStormMessageWindow');
%
% Figure Files opened by this function:
%   mfilename
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback by Matlab default
%
% Callbacks by figure bst_splashscreen.fig
%   axes::axes_splash "" uses CreateFcn for movegui center
%   uicontrol:pushbutton:pushbutton_agree "Yes" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_disagree "No" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_more_info "More Information" uses Callback for <automatic>
%
% At Check-in: $Author: Mosher $  $Revision: 19 $  $Date: 5/26/04 9:59a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:29:47 -----------------------

% ----------------------------------------------------------------
% JCM 3 May 2002, bst_message_window upgrades to "wrap" text.
% JCM 2-Nov-2002  minor changes to appearance of .fig, some commenting
% SB  18-Feb-2003 Changed call to splashcreen image
% JCM 19-May-2003 bst_layout compatibility
% ----------------------------------------------------------------

% Last Modified by GUIDE v2.0 22-May-2002 10:27:37

if nargin == 0  % LAUNCH GUI

	fig = openfig(mfilename,'reuse'); % figure is initially invisible

    % the splash screen is custom color and font and will not be run through bst_color_scheme
    
    % Generate a structure of handles to pass to callbacks, and store it. 
    handles = guihandles(fig);
    guidata(fig, handles);

    set(fig,'handlevisibility','on'); %make sure visible to imagesc command
    
    % custom create commands
    bst_color_scheme(fig);
    setappdata(fig,'TileType','T'); % field tile
    set(handles.copyright,'fontunits','points','fontsize',8);
    bst_layout('align',fig,1,1,1); % one large tile

    initialize_gui(fig,[],handles);

elseif ischar(varargin{1}) % INVOKE NAMED SUBFUNCTION OR CALLBACK

	try
		if (nargout)
			[varargout{1:nargout}] = feval(varargin{:}); % FEVAL switchyard
		else
			feval(varargin{:}); % FEVAL switchyard
		end
	catch
		disp(lasterr);
	end

end


% ------------------------- local functions --------------------
function initialize_gui(fig,eventdata,handles);
% load up the current logo and draw it to the axes
logo = imread('logobrainstorm','jpg'); % Sb Feb 18, 2003 - changed to lowercase image name
set(0,'CurrentFigure',fig); % make sure it's the gcf
set(fig,'CurrentAxes',handles.axes_splash); % make sure it's the gca
LOGO = imagesc(logo);
axis off

% Template:

% Copyright (c) 2003 BrainStorm by the University of Southern California. 
% This software was generated primarily with support of grants from the 
% National Institute of Mental Health (R01 MH53213) and the National Institute of Biomedical Imaging and Bioengineering (R01 EB000363). 
%
% Principal Investigator: 
%
%	Richard M. Leahy, PhD Signal & Image Processing Institute, University of 	Southern California, Los Angeles, CA. 
% 
% Primary Developers and Collaborators: 
% 
% 	John C. Mosher, PhD, Biophysics Group, Los Alamos National Laboratory, Los 	Alamos NM. 
% 
% 	Sylvain Baillet, PhD, CNRS Cognitive Neuroscience & Brain Imaging 	Laboratory, Hopital de la Salpetriere, Paris, France. 
% 
% THE SOFTWARE IS PROVIDED "AS IS," AND THE UNIVERSITY OF SOUTHERN 
% CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY WARRANTY, EXPRESS OR IMPLIED, 
% INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
% PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY LIABILITY OR RESPONSIBILITY FOR THE 
% USE OF THIS SOFTWARE. 
% 
% BrainStorm (which is the collection of files listed in the Contents.m file 
% included with each distribution) is free but copyrighted software, distributed 
% under the terms of the GNU General Public License as published by the Free 
% Software Foundation. Further details on the GPL license can be found at 
% http://www.gnu.org/copyleft/gpl.html. This license specifies the terms and conditions for use, copying, distribution and modification which. Through 
% the use of this software, users agree to be bound by the terms and 
% conditions of the GPL license.



% Arrange in cells such that textwrap returns nicely. Blank cells add nice spacing.
CopyCell = {...
   sprintf('COPYRIGHT (c) %s BrainStorm by the University of Southern California.',datestr(now,10)')...
      '',...
      'This sofware was generated primarily with support of grants from the National Institute of Mental Health (R01 MH53213) and the National Institute of Biomedical Imaging and Bioengineering (R01 EB000363).',...
      'Principal Investigator:',...
      'Richard M. Leahy, PhD Signal & Image Processing Institute, University of 	Southern California, Los Angeles, CA',...
      'Primary Developers and Collaborators:',...
      'John C. Mosher, PhD, Biophysics Group, Los Alamos National Laboratory, Los Alamos, NM',...
      'Sylvain Baillet, PhD, CNRS Cognitive Neuroscience & Brain Imaging Laboratory, Hopital de la Salpetriere, Paris, France',...
      '',...
      'RESEARCH USE ONLY! THIS SOFTWARE IS PROVIDED "AS IS," AND THE UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.'...
      '',...
      'BrainStorm (which is the collection of files listed in the Contents.m file included with each distribution) is free but copyrighted software, distributed under the terms of the GNU General Public License as published by the Free Software Foundation. Further details on the GPL license can be found at http://www.gnu.org/copyleft/gpl.html. This license specifies the terms and conditions for use, copying, distribution and modification. Through the use of this software, users agree to be bound by the terms and conditions of the GPL license.',...
   };

OutString = textwrap(handles.copyright,CopyCell);

%set(handles.copyright,'Fontname','default','FontSize',10); % explicit set necessary to keep font controlled
set(handles.copyright,'String',OutString);

set(fig,'visible','on'); % show now after creating
bst_message_window({'','Please answer the copyright notice window.'});

% also display to the command window
for i = 1:length(CopyCell),
   disp(CopyCell{i})
end


% Wait for callbacks to run and window to be dismissed:
uiwait(fig);


% ---------------------- Make the message window small -------------------------
function small_message_window;

% find the BrainStorm Message Window
fig = getappdata(0,'BrainStormMessageWindow');

L = getpref('BrainStorm','Layout'); % the current settings

set(fig,'Position',L.winpos(1,:));


% --------------------------------------------------------------------
function varargout = pushbutton_agree_Callback(h, eventdata, handles, varargin)

% setpref to show date of agreement

small_message_window;

bst_message_window('Acknowledged');

setpref('BrainStorm','DateofAgreement',datestr(floor(now)));

close(handles.SPLASHSCREEN); % close the window





% --------------------------------------------------------------------
function varargout = pushbutton_disagree_Callback(h, eventdata, handles, varargin)

small_message_window;

bst_message_window('Declined');

% setpref to show date of agreement as blank
% BUG: getpref does not recognize null answers in R12.1, use blank instead

setpref('BrainStorm','DateofAgreement',' ');

close(handles.SPLASHSCREEN); % close the window



% --------------------------------------------------------------------
function varargout = pushbutton_more_info_Callback(h, eventdata, handles, varargin)

% template:

% Copyright and Software Support
% 
% Brainstorm is software written in MATLAB for the analysis and visualization of
% MEG and EEG data. We provide routines for computing forward models based on
% spherical and realistic boundary element methods. These latter require that
% you provide a tessellated representation of the brain, skull and scalp for use
% in these calculations. Inverse methods include dipole fitting based on the
% MUSIC scanning method and cortically constrained minimum norm imaging. We also
% include software for volumetric and surface rendering of  inverse solutions.
% The methods implemented in this software are described in  our publications,
% which can be accessed at http://neuroimage.usc.edu. We  have provided a
% graphical user interface to our software, but all of the basic functions can
% be called from the command line and are documented at the BrainStorm website. 
% 
% This software was generated primarily with support of grants from the 
% National Institute of Mental Health (R01 MH53213) and the National Institute
% of Biomedical Imaging and Bioengineering (R01 EB000363). The project is a
% close collaboration between the Principal Investigator at USC, Richard M.
% Leahy, PhD, and his colleagues: John C. Mosher, PhD, (Biophysics Group, Los
% Alamos National Laboratory, Los Alamos NM) and Sylvain Baillet, PhD, (CNRS
% Cognitive Neuroscience & Brain Imaging 	Laboratory, Hopital de la Salpetriere,
% Paris, France). Other contributors to the software are identified in the help
% files for the specific functions to which they contributed. 
% 
% BrainStorm (which is the collection of files listed in the Contents.m file 
% included with each distribution) is free but copyright software, distributed 
% under the terms of the GNU General Public License as published by the Free 
% Software Foundation. Further details on the GPL license can be found at 
% http://www.gnu.org/copyleft/gpl.html. This license specifies terms and
% conditions for use, copying, distribution and modification of BrainStorm.
% Through the use of this software, users agree to be bound by the terms and
% conditions of the GPL license. 
% 
% THE SOFTWARE IS PROVIDED "AS IS," AND THE UNIVERSITY OF SOUTHERN  CALIFORNIA
% AND ITS COLLABORATORS DO NOT MAKE ANY WARRANTY, EXPRESS OR IMPLIED,  INCLUDING
% BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A  PARTICULAR
% PURPOSE, NOR DO THEY ASSUME ANY LIABILITY OR RESPONSIBILITY FOR THE  USE OF
% THIS SOFTWARE. 
% 
% Please note that while we have endeavored to make BrainStorm robust and easy
% to use, we are not professional programmers, nor do we have the resources to
% fully support this software. We have provided various levels of online
% tutorial and documentation and have also set up a FORUM for registered users
% and developers to communicate. We will also periodically release updated code
% and documentation. While we will attempt to resolve serious issues that arise
% in the FORUM discussions, we cannot guarantee a response to specific questions
% nor are the individual authors of the software available to answer questions
% about the software. 

par1 = 'Copyright and Software Support';

% one long string
par2 = [...
'Brainstorm is software written in MATLAB for the analysis and visualization of ',...
'MEG and EEG data. We provide routines for computing forward models based on ',...
'spherical and realistic boundary element methods. These latter require that ',...
'you provide a tessellated representation of the brain, skull and scalp for use ',...
'in these calculations. Inverse methods include dipole fitting based on the ',...
'MUSIC scanning method and cortically constrained minimum norm imaging. We also ',...
'include software for volumetric and surface rendering of  inverse solutions. ',...
'The methods implemented in this software are described in  our publications, ',...
'which can be accessed at http://neuroimage.usc.edu. We  have provided a ',...
'graphical user interface to our software, but all of the basic functions can ',...
'be called from the command line and are documented at the BrainStorm website.'];

par3 = [...
'This software was generated primarily with support of grants from the ',...
'National Institute of Mental Health (R01 MH53213) and the National Institute ',...
'of Biomedical Imaging and Bioengineering (R01 EB000363). The project is a ',...
'close collaboration between the Principal Investigator at USC, Richard M. ',...
'Leahy, PhD, and his colleagues: John C. Mosher, PhD, (Biophysics Group, Los ',...
'Alamos National Laboratory, Los Alamos NM) and Sylvain Baillet, PhD, (CNRS ',...
'Cognitive Neuroscience & Brain Imaging 	Laboratory, Hopital de la Salpetriere, ',...
'Paris, France). Other contributors to the software are identified in the help ',...
'files for the specific functions to which they contributed.'];

par4 = [...
'BrainStorm (which is the collection of files listed in the Contents.m file ',...
'included with each distribution) is free but copyright software, distributed ',...
'under the terms of the GNU General Public License as published by the Free ',...
'Software Foundation. Further details on the GPL license can be found at ',...
'http://www.gnu.org/copyleft/gpl.html. This license specifies terms and ',...
'conditions for use, copying, distribution and modification of BrainStorm. ',...
'Through the use of this software, users agree to be bound by the terms and ',...
'conditions of the GPL license.'];

par5 = [...
'THE SOFTWARE IS PROVIDED "AS IS," AND THE UNIVERSITY OF SOUTHERN  CALIFORNIA ',...
'AND ITS COLLABORATORS DO NOT MAKE ANY WARRANTY, EXPRESS OR IMPLIED,  INCLUDING ',...
'BUT NOT LIMITED TO WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A  PARTICULAR ',...
'PURPOSE, NOR DO THEY ASSUME ANY LIABILITY OR RESPONSIBILITY FOR THE  USE OF ',...
'THIS SOFTWARE.'];

par6 = [...
'Please note that while we have endeavored to make BrainStorm robust and easy ',...
'to use, we are not professional programmers, nor do we have the resources to ',...
'fully support this software. We have provided various levels of online ',...
'tutorial and documentation and have also set up a FORUM for registered users ',...
'and developers to communicate. We will also periodically release updated code ',...
'and documentation. While we will attempt to resolve serious issues that arise ',...
'in the FORUM discussions, we cannot guarantee a response to specific questions ',...
'nor are the individual authors of the software available to answer questions ',...
'about the software.'];


par7 = [...
      'Please answer the Copyright notice window.'];

OutString = {' ',par1,' ',par2,' ',par3,' ',par4,' ',par5,' ',par6,' ',par7};

% enlarge the message window for easier viewing
% Make it the same size as a single field tile i.e. 1,1,1

% find the BrainStorm Message Window
fig = getappdata(0,'BrainStormMessageWindow');

L = getpref('BrainStorm','Layout'); % the current settings


% put in the lower left of the BST window, with height of one tile
set(fig, 'Position', [L.ScreenPosition(1:2) L.tilepos{1,1}(3:4)]);

figure(fig); % bring to the front

bst_message_window('wrap',OutString);

% also display to the command window for copying
for i = 1:length(OutString),
   disp(OutString{i}) % display to command window as long lines
end
