function [Cmap,map]=catci(acti,Cmap,M,cThres)
%CATCI - computing color coding for activation on the vertices
% function [Cmap,map]=catci(acti,Cmap,M,cThres)
%
%	computing color coding for activation on the vertices
%
%  inputs : acti : vector containing activation, Cmap : colormap containing deepness coding on the vertices; M a value that indicates the maximum of activation for relative color mapping
%  outputs : Cmap : colormap containing deepnes and activation coding on the vertices, map : colormap for the coding of activation         
%

%<autobegin> ---------------------- 26-May-2004 11:29:53 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Visualization
%
% At Check-in: $Author: Mosher $  $Revision: 15 $  $Date: 5/26/04 9:59a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:29:53 -----------------------



% threshold for activation
MaxActi = max(abs(acti(:)));
acti=abs(acti)/MaxActi;

if nargin == 2
    M = MaxActi;
    cThres = 0;
elseif nargin == 3
    cThres = 0;
end

MAX = MaxActi/M; % Colormapping relative to maximum M
v_actthres=find(MAX*acti>=cThres/100);
acti_thres=acti(v_actthres);

% spreading of activationsize9)
%acti_thres = (acti_thres-min(acti))/(max(acti_thres-min(acti)));
%acti_thres = MAX*acti_thres/max(acti_thres);
acti_thres = acti_thres/max(acti_thres);

clear acti;

%C_contrast=sum(Cmap,2)/3;
%C_contrast=.35*ones(size(Cmap(:,1)));%Cmap(:,1); % Assume grey levels for depth coding
C_contrast = Cmap(v_actthres,1); % Assume grey levels for depth coding / do .8*Cmap(v_actthres,1) for darker colors


% coding of activation itself
CR=ones(size(v_actthres,1),1);
CG=CR;
CB=CR;

% % Processing of the RED colormap
% maxx = MAX./C_contrast;
% minn = ones(size(maxx)); 
% x1 = 0; x2 = 48/128;
% I1=find(acti_thres<=x2);
% CR(I1)= ((acti_thres(I1)-x1)/(x2-x1)).*(maxx(I1)-minn(I1))+minn(I1);
% I1=find(acti_thres>x2);
% CR(I1) = maxx(I1);%*(ones(size(I1,1),1));
% 
% %Processing of the GREEN & BLUE colormaps
% x1 = 0; x2 = 64/128;
% I1=find(acti_thres<=x2);
% CG(I1) = minn(I1);%*(ones(size(I1,1),1));
% CB(I1) = minn(I1);%*(ones(size(I1,1),1));
% 
% x1 = 64/128; x2 = 128/128;
% I1=find(acti_thres>x1 & acti_thres<=x2);
% CG(I1)= ((acti_thres(I1)-x1)/(x2-x1)).*(maxx(I1)-minn(I1))+minn(I1);
% CB(I1) = minn(I1);%*(ones(size(I1,1),1));
% 

% Processing of the RED colormap
maxx = 1./C_contrast;
minn = ones(size(maxx)); 
x1 = 0; x2 = 84/128/MAX;
K = 1;

I1=find(acti_thres<=x2);
CR(I1)= ((acti_thres(I1)-x1)/(x2-x1)).*(maxx(I1)-K*minn(I1))+K*minn(I1);
CG(I1)= K*minn(I1);
CB(I1)= K*minn(I1);

I1=find(acti_thres > x2);
CR(I1) = maxx(I1);%*(ones(size(I1,1),1));

%Processing of the GREEN & BLUE colormaps
x1 = 84/MAX/128; x2 = 128/MAX/128;
I1=find(acti_thres >x1 & acti_thres<=x2);
CG(I1)= ((acti_thres(I1)-x1)/(x2-x1)).*(maxx(I1)-K*minn(I1))+K*minn(I1);
CB(I1) = K*minn(I1);%*(ones(size(I1,1),1));

%Processing of the GREEN & BLUE colormaps
x1 = 190/MAX/128; x2 = 128/MAX/128;
I1=find(acti_thres >x1 & acti_thres<=x2);
CG(I1)= maxx(I1);
CB(I1) = ((acti_thres(I1)-x1)/(x2-x1)).*(maxx(I1)-K*minn(I1))+K*minn(I1);


if ~isempty(v_actthres) % No source above the threshold
    % coding of deepness and activation on the vertices
    Cmap(v_actthres,:) = [C_contrast.*CR C_contrast.*CG C_contrast.*CB];
end


% compute the colormap for activation coding
load('bst_cactivcmap','map') % Load colormap map from file (modifies HOT(128) colormap)
return
