function [X,Y,Z,str,hl,hs] = depthgauge(p1,p2,Len,Prec,Scale,ha);
%DEPTHGAUGE - Make a depthgauge for measuring depth
% function [X,Y,Z,str,hl,hs] = depthgauge(p1,p2,Len,Prec,Scale,ha);
% function [X,Y,Z,str] = depthgauge(p1,p2,Len,Prec,Scale,ha);
% depthgauge begins a point p1 and proceeds in increments of Prec towards p2
%  for a distance of Len.
% [X,Y,Z] are returned such that line(X,Y,Z) will draw the segments.
% Suggested use is 
%  hl = line(X,Y,Z,'marker','diamond','markerfacecolor','r','markeredgecolor','k','color','r');
%   text(X,Y,Z,str);
% If Scale is given, then Prec is multiplied by Scale before creating
%  string (e.g. Scale=1000 converts string units from meters to mm);
% if ha is given, then depthgauge is added into the axis given by ha and the 
%  handles to the depthgauge segments returned

%<autobegin> ---------------------- 26-May-2004 11:30:10 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Visualization
%
% At Check-in: $Author: Mosher $  $Revision: 12 $  $Date: 5/26/04 9:59a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:30:10 -----------------------


% John C. Mosher, Ph.D. See Copyright.m file for information

% $Date: 5/26/04 9:59a $ $Revision: 12 $

p2 = p2(:);
p1 = p1(:);

r = p2-p1;
r = r/norm(r); % unit pointing vector

X = [];
Y = [];
Z = [];
str = [];

for i = 0:Prec:Len, % each increment in the stick
  nextp = p1 + r*i;
  X = [X; nextp(1)];
  Y = [Y; nextp(2)];
  Z = [Z; nextp(3)];
  str = strvcat(str,num2str(i*Scale));
end

if(exist('ha','var')),
  axes(ha)
  hl = line(X,Y,Z,'marker','diamond','markerfacecolor','r','markeredgecolor','k','color','r');
  hs = text(X,Y,Z,str);
else
  hl = [];
  hs = [];
end


return
