function str = engstr(num,prec);
%ENGSTR - create a string for the number in engineering format
% function str = engstr(num,prec);
% If Format is given, then the number of values
%  after the decimal point is equal to the integer prec
% Otherwise, prec defaults to 1, as in 2.5 K

%<autobegin> ---------------------- 26-May-2004 11:30:14 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Utility - General
%
% At Check-in: $Author: Mosher $  $Revision: 12 $  $Date: 5/26/04 9:59a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:30:14 -----------------------


if(~exist('prec','var')),
   prec = [];
end
if(isempty(prec)),
   Format = '%.1f'; % default
else
   Format = sprintf('%%.%.0ff',prec); % user given
end

base = floor(log10(num)/3);

mant = num/10^(3*base);

switch base
case -3
   suffix = 'nano';
case -2
   suffix = 'micro';
case -1
   suffix = 'milli';
case 0
   suffix = '';
case 1
   suffix = 'K';
case 2
   suffix = 'M';
case 3
   suffix = 'G';
otherwise
   suffix = sprintf('x 10^(%.0f)',base*3);
end

str = sprintf([Format ' %s'],mant,suffix);

return
