function helptext = help_figure_list;
%HELP_FIGURE_LIST - Explain the figures used by BrainStorm
% function helptext = help_figure_list;
%Call as a function or type 'help help_figure_list' at the command line
%
%Generate this file using the development tool make_figure_list
%
% ==========================  BrainStorm  ==========================
%
%As of 17-Dec-2003 15:52:45 in the BrainStorm Toolbox are these figures:
%
% ========== BEM_PARAM_SELECT.FIG ===========
%
% Help for this figure file (help_fig_bem_param_select) is given as:
%
%   (add help information)
%
%  The following files in the Toolbox access this figure:
%
% headmodeler_gui.m : Application M-file to build head models
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in bem_param_select.m
%
% Callbacks by figure bem_param_select.fig
%   uicontrol:checkbox:collocation "Collocation" uses Callback for
%     headmodeler_gui('mutincomp_test',gcbo,[],guidata(gcbo));
%   uicontrol:checkbox:constant "Constant" uses Callback for
%     headmodeler_gui('mutincomp_basis',gcbo,[],guidata(gcbo));
%   uicontrol:checkbox:galerkin "Galerkin" uses Callback for
%     headmodeler_gui('mutincomp_test',gcbo,[],guidata(gcbo));
%   uicontrol:checkbox:linear "Linear" uses Callback for
%     headmodeler_gui('mutincomp_basis',gcbo,[],guidata(gcbo));
%   uicontrol:listbox:available "" uses Callback for
%     headmodeler_gui('HEnvelopeSelect_Callback',gcbo,[],guidata(gcbo))
%   uicontrol:listbox:removed "" uses Callback for
%     headmodeler_gui('HEnvelopeRemove_Callback',gcbo,[],guidata(gcbo))
%   uicontrol:pushbutton:pushbutton2 ">>" uses Callback for
%     headmodeler_gui('HEnvelopeSelect_Callback',gcbo,[],guidata(gcbo))
%   uicontrol:pushbutton:pushbutton3 "<<" uses Callback for
%     headmodeler_gui('HEnvelopeRemove_Callback',gcbo,[],guidata(gcbo))
%   uicontrol:pushbutton:pViewBEMEnvelopes "View Envelopes" uses Callback for
%     headmodeler_gui('ViewBEMEnvelopes',gcbo,[],guidata(gcbo))
%   uicontrol:pushbutton:pViewSensors "View Sensors" uses Callback for
%     headmodeler_gui('ViewSensors',gcbo,[],guidata(gcbo))
%   uicontrol:pushbutton:QUIT "Close" uses Callback for
%     headmodeler_gui('BEMParamSelectCancel_Callback',gcbo,[],guidata(gcbo))
%   uicontrol:text:Btext10 "Ordered Selection" uses Callback for
%     bem_envelope_select('StaticText1_Callback',gcbo,[],guidata(gcbo))
%   uicontrol:text:Btext12 "Available" uses Callback for
%     bem_envelope_select('StaticText1_Callback',gcbo,[],guidata(gcbo))
%   uicontrol:text:Dtext11 "Select the envelopes for BEM modelling: " uses Callback for
%     bem_envelope_select('StaticText1_Callback',gcbo,[],guidata(gcbo))
%
%
%
% ========== BST_MESSAGE_WINDOW.FIG ===========
%
% Help for this figure file (help_fig_bst_message_window) is given as:
%
%   (See bst_message_window.m)
%
% Help was also found in bst_message_window.m:
%
%  BST_MESSAGE_WINDOW Application M-file for bst_message_window.fig, with NON CALLBACKS
%   function varargout = bst_message_window(varargin)
%      FIG = BST_MESSAGE_WINDOW launch bst_message_window GUI.
%      BST_MESSAGE_WINDOW('callback_name', ...) invoke the named callback.
%   NON CALLBACKS:
%   bst_message_window(cellstr) appends cell array of strings cellstr to window 
%   bst_message_window('append',str) appends string or cell of strings to window
%   bst_message_window(str) will also append string, unless it is a valid function call
%   bst_message_window('wrap',str) will wrap string or cell of strings to the window
%   bst_message_window('unique',str) will wrap string or cell of strings to a unique window,
%    returning the handle to the window, i.e. it won't go to the message window, but rather
%    its own message window.
%   bst_message_window('overwrite',str) overwrites the last line with the new string
%   
%   bst_message_window('close') removes the window, otherise the CloseRequestFcn executes
%   If window does not exist, 'append' will open it
%
%  The following files in the Toolbox access this figure:
%
%           bst_message_window.m : Application M-file for bst_message_window.fig, with NON CALLBACKS
%                     bem_gain.m : Computes the EEG/MEG forward/gain matrix associated with a set of grid points 
%                     bem_xfer.m : Computation of the MEG and/or EEG BEM transfer matrices
%          browse_study_folder.m : Find all *brainstormstudy.mat files in a directory tree
%              bst_headmodeler.m : Solution to the MEG/EEG forward problem
%          bst_imaging_display.m : : display utility for cortical distributed source imaging 
%            bst_sourceimaging.m : Command line call to source imaging routines
%             bst_splashscreen.m : GUI app for license information and agreement
%           bst_static_taskbar.m : BrainStorm's primary taskbar always visible
%         bst_wavedata_display.m : Plot waveforms in tiles
%                 data_manager.m : Edit/select database, subjects, studies, datasets, build headmodels, import data.
%             database_manager.m : GUI to edit the User Databases and select one
%                  dataplot_cb.m : : Callback switchyard for the DATAPLOT Tool
%                ds2brainstorm.m : Convert a DS CTF dataset into BrainStorm format
%             extract_channels.m : Extract the channels to be used in this particular run
%                  get_channel.m : Get the Channel information associated with a particular data file
%           get_user_directory.m : Get the user's root directory information
%                    gridmaker.m : 3D regular gridding of surface envelope
%              headmodeler_gui.m : Application M-file to build head models
%                 help_manager.m : Application M-file for help_manager.fig
%                   importdata.m : GUI m-file Import data from major MEG and EEG systems.
%               layout_manager.m : Application M-file to manage the window layout
%        make_default_database.m : Confirm or Create a default database, default study, default subject
%           make_default_study.m : Create simulated default data and link to a simulated subject
%         make_default_subject.m : Make a brainstormsubject and simulated MRI in a folder
%        manage_corticalscouts.m : Application M-file for manage_corticalscouts.fig
%                     meg4read.m : READ CTF MEG4 file format
%                    meg4write.m : WRITE CTF MEG4 file format
%                      minnorm.m : Mininum norm solution as called from command line or BST_SOURCEIMAGING.M
%                mri_read_tool.m : AOS Version Application M-file to read in MRI and manipulate
%                       os_meg.m : Calculate the (overlapping) sphere models for MEG
%           overlapping_sphere.m : Create overlapping spheres for E/MEG channels.
%        parametric_estimation.m : GUI for selecting data segments and subspaces prior to estimation
%         rap_music_parameters.m : Application M-file for rap_music_parameters.fig
%                 rapmusic_gui.m : Execute RAPMUSIC using GUI inputs, BrainStorm MMII version
%          results_time_series.m : Application M-file for results_time_series.fig
%        results_visualization.m : Application M-file View the results of source modeling
%                select_folder.m : Application M-file for bst_SelectFolder.fig
% set_sourceviewing_parameters.m : Application M-file for set_sourceviewing_parameters.fig
%                    simulator.m : Application M-file for simulator.fig
%                simulator_mri.m : Application M-file to make a simulated spherical MRI
%                 source_grids.m : Generate source grids for parametric model searches
%                sourceimaging.m : Main switch to source imaging routines
%                 study_editor.m : GUI to edit the BrainStorm Study information, case switchyard
%               subject_editor.m : GUI to edit the BrainStorm Subject information, case switchyard
%                    web_pages.m : Listbox of relevant BrainStorm web pages and email addresses
%                   zscore_gui.m : : management of zscore visualization
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in bst_message_window.m
%
% Callbacks by figure bst_message_window.fig
%   figure::BrainStormMessages "" uses ResizeFcn for <automatic>
%   uicontrol:listbox:Messages "BrainStorm Message Window" uses Callback for <automatic>
%
%
%
% ========== BST_SPLASHSCREEN.FIG ===========
%
% Help for this figure file (help_fig_bst_splashscreen) is given as:
%
%   (add help information)
%
% Help was also found in bst_splashscreen.m:
%
%  BST_SPLASHSCREEN GUI app for license information and agreement
%   function varargout = bst_splashscreen(varargin)
%      FIG = BST_SPLASHSCREEN launch bst_splashscreen GUI.
%      BST_SPLASHSCREEN('callback_name', ...) invoke the named callback.
%  
%   Main operation is to set or clear the group 'BrainStorm' preference 
%    'DateofAgreement' to be today's date. Startup.m then checks this preference
%    and continues or denies BrainStorm execution
%
%  The following files in the Toolbox access this figure:
%
% bst_splashscreen.m : GUI app for license information and agreement
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in bst_splashscreen.m
%
% Callbacks by figure bst_splashscreen.fig
%   axes::axes_splash "" uses CreateFcn for movegui center
%   uicontrol:pushbutton:pushbutton_agree "Yes" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_disagree "No" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_more_info "More Information" uses Callback for <automatic>
%
%
%
% ========== BST_STATIC_TASKBAR.FIG ===========
%
% Help for this figure file (help_fig_bst_static_taskbar) is given as:
%
%   (add help information)
%
% Help was also found in bst_static_taskbar.m:
%
%  BST_STATIC_TASKBAR BrainStorm's primary taskbar always visible
%   function varargout = bst_static_taskbar(varargin)
%      FIG = BST_STATIC_TASKBAR launch bst_static_taskbar GUI.
%      BST_STATIC_TASKBAR('callback_name', ...) invoke the named callback.
%  
%   Comments on this taskbar, programming guide, etc:
%  
%   Important Application data are maintained in this GUI, for referencing by other 
%    dynamic toolbars and tiles. Handle visibility is on and non-integer. 
%   Tag for the gui is the "static_taskbar".
%   Let fig = findobj(get(0,'chil'),'flat','tag','static_taskbar');
%   These application data are stored in the figure handle, accessible as
%    getappdata(fig,<appname>), or getappdata(gcf,<appname>) inside these callbacks.
%   STUDY, MRI, TESS, HEADMODEL, DATA, RESULTS
%    For each of these appdata, a list of full referential filenames are returned in
%    a cell array. STUDY is simply the Comment displayed in the static taskbar
%   To get the current MRI filename displayed, use 
%    [fname,h,AllFilenames] = bst_static_taskbar('GET','MRI');
%   fname is a CELL ARRAY of strings currently selected
%   and similarly for the other tags
%   h is the handle of the popup
%   AllFilenames is the cell array of all names in the popup
%    (identical to getappdata(fig,<appname>));
%   For the EEG, MEG, and Other checkboxes, use
%    [val,enable,h] = bst_static_taskbar('GET','MEG'),
%    or 'EEG', or 'OTHER'.
%  
%   AllFilenames = bst_static_taskbar('RefreshResults') will return
%    the cellarray of all filenames after refreshing the list.
%  
%   Examples:
%    Assume fig points to the bst_static_taskbar
%    fig = findobj(get(0,'chil'),'flat','tag','static_taskbar');
%  
%    To get the full list of current data files in the study
%    datanames = getappdata(fig,'DATA'); % referential filenames
%    
%    To get the data name currently pointed at in the taskbar
%    [fname,h] = bst_static_taskbar('GET','DATA'); % referential filename
%   
%    To see if the user wants MEG data
%    [val,enable,h] = bst_static_taskbar('GET','MEG');
%    or simply
%    val = bst_static_taskbar('GET','MEG');
%
%  The following files in the Toolbox access this figure:
%
%    bst_static_taskbar.m : BrainStorm's primary taskbar always visible
%  bst_wavedata_display.m : Plot waveforms in tiles
%           chi_pdf_fit.m : GUI to create and test covariance matrix
%  covariance_generator.m : GUI to create and test covariance matrix
%          data_manager.m : Edit/select database, subjects, studies, datasets, build headmodels, import data.
%      data_selector_cb.m : Callback function to setup and execute inverse techniques
%           dataplot_cb.m : : Callback switchyard for the DATAPLOT Tool
%           get_channel.m : Get the Channel information associated with a particular data file
% parametric_estimation.m : GUI for selecting data segments and subspaces prior to estimation
%  rap_music_parameters.m : Application M-file for rap_music_parameters.fig
%          rapmusic_gui.m : Execute RAPMUSIC using GUI inputs, BrainStorm MMII version
%         sourceimaging.m : Main switch to source imaging routines
%          view_manager.m : Application M-file to view and process data
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in bst_static_taskbar.m
%
% Callbacks by figure bst_static_taskbar.fig
%   uicontrol:checkbox:checkbox_EEG "EEG" uses Callback for <automatic>
%   uicontrol:checkbox:checkbox_MEG "MEG" uses Callback for <automatic>
%   uicontrol:checkbox:checkbox_OTHER "Other" uses Callback for <automatic>
%   uicontrol:popupmenu:popupmenu_DATA "Data file(s)" uses Callback for <automatic>
%   uicontrol:popupmenu:popupmenu_HEADMODEL "Headmodel(s)" uses Callback for <automatic>
%   uicontrol:popupmenu:popupmenu_MRI "MRI files" uses Callback for <automatic>
%   uicontrol:popupmenu:popupmenu_RESULTS "Results file(s)" uses Callback for <automatic>
%   uicontrol:popupmenu:popupmenu_TESS "Tessellation files" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_next_data ">" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_next_results ">" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_previous_data "<" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_previous_results "<" uses Callback for <automatic>
%   uimenu::menu_advanced_headmodels "" uses Callback for <automatic>
%   uimenu::menu_datamanager "" uses Callback for <automatic>
%   uimenu::menu_default_headmodel "" uses Callback for <automatic>
%   uimenu::menu_editor "" uses Callback for <automatic>
%   uimenu::menu_help_contents "" uses Callback for <automatic>
%   uimenu::menu_help_html "" uses Callback for <automatic>
%   uimenu::menu_help_newuser "" uses Callback for <automatic>
%   uimenu::menu_help_online "" uses Callback for <automatic>
%   uimenu::menu_help_tutorial "" uses Callback for <automatic>
%   uimenu::menu_information "" uses Callback for <automatic>
%   uimenu::menu_layout "" uses Callback for <automatic>
%   uimenu::menu_LCMV "" uses Callback for <automatic>
%   uimenu::menu_LCMV_scan "" uses Callback for <automatic>
%   uimenu::menu_LeastSquares "" uses Callback for <automatic>
%   uimenu::menu_message "" uses Callback for <automatic>
%   uimenu::menu_MinNorm "" uses Callback for <automatic>
%   uimenu::menu_MinNorm_recursive "" uses Callback for <automatic>
%   uimenu::menu_mri_alex "" uses Callback for <automatic>
%   uimenu::menu_mri_viewer_baillet "" uses Callback for <automatic>
%   uimenu::menu_MUSIC_cortical "" uses Callback for <automatic>
%   uimenu::menu_quit "" uses Callback for <automatic>
%   uimenu::menu_RAPmusic "" uses Callback for <automatic>
%   uimenu::menu_results_visualization "" uses Callback for <automatic>
%   uimenu::menu_Rmusic "" uses Callback for <automatic>
%   uimenu::menu_simulate_data "" uses Callback for <automatic>
%   uimenu::menu_simulate_mri "" uses Callback for <automatic>
%   uimenu::menu_snap "" uses Callback for <automatic>
%   uimenu::menu_STmap "" uses Callback for <automatic>
%   uimenu::menu_tesselation_manager "" uses Callback for <automatic>
%   uimenu::menu_Tiling "" uses Callback for <automatic>
%   uimenu::menu_viewer "" uses Callback for <automatic>
%
%
%
% ========== CHANNEL_SELECT.FIG ===========
%
% Help for this figure file (help_fig_channel_select) is given as:
%
%   (add help information)
%
%  The following files in the Toolbox access this figure:
%
% dataplot_cb.m : : Callback switchyard for the DATAPLOT Tool
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in channel_select.m
%
% Callbacks by figure channel_select.fig
%   figure::channel_select "" uses CreateFcn for movegui southeast;
%   uicontrol:popupmenu:pChannelSets "Channel Sets" uses Callback for dataplot_cb channel_switch
%   uicontrol:pushbutton:OPushbutton1 "Done" uses Callback for dataplot_cb channel_select_done
%   uicontrol:pushbutton:pAdd ">" uses Callback for dataplot_cb channel_switch
%   uicontrol:pushbutton:pRemove "<" uses Callback for dataplot_cb channel_switch
%   uicontrol:pushbutton:QPushbutton1 "Close" uses Callback for close gcbf
%
%
%
% ========== CHI_PDF_FIT.FIG ===========
%
% Help for this figure file (help_fig_chi_pdf_fit) is given as:
%
%   (add help information)
%
% Help was also found in chi_pdf_fit.m:
%
%  CHI_PDF_FIT GUI to create and test covariance matrix
%   function varargout = chi_pdf_fit(varargin)
%      FIG = CHI_PDF_FIT launch chi_pdf_fit GUI.
%      CHI_PDF_FIT('callback_name', ...) invoke the named callback.
%
%  The following files in the Toolbox access this figure:
%
% chi_pdf_fit.m : GUI to create and test covariance matrix
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in chi_pdf_fit.m
%
% Callbacks by figure chi_pdf_fit.fig
%   uicontrol:edit:edit_inc "incr" uses Callback for <automatic>
%   uicontrol:edit:edit_rank "Rank" uses Callback for <automatic>
%   uicontrol:edit:edit_scale "Scale" uses Callback for <automatic>
%   uicontrol:popupmenu:popupmenu_filter "High Pass" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_reload "Reload" uses Callback for <automatic>
%   uicontrol:radiobutton:radiobutton_diag "Diagonal" uses Callback for <automatic>
%   uicontrol:radiobutton:radiobutton_full "Full" uses Callback for <automatic>
%   uicontrol:radiobutton:radiobutton_iid "I.I.D." uses Callback for <automatic>
%   uicontrol:slider:slider_rank "" uses Callback for <automatic>
%   uicontrol:slider:slider_scale "" uses Callback for <automatic>
%
%
%
% ========== COVARIANCE_GENERATOR.FIG ===========
%
% Help for this figure file (help_fig_covariance_generator) is given as:
%
%   (add help information)
%
% Help was also found in covariance_generator.m:
%
%  COVARIANCE_GENERATOR GUI to create and test covariance matrix
%   function varargout = covariance_generator(varargin)
%      FIG = COVARIANCE_GENERATOR launch covariance_generator GUI.
%      COVARIANCE_GENERATOR('callback_name', ...) invoke the named callback.
%  
%   See also COVARIANCE_PLOTS
%
%  The following files in the Toolbox access this figure:
%
% covariance_generator.m : GUI to create and test covariance matrix
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in covariance_generator.m
%
% Callbacks by figure covariance_generator.fig
%   uicontrol:edit:edit_data_rank "Rank" uses Callback for <automatic>
%   uicontrol:edit:edit_inc "incr" uses Callback for <automatic>
%   uicontrol:edit:edit_rank "Rank" uses Callback for <automatic>
%   uicontrol:edit:edit_scale "Scale" uses Callback for <automatic>
%   uicontrol:popupmenu:popupmenu_filter "High Pass" uses Callback for <automatic>
%   uicontrol:popupmenu:popupmenu_matrix_noise "I.I.D." uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_apply_whitener "Whiten" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_load_noise "Load" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_recalc "ReCalc" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_recalc_data "ReCalc" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_reload "Reload" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_store_data "Store" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_store_noise "Store" uses Callback for <automatic>
%   uicontrol:slider:slider_data_rank "" uses Callback for <automatic>
%   uicontrol:slider:slider_rank "" uses Callback for <automatic>
%   uicontrol:slider:slider_scale "" uses Callback for <automatic>
%
%
%
% ========== COVARIANCE_PLOTS.FIG ===========
%
% Help for this figure file (help_fig_covariance_plots) is given as:
%
%   (add help information)
%
% Help was also found in covariance_plots.m:
%
%  COVARIANCE_PLOTS M-file for covariance_generator, covariance_plots
%   function varargout = covariance_plots(varargin)
%      FIG = COVARIANCE_PLOTS launch covariance_plots GUI.
%      COVARIANCE_PLOTS('callback_name', ...) invoke the named callback.
%  
%   See also COVARIANCE_GENERATOR
%
%  The following files in the Toolbox access this figure:
%
%     covariance_plots.m : M-file for covariance_generator, covariance_plots
% covariance_generator.m : GUI to create and test covariance matrix
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in covariance_plots.m
%
%
%
% ========== DATA_MANAGER.FIG ===========
%
% Help for this figure file (help_fig_data_manager) is given as:
%
%   (add help information)
%
% Help was also found in data_manager.m:
%
%  DATA_MANAGER Edit/select database, subjects, studies, datasets, build headmodels, import data.
%   function varargout = data_manager(varargin)
%      FIG = DATA_MANAGER launch data_manager GUI.
%      DATA_MANAGER('callback_name', ...) invoke the named callback.
%  
%   This GUI concentrates a lot of data management. The user can edit/select the database.
%    The information in any study or subject can be edited. Data from the vendors and
%    in ASCII format can be loaded. 
%    Tesselation files can be loaded through the subject editor.
%    Headmodels for any study can be generated.
%   
%   In addition to generating the appropriate Mat-files, a primary output of this manager
%    is the setting of the structures in the BrainStorm Taskbar, which allows other routines to
%    determine exactly what data the user wants in the other routines. Use get_user_directory
%    to retrieve this structure. This structure is also mirrored in the BrainStorm Preferences,
%    so that subsequent sessions can begin at the last point, or batch routines can be run.
%
%  The following files in the Toolbox access this figure:
%
%          data_manager.m : Edit/select database, subjects, studies, datasets, build headmodels, import data.
%    bst_static_taskbar.m : BrainStorm's primary taskbar always visible
%      extract_channels.m : Extract the channels to be used in this particular run
%    get_user_directory.m : Get the user's root directory information
%       headmodeler_gui.m : Application M-file to build head models
%            importdata.m : GUI m-file Import data from major MEG and EEG systems.
% parametric_estimation.m : GUI for selecting data segments and subspaces prior to estimation
%          study_editor.m : GUI to edit the BrainStorm Study information, case switchyard
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in data_manager.m
%
% Callbacks by figure data_manager.fig
%   uicontrol:listbox:listbox_Data "Select a data folder in the list above" uses Callback for <automatic>
%   uicontrol:listbox:listbox_Study "Scanning Current Folder Tree..." uses Callback for <automatic>
%   uicontrol:popupmenu:popup_CurrentDatabase "Databases" uses Callback for <automatic>
%   uimenu::menu_close "" uses Callback for <automatic>
%   uimenu::menu_edit_database "" uses Callback for <automatic>
%   uimenu::menu_edit_rebuild "" uses Callback for <automatic>
%   uimenu::menu_edit_study "" uses Callback for <automatic>
%   uimenu::menu_edit_subject "" uses Callback for <automatic>
%   uimenu::menu_import_data "" uses Callback for <automatic>
%   uimenu::menu_pooled_allow "" uses Callback for <automatic>
%   uimenu::menu_pooled_define "" uses Callback for <automatic>
%   uimenu::menu_view_datafiles "" uses Callback for <automatic>
%   uimenu::menu_view_information "" uses Callback for <automatic>
%   uimenu::menu_view_results "" uses Callback for <automatic>
%
%
%
% ========== DATA_SELECTOR.FIG ===========
%
% Help for this figure file (help_fig_data_selector) is given as:
%
%   (add help information)
%
%  The following files in the Toolbox access this figure:
%
%     bst_sourceimaging.m : Command line call to source imaging routines
%      data_selector_cb.m : Callback function to setup and execute inverse techniques
% parametric_estimation.m : GUI for selecting data segments and subspaces prior to estimation
%         sourceimaging.m : Main switch to source imaging routines
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in data_selector.m
%
% Callbacks by figure data_selector.fig
%   axes::AxisNoiseSubspace "" uses ButtonDownFcn for data_selector_cb('set time')
%   axes::AxisSignalSubspace "" uses ButtonDownFcn for data_selector_cb('set time')
%   figure::Data Selector "" uses KeyPressFcn for dokeypress(gcbf)
%   figure::Data Selector "" uses ResizeFcn for doresize(gcbf)
%   uicontrol:edit:EditRank "0" uses Callback for data_selector_cb('set textrank')
%   uicontrol:popupmenu:PopupSVD "Log Y-Axis" uses Callback for data_selector_cb('plot svd')
%   uicontrol:pushbutton:OKpushbutton "Done" uses Callback for data_selector_cb Done
%   uicontrol:pushbutton:Qpushbutton "Close" uses Callback for close(gcbf)
%   uicontrol:slider:SliderRank "" uses Callback for data_selector_cb('set sliderrank')
%   uimenu::EEGData "" uses Callback for data_selector_cb('checkdata')
%   uimenu::Exit Window "" uses Callback for data_selector_cb('exit')
%   uimenu::LoadData "" uses Callback for data_selector_cb('load')
%   uimenu::MEGData "" uses Callback for data_selector_cb('checkdata')
%   uimenu::OtherData "" uses Callback for data_selector_cb('checkdata')
%   uimenu::Source EstimationLeast Square "" uses Callback for data_selector_cb('leastsquares')
%   uimenu::Source EstimationLinear Imaging "" uses Callback for data_selector_cb('minnorm')
%   uimenu::Source EstimationRAP-MUSIC "" uses Callback for data_selector_cb('rap-music')
%   uimenu::UimenuReset "" uses Callback for data_selector_cb('reset')
%
%
%
% ========== DATABASE_MANAGER.FIG ===========
%
% Help for this figure file (help_fig_database_manager) is given as:
%
%   (add help information)
%
% Help was also found in database_manager.m:
%
%  DATABASE_MANAGER GUI to edit the User Databases and select one
%   function varargout = database_manager(varargin)
%      USER = DATABASE_MANAGER launch modal GUI
%      DATABASE_MANAGER('callback_name', ...) invoke the named callback.
%  
%   Modal window, 
%    "Done" button returns selected database as Users structure, updates
%    the application data BrainStormDataBase in the TASKBAR, and saves the
%    databases in the Matlab prefs. Since the user may have switched databases,
%    the BrainStorm UserCurrentData is blanked.
%   Returns the structure with fields:
%    Comment, string commenting on the location of the files
%    STUDIES, string giving the root location of all studies
%    SUBJECTS, string giving the root for subjects.
%    CurrentData with fields:
%        StudyFile: ''
%      SubjectFile: ''
%  
%   "Cancel" does nothing.
%
%  The following files in the Toolbox access this figure:
%
% database_manager.m : GUI to edit the User Databases and select one
%     data_manager.m : Edit/select database, subjects, studies, datasets, build headmodels, import data.
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in database_manager.m
%
% Callbacks by figure database_manager.fig
%   uicontrol:edit:edit_databasename "Edit Text" uses Callback for <automatic>
%   uicontrol:edit:edit_STUDIES "Edit Text" uses Callback for <automatic>
%   uicontrol:edit:edit_SUBJECTS "Edit Text" uses Callback for <automatic>
%   uicontrol:listbox:listbox_database "Listbox" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_add "Add" uses ButtonDownFcn for <automatic>
%   uicontrol:pushbutton:pushbutton_add "Add" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_cancel "Cancel" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_done "Save" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_help "Help" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_remove "Remove" uses ButtonDownFcn for <automatic>
%   uicontrol:pushbutton:pushbutton_remove "Remove" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_STUDIES "Studies" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_SUBJECTS "Subjects" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_update "Update" uses ButtonDownFcn for <automatic>
%   uicontrol:pushbutton:pushbutton_update "Update" uses Callback for <automatic>
%
%
%
% ========== DATAPLOT.FIG ===========
%
% Help for this figure file (help_fig_dataplot) is given as:
%
%   (add help information)
%
%  The following files in the Toolbox access this figure:
%
%   bst_imaging_display.m : : display utility for cortical distributed source imaging 
%    bst_static_taskbar.m : BrainStorm's primary taskbar always visible
%  bst_wavedata_display.m : Plot waveforms in tiles
%          data_manager.m : Edit/select database, subjects, studies, datasets, build headmodels, import data.
%      data_selector_cb.m : Callback function to setup and execute inverse techniques
%           dataplot_cb.m : : Callback switchyard for the DATAPLOT Tool
% manage_corticalscouts.m : Application M-file for manage_corticalscouts.fig
% parametric_estimation.m : GUI for selecting data segments and subspaces prior to estimation
%  rap_music_parameters.m : Application M-file for rap_music_parameters.fig
%   results_time_series.m : Application M-file for results_time_series.fig
%         sourceimaging.m : Main switch to source imaging routines
%            zscore_gui.m : : management of zscore visualization
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in dataplot.m
%
% Callbacks by figure dataplot.fig
%   figure::DATAPLOT "" uses DeleteFcn for clear global data
%   uicontrol:edit:current_time "0" uses Callback for dataplot_cb set_current_time
%   uicontrol:edit:step "''" uses Callback for dataplot_cb set_time_step
%   uicontrol:edit:time_max "" uses Callback for dataplot_cb set_time_max
%   uicontrol:edit:time_min "" uses Callback for dataplot_cb set_time_min
%   uicontrol:popupmenu:ChangeUnits "MKS" uses Callback for dataplot_cb ChangeUnits
%   uicontrol:popupmenu:DataViewingDataType "Original Data" uses Callback for
%     dataplot_cb DataViewingDataType
%   uicontrol:popupmenu:DataViewingSpatialDisplay "<No Scalp Topography>" uses Callback for
%     dataplot_cb DataViewingSpatialDisplay
%   uicontrol:popupmenu:DataViewingTimeDisplay "<No Time Display>" uses Callback for
%     dataplot_cb DataViewingTimeDisplay
%   uicontrol:popupmenu:SourceEstimationMethod "-------- IMAGING " uses Callback for
%     dataplot_cb SourceImaging
%   uicontrol:popupmenu:SourceViewingSpatialDisplay "<No Spatial Topography>" uses Callback for
%     dataplot_cb SourceViewingSpatialDisplay
%   uicontrol:popupmenu:SourceViewingTimeDisplay "<No Time Display>" uses Callback for
%     dataplot_cb SourceViewingTimeDisplay
%   uicontrol:pushbutton:HPlot "Plot" uses Callback for dataplot_cb('Plot','Measures')
%   uicontrol:pushbutton:HPlotTimeSeries "Plot" uses Callback for dataplot_cb('Plot','RESULTS')
%   uicontrol:pushbutton:HSetDataViewing "Set" uses Callback for dataplot_cb SetDataViewing
%   uicontrol:pushbutton:HSetSourceViewing "Set" uses Callback for dataplot_cb SetSourceViewing
%   uicontrol:pushbutton:LOAD "Load" uses Callback for dataplot_cb loaddata
%   uicontrol:pushbutton:MSIndexSwitch "ms/index" uses Callback for dataplot_cb MSIndexSwitch
%   uicontrol:pushbutton:NoiseModel "Noise Model" uses Callback for dataplot_cb CallDataSelector
%   uicontrol:pushbutton:pushbutton6 "Save" uses Callback for dataplot_cb saveas
%   uicontrol:pushbutton:SourceModel "Source Model" uses Callback for
%     dummy_dynamic_viewer('pushbutton11_Callback',gcbo,[],guidata(gcbo))
%   uicontrol:slider:TimeSlider "" uses Callback for dataplot_cb mapping_slider
%   uicontrol:togglebutton:Hbttn_append "Append" uses Callback for dataplot_cb AppendData
%
%
%
% ========== GENERIC_LISTBOX_WIN.FIG ===========
%
% Help for this figure file (help_fig_generic_listbox_win) is given as:
%
%   (add help information)
%
%  The following files in the Toolbox access this figure:
%
%     importdata.m : GUI m-file Import data from major MEG and EEG systems.
% subject_editor.m : GUI to edit the BrainStorm Subject information, case switchyard
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in generic_listbox_win.m
%
% Callbacks by figure generic_listbox_win.fig
%   uicontrol:pushbutton:DONE "Done" uses Callback for subject_editor ImportTriDone
%
%
%
% ========== HEADMODELER_GUI.FIG ===========
%
% Help for this figure file (help_fig_headmodeler_gui) is given as:
%
%   (add help information)
%
% Help was also found in headmodeler_gui.m:
%
%  HEADMODELER_GUI Application M-file to build head models
%   function varargout = headmodeler_gui(varargin)
%      fig = HEADMODELER_GUI launch headmodeler_gui GUI.
%      HEADMODELER_GUI('callback_name', ...) invoke the named callback.
%
%  The following files in the Toolbox access this figure:
%
%    headmodeler_gui.m : Application M-file to build head models
% bst_static_taskbar.m : BrainStorm's primary taskbar always visible
%       data_manager.m : Edit/select database, subjects, studies, datasets, build headmodels, import data.
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in headmodeler_gui.m
%
% Callbacks by figure headmodeler_gui.fig
%   figure::headmodeler "" uses CreateFcn for movegui center;
%   uicontrol:checkbox:ComputeVolumeSourceGrid "Compute" uses Callback for <automatic>
%   uicontrol:checkbox:EEG "EEG" uses Callback for
%     headmodeler_gui('SelectEEG_Callback',gcbo,[],guidata(gcbo))
%   uicontrol:checkbox:MEG "MEG" uses Callback for
%     headmodeler_gui('SelectMEG_Callback',gcbo,[],guidata(gcbo))
%   uicontrol:checkbox:Tverbose "Verbose" uses Callback for
%     headmodeler_gui('verbose_Callback',gcbo,[],guidata(gcbo))
%   uicontrol:edit:center "" uses Callback for <automatic>
%   uicontrol:edit:conductivity "" uses Callback for <automatic>
%   uicontrol:edit:HeadModelName "Default" uses Callback for <automatic>
%   uicontrol:edit:radii "" uses Callback for <automatic>
%   uicontrol:edit:spacing "2" uses Callback for
%     headmodeler_gui('SPACING_Callback',gcbo,[],guidata(gcbo))
%   uicontrol:popupmenu:crtxlistboxx "No Study in Memory" uses Callback for <automatic>
%   uicontrol:popupmenu:EEGForwardMethod "Single Sphere" uses Callback for <automatic>
%   uicontrol:popupmenu:listboxx "No Study in Memory" uses Callback for <automatic>
%   uicontrol:popupmenu:LoadHeadModelFile "<Load HeadModel File>" uses Callback for
%     headmodeler_gui('LoadHeadmodelFile_Callback',gcbo,[],guidata(gcbo))
%   uicontrol:popupmenu:MEGForwardMethod "Single Sphere" uses Callback for <automatic>
%   uicontrol:popupmenu:ref "." uses Callback for <automatic>
%   uicontrol:pushbutton:HComputeSphereParameters "Adjust" uses Callback for
%     headmodeler_gui('ComputeSphereParameters_Callback',gcbf,[],guidata(gcbf))
%   uicontrol:pushbutton:HRunHeadModeling "Run" uses Callback for <automatic>
%   uicontrol:pushbutton:pViewBrain "View" uses Callback for <automatic>
%   uicontrol:pushbutton:pViewScalp "View" uses Callback for <automatic>
%   uicontrol:pushbutton:QUIT "Close" uses Callback for close gcbf
%
%
%
% ========== HELP_MANAGER.FIG ===========
%
% Help for this figure file (help_fig_help_manager) is given as:
%
%   (add help information)
%
% Help was also found in help_manager.m:
%
%  HELP_MANAGER Application M-file for help_manager.fig
%   function varargout = help_manager(varargin)
%      FIG = HELP_MANAGER launch help_manager GUI.
%      HELP_MANAGER('callback_name', ...) invoke the named callback.
%
%  The following files in the Toolbox access this figure:
%
%       help_manager.m : Application M-file for help_manager.fig
% bst_static_taskbar.m : BrainStorm's primary taskbar always visible
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in help_manager.m
%
% Callbacks by figure help_manager.fig
%   uicontrol:pushbutton:pushbutton_contents "Contents" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_html "HTML" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_new_user "New User" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_online "Online Links" uses Callback for <automatic>
%
%
%
% ========== IMPORTDATA.FIG ===========
%
% Help for this figure file (help_fig_importdata) is given as:
%
%   (add help information)
%
% Help was also found in importdata.m:
%
%  IMPORTDATA GUI m-file Import data from major MEG and EEG systems.
%   function varargout = importdata(varargin);
%   Import data from the 3 major MEG systems (Neuromag, CTF & BTi) + 
%    a selection of EEG systems and generic ASCII format. 
%
%  The following files in the Toolbox access this figure:
%
%    importdata.m : GUI m-file Import data from major MEG and EEG systems.
%  data_manager.m : Edit/select database, subjects, studies, datasets, build headmodels, import data.
% ds2brainstorm.m : Convert a DS CTF dataset into BrainStorm format
%      meg4read.m : READ CTF MEG4 file format
%     meg4write.m : WRITE CTF MEG4 file format
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in importdata.m
%
% Callbacks by figure importdata.fig
%   uicontextmenu::See more information  "" uses Callback for importdata DisplayMarkerInfo
%   uicontrol:checkbox:cAllMarkers "" uses Callback for importdata MarkerInfo
%   uicontrol:checkbox:cCommonMarkers "" uses Callback for importdata MarkerInfo
%   uicontrol:checkbox:checkDCPreTrig "Based on pretrigger" uses Callback for importdata checkDC
%   uicontrol:checkbox:checkDCWholeTrial "Based on whole trial" uses Callback for importdata checkDC
%   uicontrol:checkbox:checkRemoveDC "Remove DC offset" uses Callback for importdata RemoveDCOffset
%   uicontrol:checkbox:cMarkerTimeRange "" uses Callback for importdata MarkerTimeRange
%   uicontrol:checkbox:cReadWholeTrials "Read whole trial(s)" uses Callback for
%     importdata MarkerTimeRange
%   uicontrol:checkbox:cSeqBlockRW "Sequential Block Read/Write" uses Callback for
%     importdata SeqBlockRW
%   uicontrol:checkbox:cSplitTrials "Split trials in multiple data.mat files" uses Callback for
%     importdata MarkerTimeRange
%   uicontrol:checkbox:cUseMarkers "Do not use markers" uses Callback for importdata MarkerInfo
%   uicontrol:checkbox:TNativeFormat "Keep native format" uses Callback for importdata TNativeFormat
%   uicontrol:edit:eTimeRange """ uses Callback for importdata MarkerTimeRange
%   uicontrol:edit:eTrialSelection "''" uses Callback for importdata TrialSelection
%   uicontrol:listbox:LMarkerList "''" uses Callback for importdata AssignMarkerToDataSet
%   uicontrol:listbox:LSubjects "''" uses Callback for importdata AssignSubjectToDataSet
%   uicontrol:listbox:RawDataList "''" uses Callback for importdata MarkerInfo
%   uicontrol:popupmenu:popupDataFormats "Pick-up a data format. . ." uses Callback for
%     importdata system_select
%   uicontrol:popupmenu:popupEEGRef "Pick-up a reference for the EEG" uses Callback for
%     importdata SelectEEGReference
%   uicontrol:pushbutton:HOK "Import" uses Callback for importdata OK
%   uicontrol:pushbutton:QPushbutton1 "Close" uses Callback for delete(gcbf)
%   uicontrol:text:BTrialSelection "Trial Selection" uses Callback for importdata MarkerTimeRange
%   uicontrol:text:tAllMarkers "Use (all) marker(s) from" uses Callback for importdata MarkerInfo
%   uicontrol:text:tCommonMarkers "Use marker(s) common" uses Callback for importdata MarkerInfo
%   uicontrol:text:tMarkerTimeRange "Time Range" uses Callback for importdata MarkerTimeRange
%
%
%
% ========== LAYOUT_MANAGER.FIG ===========
%
% Help for this figure file (help_fig_layout_manager) is given as:
%
%   (add help information)
%
% Help was also found in layout_manager.m:
%
%  LAYOUT_MANAGER Application M-file to manage the window layout
%   function varargout = layout_manager(varargin)
%      FIG = LAYOUT_MANAGER launch layout_manager GUI.
%      LAYOUT_MANAGER('callback_name', ...) invoke the named callback.
%  
%   Clicking on the figure background automatically refreshes the window list.
%   Right click the "Set" button or press the "Help" button for information on
%    how to set the BrainStorm margins.
%
%  The following files in the Toolbox access this figure:
%
%     layout_manager.m : Application M-file to manage the window layout
% bst_static_taskbar.m : BrainStorm's primary taskbar always visible
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in layout_manager.m
%
% Callbacks by figure layout_manager.fig
%   figure::layout_manager "" uses WindowButtonDownFcn for <automatic>
%   uicontrol:listbox:listbox_tiles "Listbox" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_align "Snap" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_close "Close All" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_close_tiles "Close Tiles" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_full "Default" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_help "Help" uses ButtonDownFcn for
%     layout_manager('pushbutton_margins_ButtonDownFcn',gcbo,[],guidata(gcbo))
%   uicontrol:pushbutton:pushbutton_help "Help" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_margins "Set" uses ButtonDownFcn for <automatic>
%   uicontrol:pushbutton:pushbutton_margins "Set" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_refresh "Refresh" uses Callback for <automatic>
%
%
%
% ========== LEAST_SQUARES_PARAMETERS.FIG ===========
%
% Help for this figure file (help_fig_least_squares_parameters) is given as:
%
%   (add help information)
%
% Help was also found in least_squares_parameters.m:
%
%  LEAST_SQUARES_PARAMETERS Application M-file for least_squares_parameters.fig
%   function varargout = least_squares_parameters(varargin)
%      FIG = LEAST_SQUARES_PARAMETERS launch least_squares_parameters GUI.
%      LEAST_SQUARES_PARAMETERS('callback_name', ...) invoke the named callback.
%
%  The following files in the Toolbox access this figure:
%
%            data_selector_cb.m : Callback function to setup and execute inverse techniques
%                 dataplot_cb.m : : Callback switchyard for the DATAPLOT Tool
% least_squares_parameters_cb.m : least_squares GUI setup and execution
%       parametric_estimation.m : GUI for selecting data segments and subspaces prior to estimation
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in least_squares_parameters.m
%
% Callbacks by figure least_squares_parameters.fig
%   figure::figure_LeastSquaresGui "" uses KeyPressFcn for dokeypress(gcbf)
%   figure::figure_LeastSquaresGui "" uses ResizeFcn for doresize(gcbf)
%   uicontrol:edit:edit_CurrentDipoleStereo "1" uses Callback for
%     least_squares_parameters_cb('set number')
%   uicontrol:edit:edit_MagneticDipole "1" uses Callback for
%     least_squares_parameters_cb('set number')
%   uicontrol:edit:edit_MagneticDipoleStereo "1" uses Callback for
%     least_squares_parameters_cb('set number')
%   uicontrol:edit:edit_Multipole "1" uses Callback for least_squares_parameters_cb('set number')
%   uicontrol:edit:edit_MultipoleStereo "1" uses Callback for
%     least_squares_parameters_cb('set number')
%   uicontrol:edit:EditCurrentDipole "1" uses Callback for least_squares_parameters_cb('set number')
%   uicontrol:popupmenu:popup_regularization "Regularization . . ." uses Callback for
%     least_squares_parameters_cb('set reg')
%   uicontrol:pushbutton:pushbutton_close "Close" uses Callback for delete(gcbf)
%   uicontrol:pushbutton:pushbutton_EditStartingPoints "Edit" uses Callback for
%     least_squares_parameters_cb('edit starting points');
%   uicontrol:pushbutton:pushbutton_Execute "Execute" uses Callback for
%     least_squares_parameters_cb('execute rap');
%   uicontrol:pushbutton:pushbutton_LoadStartingPoints "Load" uses Callback for
%     least_squares_parameters_cb('load starting points');
%   uicontrol:radiobutton:radio_CurrentDipole "Current Dipole" uses Callback for
%     least_squares_parameters_cb('set source')
%   uicontrol:radiobutton:radio_CurrentDipoleStereo "   Stereo Pair" uses Callback for
%     least_squares_parameters_cb('set source')
%   uicontrol:radiobutton:radio_MagneticDipole "Magnetic Dipole" uses Callback for
%     least_squares_parameters_cb('set source')
%   uicontrol:radiobutton:radio_MagneticDipoleStereo "   Stereo Pair" uses Callback for
%     least_squares_parameters_cb('set source')
%   uicontrol:radiobutton:radio_Moving "Moving" uses Callback for
%     least_squares_parameters_cb('set spatiotemporal')
%   uicontrol:radiobutton:radio_Multipole "1st-order Multipole" uses Callback for
%     least_squares_parameters_cb('set source')
%   uicontrol:radiobutton:radio_MultipoleStereo "   Stereo Pair" uses Callback for
%     least_squares_parameters_cb('set source')
%   uicontrol:radiobutton:radio_OrientationFixed "Fixed" uses Callback for
%     least_squares_parameters_cb('set orientation')
%   uicontrol:radiobutton:radio_OrientationRotating "Rotating" uses Callback for
%     least_squares_parameters_cb('set orientation')
%   uicontrol:radiobutton:radio_OrientationSynchronous "Synchronous" uses Callback for
%     least_squares_parameters_cb('set orientation')
%   uicontrol:radiobutton:radio_Stationary "Stationary" uses Callback for
%     least_squares_parameters_cb('set spatiotemporal')
%
%
%
% ========== LISTBOX_WIN.FIG ===========
%
% Help for this figure file (help_fig_listbox_win) is given as:
%
%   (add help information)
%
%  The following files in the Toolbox access this figure:
%
% help_fig_generic_listbox_win.m : Information on figure file 'generic_listbox_win'
%                   importdata.m : GUI m-file Import data from major MEG and EEG systems.
%               subject_editor.m : GUI to edit the BrainStorm Subject information, case switchyard
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in listbox_win.m
%
% Callbacks by figure listbox_win.fig
%   uicontrol:listbox:listbox "Hold On Please..." uses Callback for importdata ReadMarkerFile
%
%
%
% ========== LISTCHAN.FIG ===========
%
% Help for this figure file (help_fig_listchan) is given as:
%
%   (add help information)
%
%  The following files in the Toolbox access this figure:
%
% dataplot_cb.m : : Callback switchyard for the DATAPLOT Tool
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in listchan.m
%
% Callbacks by figure listchan.fig
%   uicontrol:listbox:available "" uses CreateFcn for movegui center
%   uicontrol:listbox:removed "" uses CreateFcn for movegui center
%   uicontrol:pushbutton:Pushbutton1 ">" uses CreateFcn for movegui center
%   uicontrol:pushbutton:Pushbutton1 ">" uses Callback for dataplot_cb channel_plot_remove
%   uicontrol:pushbutton:Pushbutton1 "<" uses CreateFcn for movegui center
%   uicontrol:pushbutton:Pushbutton1 "<" uses Callback for dataplot_cb channel_plot_restore
%   uicontrol:pushbutton:Pushbutton1 "Cancel" uses CreateFcn for movegui center
%   uicontrol:pushbutton:Pushbutton1 "Cancel" uses Callback for close gcbf
%   uicontrol:pushbutton:Pushbutton1 "Apply" uses CreateFcn for movegui center
%   uicontrol:pushbutton:Pushbutton1 "Apply" uses Callback for dataplot_cb listchan_refresh
%   uicontrol:pushbutton:pushbutton1 "Select All" uses CreateFcn for movegui center
%   uicontrol:pushbutton:pushbutton1 "Select All" uses Callback for dataplot_cb listchan_SelectAll
%   uicontrol:pushbutton:pushbutton2 "Remove All" uses CreateFcn for movegui center
%   uicontrol:pushbutton:pushbutton2 "Remove All" uses Callback for dataplot_cb listchan_RemoveAll
%   uicontrol:text:StaticText1 "Available" uses CreateFcn for movegui center
%   uicontrol:text:StaticText1 "Selected" uses CreateFcn for movegui center
%   uicontrol:text:text1 "Number of Columns" uses CreateFcn for movegui center
%
%
%
% ========== MANAGE_CORTICALSCOUTS.FIG ===========
%
% Help for this figure file (help_fig_manage_corticalscouts) is given as:
%
%   (add help information)
%
% Help was also found in manage_corticalscouts.m:
%
%  MANAGE_CORTICALSCOUTS Application M-file for manage_corticalscouts.fig
%   function varargout = manage_corticalscouts(action,varargin)
%
%  The following files in the Toolbox access this figure:
%
% manage_corticalscouts.m : Application M-file for manage_corticalscouts.fig
%           dataplot_cb.m : : Callback switchyard for the DATAPLOT Tool
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in manage_corticalscouts.m
%
% Callbacks by figure manage_corticalscouts.fig
%   uicontrol:checkbox:AbsoluteCurrent "Absolute current values" uses Callback for
%     manage_corticalscouts mutincomp_meanmax
%   uicontrol:pushbutton:DeleteCorticalSpot "Delete" uses Callback for
%     manage_corticalscouts DeleteCorticalSpot
%   uicontrol:pushbutton:LoadCorticalSpot "Load" uses Callback for
%     manage_corticalscouts LoadCorticalSpot
%   uicontrol:pushbutton:pushbutton35 "Activate" uses Callback for
%     manage_corticalscouts CorticalSpotActivity
%   uicontrol:pushbutton:pushbutton38 "+" uses Callback for manage_corticalscouts GrowCorticalArea
%   uicontrol:pushbutton:pushbutton39 "-" uses Callback for manage_corticalscouts ReduceCorticalArea
%   uicontrol:pushbutton:pushbutton41 "MRI" uses Callback for
%     manage_corticalscouts ImportScoutsFromMRI
%   uicontrol:pushbutton:pushbutton42 "Threshold" uses Callback for
%      manage_corticalscouts CorticalScoutFromThres
%   uicontrol:pushbutton:pushbutton43 "Corr. with sensor" uses Callback for
%     manage_corticalscouts CorrelationMapFromSensor
%   uicontrol:pushbutton:Qpushbutton7 "Close" uses Callback for close(gcbf)
%   uicontrol:pushbutton:RenameCorticalSpot "Rename" uses Callback for
%     manage_corticalscouts RenameCorticalSpot
%   uicontrol:pushbutton:SaveCorticalSpot "Save" uses Callback for
%     manage_corticalscouts SaveCorticalSpot
%   uicontrol:pushbutton:SelectCorticalSpot "Probe" uses Callback for
%     manage_corticalscouts SelectCorticalSpot
%   uicontrol:radiobutton:AllCorticalArea "All" uses Callback for
%     manage_corticalscouts mutincomp_meanmax
%   uicontrol:radiobutton:MaxCorticalArea "Max" uses Callback for
%     manage_corticalscouts mutincomp_meanmax
%   uicontrol:radiobutton:MeanCorticalArea "Mean" uses Callback for
%     manage_corticalscouts mutincomp_meanmax
%   uicontrol:togglebutton:pushbutton40 "Show selected" uses Callback for
%     manage_corticalscouts ShowClusters
%
%
%
% ========== MAP_SINGLE.FIG ===========
%
% Help for this figure file (help_fig_map_single) is given as:
%
%   (add help information)
%
%  The following files in the Toolbox access this figure:
%
%        dataplot_cb.m : : Callback switchyard for the DATAPLOT Tool
% mri_src_mapping_cb.m : (action)
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in map_single.m
%
%
%
% ========== MAPPING.FIG ===========
%
% Help for this figure file (help_fig_mapping) is given as:
%
%   (add help information)
%
%  The following files in the Toolbox access this figure:
%
%          bst_imaging_display.m : : display utility for cortical distributed source imaging 
%         bst_wavedata_display.m : Plot waveforms in tiles
%                        catci.m : computing color coding for activation on the vertices
%                  dataplot_cb.m : : Callback switchyard for the DATAPLOT Tool
%        manage_corticalscouts.m : Application M-file for manage_corticalscouts.fig
%              mri_src_mapping.m : .mat .m GUI combination for loading generators
%           mri_src_mapping_cb.m : (action)
%                   mritool_cb.m : Switchyard corresponding to the MRITOOL GUI (mribox.fig)
% set_sourceviewing_parameters.m : Application M-file for set_sourceviewing_parameters.fig
%                  subcorr_gui.m : Subcorr function custom to the gui features
%                   zscore_gui.m : : management of zscore visualization
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in mapping.m
%
% Callbacks by figure mapping.fig
%   figure::mapping "" uses ButtonDownFcn for dataplot_cb line_select
%   uicontrol:checkbox:ABSOLUTE "Absolute" uses Callback for dataplot_cb mutincomp_cmapping
%   uicontrol:checkbox:Colorbar "Colorbar" uses Callback for dataplot_cb Colorbar_mapping
%   uicontrol:checkbox:fit "Sensor array" uses Callback for dataplot_cb mapping_head_shape
%   uicontrol:checkbox:gradient "Gradient" uses Callback for dataplot_cb mapping_type
%   uicontrol:checkbox:magnetic "Mag. Field Estim." uses Callback for dataplot_cb mapping_type
%   uicontrol:checkbox:movie "Movie" uses Callback for dataplot_cb mapping_display_type
%   uicontrol:checkbox:raw "Raw Mapping" uses Callback for dataplot_cb mapping_type
%   uicontrol:checkbox:RELATIVE "Relative" uses Callback for dataplot_cb mutincomp_cmapping
%   uicontrol:checkbox:scalp "Scalp surface" uses Callback for dataplot_cb mapping_head_shape
%   uicontrol:checkbox:ShowSensorLabels "Sensor Labels" uses Callback for dataplot_cb mapping_type
%   uicontrol:checkbox:single "Single" uses Callback for dataplot_cb mapping_display_type
%   uicontrol:checkbox:slides "Slides" uses Callback for dataplot_cb mapping_display_type
%   uicontrol:checkbox:sphere "Sphere" uses Callback for dataplot_cb mapping_head_shape
%   uicontrol:edit:current_time "0" uses Callback for dataplot_cb set_current_time
%   uicontrol:pushbutton:go "Apply" uses Callback for dataplot_cb gomapping
%   uicontrol:pushbutton:Pushbutton1 "Quit" uses Callback for delete(gcbf)
%   uicontrol:slider:slider_time "" uses Callback for dataplot_cb mapping_slider
%
%
%
% ========== MARKERS_SELECT.FIG ===========
%
% Help for this figure file (help_fig_markers_select) is given as:
%
%   (add help information)
%
%  The following files in the Toolbox access this figure:
%
% sourceimaging.m : Main switch to source imaging routines
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in markers_select.m
%
% Callbacks by figure markers_select.fig
%   figure::marker_select "" uses CreateFcn for movegui center;
%   uicontrol:checkbox:AllEvents "all" uses Callback for sourceimaging EventSelection
%   uicontrol:edit:EventSelection "" uses Callback for sourceimaging EventSelection2
%   uicontrol:pushbutton:HPushbutton1 "Done" uses Callback for close gcbf
%   uicontrol:pushbutton:HPushbutton10 ">" uses Callback for sourceimaging markers_select
%   uicontrol:pushbutton:HPushbutton2 "<" uses Callback for sourceimaging markers_remove
%   uicontrol:pushbutton:QPushbutton1 "Quit" uses Callback for close gcbf
%
%
%
% ========== MINNORM_PARAMETERS.FIG ===========
%
% Help for this figure file (help_fig_minnorm_parameters) is given as:
%
%   (add help information)
%
%  The following files in the Toolbox access this figure:
%
%      data_selector_cb.m : Callback function to setup and execute inverse techniques
% minnorm_parameters_cb.m : Minimum Norm GUI setup and execution
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in minnorm_parameters.m
%
% Callbacks by figure minnorm_parameters.fig
%   figure::MinNorm Gui "" uses KeyPressFcn for dokeypress(gcbf)
%   figure::MinNorm Gui "" uses ResizeFcn for doresize(gcbf)
%   uicontrol:popupmenu:PopupReg "Regularization . . ." uses Callback for
%     minnorm_parameters_cb ('set reg');
%   uicontrol:pushbutton:ExecuteRAP "Execute" uses Callback for minnorm_parameters_cb('execute rap');
%   uicontrol:pushbutton:Pushbutton1 "Quit" uses Callback for delete(gcbf)
%   uimenu::                       "" uses Callback for
%     filemenufcn(gcbf,'FilePost')                                                    
%   uimenu::                       "" uses Callback for
%     figure                                                                          
%   uimenu::                       "" uses Callback for
%     filemenufcn(gcbf,'FileOpen')                                                    
%   uimenu::                       "" uses Callback for
%     close(gcbf)                                                                     
%   uimenu::                       "" uses Callback for
%     filemenufcn(gcbf,'FileExport')                                                  
%   uimenu::                       "" uses Callback for
%     propedit(gcbf)                                                                  
%   uimenu::                       "" uses Callback for
%     filemenufcn(gcbf,'FilePreferences')                                             
%   uimenu::                       "" uses Callback for
%     pagesetupdlg(gcbf)                                                              
%   uimenu::                       "" uses Callback for
%     filemenufcn(gcbf,'FilePrintSetup')                                              
%   uimenu::                       "" uses Callback for
%     printpreview(gcbf)                                                              
%   uimenu::                       "" uses Callback for
%     printdlg                                                                        
%   uimenu::                       "" uses Callback for
%     editmenufcn(gcbf,'EditCopyFigure')                                              
%   uimenu::                       "" uses Callback for
%     editmenufcn(gcbf,'EditCopyOptions')                                             
%   uimenu::                       "" uses Callback for
%     domymenu('menubar','toggletoolbar',gcbf)                                        
%   uimenu::                       "" uses Callback for
%     %<noop>                                                                         
%   uimenu::                       "" uses Callback for
%     domymenu menubar addaxes                                                        
%   uimenu::                       "" uses Callback for
%     domymenu menubar addarrow                                                       
%   uimenu::                       "" uses Callback for
%     domymenu menubar addline                                                        
%   uimenu::                       "" uses Callback for
%     domymenu menubar addtext                                                        
%   uimenu::                       "" uses Callback for
%     domymenu menubar zoomin                                                         
%   uimenu::                       "" uses Callback for
%     domymenu menubar zoomout                                                        
%   uimenu::                       "" uses Callback for
%     domymenu menubar rotate3d                                                       
%   uimenu::                       "" uses Callback for
%     winmenu(gcbo)                                                                   
%   uimenu::                       "" uses Callback for
%     %<noop>                                                                         
%   uimenu::                       "" uses Callback for
%     helpview([docroot '/mapfiles/plotedit.map'], 'plot_editor','PlotEditCollection')
%   uimenu::                       "" uses Callback for
%     web([docroot '/techdoc/umg/umg.html']);                                         
%   uimenu::                       "" uses Callback for
%     helpwin                                                                         
%   uimenu::                       "" uses Callback for
%     helpwin helpinfo                                                                
%   uimenu::                       "" uses Callback for
%     helpdesk                                                                        
%   uimenu::                       "" uses Callback for
%     demo                                                                            
%   uimenu::                       "" uses Callback for
%     uimenufcn(gcbf,'HelpAbout')                                                     
%   uimenu::                       "" uses Callback for
%     doc subscribe                                                                   
%   uimenu::figMenuEdit "" uses Callback for
%     editmenufcn(gcbf,'EditPost')                                                    
%   uimenu::figMenuEditClear "" uses Callback for
%     uimenufcn(gcbf,'EditClear')                                                     
%   uimenu::figMenuEditCopy "" uses Callback for
%     uimenufcn(gcbf,'EditCopy')                                                      
%   uimenu::figMenuEditCut "" uses Callback for
%     uimenufcn(gcbf,'EditCut')                                                       
%   uimenu::figMenuEditPaste "" uses Callback for
%     uimenufcn(gcbf,'EditPaste')                                                     
%   uimenu::figMenuEditSelectAll "" uses Callback for
%     uimenufcn(gcbf,'EditSelectAll')                                                 
%   uimenu::figMenuEditUndo "" uses Callback for
%     editmenufcn(gcbf,'EditUndo')                                                    
%   uimenu::figMenuFileSave "" uses Callback for
%     filemenufcn(gcbf,'FileSave')                                                    
%   uimenu::figMenuFileSaveAs "" uses Callback for
%     filemenufcn(gcbf,'FileSaveAs')                                                  
%   uimenu::figMenuTools "" uses Callback for
%     domymenu('menubar','updatetools',gcbf)                                          
%   uimenu::figMenuToolsAxesProps "" uses Callback for
%     domymenu menubar axesprop                                                       
%   uimenu::figMenuToolsLineProps "" uses Callback for
%     domymenu menubar lineprop                                                       
%   uimenu::figMenuToolsLockAxes "" uses Callback for
%     domymenu menubar lockaxes                                                       
%   uimenu::figMenuToolsPlotedit "" uses Callback for
%     plotedit(gcbf)                                                                  
%   uimenu::figMenuToolsShowLegend "" uses Callback for
%     domymenu menubar legend                                                         
%   uimenu::figMenuToolsTextProps "" uses Callback for
%     domymenu menubar textprop                                                       
%   uitoggletool::ScribeSelectToolBtn "" uses DeleteFcn for plotedit(gcbf,'off')
%
%
%
% ========== MRI_READ_TOOL.FIG ===========
%
% Help for this figure file (help_fig_mri_read_tool) is given as:
%
%   (add help information)
%
% Help was also found in mri_read_tool.m:
%
%  MRI_READ_TOOL AOS Version Application M-file to read in MRI and manipulate
%   function varargout = mri_read_tool(varargin)
%      FIG = MRI_READ_TOOL launch mri_read_tool GUI.
%      MRI_READ_TOOL('callback_name', ...) invoke the named callback.
%  
%   Particularly useful with results_visulation to automatically load
%    results. 
%   See also RESULTS_VISULIZATION 
%
%  The following files in the Toolbox access this figure:
%
%         mri_read_tool.m : AOS Version Application M-file to read in MRI and manipulate
%    bst_static_taskbar.m : BrainStorm's primary taskbar always visible
%  make_default_subject.m : Make a brainstormsubject and simulated MRI in a folder
%   results_time_series.m : Application M-file for results_time_series.fig
% results_visualization.m : Application M-file View the results of source modeling
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in mri_read_tool.m
%
% Callbacks by figure mri_read_tool.fig
%   uicontextmenu::deletepoints "" uses Callback for <automatic>
%   uicontrol:listbox:coords "Coordinates" uses Callback for
%     mri_read_tool('coord_Callback',gcbo,[],guidata(gcbo))
%   uicontrol:listbox:listpoints "Selected Points" uses ButtonDownFcn for <automatic>
%   uicontrol:listbox:listpoints "Selected Points" uses Callback for <automatic>
%   uicontrol:pushbutton:addpoint "Add Point" uses Callback for <automatic>
%   uicontrol:pushbutton:brighten "Brighten" uses Callback for <automatic>
%   uicontrol:pushbutton:darken "Darken" uses Callback for <automatic>
%   uicontrol:pushbutton:definepcs "Define PCS" uses Callback for <automatic>
%   uicontrol:pushbutton:Hloadbsformat "Load BST Format" uses Callback for
%     mri_read_tool('readbs_Callback',gcbo,[],guidata(gcbo))
%   uicontrol:pushbutton:Quit "Quit" uses Callback for <automatic>
%   uicontrol:slider:slider1 "" uses Callback for <automatic>
%   uicontrol:slider:slider2 "" uses Callback for <automatic>
%   uicontrol:slider:slider3 "" uses Callback for <automatic>
%   uicontrol:slider:slider4 "" uses Callback for <automatic>
%   uicontrol:slider:slider5 "" uses Callback for <automatic>
%   uicontrol:slider:slider6 "" uses Callback for <automatic>
%   uicontrol:togglebutton:zoomtoggle "Zoom On" uses Callback for <automatic>
%   uimenu::deleteall "" uses Callback for <automatic>
%   uimenu::deletecurrent "" uses Callback for <automatic>
%   uimenu::hideall "" uses Callback for <automatic>
%   uimenu::hidecurrent "" uses Callback for <automatic>
%   uimenu::print_preview "" uses Callback for printpreview(gcbf)
%   uimenu::rawformat "" uses Callback for <automatic>
%   uimenu::readbsuite "" uses Callback for <automatic>
%   uimenu::readctf "" uses Callback for <automatic>
%   uimenu::readmrscans "" uses Callback for <automatic>
%   uimenu::savemrscan_Bsuite "" uses Callback for
%     mri_read_tool('savemrscans_Bsuite_Callback',gcbo,[],guidata(gcbo))
%   uimenu::savemrscans "" uses Callback for <automatic>
%   uimenu::savepoints "" uses Callback for <automatic>
%   uimenu::showall "" uses Callback for <automatic>
%   uimenu::ShowCrosshairs "" uses Callback for <automatic>
%
%
%
% ========== MRI_SCAN_PARAMS.FIG ===========
%
% Help for this figure file (help_fig_mri_scan_params) is given as:
%
%   (add help information)
%
% Help was also found in mri_scan_params.m:
%
%  MRI_SCAN_PARAMS Application M-file for mri_scan_params.fig
%   function varargout = mri_scan_params(varargin)
%      FIG = MRI_SCAN_PARAMS launch mri_scan_params GUI.
%      MRI_SCAN_PARAMS('callback_name', ...) invoke the named callback.
%
%  The following files in the Toolbox access this figure:
%
% mri_scan_params.m : Application M-file for mri_scan_params.fig
%   mri_read_tool.m : AOS Version Application M-file to read in MRI and manipulate
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in mri_scan_params.m
%
% Callbacks by figure mri_scan_params.fig
%   uicontrol:checkbox:checkbox1 "littleendian" uses Callback for <automatic>
%   uicontrol:edit:fov "220 220" uses Callback for <automatic>
%   uicontrol:edit:header "0" uses Callback for <automatic>
%   uicontrol:edit:image_size "256 256" uses Callback for <automatic>
%   uicontrol:edit:nslice "150" uses Callback for <automatic>
%   uicontrol:edit:slice_thickness "1.09" uses Callback for <automatic>
%   uicontrol:popupmenu:data_format "char char*1 Character; 8 bits " uses Callback for <automatic>
%   uicontrol:popupmenu:scan_type "Axial" uses Callback for <automatic>
%   uicontrol:pushbutton:done "Done" uses Callback for <automatic>
%   uicontrol:pushbutton:Hquit "Quit" uses Callback for
%     mri_scan_params('quit_Callback',gcbo,[],guidata(gcbo))
%
%
%
% ========== MRIBOX.FIG ===========
%
% Help for this figure file (help_fig_mribox) is given as:
%
%   (add help information)
%
%  The following files in the Toolbox access this figure:
%
% mritool_cb.m : Switchyard corresponding to the MRITOOL GUI (mribox.fig)
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in mribox.m
%
% Callbacks by figure mribox.fig
%   text::Axes1Text1 "" uses ButtonDownFcn for ctlpanel SelectMoveResize
%   text::Axes1Text1 "" uses ButtonDownFcn for ctlpanel SelectMoveResize
%   text::Axes1Text2 "" uses ButtonDownFcn for ctlpanel SelectMoveResize
%   text::Axes1Text2 "" uses ButtonDownFcn for ctlpanel SelectMoveResize
%   text::Axes1Text3 "" uses ButtonDownFcn for ctlpanel SelectMoveResize
%   text::Axes1Text3 "" uses ButtonDownFcn for ctlpanel SelectMoveResize
%   text::Axes1Text4 "" uses ButtonDownFcn for ctlpanel SelectMoveResize
%   text::Axes1Text4 "" uses ButtonDownFcn for ctlpanel SelectMoveResize
%   uicontrol:checkbox:big-endian "Big-endian" uses Callback for
%     mutincomp([findobj(gcbf,'Tag','big-endian'), findobj(gcbf,'Tag','little-endian')]);
%   uicontrol:checkbox:flip_lr_a "" uses Callback for mritool_cb flip_lr_a
%   uicontrol:checkbox:flip_ud_c "" uses Callback for mritool_cb flip_ud_c
%   uicontrol:checkbox:flip_ud_s "" uses Callback for mritool_cb flip_ud_s
%   uicontrol:checkbox:gotopoint "'Go to Point' mode" uses Callback for mritool_cb gotopoint
%   uicontrol:checkbox:little-endian "Little-endian" uses Callback for
%     mutincomp([findobj(gcbf,'Tag','big-endian'), findobj(gcbf,'Tag','little-endian')]);
%   uicontrol:checkbox:mouse_slct "Select Slice with Mouse" uses Callback for mritool_cb mouse_slct
%   uicontrol:checkbox:show_coordinates "Show Coordinates" uses Callback for
%     mritool_cb show_coordinates
%   uicontrol:checkbox:zoom "Activate Zoom" uses Callback for mritool_cb zoom
%   uicontrol:listbox:listbox "" uses Callback for mritool_cb current_point
%   uicontrol:pushbutton:BLOBS "Load SPM Clusters" uses Callback for mritool_cb addblobs
%   uicontrol:pushbutton:deletepoint "Delete" uses Callback for mritool_cb deletepoint
%   uicontrol:pushbutton:Hscalppoints "Load MR Volume" uses Callback for mritool_cb LoadBrainStorm
%   uicontrol:pushbutton:LEAFLET "Leaflet" uses Callback for mritool_cb leaflet
%   uicontrol:pushbutton:newlabel "New Label" uses Callback for mritool_cb newlabel
%   uicontrol:pushbutton:next ">" uses Callback for mritool_cb current_point
%   uicontrol:pushbutton:PCS "Define SCS" uses Callback for mritool_cb pcs
%   uicontrol:pushbutton:previous "<" uses Callback for mritool_cb current_point
%   uicontrol:pushbutton:pushbutton1 "Cortical Scout" uses Callback for mritool_cb CorticalScout
%   uicontrol:pushbutton:Quit "Quit" uses Callback for mritool_cb quit
%   uicontrol:pushbutton:scalppoints "Rendering" uses Callback for rendering_cb create
%   uicontrol:pushbutton:seelabels "Show Label" uses Callback for mritool_cb seelabels
%   uicontrol:pushbutton:seepoints "See/Hidel Points" uses Callback for mritool_cb seepoints
%   uicontrol:pushbutton:showfiducials "Show Fiducials" uses Callback for mritool_cb showfiducials
%   uicontrol:pushbutton:slctpoint "Brighten" uses Callback for mritool_cb brighten
%   uicontrol:pushbutton:slctpoint2 "Darken" uses Callback for mritool_cb darken
%   uicontrol:pushbutton:slctpoint20 "Select" uses Callback for mritool_cb slctpoint
%   uicontrol:pushbutton:slctpoint3 "Process fMRI Files" uses Callback for mritool_cb concatenate
%   uicontrol:pushbutton:slctpoint5 "Load Generators" uses Callback for mritool_cb readresults
%   uicontrol:radiobutton:ZoomButton1 "" uses Callback for mritool_cb ZoomButton
%   uicontrol:radiobutton:ZoomButton2 "" uses Callback for mritool_cb ZoomButton
%   uicontrol:radiobutton:ZoomButton3 "" uses Callback for mritool_cb ZoomButton
%   uicontrol:slider:1 "" uses ButtonDownFcn for mritool_cb sliders
%   uicontrol:slider:1 "" uses Callback for mritool_cb sliders
%   uicontrol:slider:2 "" uses ButtonDownFcn for mritool_cb sliders
%   uicontrol:slider:2 "" uses Callback for mritool_cb sliders
%   uicontrol:slider:3 "" uses ButtonDownFcn for mritool_cb sliders
%   uicontrol:slider:3 "" uses Callback for mritool_cb sliders
%   uimenu:: "" uses Callback for mritool_cb fifmri
%   uimenu::FileImport MR Scans.mri formatuimenu1 "" uses Callback for mritool_cb mrislice
%   uimenu::FileImport MRI Data.mri format1 "" uses Callback for mritool_cb mriformat
%   uimenu::FileRead MR Scansuimenu1 "" uses Callback for mritool_cb saveaxial
%   uimenu::Fileuimenu3 "" uses Callback for mritool_cb SaveAsBrainstorm
%   uimenu::Fileuimenu4 "" uses Callback for mritool_cb LoadBrainStorm
%   uimenu::img format "" uses Callback for mritool_cb imgformat
%   uimenu::Import/Export Cortical Remappinguimenu1 "" uses Callback for mritool_cb saveas_points
%   uimenu::Import/Export Import MEG Cortical Mapsuimenu1 "" uses Callback for
%     mritool_cb cortic_remap
%   uimenu::Import/Export Read MR ScansLoad .mri formatuimenu1 "" uses Callback for mritool_cb ctfmri
%   uimenu::Import/Export uimenu1 "" uses Callback for mritool_cb MEGBlobs
%   uimenu::IMPORT_mridata "" uses Callback for mritool_cb IMPORT_mridata 
%
%
%
% ========== PARAMETRIC_ESTIMATION.FIG ===========
%
% Help for this figure file (help_fig_parametric_estimation) is given as:
%
%   (add help information)
%
% Help was also found in parametric_estimation.m:
%
%  PARAMETRIC_ESTIMATION GUI for selecting data segments and subspaces prior to estimation
%   function varargout = parametric_estimation(varargin)
%      FIG = PARAMETRIC_ESTIMATION launch parametric_estimation GUI.
%      PARAMETRIC_ESTIMATION('callback_name', ...) invoke the named callback.
%  
%   Application Data in this GUI, handles.ParametricEstimation
%    StudySubject, standard structure
%    Data, standard structure as loaded from the disk
%    DataFile, fully qualified filename
%    USV, decomposition of selected data segment
%    hplot, handle to the vertical line the SVD plot
%
%  The following files in the Toolbox access this figure:
%
% parametric_estimation.m : GUI for selecting data segments and subspaces prior to estimation
%    bst_static_taskbar.m : BrainStorm's primary taskbar always visible
%           dataplot_cb.m : : Callback switchyard for the DATAPLOT Tool
%  rap_music_parameters.m : Application M-file for rap_music_parameters.fig
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in parametric_estimation.m
%
% Callbacks by figure parametric_estimation.fig
%   axes::AxisNoiseSubspace "" uses ButtonDownFcn for <automatic>
%   axes::AxisSignalSubspace "" uses ButtonDownFcn for <automatic>
%   axes::AxisSVD "" uses ButtonDownFcn for <automatic>
%   uicontextmenu::uicontextmenu_selection_action "" uses Callback for <automatic>
%   uicontrol:checkbox:button_grid "Gridding" uses Callback for <automatic>
%   uicontrol:checkbox:PopupSVD "Log Y-Axis" uses Callback for <automatic>
%   uicontrol:edit:EditMaxTime "Max" uses Callback for <automatic>
%   uicontrol:edit:EditMinTime "Min" uses Callback for <automatic>
%   uicontrol:edit:EditRank "Rank" uses Callback for <automatic>
%   uicontrol:listbox:Data_Stats "Time Index:" uses Callback for <automatic>
%   uicontrol:popupmenu:EstimationTechnique "Select Method . . ." uses Callback for <automatic>
%   uicontrol:popupmenu:popupmenu_domain "Time" uses Callback for <automatic>
%   uicontrol:pushbutton:DatabaseManager "Data Manager" uses Callback for <automatic>
%   uicontrol:pushbutton:Pushbutton_decompose "Decompose" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_help "Help" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_reload_data "Reload Data" uses Callback for <automatic>
%   uicontrol:pushbutton:Quit "Done" uses Callback for <automatic>
%   uicontrol:radiobutton:radiobutton_eeg "EEG Data" uses Callback for <automatic>
%   uicontrol:radiobutton:radiobutton_meg "MEG Data" uses Callback for <automatic>
%   uicontrol:slider:SliderRank "" uses Callback for <automatic>
%   uicontrol:togglebutton:togglebutton_projector_detect "No Projector Detected" uses Callback for <automatic>
%   uicontrol:togglebutton:togglebutton_zoom "Zoom Mode" uses ButtonDownFcn for <automatic>
%   uicontrol:togglebutton:togglebutton_zoom "Zoom Mode" uses Callback for <automatic>
%   uimenu::uimenu_clear_data_exclusion "" uses Callback for <automatic>
%   uimenu::uimenu_clear_projector "" uses Callback for <automatic>
%   uimenu::uimenu_data_exclude "" uses Callback for <automatic>
%   uimenu::uimenu_help_selection_action "" uses Callback for <automatic>
%   uimenu::uimenu_subspace_reject "" uses Callback for <automatic>
%
%
%
% ========== PCS_PARAMS.FIG ===========
%
% Help for this figure file (help_fig_pcs_params) is given as:
%
%   (add help information)
%
% Help was also found in pcs_params.m:
%
%  PCS_PARAMS Application M-file to set the parameters of the patient coordinates
%   function varargout = PCS_params(varargin)
%      FIG = PCS_PARAMS launch PCS_params GUI.
%      PCS_PARAMS('callback_name', ...) invoke the named callback.
%
%  The following files in the Toolbox access this figure:
%
%    pcs_params.m : Application M-file to set the parameters of the patient coordinates
% mri_read_tool.m : AOS Version Application M-file to read in MRI and manipulate
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in pcs_params.m
%
% Callbacks by figure pcs_params.fig
%   uicontrol:listbox:listbox1 "Listbox" uses Callback for
%     PCS_params('listbox1_Callback',gcbo,[],guidata(gcbo))
%   uicontrol:listbox:listbox2 "Listbox" uses Callback for
%     PCS_params('listbox2_Callback',gcbo,[],guidata(gcbo))
%   uicontrol:pushbutton:assign "Assign" uses Callback for
%     PCS_params('assign_Callback',gcbo,[],guidata(gcbo))
%   uicontrol:pushbutton:done "Done" uses Callback for
%     PCS_params('done_Callback',gcbo,[],guidata(gcbo))
%   uicontrol:pushbutton:Quit "Quit" uses Callback for
%     PCS_params('quit_Callback',gcbo,[],guidata(gcbo))
%   uicontrol:radiobutton:checkboxctf "CTF / Magnes" uses Callback for
%     PCS_params('checkboxctf_Callback',gcbo,[],guidata(gcbo))
%   uicontrol:radiobutton:checkboxnmag "Neuromag" uses Callback for
%     PCS_params('checkboxnmag_Callback',gcbo,[],guidata(gcbo))
%
%
%
% ========== RAP_MUSIC_PARAMETERS.FIG ===========
%
% Help for this figure file (help_fig_rap_music_parameters) is given as:
%
%   (add help information)
%
% Help was also found in rap_music_parameters.m:
%
%  RAP_MUSIC_PARAMETERS Application M-file for rap_music_parameters.fig
%   function varargout = rap_music_parameters(varargin)
%      FIG = RAP_MUSIC_PARAMETERS launch rap_music_parameters GUI.
%      RAP_MUSIC_PARAMETERS('callback_name', ...) invoke the named callback.
%
%  The following files in the Toolbox access this figure:
%
%  rap_music_parameters.m : Application M-file for rap_music_parameters.fig
%    bst_static_taskbar.m : BrainStorm's primary taskbar always visible
%           dataplot_cb.m : : Callback switchyard for the DATAPLOT Tool
% parametric_estimation.m : GUI for selecting data segments and subspaces prior to estimation
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in rap_music_parameters.m
%
% Callbacks by figure rap_music_parameters.fig
%   uicontrol:checkbox:checkbox_final_graphs "Final" uses Callback for <automatic>
%   uicontrol:checkbox:checkbox_interactive_graphs "Interactive" uses Callback for <automatic>
%   uicontrol:checkbox:CheckboxColumnNorm "Column Normalization" uses Callback for <automatic>
%   uicontrol:checkbox:CurrentDipole "Current Dipoles" uses Callback for <automatic>
%   uicontrol:checkbox:CurrentDipole2 "Synchronous Pairs of Dipoles" uses Callback for <automatic>
%   uicontrol:checkbox:Multipole "1st-order Multipoles" uses Callback for <automatic>
%   uicontrol:checkbox:Multipole2 "Synchronous Pairs of Multipoles" uses Callback for <automatic>
%   uicontrol:edit:edit_threshold "0.95" uses Callback for <automatic>
%   uicontrol:edit:EditReg "100" uses Callback for <automatic>
%   uicontrol:edit:HeadModel_Directory "Head Model Directory" uses Callback for <automatic>
%   uicontrol:popupmenu:popup_cd2_headmodel "Popup Menu" uses ButtonDownFcn for <automatic>
%   uicontrol:popupmenu:popup_cd2_headmodel "Popup Menu" uses Callback for <automatic>
%   uicontrol:popupmenu:popup_cd_headmodel "Popup Menu" uses ButtonDownFcn for <automatic>
%   uicontrol:popupmenu:popup_cd_headmodel "Popup Menu" uses Callback for <automatic>
%   uicontrol:popupmenu:popup_cme2_headmodel "Popup Menu" uses ButtonDownFcn for <automatic>
%   uicontrol:popupmenu:popup_cme2_headmodel "Popup Menu" uses Callback for <automatic>
%   uicontrol:popupmenu:popup_cme_headmodel "Popup Menu" uses ButtonDownFcn for <automatic>
%   uicontrol:popupmenu:popup_cme_headmodel "Popup Menu" uses Callback for <automatic>
%   uicontrol:popupmenu:PopupReg "Regularization . . ." uses ButtonDownFcn for <automatic>
%   uicontrol:popupmenu:PopupReg "Regularization . . ." uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_execute "Execute" uses Callback for <automatic>
%   uicontrol:slider:slider_threshold "" uses Callback for <automatic>
%   uimenu::menu_help_correlation "" uses Callback for <automatic>
%   uimenu::menu_quit "" uses Callback for <automatic>
%   uimenu::Untitled_5 "" uses Callback for <automatic>
%
%
%
% ========== RESULTS_TIME_SERIES.FIG ===========
%
% Help for this figure file (help_fig_results_time_series) is given as:
%
%   (add help information)
%
% Help was also found in results_time_series.m:
%
%  RESULTS_TIME_SERIES Application M-file for results_time_series.fig
%   function varargout = results_time_series(varargin)
%      FIG = RESULTS_TIME_SERIES launch results_time_series GUI.
%      RESULTS_TIME_SERIES('callback_name', ...) invoke the named callback.
%
%  The following files in the Toolbox access this figure:
%
% results_time_series.m : Application M-file for results_time_series.fig
%        rapmusic_gui.m : Execute RAPMUSIC using GUI inputs, BrainStorm MMII version
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in results_time_series.m
%
% Callbacks by figure results_time_series.fig
%   uicontextmenu::uicontext_flip_orientation "" uses Callback for <automatic>
%   uicontrol:checkbox:checkbox_scale "Scale" uses ButtonDownFcn for <automatic>
%   uicontrol:checkbox:checkbox_scale "Scale" uses Callback for <automatic>
%   uicontrol:listbox:listbox_sourceparam "Source Parameters" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_help "Help" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_print "Print Menu ..." uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_quit "Quit" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_results_spatial "Spatial Display" uses Callback for <automatic>
%   uimenu::uimenu_flip_orientation "" uses Callback for <automatic>
%
%
%
% ========== RESULTS_UPDATE_GUI.FIG ===========
%
% Help for this figure file (help_fig_results_update_gui) is given as:
%
%   (add help information)
%
%  The following files in the Toolbox access this figure:
%
% results_update.m : Update of display the source parameters and residuals while RAP-MUSIC or LS is running.
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in results_update_gui.m
%
% Callbacks by figure results_update_gui.fig
%   text::Axes1Text1 "" uses ButtonDownFcn for ctlpanel SelectMoveResize
%   text::Axes1Text2 "" uses ButtonDownFcn for ctlpanel SelectMoveResize
%   text::Axes1Text3 "" uses ButtonDownFcn for ctlpanel SelectMoveResize
%   text::Axes1Text4 "" uses ButtonDownFcn for ctlpanel SelectMoveResize
%   uimenu::                       "" uses Callback for
%     filemenufcn(gcbf,'FilePost')                                                    
%   uimenu::                       "" uses Callback for
%     figure                                                                          
%   uimenu::                       "" uses Callback for
%     filemenufcn(gcbf,'FileOpen')                                                    
%   uimenu::                       "" uses Callback for
%     close(gcbf)                                                                     
%   uimenu::                       "" uses Callback for
%     filemenufcn(gcbf,'FileExport')                                                  
%   uimenu::                       "" uses Callback for
%     propedit(gcbf)                                                                  
%   uimenu::                       "" uses Callback for
%     filemenufcn(gcbf,'FilePreferences')                                             
%   uimenu::                       "" uses Callback for
%     pagesetupdlg(gcbf)                                                              
%   uimenu::                       "" uses Callback for
%     filemenufcn(gcbf,'FilePrintSetup')                                              
%   uimenu::                       "" uses Callback for
%     printpreview(gcbf)                                                              
%   uimenu::                       "" uses Callback for
%     printdlg                                                                        
%   uimenu::                       "" uses Callback for
%     editmenufcn(gcbf,'EditCopyFigure')                                              
%   uimenu::                       "" uses Callback for
%     editmenufcn(gcbf,'EditCopyOptions')                                             
%   uimenu::                       "" uses Callback for
%     domymenu('menubar','toggletoolbar',gcbf)                                        
%   uimenu::                       "" uses Callback for
%     %<noop>                                                                         
%   uimenu::                       "" uses Callback for
%     domymenu menubar addaxes                                                        
%   uimenu::                       "" uses Callback for
%     domymenu menubar addarrow                                                       
%   uimenu::                       "" uses Callback for
%     domymenu menubar addline                                                        
%   uimenu::                       "" uses Callback for
%     domymenu menubar addtext                                                        
%   uimenu::                       "" uses Callback for
%     domymenu menubar zoomin                                                         
%   uimenu::                       "" uses Callback for
%     domymenu menubar zoomout                                                        
%   uimenu::                       "" uses Callback for
%     domymenu menubar rotate3d                                                       
%   uimenu::                       "" uses Callback for
%     winmenu(gcbo)                                                                   
%   uimenu::                       "" uses Callback for
%     %<noop>                                                                         
%   uimenu::                       "" uses Callback for
%     helpview([docroot '/mapfiles/plotedit.map'], 'plot_editor','PlotEditCollection')
%   uimenu::                       "" uses Callback for
%     web([docroot '/techdoc/umg/umg.html']);                                         
%   uimenu::                       "" uses Callback for
%     helpwin                                                                         
%   uimenu::                       "" uses Callback for
%     helpwin helpinfo                                                                
%   uimenu::                       "" uses Callback for
%     helpdesk                                                                        
%   uimenu::                       "" uses Callback for
%     demo                                                                            
%   uimenu::                       "" uses Callback for
%     uimenufcn(gcbf,'HelpAbout')                                                     
%   uimenu::                       "" uses Callback for
%     doc subscribe                                                                   
%   uimenu::figMenuEdit "" uses Callback for
%     editmenufcn(gcbf,'EditPost')                                                    
%   uimenu::figMenuEditClear "" uses Callback for
%     uimenufcn(gcbf,'EditClear')                                                     
%   uimenu::figMenuEditCopy "" uses Callback for
%     uimenufcn(gcbf,'EditCopy')                                                      
%   uimenu::figMenuEditCut "" uses Callback for
%     uimenufcn(gcbf,'EditCut')                                                       
%   uimenu::figMenuEditPaste "" uses Callback for
%     uimenufcn(gcbf,'EditPaste')                                                     
%   uimenu::figMenuEditSelectAll "" uses Callback for
%     uimenufcn(gcbf,'EditSelectAll')                                                 
%   uimenu::figMenuEditUndo "" uses Callback for
%     editmenufcn(gcbf,'EditUndo')                                                    
%   uimenu::figMenuFileSave "" uses Callback for
%     filemenufcn(gcbf,'FileSave')                                                    
%   uimenu::figMenuFileSaveAs "" uses Callback for
%     filemenufcn(gcbf,'FileSaveAs')                                                  
%   uimenu::figMenuTools "" uses Callback for
%     domymenu('menubar','updatetools',gcbf)                                          
%   uimenu::figMenuToolsAxesProps "" uses Callback for
%     domymenu menubar axesprop                                                       
%   uimenu::figMenuToolsLineProps "" uses Callback for
%     domymenu menubar lineprop                                                       
%   uimenu::figMenuToolsLockAxes "" uses Callback for
%     domymenu menubar lockaxes                                                       
%   uimenu::figMenuToolsPlotedit "" uses Callback for
%     plotedit(gcbf)                                                                  
%   uimenu::figMenuToolsShowLegend "" uses Callback for
%     domymenu menubar legend                                                         
%   uimenu::figMenuToolsTextProps "" uses Callback for
%     domymenu menubar textprop                                                       
%   uitoggletool::ScribeSelectToolBtn "" uses DeleteFcn for plotedit(gcbf,'off')
%
%
%
% ========== RESULTS_VISUALIZATION.FIG ===========
%
% Help for this figure file (help_fig_results_visualization) is given as:
%
%   (add help information)
%
% Help was also found in results_visualization.m:
%
%  RESULTS_VISUALIZATION Application M-file View the results of source modeling
%   function varargout = results_visualization(varargin)
%      FIG = RESULTS_VISUALIZATION launch results_visualization GUI.
%      RESULTS_VISUALIZATION('callback_name', ...) invoke the named callback.
%  
%   Launches MRI_READ_TOOL as companion for orthogonal viewing of results
%   E.G. 
%      fig = results_visualization;
%      fighandles = guihandles(fig);
%      results_visualization('loadparametric_Callback',...
%        fighandles.loadparametric, [], fighandles, ResultsFname);
%   where ResultsFname is the name of a BrainStorm results file,
%   or do not include ResultsFname for an interactive load.
%  
%   See also MRI_READ_TOOL
%
%  The following files in the Toolbox access this figure:
%
% results_visualization.m : Application M-file View the results of source modeling
%    bst_static_taskbar.m : BrainStorm's primary taskbar always visible
%          rapmusic_gui.m : Execute RAPMUSIC using GUI inputs, BrainStorm MMII version
%   results_time_series.m : Application M-file for results_time_series.fig
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in results_visualization.m
%
% Callbacks by figure results_visualization.fig
%   axes::indeptopo "" uses ButtonDownFcn for
%     results_visualization('indeptopo_ButtondownFcn',gcbo,[],guidata(gcbo))
%   uicontextmenu::sourcelistmenu "" uses Callback for <automatic>
%   uicontextmenu::timecoursemenu "" uses Callback for <automatic>
%   uicontrol:listbox:sourcelist "Listbox" uses ButtonDownFcn for
%     results_visualization('sourcelist_ButtondownFcn',gcbo,[],guidata(gcbo))
%   uicontrol:listbox:sourcelist "Listbox" uses Callback for <automatic>
%   uicontrol:listbox:sourceparams "" uses Callback for <automatic>
%   uicontrol:pushbutton:Quit "Quit" uses Callback for <automatic>
%   uicontrol:pushbutton:ShowAllTopos "Show All Topographies" uses Callback for <automatic>
%   uimenu::addon "" uses Callback for <automatic>
%   uimenu::deleteall "" uses Callback for <automatic>
%   uimenu::deletesource "" uses Callback for <automatic>
%   uimenu::hideall "" uses Callback for <automatic>
%   uimenu::hidesource "" uses Callback for <automatic>
%   uimenu::loadnonparametric "" uses Callback for <automatic>
%   uimenu::loadparametric "" uses Callback for <automatic>
%   uimenu::loadsources "" uses Callback for <automatic>
%   uimenu::rot3d "" uses Callback for <automatic>
%   uimenu::showall "" uses Callback for <automatic>
%   uimenu::showsource "" uses Callback for <automatic>
%   uimenu::tools "" uses Callback for <automatic>
%
%
%
% ========== SELECT_FOLDER.FIG ===========
%
% Help for this figure file (help_fig_select_folder) is given as:
%
%   (add help information)
%
% Help was also found in select_folder.m:
%
%  SELECT_FOLDER Application M-file for bst_SelectFolder.fig
%   function varargout = select_folder(varargin)
%    Modal GUI call,halts execution until response.
%      FOLDER = SELECT_FOLDER launch select_folder GUI, modal, 
%             wait for user to respond, return selected FOLDER or return empty.
%      SELECT_FOLDER('callback_name', ...) invoke the named callback, used
%             by the uicontrols
%
%  The following files in the Toolbox access this figure:
%
%    select_folder.m : Application M-file for bst_SelectFolder.fig
% database_manager.m : GUI to edit the User Databases and select one
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in select_folder.m
%
% Callbacks by figure select_folder.fig
%   figure::SelectFolder "" uses CreateFcn for movegui center
%   figure::SelectFolder "" uses ResizeFcn for <automatic>
%   uicontrol:listbox:FolderListbox "" uses Callback for <automatic>
%   uicontrol:popupmenu:popup_drive "A:\" uses ButtonDownFcn for <automatic>
%   uicontrol:popupmenu:popup_drive "A:\" uses Callback for <automatic>
%   uicontrol:pushbutton:Quit "Cancel" uses Callback for <automatic>
%   uicontrol:pushbutton:Select "Select" uses Callback for <automatic>
%
%
%
% ========== SET_DATAVIEWING_PARAMETERS.FIG ===========
%
% Help for this figure file (help_fig_set_dataviewing_parameters) is given as:
%
%   (add help information)
%
%  The following files in the Toolbox access this figure:
%
% dataplot_cb.m : : Callback switchyard for the DATAPLOT Tool
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in set_dataviewing_parameters.m
%
% Callbacks by figure set_dataviewing_parameters.fig
%   uicontrol:checkbox:cAbsoluteColormap "Absolute" uses Callback for dataplot_cb AbsoluteColormap
%   uicontrol:checkbox:cColorbar "Colorbar" uses Callback for dataplot_cb Colorbar
%   uicontrol:checkbox:cContours "On" uses Callback for dataplot_cb ShowContours
%   uicontrol:checkbox:cSensorLabels "Labels" uses Callback for dataplot_cb SensorLabels
%   uicontrol:checkbox:cSensorMarkers "Markers" uses Callback for dataplot_cb SensorMarkers
%   uicontrol:edit:ColumnLayout "4" uses Callback for dataplot_cb ChangeColumnLayout
%   uicontrol:edit:eGainValue "1" uses Callback for dataplot_cb ApplyGain
%   uicontrol:pushbutton:dec "-" uses Callback for dataplot_cb ChangeColumnLayout
%   uicontrol:pushbutton:inc "+" uses Callback for dataplot_cb ChangeColumnLayout
%   uicontrol:pushbutton:pushbutton1 "Select" uses Callback for dataplot_cb selectchannels
%   uicontrol:pushbutton:pushbutton2 "Filter" uses Callback for dataplot_cb create_filter_window
%   uicontrol:pushbutton:pushbutton5 "-" uses Callback for dataplot_cb ChangeGain
%   uicontrol:pushbutton:pushbutton6 "+" uses Callback for dataplot_cb ChangeGain
%   uicontrol:pushbutton:pushbutton8 "Movie" uses Callback for dataplot_cb GenerateMovie
%   uicontrol:pushbutton:pushbutton9 "Slides" uses Callback for dataplot_cb GenerateSlides
%   uicontrol:pushbutton:Qpushbutton7 "Close" uses Callback for close(gcbf)
%
%
%
% ========== SET_SOURCEVIEWING_PARAMETERS.FIG ===========
%
% Help for this figure file (help_fig_set_sourceviewing_parameters) is given as:
%
%   (add help information)
%
% Help was also found in set_sourceviewing_parameters.m:
%
%  SET_SOURCEVIEWING_PARAMETERS Application M-file for set_sourceviewing_parameters.fig
%   function varargout = set_sourceviewing_parameters(action,varargin)
%
%  The following files in the Toolbox access this figure:
%
% set_sourceviewing_parameters.m : Application M-file for set_sourceviewing_parameters.fig
%                  dataplot_cb.m : : Callback switchyard for the DATAPLOT Tool
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in set_sourceviewing_parameters.m
%
% Callbacks by figure set_sourceviewing_parameters.fig
%   uicontrol:edit:currDensityTruncateEdit "50" uses Callback for
%     set_sourceviewing_parameters currDensityTruncate
%   uicontrol:edit:editIterations "10" uses Callback for set_sourceviewing_parameters SmoothSurface
%   uicontrol:popupmenu:CutPlane "Top" uses Callback for set_sourceviewing_parameters CutPlane
%   uicontrol:popupmenu:Lighting "None" uses Callback for set_sourceviewing_parameters Lighting
%   uicontrol:pushbutton:pushbutton10 "Add" uses Callback for set_sourceviewing_parameters AddLight
%   uicontrol:pushbutton:pushbutton11 "Remove" uses Callback for
%     set_sourceviewing_parameters RemoveLight
%   uicontrol:pushbutton:pushbutton13 "Go" uses Callback for
%     set_sourceviewing_parameters SmoothSurface
%   uicontrol:pushbutton:Qpushbutton7 "Close" uses Callback for close(gcbf)
%   uicontrol:pushbutton:ResetSurface "Reset" uses Callback for
%     set_sourceviewing_parameters ResetSurface
%   uicontrol:slider:anatTransparency "" uses Callback for
%     set_sourceviewing_parameters anatTransparency
%   uicontrol:slider:currDensityTruncateSlider "" uses Callback for
%     set_sourceviewing_parameters currDensityTruncate
%   uicontrol:slider:CurvatureThresholdSlider "" uses Callback for
%     set_sourceviewing_parameters CurvatureThreshold
%   uicontrol:slider:SmoothSurface "" uses Callback for set_sourceviewing_parameters SmoothSurface
%   uicontrol:slider:SurfaceOpacity "" uses Callback for set_sourceviewing_parameters SurfaceOpacity
%   uicontrol:togglebutton:AddColorbar "Colorbar" uses Callback for
%     set_sourceviewing_parameters AddColorbar
%   uicontrol:togglebutton:OrthViews "Orth. Views" uses Callback for
%     set_sourceviewing_parameters OrthViews
%   uicontrol:togglebutton:ShowCurvature "Show" uses Callback for
%     set_sourceviewing_parameters MapCurvature
%   uicontrol:togglebutton:togglebutton2 "Normalize" uses Callback for
%     set_sourceviewing_parameters NormalizeColorMap
%   uicontrol:togglebutton:togglebutton4 "Tessellation Handler" uses Callback for
%     set_sourceviewing_parameters CallTessellationHandler
%
%
%
% ========== SHOW_SIGNAL_DECOMPOSITION.FIG ===========
%
% Help for this figure file (help_fig_show_signal_decomposition) is given as:
%
%   (add help information)
%
% Help was also found in show_signal_decomposition.m:
%
%  SHOW_SIGNAL_DECOMPOSITION Application M-file for show_signal_decomposition.fig
%   function varargout = show_signal_decomposition(varargin)
%      FIG = SHOW_SIGNAL_DECOMPOSITION launch show_signal_decomposition GUI.
%      SHOW_SIGNAL_DECOMPOSITION('callback_name', ...) invoke the named callback.
%
%  The following files in the Toolbox access this figure:
%
% show_signal_decomposition.m : Application M-file for show_signal_decomposition.fig
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in show_signal_decomposition.m
%
%
%
% ========== SIMULATOR.FIG ===========
%
% Help for this figure file (help_fig_simulator) is given as:
%
%   (add help information)
%
% Help was also found in simulator.m:
%
%  SIMULATOR Application M-file for simulator.fig
%   function varargout = simulator(varargin)
%      FIG = SIMULATOR launch simulator GUI.
%      SIMULATOR('callback_name', ...) invoke the named callback.
%
%  The following files in the Toolbox access this figure:
%
%              simulator.m : Application M-file for simulator.fig
%     bst_static_taskbar.m : BrainStorm's primary taskbar always visible
% help_fig_simulator_mri.m : Information on figure file 'simulator_mri'
%     make_default_study.m : Create simulated default data and link to a simulated subject
%   make_default_subject.m : Make a brainstormsubject and simulated MRI in a folder
%          simulator_mri.m : Application M-file to make a simulated spherical MRI
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in simulator.m
%
% Callbacks by figure simulator.fig
%   uicontrol:edit:edit_brain_radius "Brain Radius" uses Callback for <automatic>
%   uicontrol:edit:edit_data_folder_name "Simulation Folder Name" uses Callback for <automatic>
%   uicontrol:edit:edit_data_root_name "Root File Name" uses Callback for <automatic>
%   uicontrol:edit:edit_head_center "Head Center" uses Callback for <automatic>
%   uicontrol:edit:edit_noise_variance "Noise %" uses Callback for <automatic>
%   uicontrol:edit:edit_number_samples "Number Samps" uses Callback for <automatic>
%   uicontrol:edit:edit_number_sources "Num Sources" uses Callback for <automatic>
%   uicontrol:edit:edit_scalp_radius "Scalp Radius" uses Callback for <automatic>
%   uicontrol:edit:edit_sensor_baseline "Baseline Sep" uses Callback for <automatic>
%   uicontrol:edit:edit_sensor_radius "Meg Sensor Radius" uses Callback for <automatic>
%   uicontrol:edit:edit_sensor_spacing "Sensor Spacing" uses Callback for <automatic>
%   uicontrol:edit:edit_STUDIES "Studies Folder" uses Callback for <automatic>
%   uicontrol:listbox:listbox_source_amplitude "Amp" uses Callback for <automatic>
%   uicontrol:listbox:listbox_source_delay "Delay Samps" uses Callback for <automatic>
%   uicontrol:listbox:listbox_source_location "Location 1" uses Callback for <automatic>
%   uicontrol:listbox:listbox_source_model "None" uses Callback for <automatic>
%   uicontrol:listbox:listbox_source_orientation "Orientation" uses Callback for <automatic>
%   uicontrol:listbox:listbox_source_waveform "Hamming" uses Callback for <automatic>
%   uicontrol:popupmenu:popup_data_modality "MEG" uses Callback for <automatic>
%   uicontrol:popupmenu:popup_noise_generator "Noiseless" uses Callback for <automatic>
%   uicontrol:popupmenu:popup_sensor_coverage "Upper Hemisphere" uses Callback for <automatic>
%   uicontrol:popupmenu:popup_sensor_type "Magnetometer" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_generate "Generate" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_load_results "Previous Results" uses Callback for <automatic>
%   uimenu::help_orientation_context_menu "" uses Callback for <automatic>
%   uimenu::uimenu_edit_amplitude "" uses Callback for <automatic>
%   uimenu::uimenu_edit_delay "" uses Callback for <automatic>
%   uimenu::uimenu_edit_location "" uses Callback for <automatic>
%   uimenu::uimenu_edit_orientation "" uses Callback for <automatic>
%   uimenu::uimenu_ForceTangential "" uses Callback for <automatic>
%   uimenu::uimenu_help_amplitude "" uses Callback for <automatic>
%   uimenu::uimenu_help_delay "" uses Callback for <automatic>
%   uimenu::uimenu_help_location "" uses Callback for <automatic>
%   uimenu::uimenu_help_model "" uses Callback for <automatic>
%   uimenu::uimenu_help_waveform "" uses Callback for <automatic>
%   uimenu::uimenu_random_location "" uses Callback for <automatic>
%   uimenu::uimenu_random_orientation "" uses Callback for <automatic>
%   uimenu::uimenu_source_model_dipole "" uses Callback for <automatic>
%   uimenu::uimenu_source_model_multipole "" uses Callback for <automatic>
%   uimenu::uimenu_waveform_boxcar "" uses Callback for <automatic>
%   uimenu::uimenu_waveform_custom "" uses Callback for <automatic>
%   uimenu::uimenu_waveform_hamming "" uses Callback for <automatic>
%   uimenu::uimenu_waveform_hann "" uses Callback for <automatic>
%   uimenu::uimenu_waveform_sinusoid "" uses Callback for <automatic>
%   uimenu::uimenu_waveform_triangle "" uses Callback for <automatic>
%
%
%
% ========== SIMULATOR_MRI.FIG ===========
%
% Help for this figure file (help_fig_simulator_mri) is given as:
%
%   (add help information)
%
% Help was also found in simulator_mri.m:
%
%  SIMULATOR_MRI Application M-file to make a simulated spherical MRI
%   function varargout = simulator_mri(varargin)
%      FIG = SIMULATOR_MRI launch simulator_mri GUI.
%      SIMULATOR_MRI('callback_name', ...) invoke the named callback.
%
%  The following files in the Toolbox access this figure:
%
%        simulator_mri.m : Application M-file to make a simulated spherical MRI
%   bst_static_taskbar.m : BrainStorm's primary taskbar always visible
% make_default_subject.m : Make a brainstormsubject and simulated MRI in a folder
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in simulator_mri.m
%
% Callbacks by figure simulator_mri.fig
%   uicontrol:edit:edit_center "Center" uses Callback for <automatic>
%   uicontrol:edit:edit_fiducial_color "Fiducial Color" uses Callback for <automatic>
%   uicontrol:edit:edit_file_name "Edit Text" uses Callback for <automatic>
%   uicontrol:edit:edit_folder_name "Edit Text" uses Callback for <automatic>
%   uicontrol:edit:edit_fov "FOV" uses Callback for <automatic>
%   uicontrol:edit:edit_num_voxels_side "VoxelsSide" uses Callback for <automatic>
%   uicontrol:edit:edit_SUBJECTS "Edit Text" uses Callback for <automatic>
%   uicontrol:listbox:listbox_boundary_name "Boundary Name" uses Callback for <automatic>
%   uicontrol:listbox:listbox_color "Color" uses Callback for <automatic>
%   uicontrol:listbox:listbox_radius "Radius" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_generate "Generate" uses Callback for <automatic>
%   uimenu::uimenu_boundary_cortex "" uses Callback for <automatic>
%   uimenu::uimenu_boundary_csf "" uses Callback for <automatic>
%   uimenu::uimenu_boundary_custom "" uses Callback for <automatic>
%   uimenu::uimenu_boundary_help "" uses Callback for <automatic>
%   uimenu::uimenu_boundary_name "" uses Callback for <automatic>
%   uimenu::uimenu_boundary_scalp "" uses Callback for <automatic>
%   uimenu::uimenu_boundary_skull "" uses Callback for <automatic>
%   uimenu::uimenu_edit_color "" uses Callback for <automatic>
%   uimenu::uimenu_edit_radius "" uses Callback for <automatic>
%   uimenu::uimenu_edit_thickness "" uses Callback for <automatic>
%   uimenu::uimenu_help_color "" uses Callback for <automatic>
%   uimenu::uimenu_insert_above "" uses Callback for <automatic>
%   uimenu::uimenu_insert_below "" uses Callback for <automatic>
%   uimenu::uimenu_radius_help "" uses Callback for <automatic>
%   uimenu::uimenu_remove_boundary "" uses Callback for <automatic>
%   uimenu::uimenu_white_matter "" uses Callback for <automatic>
%
%
%
% ========== SOURCEIMAGING.FIG ===========
%
% Help for this figure file (help_fig_sourceimaging) is given as:
%
%   (add help information)
%
% Help was also found in sourceimaging.m:
%
%  SOURCEIMAGING Main switch to source imaging routines
%   function varargout = sourceimaging(varargin)
%   function sourceimaging(varargin)
%   GUI switchyard for cortical imaging routines 
%    (was sourceimaging.m before major upgrade on 07-Aug-2002)
%
%  The following files in the Toolbox access this figure:
%
%                     sourceimaging.m : Main switch to source imaging routines
%                 bst_sourceimaging.m : Command line call to source imaging routines
%                bst_static_taskbar.m : BrainStorm's primary taskbar always visible
%                       dataplot_cb.m : : Callback switchyard for the DATAPLOT Tool
% help_fig_sourceimaging_parameters.m : Information on figure file 'sourceimaging_parameters'
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in sourceimaging.m
%
% Callbacks by figure sourceimaging.fig
%   uicontrol:checkbox:cAutomaticParameterSetUp "Automatic" uses Callback for
%     bst_sourceimaging mutincomp_amp_grad
%   uicontrol:pushbutton:HGo "Go" uses Callback for sourceimaging Go
%   uicontrol:pushbutton:HSetParameters "Set" uses Callback for sourceimaging ImagingParametersGUI
%   uicontrol:pushbutton:HView "View" uses Callback for sourceimaging View
%   uicontrol:pushbutton:Quit "Quit" uses Callback for sourceimaging Quit
%   uicontrol:pushbutton:SelectMarkers "Select Markers" uses Callback for sourceimaging SelectMarkers
%
%
%
% ========== SOURCEIMAGING_PARAMETERS.FIG ===========
%
% Help for this figure file (help_fig_sourceimaging_parameters) is given as:
%
%   (add help information)
%
%  The following files in the Toolbox access this figure:
%
% sourceimaging.m : Main switch to source imaging routines
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in sourceimaging_parameters.m
%
% Callbacks by figure sourceimaging_parameters.fig
%   uicontrol:checkbox:cBrainStorm "BrainStorm format" uses Callback for
%     sourceimaging mutincomp_kernel
%   uicontrol:checkbox:cKernel "Kernel only" uses Callback for sourceimaging mutincomp_kernel
%   uicontrol:checkbox:CorticalNeighborhoodSystem "Cortical Neighb. System" uses Callback for
%     sourceimaging mutincomp_amp_grad
%   uicontrol:checkbox:OnAmplitudes "source amplitudes" uses Callback for
%     sourceimaging mutincomp_amp_grad
%   uicontrol:checkbox:OnGradients "gradients of source amplitudes" uses Callback for
%     sourceimaging mutincomp_amp_grad
%   uicontrol:pushbutton: "Go" uses Callback for sourceimaging CorticalNeighborhoodSystem
%   uicontrol:pushbutton:HOK "Done" uses Callback for sourceimaging ImagingParametersGUI_DONE
%   uicontrol:pushbutton:Qancel "Close" uses Callback for delete(gcbf)
%   uicontrol:pushbutton:SubspaceSelection "Subspace Select" uses Callback for
%     sourceimaging SubspaceSelection
%
%
%
% ========== STUDY_EDITOR.FIG ===========
%
% Help for this figure file (help_fig_study_editor) is given as:
%
%   (add help information)
%
% Help was also found in study_editor.m:
%
%  STUDY_EDITOR GUI to edit the BrainStorm Study information, case switchyard
%   function varargout = study_editor(action,varargin);
%   Initiate with study_editor('create');
%   Need that DataManager window be open
%  
%   Creates/Edits a brainstormstudy.mat file
%   [FIG,HANDLES] = STUDY_EDITOR(action) returns figure handle
%
%  The following files in the Toolbox access this figure:
%
% study_editor.m : GUI to edit the BrainStorm Study information, case switchyard
% data_manager.m : Edit/select database, subjects, studies, datasets, build headmodels, import data.
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in study_editor.m
%
% Callbacks by figure study_editor.fig
%   uicontrol:edit:DOM "" uses Callback for study_editor UpdateStudyFields
%   uicontrol:edit:DOS "" uses Callback for study_editor UpdateStudyFields
%   uicontrol:edit:eSession "" uses Callback for study_editor UpdateStudyFields
%   uicontrol:edit:LStudyName "" uses Callback for study_editor UpdateStudyFields
%   uicontrol:listbox:LStudies "Sifting through current DataBase..." uses Callback for
%     study_editor StudyListbox
%   uicontrol:listbox:LSubjects "..." uses Callback for study_editor SubjectListbox
%   uicontrol:pushbutton:Pushbutton1 "Browse" uses Callback for study_editor subj_loadfile
%   uicontrol:pushbutton:Pushbutton2 "Load" uses Callback for study_editor loadfile
%   uicontrol:pushbutton:pushbutton3 "Save" uses Callback for study_editor save
%   uicontrol:pushbutton:Pushbutton4 "Save as" uses Callback for study_editor saveas
%   uicontrol:pushbutton:Quit "Done" uses Callback for study_editor quit
%
%
%
% ========== SUBJECT_EDITOR.FIG ===========
%
% Help for this figure file (help_fig_subject_editor) is given as:
%
%   (add help information)
%
% Help was also found in subject_editor.m:
%
%  SUBJECT_EDITOR GUI to edit the BrainStorm Subject information, case switchyard
%   function varargout = subject_editor(action,varargin)
%   R11 Case Switchyard, Creates/Edits a brainstormsubject.mat file
%   Invoke as subject_editor('create');
%   [FIG,HANDLES] = subject_editor(action) returns the figure and handles
%
%  The following files in the Toolbox access this figure:
%
%     subject_editor.m : GUI to edit the BrainStorm Subject information, case switchyard
% bst_static_taskbar.m : BrainStorm's primary taskbar always visible
%       data_manager.m : Edit/select database, subjects, studies, datasets, build headmodels, import data.
%            fidufit.m : (overwrite succinct one line summary here)
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in subject_editor.m
%
% Callbacks by figure subject_editor.fig
%   uicontrol:listbox:e_comment "" uses Callback for subject_editor CurrentEnvelopeInfo
%   uicontrol:popupmenu:listboxx "''" uses Callback for subject_editor listboxx
%   uicontrol:popupmenu:Tesselation "N/A" uses Callback for subject_editor TessellationFileInfo
%   uicontrol:pushbutton:Cancel "Cancel" uses Callback for delete(gcbf)
%   uicontrol:pushbutton:fit "Adjust" uses Callback for subject_editor fit
%   uicontrol:pushbutton:pushbutton10 "View" uses Callback for subject_editor ViewEnvelope
%   uicontrol:pushbutton:pushbutton100 "Save as" uses Callback for subject_editor saveas
%   uicontrol:pushbutton:pushbutton11 "Swap faces" uses Callback for subject_editor SwapFaces
%   uicontrol:pushbutton:pushbutton2 "Import" uses Callback for subject_editor ImportAnatomy
%   uicontrol:pushbutton:pushbutton4 "Import" uses Callback for subject_editor ImportTessellation
%   uicontrol:pushbutton:pushbutton5 "Rename" uses Callback for subject_editor RenameEnvelope
%   uicontrol:pushbutton:pushbutton7 "Delete" uses Callback for subject_editor DeleteEnvelope
%   uicontrol:pushbutton:Pushbutton8 "Save" uses Callback for subject_editor save
%   uicontrol:pushbutton:pushbutton8 "Downsize" uses Callback for subject_editor DownsizeEnvelope
%   uicontrol:pushbutton:pushbutton9 "Concatenate" uses Callback for
%     subject_editor ConcatenateEnvelope
%   uicontrol:pushbutton:QuitPushbutton1 "Done" uses Callback for subject_editor quit
%
%
%
% ========== TESSELLATION_HANDLER.FIG ===========
%
% Help for this figure file (help_fig_tessellation_handler) is given as:
%
%   (add help information)
%
% Help was also found in tessellation_handler.m:
%
%  TESSELLATION_HANDLER : Basic Viewing of tessellation objects in BrainStorm format; GUI Manager
%   function varargout = tessellation_handler(varargin)
%      FIG = TESSELLATION_HANDLER launch tessellation_handler GUI.
%      TESSELLATION_HANDLER('callback_name', ...) invoke the named callback.
%
%  The following files in the Toolbox access this figure:
%
%         tessellation_handler.m : : Basic Viewing of tessellation objects in BrainStorm format; GUI Manager
% set_sourceviewing_parameters.m : Application M-file for set_sourceviewing_parameters.fig
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in tessellation_handler.m
%
% Callbacks by figure tessellation_handler.fig
%   uicontrol:frame:frame1 "" uses Callback for <automatic>
%   uicontrol:frame:frame4 "" uses Callback for <automatic>
%   uicontrol:listbox:EnvelopeList "" uses Callback for <automatic>
%   uicontrol:popupmenu:TessellationFilesList "N/A" uses Callback for <automatic>
%   uicontrol:pushbutton:ConcatenateEnvelopes "Concatenate" uses Callback for <automatic>
%   uicontrol:pushbutton:DeleteEnvelope "Delete" uses Callback for <automatic>
%   uicontrol:pushbutton:DownsizeEnvelope "Downsize" uses Callback for <automatic>
%   uicontrol:pushbutton:HDone "Done" uses Callback for <automatic>
%   uicontrol:pushbutton:ImportFiles "Import" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton16 "Cancel" uses Callback for <automatic>
%   uicontrol:pushbutton:RenameEnvelope "Rename" uses Callback for <automatic>
%   uicontrol:pushbutton:Save "Save" uses Callback for <automatic>
%   uicontrol:pushbutton:SaveAs "Save as" uses Callback for <automatic>
%   uicontrol:pushbutton:SwapFaces "Swap faces" uses Callback for <automatic>
%   uicontrol:pushbutton:ViewEnvelope "View" uses Callback for <automatic>
%   uicontrol:text:FacesVertices "n/a Faces - n/a Vertices" uses Callback for ''
%   uicontrol:text:HowManyEnvelopes "Envelope(s)" uses Callback for
%     tessellation_handler('text2_Callback',gcbo,[],guidata(gcbo))
%   uicontrol:text:HowManyFiles "Tessellation File(s)" uses Callback for
%     tessellation_handler('text1_Callback',gcbo,[],guidata(gcbo))
%
%
%
% ========== TESSELLATION_SELECT.FIG ===========
%
% Help for this figure file (help_fig_tessellation_select) is given as:
%
%   (add help information)
%
%  The following files in the Toolbox access this figure:
%
% dataplot_cb.m : : Callback switchyard for the DATAPLOT Tool
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in tessellation_select.m
%
% Callbacks by figure tessellation_select.fig
%   uicontrol:edit:Baseline "" uses Callback for dataplot_cb DefineBaseline
%   uicontrol:edit:CorrectionFactor "" uses Callback for dataplot_cb ZScoreThreshold
%   uicontrol:edit:SensorSize "10" uses Callback for dataplot_cb see_sensors;
%   uicontrol:edit:TruncateFactor "0" uses Callback for dataplot_cb ScaleColormap
%   uicontrol:edit:XCut "" uses Callback for dataplot_cb CutPlane
%   uicontrol:edit:YCut "" uses Callback for dataplot_cb CutPlane
%   uicontrol:edit:ZCut "" uses Callback for dataplot_cb CutPlane
%   uicontrol:edit:ZScoreThreshold "5" uses Callback for dataplot_cb ZScoreThreshold
%   uicontrol:listbox:available "" uses Callback for dataplot_cb mesh_props, dataplot_cb mesh_add
%   uicontrol:listbox:removed "" uses Callback for dataplot_cb mesh_props, dataplot_cb mesh_remove
%   uicontrol:popupmenu:light_props "None" uses Callback for dataplot_cb mesh_lighting_props
%   uicontrol:popupmenu:ResultFiles "''" uses Callback for dataplot_cb LoadResultFile
%   uicontrol:pushbutton:AnalyzeCorticalMap "Spatiotemp. Segment" uses Callback for
%     dataplot_cb AnalyzeCorticalMap
%   uicontrol:pushbutton:Apply "Apply" uses Callback for dataplot_cb tesselation_select_done
%   uicontrol:pushbutton:AverageMaps "Avrg" uses Callback for dataplot_cb AverageMaps
%   uicontrol:pushbutton:ColorMAP "Color" uses Callback for dataplot_cb change_color
%   uicontrol:pushbutton:DeleteCorticalSpot "Delete" uses Callback for dataplot_cb DeleteCorticalSpot
%   uicontrol:pushbutton:light "Add" uses Callback for dataplot_cb camlight
%   uicontrol:pushbutton:light "Delete" uses Callback for dataplot_cb delete_tess
%   uicontrol:pushbutton:LoadBaseline "Load" uses Callback for dataplot_cb LoadBaseline
%   uicontrol:pushbutton:Pushbutton1 "Quit" uses Callback for dataplot_cb QuitTessSelect
%   uicontrol:pushbutton:pushbutton13 "Concatenate" uses Callback for dataplot_cb ConcatenateTess
%   uicontrol:pushbutton:pushbutton14 "Downsize" uses Callback for dataplot_cb DownsizeTess
%   uicontrol:pushbutton:pushbutton15 "Swap Faces" uses Callback for dataplot_cb SwapFaces
%   uicontrol:pushbutton:pushbutton16 "Rename" uses Callback for dataplot_cb RenameTess
%   uicontrol:pushbutton:pushbutton21 "Activate" uses Callback for dataplot_cb CorticalSpotActivity
%   uicontrol:pushbutton:pushbutton22 "Load" uses Callback for dataplot_cb LoadCorticalSpot
%   uicontrol:pushbutton:pushbutton23 "Save" uses Callback for dataplot_cb SaveCorticalSpot
%   uicontrol:pushbutton:pushbutton24 "+" uses Callback for dataplot_cb GrowCorticalArea
%   uicontrol:pushbutton:pushbutton25 "-" uses Callback for dataplot_cb ReduceCorticalArea
%   uicontrol:pushbutton:pushbutton26 "Remove" uses Callback for dataplot_cb remove_camlight
%   uicontrol:pushbutton:Refresh "Refresh" uses Callback for dataplot_cb mesh_rendering
%   uicontrol:pushbutton:RenameCorticalSpot "Rename" uses Callback for dataplot_cb RenameCorticalSpot
%   uicontrol:pushbutton:SelectCorticalSpot "Probe" uses Callback for dataplot_cb SelectCorticalSpot
%   uicontrol:pushbutton:STHistogram "Histo" uses Callback for dataplot_cb STHistogram
%   uicontrol:pushbutton:togglebutton10 "Fetch files" uses Callback for dataplot_cb ZScoreBatch
%   uicontrol:pushbutton:togglebutton7 "Residuals" uses Callback for dataplot_cb Residuals
%   uicontrol:radiobutton:AllCorticalArea "All" uses Callback for dataplot_cb mutincomp_meanmax
%   uicontrol:radiobutton:back "Back" uses Callback for dataplot_cb mesh_vals
%   uicontrol:radiobutton:bottom "Bottom" uses Callback for dataplot_cb mesh_vals
%   uicontrol:radiobutton:front "Front" uses Callback for dataplot_cb mesh_vals
%   uicontrol:radiobutton:left "Left" uses Callback for dataplot_cb mesh_vals
%   uicontrol:radiobutton:MaxCorticalArea "Max" uses Callback for dataplot_cb mutincomp_meanmax
%   uicontrol:radiobutton:MeanCorticalArea "Mean" uses Callback for dataplot_cb mutincomp_meanmax
%   uicontrol:radiobutton:Opaque "Opaque" uses Callback for dataplot_cb mutincomp_opaque
%   uicontrol:radiobutton:right "Right" uses Callback for dataplot_cb mesh_vals
%   uicontrol:radiobutton:top "Top" uses Callback for dataplot_cb mesh_vals
%   uicontrol:radiobutton:transparent "Transparent" uses Callback for dataplot_cb mutincomp_opaque
%   uicontrol:text:ScaleColormap "Truncate" uses Callback for dataplot_cb AddSources
%   uicontrol:togglebutton:Colorbar "Colorbar" uses Callback for dataplot_cb Colorbar
%   uicontrol:togglebutton:CorticalMap "Cortical Map" uses Callback for dataplot_cb ToggleButtonColor
%   uicontrol:togglebutton:FreezeColormap "Lock" uses Callback for dataplot_cb FreezeColormap
%   uicontrol:togglebutton:IntSTH "Integ." uses Callback for dataplot_cb IntegSTHistogram
%   uicontrol:togglebutton:MapCurvature "Map Curvature" uses Callback for
%     dataplot_cb ToggleButtonColor; dataplot_cb MapCurvature
%   uicontrol:togglebutton:Normalize "Normalize" uses Callback for dataplot_cb NormalizeColormap
%   uicontrol:togglebutton:OrthoViews "Orth. Views" uses Callback for
%     dataplot_cb ToggleButtonColor; dataplot_cb OrthoViews
%   uicontrol:togglebutton:SensorLabels "Labels" uses Callback for dataplot_cb SensorLabels;
%   uicontrol:togglebutton:Sensors3D "3D" uses Callback for
%     dataplot_cb ToggleButtonColor; dataplot_cb see_sensors_markers;dataplot_cb see_sensors;
%   uicontrol:togglebutton:SensorsMarkers "Markers" uses Callback for
%     dataplot_cb ToggleButtonColor; dataplot_cb see_sensors_markers;
%   uicontrol:togglebutton:ZScore "Z-score" uses Callback for
%     dataplot_cb ToggleButtonColor; dataplot_cb ZScore
%   uicontrol:togglebutton:ZScoreThresholdApply "Apply" uses Callback for
%     dataplot_cb ToggleButtonColor; dataplot_cb ZScoreThreshold
%   uimenu:: "" uses Callback for dataplot_cb ShowClusters
%   uimenu::CorrMapFromSensor "" uses Callback for dataplot_cb CorrelationMapFromSensor
%   uimenu::CorticalScoutFromThres "" uses Callback for dataplot_cb CorticalScoutFromThres
%   uimenu::ImportScoutsFromMRI "" uses Callback for dataplot_cb ImportScoutsFromMRI
%   uimenu::Untitled_5 "" uses Callback for dataplot_cb CorrelationWithDepthElectrodes
%
%
%
% ========== TESSELLATION_WINDOW.FIG ===========
%
% Help for this figure file (help_fig_tessellation_window) is given as:
%
%   (add help information)
%
%  The following files in the Toolbox access this figure:
%
%   bst_imaging_display.m : : display utility for cortical distributed source imaging 
%           dataplot_cb.m : : Callback switchyard for the DATAPLOT Tool
% manage_corticalscouts.m : Application M-file for manage_corticalscouts.fig
%            zscore_gui.m : : management of zscore visualization
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in tessellation_window.m
%
% Callbacks by figure tessellation_window.fig
%   figure::tessellation_window "" uses CreateFcn for movegui northwest
%
%
%
% ========== TIMESERIES.FIG ===========
%
% Help for this figure file (help_fig_timeseries) is given as:
%
%   (add help information)
%
%  The following files in the Toolbox access this figure:
%
%           dataplot_cb.m : : Callback switchyard for the DATAPLOT Tool
%               leaflet.m : (overwrite succinct one line summary here)
%            mritool_cb.m : Switchyard corresponding to the MRITOOL GUI (mribox.fig)
%   results_time_series.m : Application M-file for results_time_series.fig
% results_visualization.m : Application M-file View the results of source modeling
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in timeseries.m
%
%
%
% ========== VIEW_MANAGER.FIG ===========
%
% Help for this figure file (help_fig_view_manager) is given as:
%
%   (add help information)
%
% Help was also found in view_manager.m:
%
%  VIEW_MANAGER Application M-file to view and process data
%   function varargout = view_manager(varargin)
%      FIG = VIEW_MANAGER launch untitled GUI.
%      VIEW_MANAGER('callback_name', ...) invoke the named callback.
%   
%   Retrieves information based on the file selected by the BrainStorm Toolbar
%
%  The following files in the Toolbox access this figure:
%
%       view_manager.m : Application M-file to view and process data
% bst_static_taskbar.m : BrainStorm's primary taskbar always visible
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in view_manager.m
%
% Callbacks by figure view_manager.fig
%   figure::view_manager "" uses WindowButtonDownFcn for <automatic>
%   uicontrol:edit:edit_current_time "0" uses Callback for <automatic>
%   uicontrol:edit:edit_step "steptime" uses Callback for <automatic>
%   uicontrol:edit:edit_time_max "maxtime" uses Callback for <automatic>
%   uicontrol:edit:edit_time_min "mintime" uses Callback for <automatic>
%   uicontrol:popupmenu:ChangeUnits "T / V / A-m / A/m" uses Callback for <automatic>
%   uicontrol:popupmenu:DataViewingDataType "Original Data" uses Callback for <automatic>
%   uicontrol:popupmenu:DataViewingSpatialDisplay "<No Scalp Topography>" uses Callback for <automatic>
%   uicontrol:popupmenu:DataViewingTimeDisplay "<No Time Display>" uses Callback for <automatic>
%   uicontrol:popupmenu:SourceEstimationMethod "-------- IMAGING " uses Callback for <automatic>
%   uicontrol:popupmenu:SourceViewingSpatialDisplay "<No Spatial Topography>" uses Callback for <automatic>
%   uicontrol:popupmenu:SourceViewingTimeDisplay "<No Time Display>" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_load "Load" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_MSIndexSwitch "ms/ndx" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_NoiseModel "Noise Model" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_Plot "Plot" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_PlotTimeSeries "Plot" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_save "Save" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_SetDataViewing "Set" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_SetSourceViewing "Set" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_SourceModel "Source Model" uses Callback for <automatic>
%   uicontrol:slider:TimeSlider "" uses Callback for <automatic>
%   uicontrol:togglebutton:pushbutton_append "Append" uses Callback for <automatic>
%
%
%
% ========== VISU_MAPS.FIG ===========
%
% Help for this figure file (help_fig_visu_maps) is given as:
%
%   (add help information)
%
%  No calling files found in the Toolbox.
%
%
%
% ========== WAVE_SINGLE.FIG ===========
%
% Help for this figure file (help_fig_wave_single) is given as:
%
%   (add help information)
%
%  No calling files found in the Toolbox.
%
%
%
% ========== WEB_PAGES.FIG ===========
%
% Help for this figure file (help_fig_web_pages) is given as:
%
%   (add help information)
%
% Help was also found in web_pages.m:
%
%  WEB_PAGES Listbox of relevant BrainStorm web pages and email addresses
%   function varargout = web_pages(varargin)
%      FIG = WEB_PAGES launch web_pages GUI.
%      WEB_PAGES('callback_name', ...) invoke the named callback.
%
%  The following files in the Toolbox access this figure:
%
%          web_pages.m : Listbox of relevant BrainStorm web pages and email addresses
% bst_static_taskbar.m : BrainStorm's primary taskbar always visible
%       help_manager.m : Application M-file for help_manager.fig
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in web_pages.m
%
% Callbacks by figure web_pages.fig
%   figure::figure_web "" uses ResizeFcn for <automatic>
%   uicontrol:listbox:listbox_web "Listbox" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_call "Go To" uses Callback for <automatic>
%
%
%
% ========== ZSCORE_GUI.FIG ===========
%
% Help for this figure file (help_fig_zscore_gui) is given as:
%
%   (add help information)
%
% Help was also found in zscore_gui.m:
%
%  ZSCORE_GUI : management of zscore visualization
%   function varargin = zscore_gui(action,varargin)
%
%  The following files in the Toolbox access this figure:
%
%  zscore_gui.m : : management of zscore visualization
% dataplot_cb.m : : Callback switchyard for the DATAPLOT Tool
%
% This figure has the following uicontrol information:
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback in zscore_gui.m
%
% Callbacks by figure zscore_gui.fig
%   uicontrol:edit:Baseline "" uses Callback for zscore_gui DefineBaseline
%   uicontrol:edit:CorrectionFactor "" uses Callback for zscore_gui ZScoreThreshold
%   uicontrol:edit:ZScoreThreshold "5" uses Callback for zscore_gui ZScoreThreshold
%   uicontrol:pushbutton:AnalyzeCorticalMap "Spatiotemp. Segment" uses Callback for
%     zscore_gui AnalyzeCorticalMap
%   uicontrol:pushbutton:AverageMaps "Avrg" uses Callback for zscore_gui AverageMaps
%   uicontrol:pushbutton:pushbutton55 "Load" uses Callback for zscore_gui LoadBaseline
%   uicontrol:pushbutton:pushbutton56 "Fetch files" uses Callback for zscore_gui ZScoreBatch
%   uicontrol:pushbutton:Qpushbutton7 "Close" uses Callback for close(gcbf)
%   uicontrol:pushbutton:STHistogram "Histo" uses Callback for zscore_gui STHistogram
%   uicontrol:togglebutton:IntSTH "Integ." uses Callback for zscore_gui IntegSTHistogram
%   uicontrol:togglebutton:ZScore "Z-score" uses Callback for togglebuttoncolor ; zscore_gui ZScore
%   uicontrol:togglebutton:ZScoreThresholdApply "Apply" uses Callback for
%     togglebuttoncolor; zscore_gui ZScoreThreshold
%
%
%

%<autobegin> ---------------------- 26-May-2004 11:30:29 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Help
%
% At Check-in: $Author: Mosher $  $Revision: 8 $  $Date: 5/26/04 9:59a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:30:29 -----------------------



% CATEGORY: Help
if nargout,
  helptext = help(mfilename); % return help text
else
  helpwin(mfilename); % display in help window
end
