function varargout = help_manager(varargin)
%HELP_MANAGER - Application M-file for help_manager.fig
% function varargout = help_manager(varargin)
%    FIG = HELP_MANAGER launch help_manager GUI.
%    HELP_MANAGER('callback_name', ...) invoke the named callback.

%<autobegin> ---------------------- 26-May-2004 11:30:38 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Database Management
%
% Alphabetical list of external functions (non-Matlab):
%   toolbox\bst_color_scheme.m
%   toolbox\bst_layout.m
%   toolbox\bst_message_window.m
%   toolbox\web_pages.m
%
% Subfunctions in this file, in order of occurrence in file:
%   varargout = pushbutton_contents_Callback(h, eventdata, handles, varargin)
%   varargout = pushbutton_online_Callback(h, eventdata, handles, varargin)
%   varargout = pushbutton_html_Callback(h, eventdata, handles, varargin)
%   varargout = pushbutton_new_user_Callback(h, eventdata, handles, varargin)
%
% Application data and their calls in this file:
%   'TileType'
%   
%   setappdata(fig,'TileType','D');
%   
%
% Figure Files opened by this function:
%   mfilename
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback by Matlab default
%
% Callbacks by figure help_manager.fig
%   uicontrol:pushbutton:pushbutton_contents "Contents" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_html "HTML" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_new_user "New User" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_online "Online Links" uses Callback for <automatic>
%
% At Check-in: $Author: Mosher $  $Revision: 7 $  $Date: 5/26/04 9:59a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:30:38 -----------------------


% Last Modified by GUIDE v2.0 24-Sep-2003 15:49:23

if nargin == 0  % LAUNCH GUI

	fig = openfig(mfilename,'reuse');

	% Use system color scheme for figure:
   bst_color_scheme(fig);
   setappdata(fig,'TileType','D');
   bst_layout('align',fig)
   
   set(fig,'visible','on');
   
	% Generate a structure of handles to pass to callbacks, and store it. 
	handles = guihandles(fig);
	guidata(fig, handles);

	if nargout > 0
		varargout{1} = fig;
	end

elseif ischar(varargin{1}) % INVOKE NAMED SUBFUNCTION OR CALLBACK

	try
		if (nargout)
			[varargout{1:nargout}] = feval(varargin{:}); % FEVAL switchyard
		else
			feval(varargin{:}); % FEVAL switchyard
		end
	catch
		disp(lasterr);
	end

end



% --------------------------------------------------------------------
function varargout = pushbutton_contents_Callback(h, eventdata, handles, varargin)

bst_message_window({'','Loading Contents into help windows. Wait . . .'});

% launch the matlab help pointed to our contents.m area
brainstormHomeDirectory = fileparts(which('startup.m'));
helpwin([brainstormHomeDirectory filesep 'toolbox'])

bst_message_window({'See Matlab help window.'});


% --------------------------------------------------------------------
function varargout = pushbutton_online_Callback(h, eventdata, handles, varargin)

% activate the web pages GUI
web_pages; 



% --------------------------------------------------------------------
function varargout = pushbutton_html_Callback(h, eventdata, handles, varargin)

brainstormHomeDirectory = fileparts(which('startup.m'));

web(fullfile(brainstormHomeDirectory,'html','1','index.html'));


% --------------------------------------------------------------------
function varargout = pushbutton_new_user_Callback(h, eventdata, handles, varargin)

% show brief help in the message window
% Would like to show an html document

bst_message_window({'','BrainStorm Toolbox Help'});

msg_str = ['The Data Manager selects the trial from the database. ',...
      'Visualization allows spatial and temporal views of the data. ',...
      'Estimation uses parametric or imaging approaches to estimate a ',...
      'source solution. Visualization also allows views of the estimation ',...
      'results.'];
bst_message_window('wrap',msg_str);
