function [Lat,Data,Label,LabelNum] = load_fif_asc(fname,verbose);
%LOAD_FIF_ASC - Load data from Neuromag 122 .fif file converted to ascii
%function [Lat,Data,Label,LabelNum] = load_fif_asc(fname,verbose);
% Open and read the fiff2ascii converted file FNAME, where we assume that
% the time values are included (fiff2ascii -t).
% Returns the latencies in Lat, the m by length(Lat) matrix of data Data.
% The Label is string the labels found per row in Data, such as MEG, EEG, STI, 
% and the LabelNum is the integer associated with the Label.

%<autobegin> ---------------------- 26-May-2004 11:30:50 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Data Processing
%
% Alphabetical list of external functions (non-Matlab):
%   toolbox\str2mat0.m
%
% At Check-in: $Author: Mosher $  $Revision: 13 $  $Date: 5/26/04 9:59a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:30:50 -----------------------

% ----------------------------- Script History ---------------------------------
% September 3, 1996 author
% JCM 19-May-2004 Comments cleaning
% ----------------------------- Script History ---------------------------------

if(exist('verbose') ~= 1),
  verbose = 1;			% talkative running
end

fid = fopen(fname,'rt');	% text mode all platforms

if(fid < 0),
  error(['Unable to open file ' fname])
end

next_line = fgetl(fid);
if(verbose)
  disp(next_line)
end
key_word = sscanf(next_line,'# %s');
while(~strcmp(key_word,'channels:')),
  next_line = fgetl(fid);
  if(verbose)
    disp(next_line)
  end
  key_word = sscanf(next_line,'# %s');
end

% we are on line 'channels', read next many lines

next_line = fgetl(fid);
next_line(1) = []; 		% drop the # sign
if(verbose)
  disp(next_line)
end
% we are scanning by skipping the first char (#), then reading in pairs
%  of channel information.  First find how many separate blocks of info
[temporary,temp_els] = sscanf(next_line,'%s',Inf);
% temp_els is the number of elements read on this line
Label = [];			% initialize
LabelNum = [];
while(temp_els~=0),		% while elements were read
  
  if(verbose)
    disp(next_line)
  end
  for i = 1:(temp_els/2),	% for each pair of label, number
    [nextLab,ignore,ignore1,temp_next] = ...
	sscanf(next_line,'%s',1);
    Label = str2mat0(Label,nextLab); % append the label, using JCM routine
    next_line(1:(temp_next-1)) = []; % drop the read characters
    [nextNum,ignore,ignore1,temp_next] = sscanf(next_line,'%d',1);
    LabelNum = [LabelNum;nextNum];
    next_line(1:(temp_next-1)) = []; % drop the read number
  end				% for each pair
  next_line = fgetl(fid);
  next_line(1) = []; 		% drop the # sign
  [temporary,temp_els] = sscanf(next_line,' %s %d',[4 Inf]);

end

if(verbose),
  disp(sprintf('Read that %.0f labels of data exist',size(Label,1)))
  disp('Loading data . . .')
end

% we are on empty line, from here on it's just data

Data = fscanf(fid,'%f ',Inf);
fclose(fid);

% all data loaded, parse.
% We have size(Label,1) entries, plus the latencies.

Mrows = size(Label,1) + 1;

Data = reshape(Data,Mrows,length(Data)/Mrows);

Lat = Data(1,:);
Data(1,:) = [];

return
