function Out = load_raw(fname,dirpath);
%LOAD_RAW - Read a BrainStorm "raw" format (.txt or .raw) matrix
% function Out = load_raw(fname,dirpath);
% Read the "raw" format into a matrix. Extensions on the filename are expected
% to be "txt" or "raw", which assume ASCII text or single precision binary.  If
% an optional dirpath is given, then file is read from that directory by using a
% "cd" command; otherwise the present working directory is used. If an empty
% filename is given, the an empty matrix is returned.
%
% FORMATS:
% The BrainStorm "raw" format is for loading sensor and data from arbitrary
% formats. The file extensions are of keywords {.txt, .raw}. Files of extension
% "txt" are considered ASCII (text) files, and extensions of type "raw" are
% considered as binary files. The formats of each are:
% TXT:
%   Each line is terminated with an EOL, each ascii number is separated by white
%   space. Data are loaded using Matlab's "load -ascii" convention, see Matlab
%   help on "load". Matlab command is load('-ascii',fname). The number of rows
%   and columns are automatically inferred from the load routine.
% RAW:
%   All values are written as single precision binary, i.e. four-byte floats.
%   See Matlab help on "single" and on "fread". Data are loaded using fread as 
%   fread(fname,inf,'single'). The first float is the number of rows, the second
%   float is the number of columns, and the remaining rows*columns floats are
%   the data in the matrix of dimension rows x columns.
%
%  See also HELP_DATA_RAW

%<autobegin> ---------------------- 26-May-2004 11:30:51 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Utility - General
%
% At Check-in: $Author: Mosher $  $Revision: 8 $  $Date: 5/26/04 9:59a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:30:51 -----------------------

% Begin --------------------------- History ------------------------------------
% 19-Apr-2004 JCM Creation, may be redundant with other routines around
% End ----------------------------- History ------------------------------------

% CBB: Add error handling for load routines

if isempty(fname), % no filename given
   Out = [];
   return
end

if ~exist('dirpath','var'),
   dirpath = [];
end

if ~isempty(dirpath),
   cd(dirpath);
end

[ignore,ignore,RawType] = fileparts(fname);

switch lower(RawType)
   case '.txt'
      Out = load(fname,'-ascii'); % forces an ASCII read of the data file
   case '.raw'
      fid = fopen(fname,'r');
      MatrixSize = fread(fid,[1,2],'single');
      Out = fread(fid,MatrixSize,'single');
      fclose(fid)
end
