function B = mby3check(A,WARN);
%MBY3CHECK - Check to see if matrix is m by 3 or 3 by m.
% function B = mby3check(A,WARN);
% Return matrix as 3 x M, with message to user if M is three also.
% Reject input if neither dimension is three.
% If optional WARN is zero, then no verbosity to user.

%<autobegin> ---------------------- 26-May-2004 11:30:55 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Utility - General
%
% At Check-in: $Author: Mosher $  $Revision: 13 $  $Date: 5/26/04 9:59a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:30:55 -----------------------

% ----------------------------- Script History ---------------------------------
% JCM 19-May-2004 Comments cleaning
% ----------------------------- Script History ---------------------------------

[mA,nA] = size(A);

if(exist('WARN') ~=1),
  WARN = 1;
end
if((mA==3) & (nA==3)),
  if(WARN),
  disp('Input matrix is three by three.')
  disp(...
      'Program will assume that each COLUMN corresponds to 3-D information.')
  disp('If assumption is incorrect, rerun routine with matrix transposed.')
  end
  B = A;
elseif((mA~=3) & (nA~=3))	% neither is a three
  error('Input matrix is not three dimensional in either row or column.')
elseif(nA==3), 		% we want to transpose
  B = A';
else
  B = A;			% it's fine as is.
end
