function [R,s] = mby6check(A);
%MBY6CHECK - Check to see if matrix is m by 6 or 6 by m.
% function [R,s] = mby6check(A);
% First three (cols or rows) of A map to R, next three to s.
% Return both matrice as 3 x M, with message to user if M is six also.
% Reject input if neither dimension is six.
% A is typically location and orientation information combined in one matrix.
% See loc_basis, sarvas, sarvas_der for examples of input type.

%<autobegin> ---------------------- 26-May-2004 11:30:55 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Utility - General
%
% At Check-in: $Author: Mosher $  $Revision: 13 $  $Date: 5/26/04 9:59a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:30:55 -----------------------

% ----------------------------- Script History ---------------------------------
% JCM 19-May-2004  Comments cleaning
% ----------------------------- Script History ---------------------------------

[mA,nA] = size(A);

if((mA==6) & (nA==6)),
  disp('Input matrix is six by six.')
  disp(...
      'Program will assume that each COLUMN corresponds to 3-D information.')
  disp('If assumption is incorrect, rerun routine with matrix transposed.')
  B = A;
elseif((mA~=6) & (nA~=6))	% neither is a three
  error('Input matrix is not three dimensional in either row or column.')
elseif(nA==6), 		% we want to transpose
  B = A';
else
  B = A;			% it's fine as is.
end

R = B(1:3,:);			% typically sensor locations
s = B(4:6,:);			% typically sensor orientations
