function [vertex,faces,normal,vertex_number,faces_number]=mesh2brainstorm(filename);
%MESH2BRAINSTORM - Import .mesh tessellation files (BrainVisa interchange)
% function [vertex,faces,normal,vertex_number,faces_number]=mesh2brainstorm(filename);
%[vertex,faces,normal,vertex_number,faces_number] = mesh2brainstorm(filename);

%<autobegin> ---------------------- 23-Sep-2004 10:32:14 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Data Processing
%
% At Check-in: $Author: Mosher $  $Revision: 2 $  $Date: 9/23/04 8:58a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 23-Sep-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 23-Sep-2004 10:32:14 -----------------------


% /---Script Authors-------------------------------------\
% |  *** Denis Schwartz, Ph.D.                           |
% |  Cognitive Neuroscience & Brain Imaging Laboratory   |
% |  CNRS UPR640 - LENA                                  | 
% |  Hopital de la Salpetriere, Paris, France            |
% |  denis.schwartz@chups.jussieu.fr                     |
% |  with limited revamping by Sylvain Baillet           |
% \------------------------------------------------------/
%  
% Script History ---------------------------------------------------------------
% SB  20-Jul-2004  Added to main Toolbox
% Script History ---------------------------------------------------------------

fid = fopen(filename,'r');

[file_format, COUNT] = fread(fid, 5, 'uchar') ;
[lbindian, COUNT] = fread(fid, 4, 'uchar') ;
[arg_size, COUNT] = fread(fid, 1, 'uint32') ;
[VOID, COUNT] = fread(fid, arg_size, 'uchar') ;

[vertex_per_face, COUNT] = fread(fid, 1, 'uint32') ;
[mesh_time, COUNT] = fread(fid, 1, 'uint32') ;

[mesh_step, COUNT] = fread(fid, 1, 'uint32') ;
[vertex_number, COUNT] = fread(fid, 1, 'uint32') ;

[vertex, COUNT] = fread(fid, 3*vertex_number, 'float32') ;
[arg_size, COUNT] = fread(fid, 1, 'uint32') ;
vertex=reshape(vertex,3,vertex_number)' ;

[normal, COUNT] = fread(fid, 3*vertex_number, 'float32') ;
[arg_size, COUNT] = fread(fid, 1, 'uint32') ;
normal=reshape(normal, 3, vertex_number)' ;

[faces_number, COUNT] = fread(fid, 1, 'uint32') ;
[faces, COUNT] = fread(fid, vertex_per_face*faces_number, 'uint32') ;
faces=reshape(faces,vertex_per_face,faces_number)' ;

fclose(fid) ;
