function varargout = mri_parameters(varargin)
%MRI_PARAMETERS - Application M-file for mri_parameters.fig
% function varargout = mri_parameters(varargin)
%    FIG = MRI_PARAMETERS launch mri_parameters GUI.
%    MRI_PARAMETERS('callback_name', ...) invoke the named callback.

%<autobegin> ---------------------- 21-Jun-2004 16:44:55 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: GUI and Related
%
% Alphabetical list of external functions (non-Matlab):
%   toolbox\bst_color_scheme.m
%   toolbox\bst_layout.m
%   toolbox\bst_mriviewer.m
%
% Subfunctions in this file, in order of occurrence in file:
%   varargout = Create(h, eventdata, handles, varargin)
%   varargout = Donoe_Callback(h, eventdata, handles, varargin)
%
% Application data and their calls in this file:
%   'Tag'
%   'TileType'
%   
%   setappdata(fig,'TileType','T')
%   setappdata(findobj(0,'Tag','MRIViewer','type','figure'),'tmpMRI',tmpMRI)
%   
%   MRI = getappdata(MRIfig,'MRI');
%
% Figure Files opened by this function:
%   mfilename
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback by Matlab default
%
% Callbacks by figure mri_parameters.fig
%   uicontrol:pushbutton:Donoe "Done" uses Callback for <automatic>
%
% At Check-in: $Author: Mosher $  $Revision: 11 $  $Date: 6/21/04 3:11p $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 21-Jun-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 21-Jun-2004 16:44:55 -----------------------


% Last Modified by GUIDE v2.5 21-Jun-2004 16:01:13


% /---Script Authors-------------------------------------\
% |  *** Sylvain Baillet, Ph.D.                          |
% |  Cognitive Neuroscience & Brain Imaging Laboratory   |
% |  CNRS UPR640 - LENA                                  | 
% |  Hopital de la Salpetriere, Paris, France            |
% |  sylvain.baillet@chups.jussieu.fr                    |
% \------------------------------------------------------/
%  
% Script History ---------------------------------------------------------------
% SB  11 Mar-2004 Creation 
% Script History ---------------------------------------------------------------


if nargin == 0  % LAUNCH GUI

	fig = openfig(mfilename,'reuse');

	% Use BsT scheme for figure:
    setappdata(fig,'TileType','T')
    bst_color_scheme(fig)
    bst_layout('align',fig,2,2,2);
    set(fig,'visible','on')
    
	% Generate a structure of handles to pass to callbacks, and store it. 
	handles = guihandles(fig);
	guidata(fig, handles);

	if nargout > 0
		varargout{1} = fig;
	end

elseif ischar(varargin{1}) % INVOKE NAMED SUBFUNCTION OR CALLBACK

	try
		if (nargout)
			[varargout{1:nargout}] = feval(varargin{:}); % FEVAL switchyard
		else
			feval(varargin{:}); % FEVAL switchyard
		end
	catch
		disp(lasterr);
	end

end


%| ABOUT CALLBACKS:
%| GUIDE automatically appends subfunction prototypes to this file, and 
%| sets objects' callback properties to call them through the FEVAL 
%| switchyard above. This comment describes that mechanism.
%|
%| Each callback subfunction declaration has the following form:
%| <SUBFUNCTION_NAME>(H, EVENTDATA, HANDLES, VARARGIN)
%|
%| The subfunction name is composed using the object's Tag and the 
%| callback type separated by '_', e.g. 'slider2_Callback',
%| 'figure1_CloseRequestFcn', 'axis1_ButtondownFcn'.
%|
%| H is the callback object's handle (obtained using GCBO).
%|
%| EVENTDATA is empty, but reserved for future use.
%|
%| HANDLES is a structure containing handles of components in GUI using
%| tags as fieldnames, e.g. handles.figure1, handles.slider2. This
%| structure is created at GUI startup using GUIHANDLES and stored in
%| the figure's application data using GUIDATA. A copy of the structure
%| is passed to each callback.  You can store additional information in
%| this structure at GUI startup, and you can change the structure
%| during callbacks.  Call guidata(h, handles) after changing your
%| copy to replace the stored original so that subsequent callbacks see
%| the updates. Type "help guihandles" and "help guidata" for more
%| information.
%|
%| VARARGIN contains any extra arguments you have passed to the
%| callback. Specify the extra arguments by editing the callback
%| property in the inspector. By default, GUIDE sets the property to:
%| <MFILENAME>('<SUBFUNCTION_NAME>', gcbo, [], guidata(gcbo))
%| Add any extra arguments after the last argument, before the final
%| closing parenthesis.


% --------------------------------------------------------------------
function varargout = Create(h, eventdata, handles, varargin)
% Create figure

fig = eval(mfilename);
handles = guihandles(fig);

if isempty(varargin), return, end

MRIfig = varargin{1}; % Handle to MRIViewer's GUI


if isappdata(MRIfig,'MRI') % MRI already loaded - get volume information

    MRI = getappdata(MRIfig,'MRI');
    % fill-out display 
    set(handles.HeaderSize,'String',num2str(MRI.header));
    tmp = size(MRI.Cube);
    set(handles.ImageSize,'String',num2str(tmp(1:2),'%3.1f '));
    set(handles.eSliceThickness,'String',sprintf('%3.1f mm',MRI.Voxsize(3)));
    set(handles.NumberOfSlices,'String',tmp(3));
    set(handles.FOV,'String',sprintf('%3.1f %3.1f mm',MRI.FOV(1),MRI.FOV(2)));
    switch(lower(MRI.scantype))
    case 'axial'
        scanVal = 1;
    case 'sagittal'
        scanVal = 2;
    case 'coronal'
        scanVal = 3;
    end
    set(handles.ScanType,'Value',scanVal)
    
    % Class of variable Cube
    tmp = MRI.Cube;
    tmp = whos('tmp');
    
    Classes = get(handles.DataFormat,'String');
    set(handles.DataFormat,'Value',strmatch(tmp.class,Classes))
    
else % User wants to import a raw volume
    
    set([handles.HeaderSize,...
            handles.ImageSize,...
            handles.eSliceThickness,...
            handles.NumberOfSlices,...
            handles.FOV],'String','-')
   
    set(handles.BFileName,'String','Specify the following image parameters:')
end

% --------------------------------------------------------------------
function varargout = Donoe_Callback(h, eventdata, handles, varargin)

% Store image parameters in a tmp appdata
tmpMRI.HeaderSize = str2num(get(handles.HeaderSize,'String'));
tmpMRI.ImageSize = str2num(get(handles.ImageSize,'String'));
tmpMRI.SliceThickness = str2num(get(handles.eSliceThickness,'String'));
tmpMRI.NumberOfSlices = str2num(get(handles.NumberOfSlices,'String'));
tmpMRI.FOV = str2num(get(handles.FOV,'String'));
tmpMF = get(handles.MachineFormat,'String');
tmpMRI.MachineFormat = tmpMF{get(handles.MachineFormat,'Value')}; clear tmpMF

switch lower(tmpMRI.MachineFormat)
    
case 'little endian' % Little endian (default)
    tmpMRI.MachineFormat = 'ieee-le';
otherwise
    tmpMRI.MachineFormat = 'ieee-be'; % Big_endian
end


switch get(handles.ScanType,'Value')
case 1
    tmpMRI.scantype = 'axial';    
case 2
    tmpMRI.scantype = 'sagittal';    
case 3
    tmpMRI.scantype = 'coronal';    
end
Classes = get(handles.DataFormat,'String');
tmpMRI.DataFormat = Classes{get(handles.DataFormat,'Value')};

setappdata(findobj(0,'Tag','MRIViewer','type','figure'),'tmpMRI',tmpMRI)

if strcmp(lower(get(gcbo,'string')),'close')
    close(gcbf)
else
    bst_mriviewer('rawmri_done')
end


