function [marker_names,n_samples ,trial_time] = readmarkerfile_ctf(DS_FOLDER);
%READMARKERFILE_CTF - Read marker information from CTF MarkerFile.mrk
% function [marker_names,n_samples ,trial_time] = readmarkerfile_ctf(DS_FOLDER);
% Read the CTF markerfile MarkerFile.mrk located in DS_FOLDER 
% (a valid .ds CTF data set folder).
% Outputs:
% marker_names is a cell array of strings containing the name of the markers
% n_samples a corresponding cell array; each cell containing the number of events per marker
% trial_time, a cell array - The content of each cell, trial_time{i}, is a N x 2 matrix related to the occurences of marker i  
% trial_time{i}(:,1) contains the trial numbers where marker i occured
% trial_time{i}(:,2) contains the corresponding time from sync point in the corresponding trial
% /---Script Author-------------------------------------\
% |                                                      |
% |  *** Sylvain Baillet, Ph.D.                          |
% |  Cognitive Neuroscience & Brain Imaging Laboratory   |
% |  CNRS UPR640 - LENA                                  | 
% |  Hopital de la Salpetriere, Paris, France            |
% |  sylvain.baillet@chups.jussieu.fr                    |
% |                                                      |
% \------------------------------------------------------/
%
% Script History ---------------------------------------------------------
%
% Script Creation : March 2001 (bst_readmarkerfilectf.m).
% SB  28-Jul-2002 : Renamed to currenty mfilename 
% ............... : Updated help header and file description

%<autobegin> ---------------------- 09-Jul-2004 22:17:15 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Data Processing
%
% At Check-in: $Author: Mosher $  $Revision: 13 $  $Date: 7/09/04 8:42p $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 09-Jul-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 09-Jul-2004 22:17:15 -----------------------


if ~exist(fullfile(DS_FOLDER,'MarkerFile.mrk'),'file'); % No marker file available in current data set
    %error(['MarkerFile MarkerFile.mrk does not exist in directory ',DS_FOLDER]);
    marker_names =[];
    n_samples = [] ; trial_time =[];
    return
end

mrkr =  textread(fullfile(DS_FOLDER,'MarkerFile.mrk'),'%s','delimiter','\n'); % Store everything in a cell array of string

id = find(strcmp(mrkr,'NUMBER OF MARKERS:'));
n_markers  = str2num(mrkr{id+1});

id = find(strcmp(mrkr,'NAME:'));
marker_names = mrkr(id+1);

id = find(strcmp(mrkr,'NUMBER OF SAMPLES:'));
n_samples  = str2num(char(mrkr(id+1)));

mrkr_info = strmatch('TRIAL NUMBER',mrkr)+1; % Lines  where the marker times/trial info start

for i = 1:n_markers
    trial_time{i} = str2num(char(mrkr(mrkr_info(i):mrkr_info(i)+n_samples(i)))); 
    if ~isempty(trial_time{i})
        trial_time{i}(:,1) = trial_time{i}(:,1) + 1; 
    end
end
