%README - What's New in Each Revision of BrainStorm 2.0 (Alpha)
%
% By it's very nature, Alpha development/revision is not as controlled as later
% versions. Below are approximate comments as to what we are improving in each
% version
%
% 12-July-2004
%
% - Data import of BESA and Neuroscan average EEG files is now operative: 
% Access is through DataManager -> File -> Import Data -> Pick-up a Data
% Format
% Electrode locations can be read from multiple file formats:
%      '.elp' simple BESA ASCII format
%      '.dat' NeuroScan for BESA electrode format
%      '.res' NeuroScan for Curry format
%      '.sfp' ZEBRIS ASCII format
% [Thanks to Felix Darvas: SIPI/USC]
%
% 20-July-2004
%
% - Data import:
% For better interchange with BrainVisa software (see
% http://brainvisa.info) :
%  -> New MRI format import filters include GIS MR format 
%  -> New Tessellation format import filters include MESH 
%  
% 09-July-2004
%
% - Data averaging within a study is now operative: 
% Access is through DataViewer -> Basic Processing -> Average
%                   Select data files within current study folder
%                   Enter a value in ms for acceptable time-jitter about
%                   some time-locked event (default is 0)
%                   Selected data files are then averaged, with adaptation
%                   of time window if original data don't have same lenght
%                   or time limits and stored in a BrainStorm data file
%                   within current study folder.
% - Data filtering is now operating again (-> Matlab Signal Processing Toolbox is required):
%   Access is through : DataViewer -> Basic Processing -> Filter
%                       A new GUI is created and offers the possibility to 
%                                 - bandpass filter data using a zero-phase filter
%                                 - for EEG : move to average-reference potentials, once bad channels were removed
% - Fixed bug when importing from CTF markers: some time clipping may occur
% when requested time window about a marker occurence would end up having
% an edge outisde the trial time limits. A message is now issued within
% DS2BRAINSTORM stating that time clipping has occured and related event
% data files have now a Time variable with proper length
% - Fixed bug in 2D layout measures display: DataViewer -> DataViewing ->
% 2D layout
% - EXTRACT_CHANNELS: Fixed bug for CTF computation when first MEG channel containing coef
%                 correction information is declared as BAD: store coef
%                 information in first good MEG channel and trim number of
%                 lines of correction matrix to proper number of good MEG
%                 channels only (crucial when running RAP_MUSIC estimation).
% - Minor change to DataViewer GUI layout : direct access to Averager and
% and Filter
% - Moved obsolete code to Archive:
%    [filter_win.m and .mat] + [mri_scan_params.fig and .m] + [waves_multi.m and
%    .mat]
% 
% 08-July-2004
%
% - Fixed miscellaneous file access issues encountered under Linux (e.g. during data import)
%
% 07-July-2004
%
% - Fixed uicontext menu bug under Linux in DATA_MANAGER: could not load
%   data using right click.
% - Fixed minor SUBJECT_EDITOR bugs: 
%        .new values for field entries of the
%        subject file are now properly displayed at once when user click on 'save'
%        button;
%        .Date of Modification field is automatically set to current day's date when subject file is updated 
%        .Anatomy-> Import now properly calls BST_MRIVIEWER (was still calling older MRITool)
%
% 06-July-2004
%
% - Import raw MRI: Axial/Sagittal/Coronal pulldown menu switch is now
%   operative.
%
% 21-June-2004
%
% - Baillet Release 2 now available in Paris, France. Mom and baby daughter
%   doing very well, Dad and older brother very happy.
%
% - Added locked-view Zoom feature to MRIViewer:
%		.Go to View -> Zoom : extends Matlab's zoom feature in a single
%		view by automatically adjusting axes limits to the other 2
%		orthogonal views.
%
% - Change of colormap in MRIViewer GUI (bst_mriviewer.fig): 
%        . Menu -> View -> Change Colormap : calls Matlab's 6.5 Colormap Editor
%
% - Ensured that all figures by default are set with handle visibility "on"
% - Added routine "find_mfiles", called from the command line that reverse
%   engineers the m-files that open a particular figure
% - Added figure names to some of the Data Viewer outputs
% - Added Matlab default file menus to the Time Series and Topography of the MRI
%   Viewer, to the Data Time Series of the Data Viewer output.
%
% 16-June-2004
%
% - Added AVIPLAYER in PublicToolbox (create / save and playback AVI movies directly within BrainStorm's dataViewer)
% - User can alter/load and save custom colormaps using interaction with
% COLORMAPEDITOR (Matlab 6.5 and greater only)
% - Fixed bugs in loading raw data as to the DataType
% - Fixed bug in tesselation tool listing the EEG channel names for alignment
% - Minor alignment of MRI Viewer when reusing
% - Bug when viewing more than seven sources in bst_wavedata_display fixed.
% 
% 15-June-2004
%
% Fixed calls to overlapping-sphere forward modelling (MEG and EEG)
% 
%
% 14-June-2004
%
% Fixed setting of analysis time window in RAP-MUSIC 
%    - now properly updates the display time window in Viewer
%    - signal subspace statistics automatically update once a new time
%      window is defined
% Fixed bug in assignement of empty Anatomy and Tesselation fields in
%   subject editor
%
% Renamed Phantom/SampleRaw data to be of type "Mixed", added how to load text
%   file, added brainstormstudy.mat file for convenience, changed "type" button
%   to have more explicit directions on whether the sample data are homogeneous
%   or of mixed types.
%
% Added similar how_to_load file to the Phantom/montreal_data folder.
%
% Updated Matlab bug information on the Forum pages, added info on unzipping.
%
% 11-June-2004
% 
% Added Help menu item for reporting bugs to the Forum
% Fixed bad link in Help menu for Local Web Pages
% Added this What's New feature as readme.m file in the toolbox
% Added categories to the BrainStorm Forum pages

%<autobegin> ---------------------- 23-Sep-2004 10:37:23 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Help
%
% At Check-in: $Author: Mosher $  $Revision: 27 $  $Date: 9/23/04 8:59a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 23-Sep-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 23-Sep-2004 10:37:23 -----------------------


% ----------------------------- Script History ---------------------------------
% JCM 11-Jun-2004  Began this file. Just add comments above for BrainStorm
%                  improvements. Add each new revision to the TOP of the pile,
%                  so that is what the user first sees in the help window.
% ----------------------------- Script History ---------------------------------

% The filename "readme.m" is a special filename in Matlab, accessed by
% "whatsnew"
% or "info" commands, but mostly deprecated. We'll simply call it with a helpwin
% function.

helpwin(mfilename)
