function [R,s] = sensor_axial(R1,baseline);
%SENSOR_AXIAL - Generate axial gradiometers
% function [R,s] = sensor_axial(R1,baseline);
% Given sensor sites in R1, generate
% axial point gradiometers in radial direction of R1 with baseline
% separations given in baseline.
% Each element of the vector baseline should give the total baseline
% distance from the R1 origin.
% 
% For example, a BTi 37-channel first-order gradiometer pattern with a
% 5 cm baseline would by simulated by
% R1 = sensor_ring(0.12,15*pi/180,4);  % generate sensor sites
% [R,s] = sensor_axial(R1,[0.05]);
%
% A second order gradiometer with a 4 cm baseline would be simulated by
% [R,s] = sensor_axial(R1,[0.04 0.08]);
%
% The first three columns of R and s will be the positions of the coils
%   nearest the head.  The next three columns correspond to the second coil in
%   each sensor.
%
% See also SENSOR_RING, SENSOR_PLANAR

%<autobegin> ---------------------- 26-May-2004 11:34:20 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Forward Modeling
%
% Alphabetical list of external functions (non-Matlab):
%   toolbox\rownorm.m
%
% At Check-in: $Author: Mosher $  $Revision: 14 $  $Date: 5/26/04 10:02a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:34:20 -----------------------

% ----------------------------- Script History ---------------------------------
% 1994 by John C. Mosher, Ph.D.
% 19-May-2004 JCM Comments Cleaning
% ----------------------------- Script History ---------------------------------


% uses rownorm

mR = size(R1,1);		% number of sensors
baseline = baseline(:)';	% make row vector
baseline = [0 baseline];	% include first coil with offset zero
nCoils = length(baseline);	% number of coils in each sensor

sn = rownorm(R1);		% norm of each row of R1
s1 = R1 ./ sn(:,[1 1 1]);	% radial direction

% initialize
R = zeros(mR,nCoils*3); % three columns per coil
s = R;				% orientations of the coils

for i = 1:nCoils,
  ndx = (i-1)*3 + [1:3];	% index into columns of R
  R(:,ndx) = R1 + baseline(i)*s1;
  s(:,ndx) = s1;		% orientation remains same
end

return
