function varargout = simulator_mri(varargin)
%SIMULATOR_MRI - Application M-file to make a simulated spherical MRI
% function varargout = simulator_mri(varargin)
%    FIG = SIMULATOR_MRI launch simulator_mri GUI.
%    SIMULATOR_MRI('callback_name', ...) invoke the named callback.

%<autobegin> ---------------------- 26-May-2004 11:34:25 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: GUI and Related
%
% Alphabetical list of external functions (non-Matlab):
%   toolbox\bst_color_scheme.m
%   toolbox\bst_layout.m
%   toolbox\bst_message_window.m
%   toolbox\get_user_directory.m
%   toolbox\save_fieldnames.m
%
% Subfunctions in this file, in order of occurrence in file:
%   initialize_gui(handles);
%   ijk = pcs2mri(xyz,CENTER,iCenter,Voxsize,SIDE);
%   xyz = mri2pcs(ijk,CENTER,iCenter,Voxsize);
%   slave_listbox(h,eventdata,handles);
%   set_boundary_name(handles,newstr);
%   edit_listbox(h,Prompt,Title);
%   varargout = pushbutton_generate_Callback(h, eventdata, handles, varargin)
%   varargout = Quit_Callback(h, eventdata, handles, varargin)
%   varargout = listbox_boundary_name_Callback(h, eventdata, handles, varargin)
%   varargout = listbox_radius_Callback(h, eventdata, handles, varargin)
%   varargout = listbox_color_Callback(h, eventdata, handles, varargin)
%   varargout = uimenu_insert_above_Callback(h, eventdata, handles, varargin)
%   varargout = uimenu_insert_below_Callback(h, eventdata, handles, varargin)
%   varargout = uimenu_remove_boundary_Callback(h, eventdata, handles, varargin)
%   varargout = uimenu_boundary_help_Callback(h, eventdata, handles, varargin)
%   varargout = uimenu_boundary_name_Callback(h, eventdata, handles, varargin)
%   varargout = uimenu_edit_radius_Callback(h, eventdata, handles, varargin)
%   varargout = uimenu_edit_thickness_Callback(h, eventdata, handles, varargin)
%   varargout = uimenu_radius_help_Callback(h, eventdata, handles, varargin)
%   varargout = uimenu_edit_color_Callback(h, eventdata, handles, varargin)
%   varargout = uimenu_help_color_Callback(h, eventdata, handles, varargin)
%   varargout = uimenu_white_matter_Callback(h, eventdata, handles, varargin)
%   varargout = uimenu_boundary_cortex_Callback(h, eventdata, handles, varargin)
%   varargout = uimenu_boundary_csf_Callback(h, eventdata, handles, varargin)
%   varargout = uimenu_boundary_skull_Callback(h, eventdata, handles, varargin)
%   varargout = uimenu_boundary_scalp_Callback(h, eventdata, handles, varargin)
%   varargout = uimenu_boundary_custom_Callback(h, eventdata, handles, varargin)
%   varargout = edit_num_voxels_side_Callback(h, eventdata, handles, varargin)
%   varargout = edit_fov_Callback(h, eventdata, handles, varargin)
%   varargout = edit_center_Callback(h, eventdata, handles, varargin)
%   varargout = edit_fiducial_color_Callback(h, eventdata, handles, varargin)
%   varargout = edit_SUBJECTS_Callback(h, eventdata, handles, varargin)
%   varargout = edit_folder_name_Callback(h, eventdata, handles, varargin)
%   varargout = edit_file_name_Callback(h, eventdata, handles, varargin)
%
% Application data and their calls in this file:
%   'TileType'
%   
%   setappdata(fig,'TileType','T');
%   
%
% Figure Files opened by this function:
%   mfilename
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback by Matlab default
%
% Callbacks by figure simulator_mri.fig
%   uicontrol:edit:edit_center "Center" uses Callback for <automatic>
%   uicontrol:edit:edit_fiducial_color "Fiducial Color" uses Callback for <automatic>
%   uicontrol:edit:edit_file_name "Edit Text" uses Callback for <automatic>
%   uicontrol:edit:edit_folder_name "Edit Text" uses Callback for <automatic>
%   uicontrol:edit:edit_fov "FOV" uses Callback for <automatic>
%   uicontrol:edit:edit_num_voxels_side "VoxelsSide" uses Callback for <automatic>
%   uicontrol:edit:edit_SUBJECTS "Edit Text" uses Callback for <automatic>
%   uicontrol:listbox:listbox_boundary_name "Boundary Name" uses Callback for <automatic>
%   uicontrol:listbox:listbox_color "Color" uses Callback for <automatic>
%   uicontrol:listbox:listbox_radius "Radius" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_generate "Generate" uses Callback for <automatic>
%   uimenu::uimenu_boundary_cortex "" uses Callback for <automatic>
%   uimenu::uimenu_boundary_csf "" uses Callback for <automatic>
%   uimenu::uimenu_boundary_custom "" uses Callback for <automatic>
%   uimenu::uimenu_boundary_help "" uses Callback for <automatic>
%   uimenu::uimenu_boundary_name "" uses Callback for <automatic>
%   uimenu::uimenu_boundary_scalp "" uses Callback for <automatic>
%   uimenu::uimenu_boundary_skull "" uses Callback for <automatic>
%   uimenu::uimenu_edit_color "" uses Callback for <automatic>
%   uimenu::uimenu_edit_radius "" uses Callback for <automatic>
%   uimenu::uimenu_edit_thickness "" uses Callback for <automatic>
%   uimenu::uimenu_help_color "" uses Callback for <automatic>
%   uimenu::uimenu_insert_above "" uses Callback for <automatic>
%   uimenu::uimenu_insert_below "" uses Callback for <automatic>
%   uimenu::uimenu_radius_help "" uses Callback for <automatic>
%   uimenu::uimenu_remove_boundary "" uses Callback for <automatic>
%   uimenu::uimenu_white_matter "" uses Callback for <automatic>
%
% At Check-in: $Author: Mosher $  $Revision: 17 $  $Date: 5/26/04 10:02a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:34:25 -----------------------


% Last Modified by GUIDE v2.0 19-Jun-2002 23:24:49

% ----------------------------- Script History ---------------------------------
% 11-Jun-2002 JCM script design
% 19-Jun-2002 JCM GUI design
% 25-May-2004 JCM adjusting for new SCS rather than PCS descriptions
% ----------------------------- Script History ---------------------------------


if nargin == 0  % LAUNCH GUI

	fig = openfig(mfilename,'reuse');

	% Use system color scheme for figure:
	set(fig,'Color',get(0,'defaultUicontrolBackgroundColor'));

	% Generate a structure of handles to pass to callbacks, and store it. 
	handles = guihandles(fig);
	guidata(fig, handles);

	if nargout > 0
		varargout{1} = fig;
	end
   
   bst_color_scheme(fig);
   setappdata(fig,'TileType','T');
   bst_layout('align',fig,2,2,3);
   initialize_gui(handles);
   set(fig,'visible','on');
   

elseif ischar(varargin{1}) % INVOKE NAMED SUBFUNCTION OR CALLBACK

	try
		if (nargout)
			[varargout{1:nargout}] = feval(varargin{:}); % FEVAL switchyard
		else
			feval(varargin{:}); % FEVAL switchyard
		end
	catch
		disp(lasterr);
	end

end


% --------------- LOCAL SUBFUNCTIONS ------------------
function initialize_gui(handles);

User = get_user_directory;

set(handles.edit_SUBJECTS,'string',User.SUBJECTS);
set(handles.edit_folder_name,'string','sphere_mri');
set(handles.edit_file_name,'string','sphere');

set(handles.listbox_boundary_name,'string',...
   {'White Matter','Cortex','CSF','Skull','Scalp'})
set(handles.listbox_radius,'string',{'75','79','82','87','90'});
set(handles.listbox_color,'string',{'200','128','150','175','200'});

set(handles.edit_num_voxels_side,'string','128');
set(handles.edit_fiducial_color,'string','255'); % 0-255 index
set(handles.edit_fov,'string','200'); % units of mm
set(handles.edit_center,'string','[0 0 0]'); % units of mm



% ---------- CONVERT ENGINEERING TO INDEX ------------
function ijk = pcs2mri(xyz,CENTER,iCenter,Voxsize,SIDE);

ijk = round(xyz/Voxsize) + repmat(iCenter,1,size(xyz,2)); % voxel numbers
if(any(ijk > SIDE) | any(ijk < 1)),
   % error(sprintf('xyz: [%f %f %f] converts illegally to [%.0f %.0f %.0f]',xyz,ijk));
   error('Illegal index conversion');
end


% ---------- CONVERT INDEX TO ENGINEERING -----------
function xyz = mri2pcs(ijk,CENTER,iCenter,Voxsize);

xyz = (ijk - repmat(iCenter,1,size(ijk,2))) * Voxsize;





% ---------------- SLAVE LISTBOXES ---------------------
function slave_listbox(h,eventdata,handles);
slaves = {'listbox_boundary_name','listbox_radius','listbox_color'};

val = get(h,'val');

for i = 1:length(slaves),
   hl = eval(sprintf('handles.%s;',slaves{i}));
   set(hl,'val',val);
end


% -------------- Set Boundary Names ------------------
function set_boundary_name(handles,newstr);

val = get(handles.listbox_boundary_name,'val');
cstr = get(handles.listbox_boundary_name,'string');
if(~iscell(cstr)),
   cstr = cellstr(cstr);
end

cstr{val} = newstr;
set(handles.listbox_boundary_name,'string',cstr);


% --------------- Edit Listbox entry -------------
function edit_listbox(h,Prompt,Title);

val = get(h,'val');
cstr = get(h,'string');
if(~iscell(cstr)),
   cstr = cellstr(cstr);
end

% Custom name entry
prompt=Prompt;
def = cstr(val);
dlgTitle = Title;
lineNo = 1;
answer = inputdlg(prompt,dlgTitle,lineNo,def);

if(~isempty(answer)),
   cstr(val) = answer;
   set(h,'string',cstr);
end





% ----------- CALLBACKS ------------------------------

% --------------------------------------------------------------------
function varargout = pushbutton_generate_Callback(h, eventdata, handles, varargin)

%SIMULATED_MRI Create an MRI cube of voxels simulating a sphere
% function mri_cube = simulated_mri;
% Lots of parameters hardwired in this m-file.

User = get_user_directory;
FOLDER = get(handles.edit_folder_name,'string');
PREFIX = get(handles.edit_file_name,'string');


% number of voxels on a side
SIDE = str2num(get(handles.edit_num_voxels_side,'string')); 

% mm field of view on each side
FOV = str2num(get(handles.edit_fov,'string'))/1000; % in meters

% Radii
RADII = get(handles.listbox_radius,'string');
Radii = str2num(char({'[', RADII{:} ']'}))/1000; % in meters

% Color
COLOR = get(handles.listbox_color,'string');
Color = str2num(char({'[', COLOR{:} ']'})); % 0-255

% Fiducial Color
FIDUCIAL = str2num(get(handles.edit_fiducial_color,'string'));

% origin of the cube is center of indices. For even number, origin is length/2,
% (asymmetric). For odd, origin is (length + 1)/2, (symmetric).

CENTER = str2num(get(handles.edit_center,'string'))'/1000; % meters

% end of user parameters
Voxsize = FOV/SIDE; % size of voxel


% establish index center
if(rem(SIDE,2)),
   iCenter = (SIDE+1)/2;
else
   iCenter = SIDE/2;
end
iCenter = [iCenter iCenter iCenter]';

mri_cube = uint8(zeros(SIDE,SIDE,SIDE));

% x is from left to right, y is from back to front, z is from bottom to top.

% Now tag all voxels as either inside or outside the regions.
% For convenience, we think of the voxels as little spheres with diameter Voxsize.

% think in terms of axial slices
[X,Y] = meshgrid([1:SIDE],[1:SIDE]);
X = X(:)';
Y = Y(:)';
for k = 1:SIDE;
   % take coordinates of an axial slice, convert to engineering units
   rSlice = mri2pcs([X;Y;zeros(1,SIDE*SIDE)+k],CENTER,iCenter,Voxsize);
   
   rSlice = sqrt(sum(rSlice.^2)); % radial distances
   rSlice = reshape(rSlice,SIDE,SIDE); % slice of radial distances to sphere

   Slice = uint8(zeros(SIDE,SIDE)); % image of this slice
   ndx = logical(zeros(size(Slice))); % initialize those already chosen
   for i = 1:length(Radii),
      indx = ~ndx & (rSlice <= Radii(i)); % not already found and in boundary
      Slice(indx) = Color(i);
      ndx = ndx | indx; % join
   end
   
   % remainder were left as zero for outside
   
   % CBB would be to assign boundary intensity that scale with distance to InnerSkull
   % (i.e. mixed voxels)
   
   mri_cube(:,:,k) = Slice;
   
end

% now assign fiducial markers in mm
System = 'CTF';

if 0
   % obsolete
   switch System
      case 'NEUROMAG'
         % pos x is out right ear, pos y out nose
         LeftPA = [-Radii(end) 0 0]';
         RightPA = [Radii(end) 0 0]';
         RightPA2 = [Radii(end) Voxsize*2 0]'; % 2nd marker
         Nasion = [0 Radii(end) 0]';
         Cz = [0 0 Radii(end)]';
         Origin = [0 0 0]';
      case 'CTF'
         % pos x out nose, pos y out left ear
         LeftPA = [0 Radii(end) 0]';
         RightPA = [0 -Radii(end) 0]';
         RightPA2 = [Voxsize*4 -Radii(end) 0]'; % 2nd marker in front of first
         Nasion = [Radii(end) 0 0]';
         Cz = [0 0 Radii(end)]';
         Origin = [0 0 0]';
   end
else
   % Setup the basic coordinates in SCS
   % For a symmetric head, the two coordinate systems are the same, just rotated
   % pos x is out right ear, pos y out nose
   LeftPA = [-Radii(end) 0 0]';
   RightPA = [Radii(end) 0 0]';
   RightPA2 = [Radii(end) Voxsize*2 0]'; % 2nd right side marker
   Nasion = [0 Radii(end) 0]';
   Cz = [0 0 Radii(end)]';
   Origin = [0 0 0]';
end


Fiducials = [Nasion LeftPA RightPA Origin RightPA2 Cz];

% find these in MRI coordinates, using local subfunction
iFiducials = pcs2mri(Fiducials,CENTER,iCenter,Voxsize,SIDE);
Voxsize = [FOV FOV FOV]*1000/SIDE; % Voxsize in mm
% convert into mm units in the MRI frame
mmCubeFiducial = iFiducials .* (Voxsize'*ones(1,size(iFiducials,2)));

for i = 1:size(iFiducials,2),
   mri_cube(iFiducials(1,i),iFiducials(2,i),iFiducials(3,i)) = FIDUCIAL;
end



cd(User.SUBJECTS)
if(~exist(FOLDER,'dir')),
   % CBB handle status errors
   [status, message] = mkdir(FOLDER);
end
cd(FOLDER)

% ----------------------------- Make File   ---------------------------------

Filename = sprintf('%s_FOV_%.0f_SIZE_%.0f.vol',PREFIX,FOV*1000,SIDE);

fid = fopen(Filename,'w');
fwrite(fid,mri_cube(:),'char');
fclose(fid);


% create a brainstorm image
% ----------------------------- Make Structure ---------------------------------
% See help_data_image
SubjectImage = struct('Cube',[],'DataClass',[],'Voxsize',[],'scantype',[],...
   'SCS',[],'Landmarks',[]);
SCS = struct('FiducialName',[],'mmCubeFiducial',[],'System',[],'R',[],'T',[]);
Landmarks = struct('MRImmXYZ',[],'Names',[]);

SubjectImage.Cube = mri_cube;
SubjectImage.DataClase = 'uint8';
SubjectImage.Voxsize = Voxsize; % Voxsize in mm
SubjectImage.scantype = 'Axial';

% now define the SCS fields
% Fiducials = [Nasion LeftPA RightPA Origin RightPA2 Cz];
SCS.FiducialName = {'Nasion','Left PA','Right PA','Origin'};
Landmarks.Names = {'Right PA 2','Cz'};
SCS.mmCubeFiducial = mmCubeFiducial(:,1:4); % specific order
Landmarks.MRImmXYZ = mmCubeFiducial(:,5:6); % the other two

SCS.System = System;
switch System
   case 'CTF'
      % rotated such that x is out nose and y is out left ear
      SCS.R = [0 1 0; -1 0 0; 0 0 1];
   case 'NEUROMAG'
      SCS.R = eye(3); % no rotation
end

SCS.T = -mmCubeFiducial(:,4); % translation to the lower left part of head
SCS.T = SCS.R * SCS.T; % in the correct system

SubjectImage.SCS = SCS;
SubjectImage.Landmarks = Landmarks;

save_fieldnames(SubjectImage,sprintf('%s_subjectimage',PREFIX));

bst_message_window('wrap',{sprintf('Wrote to %s',pwd),Filename,...
      sprintf('%s_subjectimage',PREFIX)})





% --------------------------------------------------------------------
function varargout = Quit_Callback(h, eventdata, handles, varargin)

delete(gcbf)




% ------------------ SLAVED LISTBOXES BEGIN ---------------------------
% --------------------------------------------------------------------
function varargout = listbox_boundary_name_Callback(h, eventdata, handles, varargin)

slave_listbox(h,eventdata,handles);



% --------------------------------------------------------------------
function varargout = listbox_radius_Callback(h, eventdata, handles, varargin)

slave_listbox(h,eventdata,handles);




% --------------------------------------------------------------------
function varargout = listbox_color_Callback(h, eventdata, handles, varargin)

slave_listbox(h,eventdata,handles);





% --------------------------------------------------------------------
function varargout = uimenu_insert_above_Callback(h, eventdata, handles, varargin)

val = get(handles.listbox_boundary_name,'val'); % where in the listing now

slaves = {'listbox_boundary_name','listbox_radius','listbox_color'};
inits = {'New Boundary','100','128'};

for i = 1:length(slaves),
   hl = eval(sprintf('handles.%s;',slaves{i}));
   
   cstr = get(hl,'string');
   if(~iscell(cstr)),
      cstr = cellstr(cstr);
   end
   
   cstr = [cstr(1:(val-1)); inits(i); cstr(val:end)];
   set(hl,'string',cstr);
   
end




% --------------------------------------------------------------------
function varargout = uimenu_insert_below_Callback(h, eventdata, handles, varargin)

val = get(handles.listbox_boundary_name,'val'); % where in the listing now

slaves = {'listbox_boundary_name','listbox_radius','listbox_color'};
inits = {'New Boundary','100','128'};

for i = 1:length(slaves),
   hl = eval(sprintf('handles.%s;',slaves{i}));
   
   cstr = get(hl,'string');
   if(~iscell(cstr)),
      cstr = cellstr(cstr);
   end
   
   cstr = [cstr(1:val); inits(i); cstr((val+1):end)];
   set(hl,'string',cstr,'val',val+1);
   
end




% --------------------------------------------------------------------
function varargout = uimenu_remove_boundary_Callback(h, eventdata, handles, varargin)

val = get(handles.listbox_boundary_name,'val'); % where in the listing now

slaves = {'listbox_boundary_name','listbox_radius','listbox_color'};

for i = 1:length(slaves),
   hl = eval(sprintf('handles.%s;',slaves{i}));
   
   cstr = get(hl,'string');
   if(~iscell(cstr)),
      cstr = cellstr(cstr);
   end
   
   if(length(cstr) > 1),
      cstr(val) = [];
      val = min(val,length(cstr));
      set(hl,'string',cstr,'val',val);
   end
   
end




% --------------------------------------------------------------------
function varargout = uimenu_boundary_help_Callback(h, eventdata, handles, varargin)




% --------------------------------------------------------------------
function varargout = uimenu_boundary_name_Callback(h, eventdata, handles, varargin)




% --------------------------------------------------------------------
function varargout = uimenu_edit_radius_Callback(h, eventdata, handles, varargin)

edit_listbox(handles.listbox_radius,'Radius','Boundary Radii');



% --------------------------------------------------------------------
function varargout = uimenu_edit_thickness_Callback(h, eventdata, handles, varargin)

h = handles.listbox_radius;

% now get the thickness and convert to a radius
val = get(h,'val');
if(val > 1), % inner thickness is radius
   
   cstr = get(h,'string');
   if(~iscell(cstr)),
      cstr = cellstr(cstr);
   end
   
   Radius = str2num(cstr{val});
   InnerRadius = str2num(cstr{val-1});
   Thick = Radius - InnerRadius;
   
   
   % Custom name entry
   prompt='Thickness';
   def = {sprintf('%.1f',Thick)};
   dlgTitle = 'Boundary Radii';
   lineNo = 1;
   answer = inputdlg(prompt,dlgTitle,lineNo,def);
   
   if(~isempty(answer)),
      Thick = str2num(answer{1});
      cstr{val} = int2str(InnerRadius + Thick);
      
      set(h,'string',cstr);
   end

else
   % Val = 1, use radii, not thickness
   uimenu_edit_radius_Callback(h,eventdata,handles,varargin);
end




% --------------------------------------------------------------------
function varargout = uimenu_radius_help_Callback(h, eventdata, handles, varargin)




% --------------------------------------------------------------------
function varargout = uimenu_edit_color_Callback(h, eventdata, handles, varargin)

edit_listbox(handles.listbox_color,'Number (0-255)','Color');


% --------------------------------------------------------------------
function varargout = uimenu_help_color_Callback(h, eventdata, handles, varargin)




% --------------------------------------------------------------------
function varargout = uimenu_white_matter_Callback(h, eventdata, handles, varargin)

set_boundary_name(handles,'White Matter')



% --------------------------------------------------------------------
function varargout = uimenu_boundary_cortex_Callback(h, eventdata, handles, varargin)

set_boundary_name(handles,'Cortex')




% --------------------------------------------------------------------
function varargout = uimenu_boundary_csf_Callback(h, eventdata, handles, varargin)


set_boundary_name(handles,'CSF')


% --------------------------------------------------------------------
function varargout = uimenu_boundary_skull_Callback(h, eventdata, handles, varargin)

set_boundary_name(handles,'Skull')


% --------------------------------------------------------------------
function varargout = uimenu_boundary_scalp_Callback(h, eventdata, handles, varargin)

set_boundary_name(handles,'Scalp')


% --------------------------------------------------------------------
function varargout = uimenu_boundary_custom_Callback(h, eventdata, handles, varargin)

edit_listbox(handles.listbox_boundary_name,'Name','Boundaries');



% ------------------ SLAVED LISTBOXES END  ---------------------------







% --------------------------------------------------------------------
function varargout = edit_num_voxels_side_Callback(h, eventdata, handles, varargin)




% --------------------------------------------------------------------
function varargout = edit_fov_Callback(h, eventdata, handles, varargin)




% --------------------------------------------------------------------
function varargout = edit_center_Callback(h, eventdata, handles, varargin)




% --------------------------------------------------------------------
function varargout = edit_fiducial_color_Callback(h, eventdata, handles, varargin)




% --------------------------------------------------------------------
function varargout = edit_SUBJECTS_Callback(h, eventdata, handles, varargin)

% inactive, display only


% --------------------------------------------------------------------
function varargout = edit_folder_name_Callback(h, eventdata, handles, varargin)




% --------------------------------------------------------------------
function varargout = edit_file_name_Callback(h, eventdata, handles, varargin)

