function sangle = solid_angle2(r,r1,r2,r3)
%SOLID_ANGLE2 - Solid angle of a viewed triangle
% function sangle = solid_angle2(r,r1,r2,r3)
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Inputs:
%         r : observation point (Nobs x 3) 
%        r1 : First Vertice of Triangles (Nt x 3) 
%        r2 : Second Vertice of Triangles (Nt x 3)
%        r3 : Third Vertice of Triangles (Nt x 3)
%
% Output:
%         sangle : Function Result (Nt x Nobs)
%
% Ref: Oosterom, Strackee, IEEE Trans. BME, pp125-126, 1983 
%
% Note: if r is on the triangle, sangle will be returned as 2*pi or -2*pi
%
% %%% John Ermer 04/04/00
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%<autobegin> ---------------------- 26-May-2004 11:34:26 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Forward Modeling
%
% Alphabetical list of external functions (non-Matlab):
%   toolbox\crossprod.m
%   toolbox\dotprod.m
%   toolbox\rownorm.m
%
% At Check-in: $Author: Mosher $  $Revision: 14 $  $Date: 5/26/04 10:02a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:34:26 -----------------------


%
Nt = size(r1,1);
Nobs = size(r,1);
%
temp = reshape(repmat(r',Nt,1),3,Nt*Nobs)'; % (Nt*Nobs)x(3)
r1_r = repmat(r1,Nobs,1) - temp;            % (Nt*Nobs)x(3)
r2_r = repmat(r2,Nobs,1) - temp;            % (Nt*Nobs)x(3)
r3_r = repmat(r3,Nobs,1) - temp;            % (Nt*Nobs)x(3)
%
n1 = rownorm(r1_r);
n2 = rownorm(r2_r);
n3 = rownorm(r3_r);
%
%%%% compute sangle for all vector sets
%
sangle = 2*atan2(dotprod(r1_r,crossprod(r2_r,r3_r)),n1.*n2.*n3+...
                 n1.*dotprod(r2_r,r3_r) + n2.*dotprod(r1_r,r3_r) +...
                 n3.*dotprod(r1_r,r2_r) );
sangle = reshape(sangle,Nt,Nobs);
%

