function [L,xl,yl,zl,geol,tri_num] = ...
    source_tess(sensor_r,source_maxr,source_minr,coverage,Factor);
%SOURCE_TESS - generate variable grid of possible source locations
% function [L,xl,yl,zl,geol,tri_num] = ...
%     source_tess(sensor_r,source_maxr,source_minr,coverage,Factor);
% Given the scalar radius to the sensors sensor_r, 
%  the maximum scalar radius to the sources source_rmax, 
%  the minimum scalar radius to the sources source_rmin,
%  then generate possible dipole source locations L in the upper hemisphere.
% 
% tri_num is the number of triangles per ring.  A zero indicates the
% start of a new surface.  ctri_sum = cumsum(tri_sum); nd = find(~tri_num);
% ctri_sum(nd) gives the number of triangles per surface.
% Coverage is from tesselate, 'half','full',or radian from z-axis
% Optional Factor is the fraction considered significant, default 0.1;

%<autobegin> ---------------------- 26-May-2004 11:34:31 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Forward Modeling
%
% Alphabetical list of external functions (non-Matlab):
%   toolbox\tesselate.m
%
% At Check-in: $Author: Mosher $  $Revision: 12 $  $Date: 5/26/04 10:02a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:34:31 -----------------------


% John C. Mosher, Ph.D.
% See Copyright.m file for information
% $Date: 5/26/04 10:02a $ $Revision: 12 $
%
% February 8, 1995 author
% JCM 2/27/95 cleanup from test version to production
% JCM 4/4/95 generate fill3 surfaces, derived from source_grid

% uses: tesselate

if(exist('Factor') ~= 1),	% user gave no Factor
  Factor = 0.1; 		% what Factor is considered insignificant
end

  next_r = source_maxr; 	% initialize
  L = [];			% source locations
  xl = [];			% vertices for x
  yl = [];			% y
  zl = [];			% z
  geol = [];			% geometry matrix
  tri_num = [];			% number of triangles
  isurfaces = 0; 		% number of surfaces used
  
  while(next_r > source_minr), 	% for appropriate spherical surfaces
    isurfaces = isurfaces + 1;
    min_d = sensor_r - next_r; 	% min distance to between source and sensor
    spacing = 2*min_d*Factor; % spacing between sensors
    theta_inc = acos(1 - 0.5*(spacing/next_r)^2); % sensor increment
    if(next_r > spacing),
      [jkx,jky,jkz,jkL,jkg,jkt] = tesselate(next_r,spacing,coverage);
      % Rn = sensor_ring(next_r,theta_inc,ceil((pi/2)/theta_inc));
      xl = [xl jkx];
      yl = [yl jky];
      zl = [zl jkz];
      geol = [geol jkg+size(L,1)];
      L = [L;jkL]; 		% add these source locations
      tri_num = [tri_num jkt];
    end
    next_r = next_r - spacing;
    tri_num = [tri_num 0]; % tag the start of a new surface
  end

  

return
