function str = str_repeater(fmt,sptr,data);
%STR_REPEATER - Repeat string format and separator to display data
% function str = str_repeater(fmt,sptr,data);
% fmt is the string variable format desired, e.g., '%.1f'
% sptr is the string variable separator between data points, e.g. ', '
% data is the data read lexicographically into the format.
% separator is not applied after last data point

%<autobegin> ---------------------- 26-May-2004 11:34:31 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Utility - General
%
% At Check-in: $Author: Mosher $  $Revision: 14 $  $Date: 5/26/04 10:02a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:34:31 -----------------------

% ----------------------------- Script History ---------------------------------
% JCM 19-May-2004  Comments cleaning
% ----------------------------- Script History ---------------------------------

mD = length(data(:));
if(iscell(data)),
    str = sprintf([fmt sptr],data{:});
else
    str = sprintf([fmt sptr],data(:));
end
mS = length(str);
str(1-[1:length(sptr)]+mS) = []; % remove last separator

return
