function varargout = transform(varargin)
%TRANSFORM - Transform coordinates between PCS and MRI
% function varargout = transform(varargin)
%    TRANSFORM('callback_name', ...) invoke the named callback.
% Callbacks are pcs2mri, mri2pcs, rap2mri,
%
% for example,
%  Xmri = transform('pcs2mri',Xpcs,R,T)
% where
%  Xpcs is
%  R is
%  T is
% Output
% Xmri is

%<autobegin> ---------------------- 26-May-2004 11:34:40 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Utility - Numeric
%
% Subfunctions in this file, in order of occurrence in file:
%   Xmri = pcs2mri(Xpcs,R,T);
%   Xpcs = mri2pcs(Xmri,R,T)
%   Y = rap2mri(Xrap,PCS)
%
% At Check-in: $Author: Mosher $  $Revision: 11 $  $Date: 5/26/04 10:02a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:34:40 -----------------------


% Alex Ossadtchi, University of Southern California
% John C. Mosher, Ph.D., Los Alamos National Laboratory

% --------------------- history ----------------
% AOS June 2002     First designs
% AOS 12-June-2002  individual subfunctions
% JCM 12-July-2002  feval switchyard designed for subfunctions
% AOS               update of calling routines for new FEVAL switchyard
% ----------------------------------------------

[varargout{1:nargout}] = feval(varargin{:}); % FEVAL switchyard


% ------------------ subfunctions --------------------------
% ------------- CONVERT FROM PCS to MRI COORDINATES
function Xmri = pcs2mri(Xpcs,R,T);
    if(nargin==3)
        Xmri = R*Xpcs+repmat(T,1,size(Xpcs,2));
    elseif(nargin==2)
        Xmri = R.R*Xpcs+repmat(R.t,1,size(Xpcs,2));
    else
        disp('incorrect number of arguments in ClearPCS2MRI');
        Xmri = [];
        return;
    end;


% ------------- FROM MRI to PCS ---------------------
function Xpcs = mri2pcs(Xmri,R,T)
   if(nargin==3)
        Xpcs = inv(R)*(Xmri - repmat(T,1,size(Xmri,2)));
    elseif(nargin==2)
        Xpcs = inv(R.R)*(Xmri - repmat(R.t,1,size(Xmri,2)));
    else
        disp('incorrect number of arguments in ClearMRI2PCS');
        Xpcs = [];
        return;
    end;
    

% ---------------- SCALE RAP MUSIC RESULTS, THEN CONVERT --------------
function Y = rap2mri(Xrap,PCS)
    X = 1000*Xrap;
    Y = PCS.R*X+repmat(PCS.t,1,size(X,2));
