function [Vertices,Faces, Comments] = tri2brainstorm(TRIFILES, VERBOSE);
%TRI2BRAINSTORM - Read .tri file into BrainStorm format
% function [Vertices,Faces, Comments] = tri2brainstorm(TRIFILES, VERBOSE);
% Reads the .tri files specified in the cell array TRIFILES and outputs 
% Vertices, Faces and Comments which are ready to be saved in a BrainStorm Tessellation file.
% VERBOSE toggles the verbose mode (1 is on)

%<autobegin> ---------------------- 26-May-2004 11:34:40 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Data Processing
%
% At Check-in: $Author: Mosher $  $Revision: 14 $  $Date: 5/26/04 10:02a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:34:40 -----------------------


% /---Script Author--------------------------------------\
% |                                                      |
% | *** Sylvain Baillet, Ph.D.                           |
% | Cognitive Neuroscience & Brain Imaging Laboratory    |
% | CNRS UPR640 - LENA                                   | 
% | Hopital de la Salpetriere, Paris, France             |
% | sylvain.baillet@chups.jussieu.fr                     |
% \------------------------------------------------------/

% History -------------------------------------------
% Date of creation: May 2001
% Date of modification: October 2001                  
%----------------------------------------------------
% SB, 2001-10 / Built a BrainStorm GUI for this
% JCM 08-Sep-2003 Commenting
% ---------------------------------------------------


% Define trifiles
% DIR = 'D:\Users\Silvin\BrainStorm\subjects\Dystonia\Vig'; % repertoire de travail
% TESS_OUT = 'Vig_tess-CTF.mat'; % Nom du ficher de sortie
% TRIFILES{1} = 'para_brain.tri';
% TRIFILES{2} = 'para_white1.tri';
% TRIFILES{3} = 'para_head.tri';
% TRIFILES{4} = 'para_white2.tri';
% TRIFILES{5} = 'para_openbrain.tri';

% Fichier Anatomist contentant les differentes interfaces
% TRIFILES{1} = 'vig_brain-CTF.tri'; 
% TRIFILES{2} = 'vig_head-CTF.tri';
% TRIFILES{3} = 'Lvig_white-CTF.tri';
% TRIFILES{4} = 'Rvig_white-CTF.tri';

% cd(DIR)

if VERBOSE
    hw = waitbar(0, 'Importing .tri files...');
end

for k = 1:length(TRIFILES)
  
    fid = fopen(TRIFILES{k},'r');
    if fid < 0, error(['Cannot open file ', TRIFILES{k}]), return, end
    nverts = abs(str2num(fgetl(fid))); % Number of Vertices
    Vertices{k} = fscanf(fid,'%f',[6 nverts]);
    Vertices{k} = Vertices{k}(1:3,:)/1000;
    fgetl(fid); % don't know why I need to skip this line -> not empty in text file

    nfaces = str2num(fgetl(fid)); % Number of faces
    nfaces = abs(nfaces(1));
    Faces{k} = fscanf(fid,'%f',[3 nfaces])'+1;
    
    [a,Comments{k}] = fileparts(TRIFILES{k});
    
    if VERBOSE
        waitbar(k/length(TRIFILES),hw);
    end
    
end
if VERBOSE
    close(hw);
end

fclose('all');

% save(TESS_OUT,'Vertices','Faces','Comment','-mat');
