function varargout = web_pages(varargin)
%WEB_PAGES - Listbox of relevant BrainStorm web pages and email addresses
% function varargout = web_pages(varargin)
%    FIG = WEB_PAGES launch web_pages GUI.
%    WEB_PAGES('callback_name', ...) invoke the named callback.

%<autobegin> ---------------------- 26-May-2004 11:34:42 -----------------------
% --------- Automatically Generated Comments Block Using AUTO_COMMENTS ---------
%
% CATEGORY: Utility - General
%
% Alphabetical list of external functions (non-Matlab):
%   toolbox\bst_color_scheme.m
%   toolbox\bst_layout.m
%   toolbox\bst_message_window.m
%
% Subfunctions in this file, in order of occurrence in file:
%   varargout = initialize_gui(fig,eventdata,handles);
%   varargout = listbox_web_Callback(h, eventdata, handles, varargin)
%   varargout = pushbutton_call_Callback(h, eventdata, handles, varargin)
%   varargout = figure_web_ResizeFcn(h, eventdata, handles, varargin)
%
% Application data and their calls in this file:
%   'ReadDisclaimer'
%   'Site'
%   'TileType'
%   
%   setappdata(fig,'ReadDisclaimer',0);
%   setappdata(fig,'ReadDisclaimer',1);
%   setappdata(fig,'Site',Site);
%   setappdata(fig,'TileType','T');
%   
%   ReadDisclaimer = getappdata(fig,'ReadDisclaimer');
%   Site = getappdata(fig,'Site');
%
% Figure Files opened by this function:
%   mfilename
%
%   Format of strings below: Type:Style:Tag, "String", CallBack Type and Call
%   <automatic> callback is <Tag>_Callback by Matlab default
%
% Callbacks by figure web_pages.fig
%   figure::figure_web "" uses ResizeFcn for <automatic>
%   uicontrol:listbox:listbox_web "Listbox" uses Callback for <automatic>
%   uicontrol:pushbutton:pushbutton_call "Go To" uses Callback for <automatic>
%
% At Check-in: $Author: Mosher $  $Revision: 20 $  $Date: 5/26/04 10:02a $
%
% This software is part of BrainStorm Toolbox Version 2.0 (Alpha) 24-May-2004
% 
% Principal Investigators and Developers:
% ** Richard M. Leahy, PhD, Signal & Image Processing Institute,
%    University of Southern California, Los Angeles, CA
% ** John C. Mosher, PhD, Biophysics Group,
%    Los Alamos National Laboratory, Los Alamos, NM
% ** Sylvain Baillet, PhD, Cognitive Neuroscience & Brain Imaging Laboratory,
%    CNRS, Hopital de la Salpetriere, Paris, France
% 
% See BrainStorm website at http://neuroimage.usc.edu for further information.
% 
% Copyright (c) 2004 BrainStorm by the University of Southern California
% This software distributed  under the terms of the GNU General Public License
% as published by the Free Software Foundation. Further details on the GPL
% license can be found at http://www.gnu.org/copyleft/gpl.html .
% 
% FOR RESEARCH PURPOSES ONLY. THE SOFTWARE IS PROVIDED "AS IS," AND THE
% UNIVERSITY OF SOUTHERN CALIFORNIA AND ITS COLLABORATORS DO NOT MAKE ANY
% WARRANTY, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO WARRANTIES OF
% MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, NOR DO THEY ASSUME ANY
% LIABILITY OR RESPONSIBILITY FOR THE USE OF THIS SOFTWARE.
%<autoend> ------------------------ 26-May-2004 11:34:42 -----------------------


% Last Modified by GUIDE v2.0 25-Jul-2002 17:07:35

% --------------------------------------------------
% JCM              Initial build
% JCM 25-Jul-2002  Added MRI sites, resize control on font
% JCM 28-Jul-2002  added lots more sites, endorsement disclaimer, more resizing for longer list
% --------------------------------------------------

if nargin == 0  % LAUNCH GUI
   
   fig = openfig(mfilename,'reuse');
   
   % Use system color scheme for figure:
   set(fig,'Color',get(0,'defaultUicontrolBackgroundColor'));
   
   % Generate a structure of handles to pass to callbacks, and store it. 
   handles = guihandles(fig);
   guidata(fig, handles);
   
   if nargout > 0
      varargout{1} = fig;
   end
   
   % customization
   bst_color_scheme(fig);
   set(handles.listbox_web,'Fontname','default'); % looks prettier
   setappdata(fig,'TileType','T');
   bst_layout('align',fig,1,2,2);
   set(fig,'visible','on')
   
   initialize_gui(fig,[],handles); % load up the sites below
   
elseif ischar(varargin{1}) % INVOKE NAMED SUBFUNCTION OR CALLBACK
   
   try
      if (nargout)
         [varargout{1:nargout}] = feval(varargin{:}); % FEVAL switchyard
      else
         feval(varargin{:}); % FEVAL switchyard
      end
   catch
      disp(lasterr);
   end
   
end

% ---------------- Local Functions ------------------------------------
% --------------------------------------------------------------------
function varargout = initialize_gui(fig,eventdata,handles);

fig = handles.figure_web;

if ~isappdata(fig,'ReadDisclaimer'),
   % no disclaimer flag, set it to on
   setappdata(fig,'ReadDisclaimer',1); % need to read disclaimer
end

% edit in the web sites here
[Site(1)] = deal(struct('http',[],'Comment',[])); % initialize structure here

% Comment is displayed, and http is the called string. You must use http://

Site(1) = struct('http','',...
   'Comment','----- USC BRAINSTORM ----------------------------------------'); % use as a delimiter

Site(end+1) = struct('http','http://neuroimage.usc.edu',...
   'Comment','USC Neuroimaging Home Page');

% use end+1 in the following form to make it easy to rearrange list
Site(end+1) = struct('http','http://neuroimage.usc.edu/publics',...
   'Comment','Citations and Reprints of Publications');

Site(end+1) = struct('http','http://neuroimage.usc.edu/brainstorm/index.html',...
   'Comment','BrainStorm Tutorial Web Pages');



Site(end+1) = struct('http','',...
   'Comment',''); % use as a delimiter

Site(end+1) = struct('http','',...
   'Comment','-------- Forums and Email for BrainStorm ---------------------'); % use as a delimiter

Site(end+1) = struct('http','http://neuroimage.usc.edu/forums/index.php?c=4',...
   'Comment','Read BrainStorm news, comments, report a bug');

Site(end+1) = struct('http','mailto:brainstorm@sipi.usc.edu',...
   'Comment','Email the BrainStorm developers');

Site(end+1) = struct('http','mailto:brainstorm-users@sipi.usc.edu',...
   'Comment','Email the BrainStorm Users Group (moderated)');



Site(end+1) = struct('http','',...
   'Comment',''); % use as a delimiter

Site(end+1) = struct('http','',...
   'Comment','-------- MRI Reading, Tesselation Sites ----------------------'); % use as a delimiter

Site(end+1) = struct('http','http://www.loni.ucla.edu/NCRR/Software/BrainSuite.html',...
   'Comment','BrainSuite Analysis Tool by David Shattuck at LONI/UCLA');

Site(end+1) = struct('http','http://surfer.nmr.mgh.harvard.edu/',...
   'Comment','FreeSurfer by CorTechs and the MGH NMR Center');

Site(end+1) = struct('http','http://www.cla.sc.edu/psyc/faculty/rorden/mricro.html',...
   'Comment','MRIcro MRI viewer and conversions by Chris Rorden');



Site(end+1) = struct('http','',...
   'Comment',''); % use as a delimiter

Site(end+1) = struct('http','',...
   'Comment','-------- Other Research Software ----------------------------'); % use as a delimiter

Site(end+1) = struct('http','http://eeg.sourceforge.net/',...
   'Comment','EEG Toolbox by Darren Weber at Flinders University of South Australia');

Site(end+1) = struct('http','http://www.fmrib.ox.ac.uk/fsl',...
   'Comment','FSL by the FMRIB Image Analysis Group at Oxford University');

Site(end+1) = struct('http','http://www.fil.ion.ucl.ac.uk/spm/',...
   'Comment','SPM at Wellcome Department of Cognitive Neurology at University College London');




Site(end+1) = struct('http','',...
   'Comment',''); % use as a delimiter

Site(end+1) = struct('http','',...
   'Comment','-------- BrainStorm Collaborator and Institutional Web Pages ------------------'); % use as a delimiter

Site(end+1) = struct('http','http://neuroimage.usc.edu/leahy_home.html',...
   'Comment','Professor Leahy''s Home Page');

Site(end+1) = struct('http','http://sipi.usc.edu',...
   'Comment','Signal and Image Processing Institute at University of Southern California');

Site(end+1) = struct('http','http://www.ccr.jussieu.fr/meg-center/',...
   'Comment','CNRS MEG/EEG Center at Piti-Salptrire Hospital');

Site(end+1) = struct('http','http://www.lanl.gov',...
   'Comment','Los Alamos National Laboratory');




Site(end+1) = struct('http','',...
   'Comment',''); % use as a delimiter

Site(end+1) = struct('http','',...
   'Comment','-------- Commercial Sites ----------------------------'); % use as a delimiter

Site(end+1) = struct('http','http://www.4dneuroimaging.com/',...
   'Comment','4D Neuroimaging');

Site(end+1) = struct('http','http://www.vsmmedtech.com/ctf/about.asp',...
   'Comment','CTF at VSM MedTech');

Site(end+1) = struct('http','http://www.neuromag.com/',...
   'Comment','Neuromag');

Site(end+1) = struct('http','http://www.egi.com/',...
   'Comment','Electrical Geodesics');

Site(end+1) = struct('http','http://www.besa.de',...
   'Comment','BESA by Michael Scherg at MEGIS');

Site(end+1) = struct('http','http://www.sourcesignal.com/',...
   'Comment','EMSE Suite by Richard Greenblatt at Source Signal Imaging');

Site(end+1) = struct('http','http://www.brainvoyager.com/',...
   'Comment','BrainVoyager by Rainer Goebel at Brain Innovation');

Site(end+1) = struct('http','http://www.ant-software.nl',...
   'Comment','Advanced Source Analysis by Frank Zanow and Thomas Knoesche at ANT');





set(handles.listbox_web,'String',{Site.Comment});


setappdata(fig,'Site',Site);




% ------------------- Callbacks ------------------------------------
% ------------------LISTBOX DOUBLECLICK CALLS WEB PAGE -----------------
function varargout = listbox_web_Callback(h, eventdata, handles, varargin)

Click = get(handles.figure_web,'selectiontype');
switch lower(Click)
case 'normal' % single clicking won't activate
otherwise
   % double-click, go to page
   pushbutton_call_Callback(h,eventdata,handles,varargin);
end
   


% --------------------- LAUNCH WEB PAGE OR MAIL COMMAND ---------------------
function varargout = pushbutton_call_Callback(h, eventdata, handles, varargin)
% can also be called by double clicking on line in the listbox

Val = get(handles.listbox_web,'Val');
fig = handles.figure_web;
Site = getappdata(fig,'Site');

ReadDisclaimer = getappdata(fig,'ReadDisclaimer');

if ReadDisclaimer,
   str = ['Commercial or other sites listed are for convenience only. ',...
         'No endorsement of products or firms included in this list ',...
         'is intended, nor is lack of endorsement intended for those not included.'];
   bst_message_window('wrap',{str});
   setappdata(fig,'ReadDisclaimer',0); % don't need to display again
end

if(~isempty(Site(Val).http)), % if not a blank site, e.g. delimiter string
   web(Site(Val).http,'-browser');
   bst_message_window('wrap',{...
      sprintf('Accessing in your browser: %s . . .',Site(Val).http)});
   % and so that user could cut and paste, send to command window as well:
   disp(sprintf('Accessing: %s . . .',Site(Val).http));
end



% --------------------------------------------------------------------
function varargout = figure_web_ResizeFcn(h, eventdata, handles, varargin)
% keep the listbox looking the same, no matter the size.

Fixed(1).h = handles.listbox_web;
Fixed(1).pts = 10;

if(1), % any others?

   Fixed(end+1).h = handles.TitleText;
   Fixed(end).pts = 14;
   
   Fixed(end+1).h = handles.pushbutton_call;
   Fixed(end).pts = 12;
   
end

for i = 1:length(Fixed)
   
   set(Fixed(i).h,'fontunits','points')
   set(Fixed(i).h,'fontsize',Fixed(i).pts);
   set(Fixed(i).h,'fontunits','points');
   
end


