#include "omatrix.h"

int nlhs;
int nrhs;
pMatrix plhs;
pMatrix prhs;

pMatrix (__cdecl *direct)     (pMatrix);
void    (__cdecl *allocate)   (pMatrix);
void    (__cdecl *free_mat)   (pMatrix);
void    (__cdecl *error)      (char *, char *);
void    (__cdecl *prText)     (char *, char *);

BOOL APIENTRY DllMain(HANDLE hModule, DWORD ul_reason_for_call, LPVOID lpReserved)
{
        if (ul_reason_for_call == DLL_PROCESS_DETACH) {
                extern void ExitFcn();

                ExitFcn();
                prText = NULL;
        }
        return(TRUE);
}

void Printf(char *format, ...)
{
        va_list ap;
        static char buf[4096];

        if (prText != NULL) {
        	va_start(ap, format);
        	_vsnprintf(buf, sizeof(buf), format, ap);
        	prText("command", buf);
        	va_end(ap);
        }
        else if (nrhs < 1) {
                char *ptr;

        	va_start(ap, format);
        	_vsnprintf(buf, sizeof(buf), format, ap);
                strcat(buf, "\nNo printing capability to command window available.\nYou need to upgrade to version 5.8 for this feature.");
                ptr = buf;
                CreateString(&ptr, 1, plhs);
        	va_end(ap);
        }
}

void setargs(int narg0, int nret0, pMatrix ret0, pMatrix arg0, pMatrix (__cdecl *direct0) (pMatrix), void (__cdecl *allocate0) (pMatrix), void (__cdecl *free_mat0) (pMatrix), void (__cdecl *error0) (char *, char *), void (__cdecl *prText0) (char *, char *))
{
        nrhs = narg0;
        nlhs = nret0;
        plhs = ret0;
        prhs = arg0;
        direct = direct0;
        allocate = allocate0;
        free_mat = free_mat0;
        error = error0;

        if ((unsigned long) prText0 > 0x1000)
        	prText = prText0;
        else
                prText = NULL;
}


/* Function to get a real scalar with error checking */

REAL GetRealScalar(pMatrix pm)
{
        Matrix mat = GetpMatrix(pm);
        char OK = TRUE;
        REAL a;

        if ((GetM(mat) == 1) && (GetN(mat) == 1)) {
            	switch (mat->type) {
                case INT_mat:
                        a = (REAL) mat->adr.i[0];
                        break;
                case REAL_mat:
                        a = (REAL) mat->adr.r[0];
                        break;
                case DOUBLE_mat:
                        a = (REAL) mat->adr.d[0];
                        break;
                default:
                        OK = FALSE;
                        break;
                }
	}
        else
                OK = FALSE;

        if (!OK) {
		ErrMsgTxt("Expecting a scalar argument.");
                /*
                sprintf(buf, "Expecting a scalar argument. %d %d %d", GetM(mat), GetN(mat), mat->type);
                ErrMsgTxt(buf);
                */
        }

        return(a);
}


#define GetVector(pm, vec, start, len, exactcount, ret) \
{ \
	int	k, m, n, count = 0; \
	int	*pri; \
        float   *prr; \
        double	*prd; \
 \
	m = GetM(pm); \
	n = GetN(pm); \
 \
	if ( !((m == 1) || (n == 1)) || \
             ((m == 1) && (((exactcount) && (len != n)) || ((!exactcount) && (n > len)))) || \
             ((n == 1) && (((exactcount) && (len != m)) || ((!exactcount) && (m > len)))) || \
	     !IsNumeric(pm) || IsComplex(pm)) { \
		ErrMsgTxt("invalid vector."); \
	} \
 \
        if (n == 1) \
                len = m; \
        else \
                len = n; \
        vec += start; \
 \
        switch (pm->type) { \
        case INT_mat: \
                pri = pm->adr.i; \
                for (k = 0; k < len; k++, pri++, vec++) { \
		  	*vec = *pri; \
	  	} \
          	break; \
        case REAL_mat: \
                prr = pm->adr.r; \
                for (k = 0; k < len; k++, prr++, vec++) { \
		  	*vec = *prr; \
	  	} \
          	break; \
        case DOUBLE_mat: \
                prd = pm->adr.d; \
                for (k = 0; k < len; k++, prd++, vec++) { \
		  	*vec = *prd; \
	  	} \
          	break; \
        } \
 \
        count = len; \
 \
        ret = count; \
}

/* Functions to get len elements from a O-Matrix vector. */

int GetIntVector(pMatrix pm, int *vec, int start, int len, int exactcount)
{
        int ret;
        Matrix mat = GetpMatrix(pm);

        GetVector(mat, vec, start, len, exactcount, ret)

        return(ret);
}

int GetRealVector(pMatrix pm, REAL *vec, int start, int	len, int exactcount)
{
        int ret;
        Matrix mat = GetpMatrix(pm);

        GetVector(mat, vec, start, len, exactcount, ret)

        return(ret);
}


/* Function to get max len elements from a O-Matrix vector.
   O-Matrix doesn't know sparse matrixes, so a matrix is converted to sparse */

int GetRealSparseVector(pMatrix pm, REAL *vec, int *index, int start, int len, int col)
{
	int	j, k, k1, m, n, start1, count = 0;
	int	*pri;
        float   *prr;
        double	*prd;
        Matrix mat = GetpMatrix(pm);

	m = GetM(mat);
	n = GetN(mat);

	if (  ((col == 0) && (((m != 1) && (n != 1)) || ((m == 1) && (n > len)) || ((n == 1) && (m > len)))) ||
              ((col != 0) && ((m > len) || (col > n))) ||
	      !IsNumeric(mat) ||
              IsComplex(mat)  ) {
/* Printf("1: m=%d, n=%d, col=%d, len=%d, IsNumeric=%d, IsComplex=%d\n", m,n,col,len,IsNumeric(mat),IsComplex(mat)); */
		ErrMsgTxt("invalid vector.");
	}

        if ((((n == 1) || (col != 0)) && (m != len)) || ((col == 0) && (m == 1) && (n != len))) {
/* Printf("2: m=%d, n=%d, col=%d, len=%d\n", m,n,col,len); */
                ErrMsgTxt("invalid vector.");
        }

        switch (mat->type) {
        case INT_mat:
                pri = mat->adr.i;
                if (col)
                	pri += (col - 1) * m;
                for (k = 0; k < len; k++, pri++) {
                        if (*pri) {
				*(vec++) = (REAL) *pri;
                		*(index++) = start + k;
                		count++;
                        }
	  	}
          	break;
        case REAL_mat:
                prr = mat->adr.r;
                if (col)
                	prr += (col - 1) * m;
                for (k = 0; k < len; k++, prr++) {
                        if (*prr) {
				*(vec++) = (REAL) *prr;
                		*(index++) = start + k;
                		count++;
                        }
	  	}
          	break;
        case DOUBLE_mat:
                prd = mat->adr.d;
                if (col)
                	prd += (col - 1) * m;
                for (k = 0; k < len; k++, prd++) {
                        if (*prd) {
				*(vec++) = (REAL) *prd;
                		*(index++) = start + k;
                		count++;
                        }
	  	}
          	break;
        }

        return(count);
}

void GetString(pMatrix pm, char *buf, int size)
{
        Matrix x_in = GetpMatrix(pm);

        if (x_in->type != CHAR_mat)
                ErrMsgTxt("Expecting a character element.");
        if (x_in->nr != 1)
                ErrMsgTxt("Expecting a single row string.");
        if (x_in->nc < size)
                size = x_in->nc;
        else
                size--;
        memcpy(buf, (char *) x_in->adr.c, size);
        buf[size] = 0;
}

strArray GetCellCharItems(pMatrix pm, int len)
{
        int m, n, i, j, k;
        Matrix x_in = GetpMatrix(pm);
        char **pa0, **pa, *str, *c;

        if (x_in->type != CHAR_mat)
                ErrMsgTxt("Expecting a character element.");
        m = GetM(x_in);
        n = GetN(x_in);
        if (!(m == len))
                ErrMsgTxt("invalid vector.");

        str = (char *) matCalloc(n + 1, sizeof(*str));

        pa = pa0 = (char **) matCalloc(len, sizeof(*pa));
        c = (char *) x_in->adr.c;
        for (i = 0; i < len; i++, c++) {
                for (k = -1, j = 0; j < n; j++)
                        if (!isspace(str[j] = c[j * m]))
                                k = j;
                str[k + 1] = 0;
                *(pa++) = strdup(str);
        }
        matFree(str);
        return(pa0);
}

void GetCellString(char **pa, char *buf, int len)
{
        strncpy(buf, *pa, len);
}

void FreeCellCharItems(strArray pa, int len)
{
        int i;

        for (i = 0; i < len; i++)
                free(pa[i]);
	matFree(pa);
}


double *CreateDoubleMatrix(int m, int n, pMatrix plhs)
{
        free_mat(plhs);
        plhs->nr   = m;
        plhs->nc   = n;
        plhs->type = DOUBLE_mat;
        allocate(plhs);
        return(plhs->adr.d);
}

void CreateString(char **str, int m, pMatrix plhs)
{
        int i, j, l0, l = 0;
        char *ptr, *str0;

        for (i = 0; i < m; i++) {
        	l0 = strlen(str[i]);
                if (l0 > l)
                        l = l0;
        }
        free_mat(plhs);
        plhs->nr   = m;
        plhs->nc   = l;
        plhs->type = CHAR_mat;
        allocate(plhs);
        ptr = (char *) plhs->adr.c;
        memset(ptr, ' ', m * l);
        for (i = 0; i < m; i++, ptr++) {

                str0 = str[i];
                l0 = strlen(str0);
                for (j = 0; j < l0; j++)
        		ptr[j * m] = str0[j];
        }
}
