#include "dll.h"

#include "lp_lib.h"

#define ErrMsgTxt(str) error("omlpsolve", str)
#define drivername "omlpsolve"
#define caller "O-Matrix"
#define IsNumeric(pm) (((pm)->type == INT_mat) || ((pm)->type == REAL_mat) || ((pm)->type == DOUBLE_mat))
#define IsComplex(pm) ((pm)->type == COMPLEX_mat)
#define IsSparse(pm) FALSE
#define GetM(pm) (pm)->nr
#define GetN(pm) (pm)->nc
#define GetpMatrix(pm) direct(pm)
#define GetPr(pm) (pm)->adr
#define adrElement address
/* #define GetPr(pm) ((pm)->type == INT_mat ? (pm)->adr.i : (pm)->type == REAL_mat ? (pm)->adr.r : (pm)->type == DOUBLE_mat ? (pm)->adr.d) */
#define matCalloc calloc
#define matFree free

#define MatrixEl matrix
#define pMatrix MatrixEl *
#define Matrix pMatrix
#define strArray char **

#undef HasCellMatrix

#define putlogfunc put_logfunc

#define init_lpsolve_lib() TRUE
#define exit_lpsolve_lib()

#define callerPrototype DLLPrototype(omlpsolve)

#define publicargs() setargs(narg, nret, ret, arg, direct, allocate, free_mat, error, prText)

#define registerExitFcn()

extern int nlhs;
extern int nrhs;
extern pMatrix plhs;
extern pMatrix prhs;

extern pMatrix (__cdecl *direct)     (pMatrix );
extern void    (__cdecl *allocate)   (pMatrix );
extern void    (__cdecl *free_mat)   (pMatrix );
extern void    (__cdecl *error)      (char *, char *);
extern void    (__cdecl *prText)     (char *, char *);

extern void setargs(int narg0, int nret0, pMatrix ret0, pMatrix arg0, pMatrix (__cdecl *direct0) (pMatrix ), void (__cdecl *allocate0) (pMatrix ), void (__cdecl *free_mat0) (pMatrix ), void (__cdecl *error0) (char *, char *), void (__cdecl *prText0) (char *, char *));
extern void Printf(char *format, ...);
extern REAL GetRealScalar(pMatrix pm);
extern int GetIntVector(pMatrix pm, int *vec, int start, int len, int exactcount);
extern int GetRealVector(pMatrix pm, REAL *vec, int start, int len, int exactcount);
extern int GetRealSparseVector(pMatrix pm, REAL *vec, int *index, int start, int len, int col);
extern void GetString(pMatrix pm, char *buf, int size);
extern strArray GetCellCharItems(pMatrix pm, int len);
extern void GetCellString(char **pa, char *buf, int len);
extern void FreeCellCharItems(strArray pa, int len);
extern double *CreateDoubleMatrix(int m, int n, pMatrix plhs);
extern void CreateString(char **str, int m, pMatrix plhs);
