function[OutFilePath]=AddSubPoints2AvgFiles(InFileMat,PrePoints,PostPoints,Ext)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%==================================================================
%
%	AddSubPoints2AvgFiles
%
%	Markus Junghoefer	[2002]
%
%	Function definition
%
%
%
%==================================================================
if nargin<4; Ext=[]; end;
if nargin<3; PostPoints=[]; end;
if nargin<2; PrePoints=[]; end;
if nargin<1; InFileMat=[]; end;
%==================================================================
if isempty(Ext); Ext='.bb'; end
[DefFilePath] = SetDefPath(1,'*');
[NFiles,InFileMat,NonUse,BatchFilePath]=ReadFileNames(InFileMat,DefFilePath,'Choose Avg files:');
[BatchFile,BatchPath]=SepFilePath(BatchFilePath);
SetDefPath(2,BatchPath);
if NFiles==0
	fprintf(1,'Sorry, no file in InFileMat !\n');
	fprintf(1,'Running file: AddSubPoints2AvgFiles');
	return;
end

fprintf('\n\n');

[PrePoints]=IfEmptyInputVal('Please choose the number of points','to add to (pos) or subtract from (neg) the beginning of interval:',PrePoints,0,1);
[PostPoints]=IfEmptyInputVal('Please choose the number of points','to add to (pos) or subtract from (neg) the end of interval:',PostPoints,0,1);

for FileIndex=1:NFiles
	[File,Path,FilePath]=GetFileNameOfMat(InFileMat,FileIndex);
	[AvgMat,File,Path,FilePath,NTrialAvgVec,StdMat,...
	SampRate,AvgRef,Version,MedMedRawVec,MedMedAvgVec,EegMegStatus,NChanExtra]=ReadAvgFile(FilePath);
	[NChan,NPoints]=size(AvgMat)
    fprintf(1,'\n\n');
    fprintf(1,'Original number of points: %g\n',NPoints);
    fprintf(1,'New number of points:      %g\n',NPoints+PrePoints+PostPoints);
    if PrePoints<0
        AvgMat=AvgMat(:,-PrePoints+1:NPoints);
        StdMat=StdMat(:,-PrePoints+1:NPoints);
    end
    if PostPoints<0
        AvgMat=AvgMat(:,1:NPoints+PostPoints);
        StdMat=StdMat(:,1:NPoints+PostPoints);
    end
    [NChan,NPoints]=size(AvgMat);
    if PrePoints>0
        AvgMatNew=zeros(NChan,NPoints+PrePoints);
        AvgMatNew(:,PrePoints+1:NPoints+PrePoints)=AvgMat;
        AvgMat=AvgMatNew;
        StdMatNew=zeros(NChan,NPoints+PrePoints);
        StdMatNew(:,PrePoints+1:NPoints+PrePoints)=StdMat;
        StdMat=StdMatNew;
        [NChan,NPoints]=size(AvgMat);
    end
    if PostPoints>0
        AvgMatNew=zeros(NChan,NPoints+PostPoints);
        AvgMatNew(:,1:NPoints)=AvgMat;
        AvgMat=AvgMatNew;
        StdMatNew=zeros(NChan,NPoints+PostPoints);
        StdMatNew(:,1:NPoints)=StdMat;
        StdMat=StdMatNew;
    end
    [NChan,NPoints]=size(AvgMat)
    SaveAvgFile([FilePath,Ext],AvgMat,NTrialAvgVec,StdMat,SampRate,MedMedRawVec,MedMedAvgVec,EegMegStatus,NChanExtra);
end







return;

