GenderVal=3;	%Male
File= 'IAPS_15_716';
Path='Geo';
PathTmp=what(Path)
if length(PathTmp)==0
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
	[File,Path]=uigetfile('*IAPS15','Look for IAPS15 file:');
	FilePath=[Path,File];
else
	Path=getfield(PathTmp,'path');
	if strcmp(Path(length(Path)),FileSep); Path=Path(1:length(Path)-1); end
	FilePath=[Path,FileSep,File];
end
MatMat=ReadData(FilePath,1,[],'ascii','ascii');
[NPic,NonUse]=size(MatMat);
PicVec=MatMat(:,1);
PicVecTmp=PicVec;
NDiffPic=0;
NIdPic=0;
NNoUseInd=0;
TakeIndVec=[1:NPic];
while ~isempty(PicVecTmp)	%Welche Bilder mehrfach vorkommen
	NDiffPic=NDiffPic+1;
	DiffPicVec(NDiffPic)=PicVecTmp(1); 
	k=find(PicVecTmp~=PicVecTmp(1));
	l=find(PicVecTmp==PicVecTmp(1));
	if length(l)>1;
		NNoUseInd=NNoUseInd+length(l)-1;
		NIdPic=NIdPic+1;
		IdPicVec(NIdPic)=PicVecTmp(l(1));
		disp(PicVecTmp(l)'); 
	end
	PicVecTmp=PicVecTmp(k);
end
if ~isempty(IdPicVec)
	Tmp=1;
	NoUseIndVec=zeros(NNoUseInd,1);		
	for i=1:length(IdPicVec)
		a=find(PicVec==IdPicVec(i));
		NoUseIndVec(Tmp:Tmp+length(a)-2)=a(2:length(a));
		Tmp=Tmp+length(a)-1;
	end
	TakeInd=0;
	TakeVec=zeros(NPic-NNoUseInd,1);
	for i=1:NPic
		if ~any(NoUseIndVec==i)
			TakeInd=TakeInd+1;
			TakeVec(TakeInd)=i;
		end
	end
	MatMat=MatMat(TakeVec,:);
	[NPic,NonUse]=size(MatMat);
end
if GenderVal==1;		%All
	Mat=MatMat(:,1:5);
elseif GenderVal==2;	%Females
	Mat=MatMat(:,6:10);
elseif GenderVal==3;	%Males
	Mat=MatMat(:,11:15);
end
PicVecTmp=Mat(:,1);
ValVec=Mat(:,2);
ValStdVec=Mat(:,3);
AroVec=Mat(:,4);
AroStdVec=Mat(:,5);
	
[File,Path,FilePath,GenderVal,MovieFunction,NCycle,...
NPicPerCycle,SortByValStatus,SortByAroStatus,SortByRGBHSVStatus,...
ColorBlackWhite,BrightStatus,UseRandPermStatus,UseExtraRatingStatus,...
StartPic,SizeMovieLogMat,MovieLogMat]=ReadMovieLogFile;
PicIndVec=MovieLogMat(:,2);	
% PicVec=MovieLogMat(:,3);
PicVec=PicVecTmp(PicIndVec);
ValVec=ValVec(PicIndVec);

MedValVec=median(ValVec)
MeanValVec=mean(ValVec)
StdValVec=std(ValVec);
DiffValVecA=zeros(352,1);
DiffValVecB=zeros(352,1);
for Ind=2:2:704
	DiffValVecA(Ind./2)=ValVec(Ind)-ValVec(Ind-1);
end
DiffValVecB(1)=0;
for Ind=3:2:703
	DiffValVecB((Ind+1)./2)=ValVec(Ind)-ValVec(Ind-1);
end
StdFac=.5;

PosDiffValVecA=find(DiffValVecA>0);
NegDiffValVecA=find(DiffValVecA<0);
PosDiffValVecB=find(DiffValVecB>0);
NegDiffValVecB=find(DiffValVecB<0);

HighValIndVec=find(ValVec>6);
LowValIndVec=find(ValVec<4);
NeuValIndVec=find(ValVec<6 & ValVec>4);

ValFig=figure('Units','normal','Position',[.5 .5 .5 .5],'Name','Valence Info','NumberTitle','off');
plot(ValVec,'--')
hold on
plot([1 NPic],[6 6],'r--')
plot([1 NPic],[4 4],'g--')
plot(HighValIndVec,ValVec(HighValIndVec),'*r')
plot(LowValIndVec,ValVec(LowValIndVec),'*g')
plot(NeuValIndVec,ValVec(NeuValIndVec),'*y')
title('Valence')
ylabel('Valence')
xlabel('Picture #')
CondVecA=zeros(352,1);
for Ind=1:2:703
	if any(NeuValIndVec==Ind)
		if any(HighValIndVec==Ind+1)
			CondVecA((Ind+1)./2)=4;
		elseif any(LowValIndVec==Ind+1)
			CondVecA((Ind+1)./2)=3;
		end
	end
end
CondVecB=zeros(352,1);
for Ind=2:2:704
	if any(NeuValIndVec==Ind+1)
		if any(HighValIndVec==Ind)
			CondVecB(Ind./2+1)=4;
		elseif any(LowValIndVec==Ind)
			CondVecB(Ind./2+1)=3;
		end
	end
end
% ValVec(1:20)'
% CondVecB(1:10)'
% return

[DefFilePath] = SetDefPath(1,'*.CON');
[CondVec,File,Path,CondFilePath,EndPos] = ReadData([],1,[],'ascii','ascii',[],[],[],[],[],[],[],DefFilePath);
SetDefPath(2,Path);
[TrialVec] = ReadData(CondFilePath,1,[],'ascii','ascii',EndPos);
NTrials=length(TrialVec)
DiffVec=zeros(NTrials-1,1);
for Ind=2:NTrials
	DiffVec(Ind-1)=TrialVec(Ind)-TrialVec(Ind-1);
end
MedDiff=median(DiffVec);
StdDiff=std(DiffVec);

TrialVecNew=zeros(352,1);
CondVecNew=zeros(352,1);
TrialVecNew(1)=TrialVec(1);
CondVecNew(1)=CondVec(1);
Index=1;
for Ind=1:length(DiffVec)
	Fac=DiffVec(Ind)./MedDiff;
 	if abs(Fac-round(Fac))./Fac<.4
		Index=Index+round(Fac);
	else
		Index=Index+floor(Fac);
	end
	TrialVecNew(Index)=TrialVec(Ind+1);
	CondVecNew(Index)=CondVec(Ind+1);
end
Index=Index
length(CondVecNew)
TakeTrialVec=find(CondVecNew~=0);
length(TakeTrialVec)
if Index~=351; error('Index~=351'); end
if length(TakeTrialVec)~=NTrials; error('length(TakeTrialVec)~=NTrials'); end
% CondVecA=zeros(351,1);
% CondVecA(PosDiffValVecA)=2.*ones(size(PosDiffValVecA));
% CondVecA(NegDiffValVecA)=ones(size(NegDiffValVecA));
CondVecA=CondVecA(TakeTrialVec);
% CondVecB=zeros(351,1);
% CondVecB(PosDiffValVecB)=2.*ones(size(PosDiffValVecB));
% CondVecB(NegDiffValVecB)=ones(size(NegDiffValVecB));
CondVecB=CondVecB(TakeTrialVec);

TrialFig=figure('Units','normal','Position',[.6 0 .4 1],'Name','Tigger Info','NumberTitle','off');
subplot(4,1,1)
plot(TrialVec)
title('Trigger Vector')
xlabel('Trigger #')
ylabel('Time Point []')
subplot(4,1,2)
plot(DiffVec)
axis([0 length(DiffVec) .9.*min(DiffVec) 1.1.*max(DiffVec)])
title('Distance between Trigger')
xlabel('Trigger #')
ylabel('Distance Points []')
subplot(4,1,3)
plot(TrialVecNew)
axis([0 length(TrialVecNew) .9.*min(TrialVecNew) 1.1.*max(TrialVecNew)])
title('New Trigger Vector')
xlabel('Trigger #')
ylabel('Points []')
subplot(4,1,4)
plot(CondVecNew)
axis([0 length(CondVecNew) .9.*min(CondVecNew) 1.1.*max(CondVecNew)])
title('New Condition Vector')
xlabel('Trigger #')
ylabel('Condition #')

CondFilePathA=[CondFilePath(1:length(CondFilePath)-4) 'A.E1' CondFilePath(length(CondFilePath)-3:length(CondFilePath))];
CondFilePathB=[CondFilePath(1:length(CondFilePath)-4) 'B.E1' CondFilePath(length(CondFilePath)-3:length(CondFilePath))];
SaveData(CondVecA,CondFilePathA,1,[],'ascii','ascii',[],[],[],1,1,0);
SaveData(CondVecB,CondFilePathB,1,[],'ascii','ascii',[],[],[],1,1,0);
