%==================================================================
%==================================================================
clear all;
%
%	Batch.m
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%	Markus Junghoefer	[1999]
%
%
%	Function definition
%	
%
%
%
%
%=================================================================

%==================================================================

TRStatus=1;
[DefFilePath]=SetDefPath('r','*.RAW')
[NNetFiles,RawFileMat,NonUse,BatchFilePath]=ReadFileNames([],DefFilePath,'Choose NetStation file:');
if NNetFiles==0; return; end
SetDefPath('w',BatchFilePath);
[ch_UseOverAllGainFile]=IfEmptyInputBo('Do you want to use one special gain and one special zero file ?',[],[],0);

if ch_UseOverAllGainFile
	[GainFile,GainPath,GainFilePath]=ReadFilePath([],'*.Gain','Please choose the over all gain file:');
	[ZeroFile,ZeroPath,ZeroFilePath]=ReadFilePath([],'*.Zero','Please choose the over all zero file:');
	if GainFile==0; GainFile=[]; GainPath=[]; GainFilePath=[]; end
	if ZeroFile==0; ZeroFile=[]; ZeroPath=[]; ZeroFilePath=[]; end
else
	GainFilePath=[];
	ZeroFilePath=[];
end

%===============FilterNetFile====================================
%Filter 50 Hz LowPass
ch_LowPassFilt=0;
ch_HighPassFilt=0;
SampRate=[];
if ch_LowPassFilt | ch_HighPassFilt
	for FileInd=1:NNetFiles
		[NoUse,NoUse,NetFilePath]=GetFileNameOfMat(RawFileMat,FileInd);
		[NoUse,NoUse,NoUse,NoUse,NoUse,NoUse,NoUse,NoUse,NoUse,NoUse,NoUse,SampRateTmp,NChan]=ReadRAWHeader(NetFilePath);
		if ~isempty(SampRate)
			 if SampRateTmp~=SampRate
				error('It is not possible to filter in batch mode because of different sampling rates in different files !')
			end
		end
		SampRate=SampRateTmp;
	end
end
[NoUse,NoUse,NetFilePath]=GetFileNameOfMat(RawFileMat,1);
[NoUse,NoUse,NoUse,NoUse,NoUse, NoUse, NoUse, NoUse, NoUse, NoUse, NoUse,SampRate,NChan]=ReadRAWHeader(NetFilePath);
HighDefFreqsMat=[SampRate 1 0.01];
HighDefRipMat=[3 45];
LowDefFreqsMat=[SampRate 50 60]; 
LowDefRipMat=[3 45];
ch_ChooseChannelInd=0;
ChanStatusVec=ones(NChan,1);
PlotStatus=0;
ch_AddSubZeros=0;
NZPoints=[];

[ch_LowPassFilt,LowB,LowA,ch_HighPassFilt,HighB,HighA,LowFreqsMat,HighFreqsMat] = ...
GetHighLowFiltCoeff(SampRate,HighDefFreqsMat,HighDefRipMat,LowDefFreqsMat,LowDefRipMat,...
ch_LowPassFilt,ch_HighPassFilt);

%===============TransNetGeoHist====================================
% [EGISFileMat,NetFileMat,CondFileMat]=TransNetGeoHist(NetFileMat,TRStatus,...
% PreTrig,PostTrig,ReTrig,GainFilePath,ZeroFilePath,OldZeroVersion,...
% NGainZeroString,SpecCondVec,NStep,NDefTrials,SimpleTrig,DSample,DMeanSampleStatus,IntTrig)
[EGISFileMat]=TransNetGeoHist(RawFileMat,TRStatus,0,41,1,GainFilePath,ZeroFilePath,0,4)

%===============CalcAutoEditMat ohne avg ref EEG und ohne flat====================================
%[AEMFilePathMat]=CalcAutoEditMat(FileMat,TimeStatusVec,ch_CalcAvgRef,ch_UseSpecChan,...
%ch_CalcBaseline,BaseStartPoint,BaseEndPoint,ch_ChooseTimeInd,LFlatWin,ch_CalcFlaMat,ch_UseAWE);

[AEMFilePathMat]=CalcAutoEditMat(EGISFileMat,[],0,[],1,1,41,1,10,0,0);

%======Such nach schlechten Kanaelen ==================================
%FindBadChan(AEMFilePathMat,AWELimesFac,BatchStatus);
FindBadChan(AEMFilePathMat,3,1);

%======Such nach schlechten trials ==================================
% [AWEFileMat]=FindBadChanTrial(FilePathMat,AWELimesFac,BatchStatus);
FindBadChanTrial(AEMFilePathMat,2.5,1);
 
%===============CalcAutoEditMat mit avg ref EEG und mit flat====================================
%[AEMFilePathMat]=CalcAutoEditMat(FileMat,TimeStatusVec,ch_CalcAvgRef,ch_UseSpecChan,...
%ch_CalcBaseline,BaseStartPoint,BaseEndPoint,ch_ChooseTimeInd,LFlatWin,ch_CalcFlaMat,ch_UseAWE);

[AEMFilePathMat]=CalcAutoEditMat(EGISFileMat,[],1,1,1,1,41,0,8,1,1);

return;