function BatchFastWordDaniela(ExportDisk,SubjIn,CorrECGFlag,FilterFlag,OverwriteStatus)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
global MsiFilePath
if nargin<5; OverwriteStatus=[]; end
if nargin<4; FilterFlag=[]; end
if nargin<3; CorrECGFlag=[]; end
if nargin<2; SubjIn=[]; end
if nargin<1; ExportDisk=[]; end
if isempty(ExportDisk); ExportDisk=1; end
if isempty(CorrECGFlag); CorrECGFlag=1; end
if isempty(FilterFlag); FilterFlag=1; end
if isempty(OverwriteStatus); OverwriteStatus=0; end
%==================================================================
%==================================================================
%
%	BatchFastWord.m
%
%	Markus Junghoefer	[2001]
%
%
%	Function definition
%	
%
%
%
%
%=================================================================
%==================================================================
UnixStr=['lspdf -posted'];
[LsPdfStatus,LsPdfResult]=unix(UnixStr)
Tmp=findstr(LsPdfResult,'"');
if length(Tmp)>4
    LengthTmp=length(Tmp)
    LsPdfResult=LsPdfResult
end
HostName=lower([LsPdfResult(Tmp(3)+1:Tmp(4)-1)]);
fprintf(1,['Data on host: ',HostName,'\n']);
HardDiskName=[LsPdfResult(Tmp(1)+1:Tmp(2)-1)];
fprintf(1,['Data on hard disk: ',HardDiskName,'\n']);
UnixStr=['get_pdfs -u -x'];
[GetPdfStatus,GetPdfResult]=unix(UnixStr);
TmpP=findstr(GetPdfResult,'-P');
TmpS=findstr(GetPdfResult,'-S');
Tmps=findstr(GetPdfResult,'-s');
Tmpr=findstr(GetPdfResult,'-r')
Tmpp=findstr(GetPdfResult,'-p');
NMsiFiles=length(TmpP);
GetPdfResult
DeleteOrigFileStatus=0
DeleteNoiseFileStatus=0

for FileInd=1:NMsiFiles
    MsiPatient=[GetPdfResult(TmpP(FileInd)+3:TmpS(FileInd)-2)];
    if ~isempty(findstr(MsiPatient,'AWFW'))
        if strcmp(MsiPatient(5),'K')
            PatStatus=0;
            if ~isempty(SubjIn)
                SubjStr=int2str(SubjIn);
                if SubjIn<10
                    SubjStr=['0',SubjStr];
                end
            else    
                SubjStr=MsiPatient(6:7);
            end
            GroupStr=[]
        else
            PatStatus=1;  
            if ~isempty(SubjIn)
                SubjStr=int2str(SubjIn);
                if SubjIn<10
                    SubjStr=['0',SubjStr];
                end
            else    
                SubjStr=MsiPatient(7:8);
            end 
            if length(MsiPatient)>8
                if strcmp(MsiPatient(9),'p')
                    SubjStr=[SubjStr,'.pos'];
                elseif strcmp(MsiPatient(9),'f')
                    SubjStr=[SubjStr,'.fol'];
                else              
                    error(['Unknown MsiPatient extension: ',MsiPatient(9),'; Known: p'])
                end
            else
                SubjStr=[SubjStr,'.pra'];
            end
            GroupStr=MsiPatient(5:6)
        end
    else
        error(['Unknown MsiPatient: ',MsiPatient,'; Known: AWFW']) 
    end 
    
    Subj=str2num(SubjStr)
    fprintf(1,'\n')
    fprintf(1,['\n MsiPatient = ',MsiPatient]);
    fprintf(1,['\n Patient Status = ',int2str(PatStatus)]);
    MsiScan=[GetPdfResult(TmpS(FileInd)+3:Tmps(FileInd)-2)];
    MsiSession=[GetPdfResult(Tmps(FileInd)+3:Tmpr(FileInd)-2)];
    MsiSessionTmp=[MsiSession(2:9),'@',MsiSession(11:15)];
    MsiRun=[GetPdfResult(Tmpr(FileInd)+3:Tmpp(FileInd)-2)];
    if FileInd<NMsiFiles
        MsiFile=deblank([GetPdfResult(Tmpp(FileInd)+3:TmpP(FileInd+1)-2)]);
    else
        MsiFile=deblank([GetPdfResult(Tmpp(FileInd)+3:length(GetPdfResult)-2)]);
    end
    if ~isempty(findstr(MsiScan,'DaniFastW'))
        Scan=1; 
        PreTrigInt=99;  
        PostTrigInt=300;     
        NDefTrials=288 
    else
        error(['Unknown scan: ',MsiScan,'; Known: DaniFastW'])
    end
    Scan=Scan
    %===========Session===============
    MsiSession=MsiSession
    Session=1
    %===========Run===============
    Run=str2num(MsiRun)
    MsiPath=['/export/',HostName,filesep,HardDiskName,'/msi_data'];
    MsiPath=[MsiPath,filesep,MsiPatient,filesep,MsiScan,filesep,MsiSessionTmp,filesep,MsiRun];
    MsiFilePath=[MsiPath,filesep,MsiFile]
    NoiseFlag=1;
    if ~isempty(findstr(MsiFile,',n'))
        fprintf(1,'\n\n')
        fprintf(1,['MsiFile is already noise reduced: Disable noise reducer; NoiseFlag=0']); 
        NoiseFlag=0;
    end 
    if ~isempty(findstr(MsiFile,',f'))
        fprintf(1,'\n\n')
        fprintf(1,['MsiFile is already filtered: Disable filterer; FilterFlag=0']); 
        FilterFlag=0;
    end
    fprintf(1,'\n\n')
    fprintf(1,['MsiFilePath: ',MsiFilePath]);
    if ~isempty(findstr(MsiPatient,'AWFW'))
        if PatStatus
            FPDirStr='FWP'
        else
            FPDirStr='FWN'
        end
    else
        error(['Unknown MsiPatient'])
    end   
    MsiPathTmp=['/export/clyde/data',int2str(ExportDisk),'/txt_data/',FPDirStr]  
    SubDir=[FPDirStr,GroupStr,SubjStr];
    [MkDirStatus,MkDirMessage]=mkdir(MsiPathTmp,SubDir);
    MsiPathTmp=[MsiPathTmp,filesep,SubDir];
    fprintf(1,'\n\n');
    fprintf(1,MkDirMessage);
    SubDir=['Run',int2str(Run)];
    [MkDirStatus,MkDirMessage]=mkdir(MsiPathTmp,SubDir);
    MsiPathTmp=[MsiPathTmp,filesep,SubDir];
    fprintf(1,'\n\n');
    fprintf(1,MkDirMessage);
    
    MsiFileTmp=[FPDirStr,GroupStr,SubjStr,'.',int2str(Run)] ;
    MsiFilePathTmp=[MsiPathTmp,filesep,MsiFileTmp];
    
    %============NoiseReducer==================
    if NoiseFlag
        fprintf('\n\n');
        fprintf(1,'Reduce noise of file:\n');
        fprintf(1,MsiFilePath);
        fprintf('\n');
        fprintf(1,'Write noise reduced data to file:\n');
        fprintf(1,[MsiFilePath,',n']);
        fprintf('\n');
        
        if ~exist([MsiFilePath,',n'])
            UnixStr=['noisereducer -P ',MsiPatient,' -S ',MsiScan,' -s ',MsiSession,' -r ',MsiRun,' -p ',MsiFile,' -R MxaA,MyaA,MzaA,GxxA,GyyA,GzxA,GzyA -g -v']
            [UnixStatus,UnixResult]=unix(UnixStr);
            display(UnixResult)
        else
            fprintf(1,'\n\n')
            fprintf(1,'Do not do noisereducer since noise reduced file:\n')
            fprintf(1,[MsiFilePath,',n']); fprintf(1,'\n')
            fprintf(1,'already exists.')
        end
        if exist([MsiFilePath,',n'])  & DeleteOrigFileStatus          
            UnixStr=['pdf_deleter -P ',MsiPatient,' -S ',MsiScan,' -s ',MsiSession,' -r ',MsiRun,' -p ',MsiFile]
            [UnixStatus,UnixResult]=unix(UnixStr);
            display(UnixResult)
        end
        MsiFile=[MsiFile,',n'];
        MsiFilePath=[MsiFilePath,',n'];
    end
    %============ECG Correction==================
    CoreStatus=0; 
    if CorrECGFlag
        %============Invert ECG sensor==================if using noisereducer
        %fprintf('\n\n');
        %fprintf(1,'Invert ECG sensor E31:\n');
        %fprintf(1,MsiFilePath);
        %fprintf('\n');
        %fprintf(1,'Write inverted data to file:\n');
        %fprintf(1,[MsiFilePath,',i']);
        %fprintf('\n');
        %if ~exist([MsiFilePath,',i'])
        %    UnixStr=['inverter -P ',MsiPatient,' -S ',MsiScan,' -s ',MsiSession,' -r ',MsiRun,' -p ',MsiFile,' -Tc E31']
        %    [UnixStatus,UnixResult]=unix(UnixStr);
        %   display(UnixResult)
        %else
        %    fprintf(1,'\n\n')
        %    fprintf(1,'Do not do ECG inversion since inverted file:\n')
        %   fprintf(1,[MsiFilePath,',i']); fprintf(1,'\n')
        %    fprintf(1,'already exists.')
        %end
        %if exist([MsiFilePath,',i'])  & DeleteOrigFileStatus          
        %   UnixStr=['pdf_deleter -P ',MsiPatient,' -S ',MsiScan,' -s ',MsiSession,' -r ',MsiRun,' -p ',MsiFile]
        %   [UnixStatus,UnixResult]=unix(UnixStr);
        %    display(UnixResult)
        %end
        %MsiFile=[MsiFile,',i'];
        %MsiFilePath=[MsiFilePath,',i']; 
        %============ECG Correction==================
        fprintf('\n\n');
        fprintf(1,'ECG correction of file:\n');
        fprintf(1,MsiFilePath);
        fprintf('\n');
        fprintf(1,'Write corrected data to file:\n');
        %fprintf(1,[MsiFilePath,',nsE31']);if using noisereducer
        fprintf(1,[MsiFilePath,',c']);
        fprintf('\n');
        if ~exist([MsiFilePath,',c'])
            %UnixStr=['noisereducer -P ',MsiPatient,' -S ',MsiScan,' -s ',MsiSession,' -r ',MsiRun,' -p ',MsiFile,' -t E31,350uV,0.1,0.3,"minima"']
            UnixStr=['cardiac_remover -P ',MsiPatient,' -S ',MsiScan,' -s ',MsiSession,' -r ',MsiRun,' -p ',MsiFile,' -C E31 -N 10 -H 0.8 -W 0.7 -w 0.2']
            [UnixStatus,UnixResult]=unix(UnixStr);
            display(UnixResult)
            ECGFilePath=[MsiPathTmp,filesep,MsiFileTmp,'.ecg.txt']
            ECGFid=fopen(ECGFilePath,'w','b');
            fprintf(ECGFid,UnixResult);
            fclose(ECGFid);
            if ~isempty(findstr(UnixStr,'core dumped'))
                CoreStatus=1; 
                fprintf(1,'\n\n')
                fprintf(1,'Core dumped in ECG correction !!!!\n')
                fprintf(1,'Continue with noise corrected file.')
                Message=char('Warning:,');
                Message=char(Message,'');
                Message=char(Message,'Core dumped in ECG correction of file:');
                Message=char(Message,'');
                Message=char(Message,[MsiFilePath]);
                Message=char(Message,'');
                Message=char(Message,'Continue without ECG correction.');
                hmsgbox=msgbox(Message,'Info','warn'); 
            else
                [PeakVec,DiffVec]=AnaEcg(ECGFilePath);
                ECGFilePath=[MsiPathTmp,filesep,MsiFileTmp,'.ecg'];
                SaveAscii(PeakVec',ECGFilePath); 
            end
        else
            fprintf(1,'\n\n')
            fprintf(1,'Do not do ECG correction since corrected file:\n')
            fprintf(1,[MsiFilePath,',c']); fprintf(1,'\n')
            fprintf(1,'already exists.')
        end
        if exist([MsiFilePath,',c'])  & DeleteOrigFileStatus          
            UnixStr=['pdf_deleter -P ',MsiPatient,' -S ',MsiScan,' -s ',MsiSession,' -r ',MsiRun,' -p ',MsiFile]
            [UnixStatus,UnixResult]=unix(UnixStr);
            display(UnixResult)
        end
        if ~CoreStatus
            MsiFile=[MsiFile,',c'];
            MsiFilePath=[MsiFilePath,',c']; 
        end
    end
    %============Filterer fbp1.5-50Hz,o==================
    if FilterFlag
        FilterStr1='bp1.5-50Hz';
        FilterExt1=[',f',FilterStr1,',o'];
        
        fprintf(1,'\n\n')
        fprintf(1,'Filter file:\n');
        fprintf(1,MsiFilePath);
        fprintf('\n');
        fprintf(1,['using filter: ',FilterStr1,'\n']);
        fprintf(1,'Write filtered data to file:\n');
        fprintf(1,[MsiFilePath,FilterExt1]);
        fprintf('\n');
        
        if ~exist([MsiFilePath,FilterExt1])
            UnixStr=['flt_help -P ',MsiPatient,' -S ',MsiScan,' -s ',MsiSession,' -r ',MsiRun,' -p ',MsiFile,' -f ',FilterStr1];
            [UnixStatus,UnixResult]=unix(UnixStr);
            fprintf(1,'\n\n')
            fprintf(1,UnixResult)
        else
            fprintf(1,'\n\n')
            fprintf(1,'Do not do filterer since filtered file:\n')
            fprintf(1,[MsiFilePath,FilterExt1]); fprintf(1,'\n')
            fprintf(1,'already exists.')
        end       
        if exist([MsiFilePath,FilterExt1]) & DeleteNoiseFileStatus          
            UnixStr=['pdf_deleter -P ',MsiPatient,' -S ',MsiScan,' -s ',MsiSession,' -r ',MsiRun,' -p ',MsiFile']
        end  
        %============Filterer bp1-20Hz-678-2==================
        FilterStatus=0
        if FilterStatus
            FilterStr2='bp1-20Hz-678-2';
            FilterExt2=[',f',FilterStr2,',o'];
            fprintf(1,'\n\n')
            fprintf(1,'Filter file:\n');
            fprintf(1,MsiFilePath);
            fprintf('\n');
            fprintf(1,['using filter: ',FilterStr2,'\n']);
            fprintf(1,'Write filtered data to file:\n');
            fprintf(1,[MsiFilePath,FilterExt2]);
            fprintf('\n');
            if ~exist([MsiFilePath,FilterExt2])
                UnixStr=['flt_help -P ',MsiPatient,' -S ',MsiScan,' -s ',MsiSession,' -r ',MsiRun,' -p ',MsiFile,' -f ',FilterStr2];
                [UnixStatus,UnixResult]=unix(UnixStr);
                fprintf(1,'\n\n')
                fprintf(1,UnixResult)
            else
                fprintf(1,'\n\n')
                fprintf(1,'Do not do filterer since filtered file:\n')
                fprintf(1,[MsiFilePath,FilterExt2]); fprintf(1,'\n')
                fprintf(1,'already exists.')
            end  
        end        
        MsiFile=[MsiFile,FilterExt1];
        MsiFilePath=[MsiPath,filesep,MsiFile];
    end
    %========================================
    %============create_set==================
    MsiFilePathTmp=[MsiPathTmp,filesep,MsiFileTmp];
    fprintf(1,'\n\n')
    fprintf(1,'Create set of file %g:\n',FileInd)
    fprintf(1,'%s\n',MsiFile);
    fprintf(1,'and write set to file:\n')
    fprintf(1,'%s\n',[MsiFilePathTmp,'.set'])
    UnixStr=['create_set -P ',MsiPatient,' -S ',MsiScan,' -s ',MsiSession,' -r ',MsiRun,' -p ',MsiFile,' > ',MsiFilePathTmp,'.set'];
    [UnixStatus,UnixResult]=unix(UnixStr);
    fprintf(1,'\n\n')
    fprintf(1,UnixResult)
    %==============exp2besa==================
    fprintf(1,'\n\n')
    fprintf(1,'Exp2BesaAsc of file %g:\n')
    fprintf(1,'%s\n',MsiFile);
    fprintf(1,'BaseFilePath:\n')
    fprintf(1,'%s\n',MsiFilePathTmp);
    UnixStr=['exp2BESAasc -n -P ',MsiPatient,' -S ',MsiScan,' -s ',MsiSession,' -r ',MsiRun,' -p ',MsiFile,' ',MsiFilePathTmp];
    [UnixStatus,UnixResult]=unix(UnixStr);
    fprintf(1,'\n\n')
    fprintf(1,UnixResult) 
    %==============TransMsiContSess=============
    fprintf(1,'\n\n')
    fprintf(1,'TransMsiContSessFastWordTrig of file %g:\n')
    fprintf(1,'%s\n',MsiFilePath);
    fprintf(1,'Write files to base:\n')
    fprintf(1,'%s\n',[MsiFilePathTmp]);
    
    [NonUse,NonUse,SesFilePath]=TransMsiContSessFastWordDaniela(MsiFilePath,MsiFilePathTmp,PreTrigInt,PostTrigInt,1,[],[],NDefTrials,Session);
    CalcAutoEditMEGMat(SesFilePath,[],1,1,100);
    
end
