function [OutFileMat]=CalcAppCorr(AppFileMat)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%==================================================================
%
%	CalcAppCorr.m
%
%	Markus Junghoefer	[1999]
%
%
%	Function definition
%	
%	[OutFileMat]=CalcAppCorr(AppFileMat)
%
%
%
%=================================================================
global AppFileMat CorrMat1 CorrVec1 CorrMat2 CorrVec2 IndVec1 IndVec2 AroVec
if nargin<1; AppFileMat=[]; end
DefFilePath=SetDefPath(1,'*.app*');
[NFiles,AppFileMat]=ReadFileNames(AppFileMat,DefFilePath,'Choose app. files or batch file:');
AroVec=ReadData([],1,[],'ascii','ascii');
AroVec2=AroVec([2:2:704]);
if NFiles==0; return; end
for FileInd=1:NFiles
	
	[AppFile,AppPath,AppFilePath]=GetFileNameOfMat(AppFileMat,FileInd);
	DefFilePath=SetDefPath(2,AppFilePath);
	AvgFilePath=[AppFilePath(1:length(AppFilePath)-4),'at',AppFilePath(length(AppFilePath)),'.ar']
	IndFilePath=[AppFilePath(1:length(AppFilePath)-4),'i',AppFilePath(length(AppFilePath)),'.c'];
	[AvgMat,File,Path,FilePath,NTrialAvgVec,StdChanTimeMat,SampRate,AvgRef,Version,MedMedRawVec,MedMedAvgVec]=ReadAvgFile(AvgFilePath);
	[NChan,NPoints]=size(AvgMat);
	[AvgMat]=CalcBaseline(AvgMat,1,NPoints,1);
	[AppMat,Version,LHeader,ScaleBins,NChan,NPoints,NTrials,SampRate,chAvgRef]=ReadAppData(AppFilePath,0);
	IndVec=ReadData(IndFilePath,1,[],'ascii','ascii');
	eval(['IndVec',int2str(FileInd),'=IndVec;'])
	CorrMat=zeros(NChan,NTrials.*2);
 	for TrialInd=1:NTrials
		fprintf('%g of %g trials done !\n',TrialInd,NTrials)
		[AppMat,Version,LHeader,ScaleBins,NChan,NPoints,NTrials,SampRate,chAvgRef]=ReadAppData(AppFilePath,TrialInd);
		[AppMat]=CalcBaseline(AppMat,1,NPoints,1);
		for ChanInd=1:NChan
			a=corrcoef(AppMat(ChanInd,1:NPoints./2-1),AvgMat(ChanInd,1:NPoints./2-1));
			CorrMat(ChanInd,TrialInd.*2-1)=a(2,1);
		end	
		for ChanInd=1:NChan
			a=corrcoef(AppMat(ChanInd,NPoints./2:NPoints),AvgMat(ChanInd,NPoints./2:NPoints));
			CorrMat(ChanInd,TrialInd.*2)=a(2,1);
		end	
		eval(['CorrMat',int2str(FileInd),'=CorrMat;'])
	end
end
CorrVec1=sum(CorrMat1);
CorrVec2=sum(CorrMat2);

HighAroIndVec=find(AroVec2>6.5);
Index=0;
HighAroTrialVec=[];
for i=1:350
	a=find(HighAroIndVec==IndVec2(i));
	if ~isempty(a)
		HighAroTrialVec(i)=5;
	else
		HighAroTrialVec(i)=0;
	end
end

Index=0;IdentIndVec1=[]; IdentIndVec2=[]; a=[], b=[];
for i=1:352
	a=find(IndVec1==i);
	b=find(IndVec2==i);
	if ~isempty(a) & ~isempty(b)
		Index=Index+1;
		AroIndVec(Index.*2-1)=i.*2-1;
		AroIndVec(Index.*2)=i.*2;
		IdentIndVec1(Index.*2-1)=a.*2-1;
		IdentIndVec2(Index.*2-1)=b.*2-1;
		IdentIndVec1(Index.*2)=a.*2;
		IdentIndVec2(Index.*2)=b.*2;
	end
end
% PicIndVec=IndVec.*2;
% NCorrVec1=norm_1(CorrVec1(1:100),1);
% NCorrVec2=norm_1(CorrVec2(1:100),1);
% NAroVec=norm_1(AroVec(PicIndVec(1:100))',1);

CorrMat=zeros(Index.*2,3);
CorrMat(:,1)=CorrVec1(IdentIndVec1)';
CorrMat(:,2)=CorrVec2(IdentIndVec2)';
CorrMat(:,3)=AroVec(AroIndVec);

a=corrcoef(CorrMat)

Tmp=xcorr(CorrVec1(IdentIndVec1),CorrVec2(IdentIndVec2));
plot(Tmp)
plot(IndVec1(1:100),CorrVec1(1:100))
hold on
plot(IndVec2(1:100),CorrVec2(1:100),'r')
plot(IndVec(1:100),AroVec(PicIndVec(1:100)).*5000,'g')

return;

