%==================================================================
%
%	CalcFrequWin.m
%
%
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%	Markus Junghoefer	[1996]
%
%
%
%	Function definition

	function [DataMat,ch_UseTimeWin,ch_KindTimeWin,RInt] = CalcFrequWin(DataMat,ch_UseTimeWin,ch_KindTimeWin,RInt,PlotWinVecStatus)

%=================================================================
if nargin<5; PlotWinVecStatus=[]; end
if nargin<4; RInt=[]; end
if nargin<3; ch_KindTimeWin=[]; end
if nargin<2; ch_UseTimeWin=[]; end
if nargin<1; DataMat=sin(linspace(0,2*pi*10,100)); ch_UseFrequWin=1; end
[ch_UseTimeWin]=IfEmptyInputBo(['Do you want to use data windows (Hanning etc.) ? Y/N'],[],ch_UseTimeWin,1,1);
if ~ch_UseTimeWin; return; end

[NChan,NPoints]=size(DataMat);
[RInt]=IfEmptyInputValInt(['Please insert the length'],['of rising and falling intervall:'],RInt,floor(NPoints./4),2,floor(NPoints./2));
if RInt<1 & RInt>NChan./2
	fprintf('Bad RInt value in CalcHanHamWin => set RInt to []');
	RInt=[];
end

[ch_KindTimeWin]=IfEmptyInputSpecVal(ch_KindTimeWin,[1 2 3 4 5 6],4,...
			['Which window do you want to use:\n\n'],...
			['Bartlet:                     [1]'],...
			['Blackman:                    [2]'],...
			['Boxcar:                      [3]'],...
			['Hanning:                     [4]'],...
			['Hamming:                     [5]'],...
			['Kaiser:                      [6]']);


if ch_KindTimeWin==1;
	w=bartlet(RInt.*2);
	WinTitleString=['Bartlet'];
elseif ch_KindTimeWin==2;
	w=blackman(RInt.*2);
	WinTitleString=['Blackman'];
elseif ch_KindTimeWin==3;
	w=boxcar(RInt.*2);
	WinTitleString=['Boxcar'];
elseif ch_KindTimeWin==4;
	w=hanning(RInt.*2);
	WinTitleString=['Hanning'];
elseif ch_KindTimeWin==5;
	w=hamming(RInt.*2);
	WinTitleString=['Hamming'];
elseif ch_KindTimeWin==6;
	w=kaiser(RInt.*2);
	WinTitleString=['Kaiser'];
end

WinVec=ones(NPoints,1);
WinVec(1:RInt)=w(1:RInt);
WinVec(NPoints-RInt+1:NPoints)=w(RInt+1:RInt.*2);

[PlotWinVecStatus]=IfEmptyInputBo(['Do you want to'],['plot the time window ?'],PlotWinVecStatus,0);
if PlotWinVecStatus; 
	plot([1:NPoints],WinVec); 
	axis([1 NPoints min(WinVec) 11.*max(WinVec)./10]);
	TitleString=['Time window using ' WinTitleString ' and falling / rising of ' int2str(RInt) ' points !'];
	title(TitleString);
	pause
end
for i=1:NChan	
	DataMat(i,:)=DataMat(i,:).*WinVec';
end
return;
			
