function GenSinWavFile(Fs,Duration,Frequ,FlaPoints,WaveFile)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%==================================================================
%
%	GenSinWavFile.m
%	
%=================================================================
if nargin<5; WaveFile=[]; end
if nargin<4; FlaPoints=[]; end
if nargin<3; Frequ=[]; end
if nargin<2; Duration=[]; end
if nargin<1; Fs=[]; end


if isempty(Fs); Fs=44100; end
if isempty(Duration); Duration=1; end
if isempty(Frequ); Frequ=1000; end
if isempty(WaveFile); WaveFile=[int2str(Fs),'_',int2str(Duration),'_',int2str(Frequ),'.wav']; end
WaveFile=WaveFile
NPoints=floor(Fs.*Duration);
if isempty(FlaPoints); FlaPoints=floor(NPoints/10); end

LR=zeros(NPoints,2);
LR(:,1)=sin(linspace(0,Frequ.*2.*pi,NPoints))';
LR(:,2)=sin(linspace(0,Frequ.*2.*pi,NPoints))';

w=hanning(FlaPoints.*2);

WinVec=ones(NPoints,1);
WinVec(1:FlaPoints)=w(1:FlaPoints);
WinVec(NPoints-FlaPoints+1:NPoints)=w(FlaPoints+1:FlaPoints.*2);
LR(:,1)=LR(:,1).*WinVec;
LR(:,2)=LR(:,2).*WinVec;
subplot(2,1,1)
plot(LR(1:FlaPoints,:));
subplot(2,1,2)
plot(LR(NPoints-FlaPoints:NPoints,:));
nbits=16;
wavwrite(LR,Fs,nbits,WaveFile);
return;
