function RatMat=GetIAPSRatings(Vec)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
if nargin<1; Vec=[]; end
if isempty(Vec)
	Vec=ReadAscii('Paul:Data:EEG:ET:R1:ET00R1.IAPS.txt')
end
NRat=length(Vec);
RatMat=zeros(NRat,3);
RatMat(:,1)=Vec;
FilePath='Paul:Matlab:Geo:IAPSRatings.txt';
IAPS=ReadAscii('Paul:Matlab:Geo:IAPSRatings.txt')';
PicNoVec=IAPS(:,1);
for i=1:NRat
	PicInd=find(PicNoVec==Vec(i));
	if isempty(PicInd)
		fprintf(1,'No IAPS picture number %g in file:\n',Vec(i))
		disp(FilePath)
		fprintf(1,'\n\n')
	else
		RatMat(i,2:3)=IAPS(PicInd(1),2:3);
	end
end

