function[]=IAPSMovie(action);
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
global ValAroVec PicVec PicIndVec PicSortIndVec AroVec ParaMat

ValAroVec=[]
 PicVec=[]
 PicIndVec=[]
 PicSortIndVec=[]
%==================================================================
%
%	IAPSMovie.m
%
%	Markus Junghoefer	[1998]
%
%
%	Function definition

%

%==================================================================
%==================================================================
if nargin<1; action='InitializeMenu'; end

%================= global variables =============================================
global hMenuFig  PicSortIndVec PicVec


if strcmp(action,'InitializeMenu'),

	%============================================================================
	%=========== INITIALIZE MENU ================================================
	%============================================================================
			
	%============== figure with graphs =========================		
   	if strcmp(computer,'MAC2')	
        	PicFigPosVec=[0 .3 .8 .73];  
        	PicAxesPosVec=[0 0 1 1];  
         	FuncFigPosVec=[0 0 .8 .2];
         	FuncAxesPosVec=[.05 .15 .9 .75];
      		MenuFigPosVec=[.8 0 .2 1];
   	elseif strcmp(computer,'PCWIN') 
         	PicFigPosVec=[0.005 .3 .80 .65];  
         	PicAxesPosVec=[0 0 1 1];  
         	FuncFigPosVec=[0.005 .05 .8 .17];
         	FuncAxesPosVec=[.05 .15 .9 .75];
      		MenuFigPosVec=[0.81 .05 .2 .9];
	 elseif strcmp(computer,'SOL2')
         	PicFigPosVec=[0.01 .01 .601 .935]; 
         	PicAxesPosVec=[0 0 1 1];  
         	FuncFigPosVec=[0 0 .6 1];	
         	FuncAxesPosVec=[.05 .15 .9 .75];
      		MenuFigPosVec=[0.6224 .01 .2 .91];
	end;
      
   	%============== figure with menu ===========================		
   	PicFigString=['IAPS movie pictures:'];
  	hPicFig=figure('Units','normal','Position',PicFigPosVec, ...
        'Name',PicFigString,'Color',[0 0 0], ...
        'NumberTitle','off');
   	hPicAxes=axes('Units','Normal','Position',PicAxesPosVec);
   	axis('off')
   
	FuncFigString=['IAPS movie function:'];
  	hFuncFig=figure('Units','normal','Position',FuncFigPosVec, ...
        'Name',FuncFigString,'Color',[.99 .99 .99], ...
        'NumberTitle','off');
  	hFuncAxes=axes('Units','Normal','Position',FuncAxesPosVec);
	axis('off')

   	MenuFigString=['IAPS movie Menu:'];
  	hMenuFig=figure('Units','normal','Position',MenuFigPosVec, ...
        'Name',MenuFigString,'Color',[.99 .99 .99], ...
        'NumberTitle','off');
    
	
    	% Information for all buttons (and menus)
    	labelColor=[0 0 0];
    	yInitPos=0.90;
    	menutop=0.955;
	btnTop = 0.6;
	top=0.75;
	left=0.125;
	btnWid=0.8;
	btnHt=0.04;
	btnHt_edit=0.050;
	textHeight = 0.05;			% not used !!!!!!!!!!!
	textWidth = 0.06;
	% Spacing between the button and the next command's label
	spacing=0.015;

	%====================================
	% The CONSOLE frame
	
	frmBorder=0.05; 
	frmLeft=left-frmBorder;
	frmBottom=0.010; 
    	frmHeight = 1-3.*frmBottom; 
	frmWidth = btnWid+2*frmBorder;
    	yPos=frmBottom-frmBorder;
    	frmPos=[frmLeft frmBottom frmWidth frmHeight];
	ConsoleRGBColor=[.2 .4 .6];
    	hConsolFrame=uicontrol( ...
        'Style','frame', ...
        'Units','normalized', ...
        'Position',frmPos, ...
	'BackgroundColor',ConsoleRGBColor);
		
	
 	%==============================================================
    	% SetGender===================================================
	%==============================================================
	
	btnNumber=1;     
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos=[left yPos-btnHt btnWid./2 btnHt];
	labelStr='All|Female|Male';
	callbackStr='IAPSMovie(''SetGender'')';

	hSetGenderMenu=uicontrol( ...
        'Style','popupmenu', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String',labelStr, ...
        'Interruptible','on', ...
	'Value',3,...
        'Callback',callbackStr,...
	'Enable','on');
	
	%==============================================================
    	% ReadData
	%==============================================================
	
    	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left+btnWid./2 yPos-btnHt btnWid./2 btnHt];
	callbackStr = 'IAPSMovie(''ReadData'')';
	hReadValenceMenu=uicontrol( ...
        'Style','pushbutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String','Read Data', ...
	'Userdata','0', ...
        'Callback',callbackStr,...
	'ForegroundColor',[0 0 0.3],...
	'Enable','on');
	
	%==============================================================
   	% ReadImage
	%==============================================================
	btnNumber=2;
    	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left yPos-btnHt btnWid./2 btnHt];
	callbackStr = 'IAPSMovie(''ReadImage'')';
	hReadImageMenu=uicontrol( ...
        'Style','pushbutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String','Read Image', ...
		'Userdata','0', ...
        'Callback',callbackStr,...
		'ForegroundColor',[0 0 0.3],...
		'Enable','on');
	
	%==============================================================
    % ReadImagePath
	%==============================================================
    yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    btnPos=[left+btnWid./2 yPos-btnHt btnWid./2 btnHt];
	callbackStr = 'IAPSMovie(''ReadImagePath'')';
	hReadImagePathMenu=uicontrol( ...
        'Style','pushbutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String','Read Image Path', ...
		'Userdata','0', ...
        'Callback',callbackStr,...
		'ForegroundColor',[0 0 0.3],...
		'Enable','on');

   	%============================================================
   	% EasyMovie
	%==============================================================
	btnNumber=3;
   	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left yPos-btnHt btnWid./2 btnHt];
	callbackStr = 'IAPSMovie(''EasyMovie'')';
	hEasyMovieMenu=uicontrol( ...
        'Style','pushbutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String','Easy Movie', ...
		'Userdata','0', ...
        'Callback',callbackStr,...
		'ForegroundColor',[0 0 0.3],...
		'Enable','on');

   	%==============================================================
   	% MovieFunction================================================
	%==============================================================
	
	btnNumber=3;     
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos=[left+btnWid./2 yPos-btnHt btnWid./2 btnHt];
	labelStr='Linear|Sinus|Cosinus|Rectangular';
	callbackStr='IAPSMovie(''SetMovieFunction'')';

	hMovieFunction=uicontrol( ...
        'Style','popupmenu', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String',labelStr, ...
        'Interruptible','on', ...
	'Value',4,...
        'Callback',callbackStr,...
	'Enable','on');
	
	%==============================================================
    	% SetNCycle
	%==============================================================
	btnNumber=4;
	
	% SetNCycleText
    	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos=[left yPos-btnHt_edit./2 2.*btnWid./3 btnHt_edit./2];    
	hSetNCycleText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','Number of Cycles:');
	
	btnPos=[left+2.*btnWid./3 yPos-btnHt_edit./2 btnWid./3 btnHt_edit./2];
	callbackStr = 'IAPSMovie(''SetNCycle'')';
    
	hSetNCycle = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','12',...
	'Value',12, ...
        'callback',callbackStr);
	
	%==============================================================
    	% SetNPicPerCycle
	%==============================================================
	btnNumber=4;
	
	% SetNPicPerCycleText
    	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos=[left yPos-btnHt_edit 2.*btnWid./3 btnHt_edit./2];    
	hSetNPicPerCycleText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','Pics per Cycle:');
	
	btnPos=[left+2.*btnWid./3 yPos-btnHt_edit btnWid./3 btnHt_edit./2];
	callbackStr = 'IAPSMovie(''SetNPicPerCycle'')';
    
	hSetNPicPerCycle = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','36',...
	'Value',36, ...
        'callback',callbackStr);
	
	%==============================================================
    	% SetNBasePic
	%==============================================================
	btnNumber=5;
	% SetNBasePicText
    	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos=[left yPos-btnHt_edit./2 2.*btnWid./3 btnHt_edit./2];    
	hSetNBasePicText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','Number of Base. Pics:');
	
	btnPos=[left+2.*btnWid./3 yPos-btnHt_edit./2 btnWid./3 btnHt_edit./2];
	callbackStr = 'IAPSMovie(''SetNBasePic'')';
    
	hSetNBasePic = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','0',...
	'Value',0, ...
        'callback',callbackStr);

	%==============================================================
   	% RunMovie
	%==============================================================
	 btnNumber=11;
    	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left yPos-btnHt btnWid./2 btnHt];
	 callbackStr = 'IAPSMovie(''RunMovie'')';
	 hRunMovieMenu=uicontrol( ...
        'Style','pushbutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String','Run Movie', ...
	'Userdata','0', ...
        'Callback',callbackStr,...
	'ForegroundColor',[0 0 0.3],...
	 'Enable','on');
     
	%==============================================================
   	% RateMenu
	%==============================================================
	btnNumber=11;
    	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left+btnWid./2 yPos-btnHt btnWid./2 btnHt];
	callbackStr = 'IAPSMovie(''SetRateMenu'')';
	hSetRateMenu=uicontrol( ...
        'Style','pushbutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String','Rate Picture', ...
	'Value',0, ...
        'Callback',callbackStr,...
	'ForegroundColor',[0 0 0.3],...
	 'Enable','on');

   	%==============================================================
   	% PauseMovie
	%==============================================================
	 btnNumber=13;
    	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left yPos-btnHt btnWid./2 btnHt];
	 callbackStr = 'IAPSMovie(''PauseMovie'')';
	 hPauseMovieMenu=uicontrol( ...
        'Style','pushbutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String','Pause Movie', ...
	'Userdata','0', ...
        'Callback',callbackStr,...
	'ForegroundColor',[0 0 0.3],...
	'Enable','on');

  	%==============================================================
   	% StopMovie
	%==============================================================
	 btnNumber=13;
    	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left+btnWid./2 yPos-btnHt btnWid./2 btnHt];
	 callbackStr = 'IAPSMovie(''StopMovie'')';
	 hStopMovieMenu=uicontrol( ...
        'Style','pushbutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String','Stop Movie', ...
        'Value',0, ...
        'Callback',callbackStr,...
	'ForegroundColor',[0 0 0.3],...
	 'Enable','on');

	%==============================================================
   	% SaveMovie
	%==============================================================
	 btnNumber=12;
    	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	btnPos=[left yPos-btnHt btnWid./2 btnHt];
	 callbackStr = 'IAPSMovie(''SaveMovie'')';
	 hSaveMovieMenu=uicontrol( ...
        'Style','pushbutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String','Save Movie', ...
        'Value',0, ...
        'Callback',callbackStr,...
	'ForegroundColor',[0 0 0.3],...
	 'Enable','off');

	%==============================================================
   	% ReadMovie
	%==============================================================
	 btnNumber=12;
    	 yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	 btnPos=[left+btnWid./2 yPos-btnHt btnWid./2 btnHt];
	 callbackStr = 'IAPSMovie(''ReadMovie'')';
	 hReadMovieMenu=uicontrol( ...
        'Style','pushbutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String','Read Movie', ...
        'Value',0, ...
        'Callback',callbackStr,...
	'ForegroundColor',[0 0 0.3],...
	'Enable','on');

	%==============================================================
    	% SortByVal
	%==============================================================
	btnNumber=6;
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
   	btnPos=[left yPos-btnHt./2 3.*btnWid./5 btnHt./2];
    	callbackStr='IAPSMovie(''SortByVal'')';

	hSortByVal=uicontrol( ...
        'Style','radiobutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String','Sort by valence', ...
	'Value',0,...
        'Callback',callbackStr,...
	'Enable','on');

	%==============================================================
	% SortByAro
	%==============================================================
	btnNumber=6;
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
   	btnPos=[left+3.*btnWid./5 yPos-btnHt./2 2.*btnWid./5 btnHt./2];
	callbackStr='IAPSMovie(''SortByAro'')';

	hSortByAro=uicontrol( ...
        'Style','radiobutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String','arousal', ...
	    'Value',1,...
        'Callback',callbackStr,...
	    'Enable','on');
	
	%==============================================================
    % SortByRGBHSV
	%==============================================================
	btnNumber=6;
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
   	btnPos=[left yPos-btnHt btnWid./2 btnHt./2];
	StrMat=' ';
	StrMat=char(StrMat,'RGB Brightness');
	StrMat=char(StrMat,'RGB Contrast');
	StrMat=char(StrMat,'PFFT of RGB Brightness');
	StrMat=char(StrMat,'Hor. PFFT of RGB Brightness');
	StrMat=char(StrMat,'Vert. PFFT of RGB Brightness');
	StrMat=char(StrMat,'HSV Brightness');
	StrMat=char(StrMat,'HSV Contrast');
	StrMat=char(StrMat,'PFFT of HSV Brightness');
	StrMat=char(StrMat,'Hor. PFFT of Brightness');
	StrMat=char(StrMat,'Vert. PFFT of Brightness');
	StrMat=char(StrMat,'Red Brightness');
	StrMat=char(StrMat,'Relative Red Brightness');
	StrMat=char(StrMat,'Red Contrast');
	StrMat=char(StrMat,'Relative Red Contrast');
	StrMat=char(StrMat,'PFFT of Red Brightness');
	StrMat=char(StrMat,'Hor. PFFT of Red Brightness');
	StrMat=char(StrMat,'Vert. PFFT of Red Brightness');
	StrMat=char(StrMat,'Green Brightness');
	StrMat=char(StrMat,'Relative Green Brightness');
	StrMat=char(StrMat,'Green Contrast');
	StrMat=char(StrMat,'Relative Green Contrast');
	StrMat=char(StrMat,'PFFT of Green Brightness');
	StrMat=char(StrMat,'Hor. PFFT of Green Brightness');
	StrMat=char(StrMat,'Vert. PFFT of Green Brightness');
	StrMat=char(StrMat,'Blue Brightness');
	StrMat=char(StrMat,'Relative Blue Brightness');
	StrMat=char(StrMat,'Blue Contrast');
	StrMat=char(StrMat,'Relative Blue Contrast');
	StrMat=char(StrMat,'PFFT of Blue Brightness');
	StrMat=char(StrMat,'Hor. PFFT of Blue Brightness');
	StrMat=char(StrMat,'Vert. PFFT of Blue Brightness');
	StrMat=char(StrMat,'Hue');
	StrMat=char(StrMat,'Relative Hue');
	StrMat=char(StrMat,'Hue Contrast');
	StrMat=char(StrMat,'Relative Hue Contrast');
	StrMat=char(StrMat,'PFFT of Hue');
	StrMat=char(StrMat,'Hor. PFFT of Hue');
	StrMat=char(StrMat,'Vert. PFFT of Hue');
	StrMat=char(StrMat,'Saturation');
	StrMat=char(StrMat,'Relative Saturation');
	StrMat=char(StrMat,'Saturation Contrast');
	StrMat=char(StrMat,'Relative Saturation Contrast');
	StrMat=char(StrMat,'PFFT of Saturation');
	StrMat=char(StrMat,'Hor. PFFT of Saturation');
	StrMat=char(StrMat,'Vert. PFFT of Saturation');
	StrMat=char(StrMat,'Value');
	StrMat=char(StrMat,'Relative Value');
	StrMat=char(StrMat,'Value Contrast');
	StrMat=char(StrMat,'Relative Value Contrast');
	StrMat=char(StrMat,'PFFT of Value');
	StrMat=char(StrMat,'Hor. PFFT of Value');
	StrMat=char(StrMat,'Vert. PFFT of Value');
	[NStrMat,MStrMat]=size(StrMat);
	labelStr='No RGB|';
	for i=2:NStrMat
		labelStr=[labelStr,' ',int2str(i),': ',deblank(StrMat(i,:)),'|'];
	end
    	callbackStr='IAPSMovie(''SortByRGBHSV'')';

	hSortByRGBHSV=uicontrol( ...
        'Style','popupmenu', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String',labelStr, ...
	'Value',1,...
	'UserData',StrMat,...
        'Callback',callbackStr,...
	'Enable','on');

	%==============================================================
	% Correct ValAro
	%==============================================================

	btnNumber=6;
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
   	btnPos=[left+btnWid./2 yPos-btnHt btnWid./2 btnHt./2];
	callbackStr='IAPSMovie(''setCorrectValAro'')';

	hCorrectValAroStatus=uicontrol( ...
        'Style','radiobutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String','Cor. ValAro', ...
	'Value',1,...
        'Callback',callbackStr,...
	'Enable','on');

	%==============================================================
	% Use Color or Black and White
	%==============================================================

	btnNumber=7;
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
   	btnPos=[left yPos-btnHt./2 btnWid./2 btnHt./2];
	callbackStr='IAPSMovie(''setColorBlackWhite'')';

	hColorBlackWhite=uicontrol( ...
        'Style','radiobutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String','Color', ...
	'Value',1,...
        'Callback',callbackStr,...
	'Enable','on');

	%==============================================================
	% Use BrightStatus Control
	%==============================================================

	btnNumber=7;
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
   	btnPos=[left+btnWid./2 yPos-btnHt./2 btnWid./2 btnHt./2];
	callbackStr='IAPSMovie(''setBrightStatus'')';

	hBrightStatus=uicontrol( ...
        'Style','radiobutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String','BrightStatus', ...
	   'Value',0,...
        'Callback',callbackStr,...
	   'Enable','on');

    %==============================================================
	% Use RandPixelStatus Control
	%==============================================================
	btnNumber=7;
    yPos=menutop-(btnNumber-1)*(btnHt+spacing);
   	btnPos=[left yPos-btnHt btnWid./2 btnHt./2];
	labelStr='Rand Pix 1|Rand Pix 2|Rand Pix 4|Rand Pix 8|Rand Pix 10|Rand Pix 16|Rand Pix 20|Rand Pix 32|Rand Pix 40|Rand Pix 64|Rand Pix 80|Rand Pix 128|Rand Pix 160|Rand Pix 256';
	hRandPixel=uicontrol( ...
        'Style','popupmenu', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String',labelStr, ...
        'Interruptible','on', ...
	     'Value',1,...
		 'Userdata',[1 2 4 8 10 16 20 32 40 64 80 128 160 256],...
        'Callback',callbackStr,...
	    'Enable','on');

	%==============================================================
    	% Use RandPerm
	%==============================================================

	btnNumber=8;
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
   	btnPos=[left yPos-btnHt./2 btnWid./2 btnHt./2];
    	callbackStr='IAPSMovie(''UseRandPerm'')';

	hUseRandPerm=uicontrol( ...
        'Style','radiobutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String','Use rand. perm', ...
	'Value',1,...
        'Callback',callbackStr,...
	'Enable','on');

	%==============================================================
    	% Use Extra Rating
	%==============================================================
	btnNumber=8;
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
   	btnPos=[left+btnWid./2 yPos-btnHt./2 btnWid./2 btnHt./2];
    	callbackStr='IAPSMovie(''UseExtraRating'')';

	hUseExtraRating=uicontrol( ...
        'Style','radiobutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String','extra rating', ...
	'Value',0,...
        'Callback',callbackStr,...
	'Enable','on');

	%==============================================================
    	% Print2FileStatus
	%==============================================================

	btnNumber=8;
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
   	btnPos=[left yPos-btnHt btnWid./2 btnHt./2];
    	callbackStr='IAPSMovie(''setPrint2FileStatus'')';

	hPrint2FileStatus=uicontrol( ...
        'Style','radiobutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String','Save to file:', ...
	'Value',0,...
        'Callback',callbackStr,...
	'Enable','on');
	
	%==============================================================
	% Print2FileMethod
	%==============================================================

	btnNumber=8;
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
   	btnPos=[left+btnWid./2 yPos-btnHt btnWid./2 btnHt./2];
    	labelStr='EPS|EPS & Tiff preview|JPEG|TIFF';
    	callbackStr='Plot3d(''setPrint2FileMethod'');';
    
	hPrint2FileMethod=uicontrol( ...
        'Style','popupmenu', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String',labelStr, ...
        'Interruptible','on', ...
	'Userdata','JPEG',...
	'Value',3,...
        'Callback',callbackStr);

	%==============================================================
	% MovieDir
	%==============================================================
	btnNumber=9;
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
   	btnPos=[left yPos-btnHt btnWid./2 btnHt./2];
	callbackStr='IAPSMovie(''MovieDir'')';

	hMovieDir=uicontrol( ...
        'Style','pushbutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String','Direction: Up', ...
	'Userdata',1,...	%Do not use value
        'Callback',callbackStr,...
	'Enable','on');

	%==============================================================
	% UseMultiples
	%==============================================================
	btnNumber=9;
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
   	btnPos=[left yPos-btnHt./2 btnWid./2 btnHt./2];
	callbackStr='IAPSMovie(''UseMultiples'')';

	hUseMultiples=uicontrol( ...
        'Style','pushbutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String','No Multiples', ...
	'Userdata',0,...	%Do not use value
        'Callback',callbackStr,...
	'Enable','on');

	%==============================================================
	% hCalEyeTrack
	%==============================================================
	btnNumber=9;
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
   	btnPos=[left+btnWid./2 yPos-btnHt./2 btnWid./2 btnHt./2];
	callbackStr='IAPSMovie(''CalEyeTrack'')';

	hCalEyeTrack=uicontrol( ...
        'Style','radiobutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String','Cal. Eye Tracking', ...
        'Callback',callbackStr,...
	'Value',0,...
	'Enable','on');

	%==============================================================
	% hEyeTrack
	%==============================================================
	btnNumber=9;
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
   	btnPos=[left+btnWid./2 yPos-btnHt btnWid./2 btnHt./2];
	callbackStr='IAPSMovie(''EyeTrack'')';

	hEyeTrack=uicontrol( ...
        'Style','radiobutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String','Eye Tracking', ...
        'Callback',callbackStr,...
	'Value',0,...
	'Enable','on');

	%==============================================================
	% StartPic
	%==============================================================
	btnNumber=10;
	
	% StartPicText
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos=[left yPos-btnHt_edit./2 2.*btnWid./3 btnHt_edit./2];    
	hStartPicText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	   'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','Start at file number:');
	
	btnPos=[left+2.*btnWid./3 yPos-btnHt_edit./2 btnWid./3 btnHt_edit./2];
	callbackStr = 'IAPSMovie(''StartPic'')';
    
	hStartPic = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','1',...
	'Value',1, ...
	'Min',1,...
	'Max',10000,...
        'callback',callbackStr);
	
	% StartPicSlider
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
  	btnPos=[left yPos-btnHt_edit btnWid btnHt_edit./2];
	callbackStr='IAPSMovie(''StartPicSlider'')';

	hStartPicSlider=uicontrol( ...
        'Style','slider', ...
        'Units','normalized', ...
        'Position',btnPos, ...
	'Value',1,...
	'Min',1,...
	'Max',10000,...
	'SliderStep',[.01,.1],...
       'Callback',callbackStr,...
       'Enable','on');

	%==============================================================
   	% RandLogMovie
	%==============================================================
	 btnNumber=14;
    	 yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	 btnPos=[left yPos-btnHt./2 btnWid./2 btnHt./2];
	 callbackStr = 'IAPSMovie(''RandLogMovie'')';
	 hRandLogMovieMenu=uicontrol( ...
        'Style','pushbutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String','Rand Log Movie', ...
        'Value',0, ...
        'Callback',callbackStr,...
	'ForegroundColor',[0 0 0.3],...
	'Enable','on');

	 btnNumber=14;
    	 yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	 btnPos=[left yPos-btnHt btnWid./2 btnHt./2];
	 callbackStr = 'IAPSMovie(''RandFileMovie'')';
	 hRandFileMovieMenu=uicontrol( ...
        'Style','pushbutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String','Rand JPG Movie', ...
        'Value',0, ...
        'Callback',callbackStr,...
	'ForegroundColor',[0 0 0.3],...
	'Enable','on');

	%==============================================================
   	% MakeMovie
	%==============================================================
	 btnNumber=14;
    	 yPos=menutop-(btnNumber-1)*(btnHt+spacing);
    	 btnPos=[left+btnWid./2 yPos-btnHt btnWid./2 btnHt];
	 callbackStr = 'IAPSMovie(''MakeMovie'')';
	 hMakeMovieMenu=uicontrol( ...
        'Style','pushbutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String','Make Movie', ...
        'Value',0, ...
        'Callback',callbackStr,...
	'ForegroundColor',[0 0 0.3],...
	'Enable','on');

	%==============================================================
	% NIdentPic
	%==============================================================
	btnNumber=15;
	
	% NIdentPic
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos=[left yPos-btnHt_edit./2 2.*btnWid./3 btnHt_edit./2];    
	hNIdentPicText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','Number of id. picts:');
	
	btnPos=[left+2.*btnWid./3 yPos-btnHt_edit./2 btnWid./3 btnHt_edit./2];
	callbackStr = 'IAPSMovie(''NIdentPic'')';
    
	hNIdentPic = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','1',...
	'Value',1, ...
        'callback',callbackStr);
	
	%==============================================================
	% FileNumberOffset
	%==============================================================
	btnNumber=15;
	
	% FileNumberOffset
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos=[left yPos-btnHt_edit 2.*btnWid./3 btnHt_edit./2];    

	hFileNumberOffsetText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','File Number Offset:');
	
	btnPos=[left+2.*btnWid./3 yPos-btnHt_edit btnWid./3 btnHt_edit./2];
	callbackStr = 'IAPSMovie(''FileNumberOffset'')';
    
	hFileNumberOffset = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','0',...
	'Value',0, ...
        'callback',callbackStr);

	%==============================================================
	% Checkerboard Radio
	%==============================================================
	btnNumber=17;
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
   	btnPos=[left yPos-btnHt./2 btnWid btnHt];
	callbackStr='IAPSMovie(''CheckStatus'')';

	hCheckStatus=uicontrol( ...
        'Style','radiobutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String','Checkerboard Status', ...
	'Value',0,...
        'Callback',callbackStr,...
	'Enable','on');

	%==============================================================
	% NRow Checkerboard 
	%==============================================================	
	% NRowCheck
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos=[left yPos-btnHt./2-btnHt_edit./2 2.*btnWid./3 btnHt_edit./2];    
	hNRowCheckText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','Number of rows:');
	
	btnPos=[left+2.*btnWid./3 yPos-btnHt./2-btnHt_edit./2 btnWid./3 btnHt_edit./2];
	callbackStr = 'IAPSMovie(''NRowCheck'')';
    
	hNRowCheck = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','6',...
	'Value',6, ...
        'callback',callbackStr);

	%==============================================================
	% NCol Checkerboard 
	%==============================================================	
	% NColCheck
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos=[left yPos-btnHt./2-btnHt_edit 2.*btnWid./3 btnHt_edit./2];    
	hNColCheckText = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','Number of cols:');
	
	btnPos=[left+2.*btnWid./3 yPos-btnHt./2-btnHt_edit btnWid./3 btnHt_edit./2];
	callbackStr = 'IAPSMovie(''NColCheck'')';
    
	hNColCheck = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','5',...
	'Value',5, ...
        'callback',callbackStr);

	hPicVec=uicontrol('Visible','off');			%21
	hRateMenuFig=0;						%25
	hParaMat=uicontrol('Visible','off');			%34
	hCalEyeTrackYVert=uicontrol('Visible','off');	%54
	hCalEyeTrackYHor=uicontrol('Visible','off');	%55
	hEyeTrackTrigVec=uicontrol('Visible','off');	%57
	hEyeTrackMat=uicontrol('Visible','off');		%58

	NonUse=0;
		
	hIAPSMovieList=[hSetGenderMenu hReadValenceMenu hReadImageMenu hReadImagePathMenu hRunMovieMenu ...
					hSortByVal hSortByAro hStartPicText hStartPic hStartPicSlider ...
					hMovieDir hMovieFunction hSetNCycleText hSetNCycle hSetNPicPerCycleText ...
               		hSetNPicPerCycle hEasyMovieMenu hPicFig hFuncFig hMenuFig ...
               		hPicVec hStopMovieMenu hPauseMovieMenu hSetRateMenu hRateMenuFig ...					%25
					hSaveMovieMenu hReadMovieMenu hUseRandPerm hUseExtraRating hPrint2FileStatus ...
					hPrint2FileMethod hColorBlackWhite hBrightStatus hParaMat hRandPixel ...
					hRandLogMovieMenu hMakeMovieMenu hNIdentPic hRandFileMovieMenu NonUse ...
					hCheckStatus hNRowCheckText hNRowCheck hNColCheckText hNColCheck ...
					hSortByRGBHSV hCorrectValAroStatus hUseMultiples hSetNBasePicText hSetNBasePic ...			%50		
					hFileNumberOffsetText hFileNumberOffset hCalEyeTrack hCalEyeTrackYVert hCalEyeTrackYHor ...
					hEyeTrack hEyeTrackTrigVec hEyeTrackMat];		
					
	set(hMenuFig,'Visible','on','UserData',hIAPSMovieList);

	IAPSMovie('ReadData');
	IAPSMovie('ReadImagePath');
	IAPSMovie('SetMovieFunction');

elseif strcmp(action,'MakeMovie') 

	hIAPSMovieList=get(hMenuFig,'Userdata');
	
	ImPath=get(hIAPSMovieList(4),'Userdata');
	MovieLogMat=get(hIAPSMovieList(27),'Userdata')
	if isempty(MovieLogMat)
		Message=char('No MovieLogMat available !');
		Message=char(Message,'');
		Message=char(Message,'Choose an Header Matrix file containing the picture numbers');
		Message=char(Message,'or use "Read Movie" to load a movie log file (press "Cancel" now).');
		hmsgbox=msgbox(Message,'Info','help'); 
		DefFilePath=SetDefPath(1);
		[ExpPicVec,File,Path] = ReadAscii;
		if isempty(File); return; end
		if File==0; return; end
		SetDefPath(2,Path);
		close(hmsgbox);
	else
  		ExpPicVec=MovieLogMat(:,3);
	end
	NIdentPic=get(hIAPSMovieList(38),'Value');
	StartPic=get(hIAPSMovieList(10),'Value');
	NBasePic=get(hIAPSMovieList(50),'Value');
	FileNumberOffset=get(hIAPSMovieList(52),'Value');

	if NBasePic>0
		BaseIndVec=get(hIAPSMovieList(50),'Userdata')
		MatMat=get(hIAPSMovieList(2),'Userdata');
		PicVec=MatMat(:,1);
		BaseVec=PicVec(BaseIndVec)
	end
% 	[NoUse,ImPath]=WriteFilePath([],'Choose Movie Image Path:');
 	
	Message=char('Choose path to save your movie !');
	Message=char(Message,'');
	Message=char(Message,'Please double check whether');
	Message=char(Message,'the given number of identical');
	Message=char(Message,['pictures (' int2str(NIdentPic) ')  and the start  ']);
	Message=char(Message,['picture number (' int2str(StartPic) ') is correct !!! ']);
	Message=char(Message,'');
	Message=char(Message,'Otherwise press "Cancel".');
	hmsgbox=msgbox(Message,'Info:','help');	
	[NoUse,SavePath]=WriteFilePath([],'Choose Movie Save Path:');
	close(hmsgbox)
	if NoUse==0; return; end
 	NPic=length(ExpPicVec);
	MCycle=3;
	LCycle=5;
	NPicPerCycle=23;
% 	NPic=704
	for PicInd=StartPic:NPic+NBasePic
		for IdentInd=1:NIdentPic
			if PicInd<=NBasePic
				PicIndTmp=(PicInd-1).*NIdentPic+IdentInd;
				FilePathOldDisp=[ImPath,int2str(BaseVec(PicInd)),'.jpg'];
				FilePathOld=['"' ImPath,int2str(BaseVec(PicInd)),'.jpg"'];
				CopyResult=applescript('acopy', 'itemName', FilePathOld,'folderName',['"' SavePath '"']);
 				FilePathOld=['"' SavePath,int2str(BaseVec(PicInd)),'.jpg"'];
				BaseFileStr='Base';
				fprintf('Base Pict.: %g of %g; IAPS #: %g; File #: %g; Ident.: %g\n',PicInd,NBasePic,BaseVec(PicInd),PicIndTmp,IdentInd);
			else
				PicInd=PicInd-NBasePic;
% 				PicIndTmp=FileNumberOffset+(PicInd-1).*NIdentPic+IdentInd;
				PicIndTmp=FileNumberOffset+(PicInd-1).*NIdentPic+IdentInd+PicInd;

				FilePathOldDisp=[ImPath,int2str(ExpPicVec(PicInd)),'.jpg'];
				FilePathOld=['"' ImPath,int2str(ExpPicVec(PicInd)),'.jpg"'];
				CopyResult=applescript('acopy', 'itemName', FilePathOld,'folderName',['"' SavePath '"']);
 				FilePathOld=['"' SavePath,int2str(ExpPicVec(PicInd)),'.jpg"'];
				fprintf('Picture: %g of %g; IAPS #: %g; File #: %g; Ident.: %g\n',PicInd,NPic,ExpPicVec(PicInd),PicIndTmp,IdentInd);
			end
% 			PicIndTmp=(ceil((PicInd-NPicPerCycle.*MCycle)./(NPicPerCycle.*MCycle))).*((LCycle-1).*NPicPerCycle.*MCycle)+(5-1).*NPicPerCycle.*MCycle+PicInd;
% 			PicIndTmp=(PicIndTmp-1).*NIdentPic+IdentInd;
 				
% 			if round(PicInd./2)==PicInd./2; 
% 				FilePathOld=['"' ImPath,'Checka2"'];
% 			else
% 				FilePathOld=['"' ImPath,'Checkb2"'];
%			end
			
% 			if round(PicInd./2)==PicInd./2; 
% 				FilePathOld=['"' SavePath,'Checka2"'];
% 			else
% 				FilePathOld=['"' SavePath,'Checkb2"'];
% 			end
			if PicIndTmp<10
				NewFile=['000' int2str(PicIndTmp) '.jpg'];
			elseif PicIndTmp>9 & PicIndTmp<100
				NewFile=['00' int2str(PicIndTmp) '.jpg'];
			elseif PicIndTmp>99 & PicIndTmp<1000
				NewFile=['0' int2str(PicIndTmp) '.jpg'];
			elseif PicIndTmp>999 & PicIndTmp<10000
				NewFile=[int2str(PicIndTmp) '.jpg'];
			end
			fprintf(FilePathOldDisp); fprintf('  =>  '); fprintf([SavePath,NewFile]); fprintf('\n');
			NewFile=['"' NewFile '"'];
 			RenameResult = applescript('arename', 'itemName', FilePathOld, 'newName', NewFile);
 			fprintf('Result of acopy:  '); fprintf(CopyResult); fprintf('\n');
 			fprintf('Result of arename:  '); fprintf(RenameResult); fprintf('\n');fprintf('\n');
		end
	end

elseif strcmp(action,'RandFileMovie') 

	hIAPSMovieList=get(hMenuFig,'Userdata');
	NIdentPic=get(hIAPSMovieList(38),'Value');
	StartPic=get(hIAPSMovieList(10),'Value');
	Message=char('Look for movie path !');
	Message=char(Message,'');
	Message=char(Message,'Please double check whether');
	Message=char(Message,'the given number of identical');
	Message=char(Message,['pictures (' int2str(NIdentPic) ')  and the start  ']);
	Message=char(Message,['picture number (' int2str(StartPic) ') is correct !!! ']);
	Message=char(Message,'');
	Message=char(Message,'Otherwise press "Cancel".');
	hmsgbox=msgbox(Message,'Info:','help');	
	[File,Path]=uigetfile('File.*','Look for jpg file:');
	close(hmsgbox)	
	if File==0; return; end
	FilePath=[Path,File];
% 	D=dir(Path);
	RandVec=ReadData([],1,[],'ascii','ascii')
	NPic=length(RandVec)
% 	NPic=length(D)./NIdentPic;
% 	RandVec=randperm(NPic)'
	pause
	fprintf('\n');clc;
	for PicInd=StartPic:NPic+StartPic-1
		for IdentInd=1:NIdentPic
			PicIndOld=(PicInd-1).*NIdentPic+IdentInd;
			if PicIndOld<10
				FileOld=['File.000' int2str(PicIndOld)];
			elseif PicIndOld>9 & PicIndOld<100
				FileOld=['File.00' int2str(PicIndOld)];
			elseif PicIndOld>99 & PicIndOld<1000
				FileOld=['File.0' int2str(PicIndOld)];
			elseif PicIndOld>999 & PicIndOld<10000
				FileOld=['File.' int2str(PicIndOld)];
			end
			PicIndNew=(StartPic+RandVec(PicInd-StartPic+1)-2).*NIdentPic+IdentInd;
			if PicIndNew<10
				FileNew=['Rand.000' int2str(PicIndNew)];
			elseif PicIndNew>9 & PicIndNew<100
				FileNew=['Rand.00' int2str(PicIndNew)];
			elseif PicIndNew>99 & PicIndNew<1000
				FileNew=['Rand.0' int2str(PicIndNew)];
			elseif PicIndNew>999 & PicIndNew<10000
				FileNew=['Rand.' int2str(PicIndNew)];
			end
			fprintf('Picture: %g of %g. Ident.: %g\n',PicInd-StartPic+1,NPic,IdentInd);
			fprintf('Old file name:  ');
			fprintf(FileOld); fprintf('\n');
			fprintf('Rand file name:  ');
			fprintf(FileNew); fprintf('\n\n');
			resultString = applescript('arename', 'itemName', ['"' Path,FileOld '"'], 'newName', ['"' FileNew '"']);
		end
	end

elseif strcmp(action,'ReadMovie') |  strcmp(action,'RandLogMovie'),

	hIAPSMovieList=get(hMenuFig,'Userdata');
	global MovieLogMat 
	set(hIAPSMovieList(27),'Value',1); 	%ReadMovieStatus
	get(hIAPSMovieList(27),'Value')
	[MovLogFile,MovLogPath,MovLogFilePath]=ReadFilePath([],[ '*MovLog*'],'Select a movie log file:');
	[File,Path,FilePath,GenderVal,MovieFunction,NCycle,NPicPerCycle,SortByValStatus,...
	SortByAroStatus,SortByRGBHSVStatus,ColorBlackWhite,BrightStatus,UseRandPermStatus,...
	UseExtraRatingStatus,StartPic,CorrectValAroStatus,SizeMovieLogMat,MovieLogMat]=ReadMovieLogFile(MovLogFilePath);

	if File==0; return; end
	set(hIAPSMovieList(1),'Value',GenderVal);
	set(hIAPSMovieList(12),'Value',MovieFunction);
	set(hIAPSMovieList(14),'Value',NCycle,'String',int2str(NCycle));
	set(hIAPSMovieList(16),'Value',NPicPerCycle,'String',int2str(NPicPerCycle));
	set(hIAPSMovieList(6),'Value',SortByValStatus);
	set(hIAPSMovieList(7),'Value',SortByAroStatus);
 	set(hIAPSMovieList(46),'Value',SortByRGBHSVStatus);
	set(hIAPSMovieList(47),'Value',CorrectValAroStatus);
	set(hIAPSMovieList(32),'Value',ColorBlackWhite); 
	set(hIAPSMovieList(33),'Value',BrightStatus); 
	set(hIAPSMovieList(28),'Value',UseRandPermStatus); 
	set(hIAPSMovieList(29),'Value',UseExtraRatingStatus); 
	%set(hIAPSMovieList(9),'Value',StartPic,'String',int2str(StartPic)); set(hIAPSMovieList(10),'Value')
	if strcmp(action,'RandLogMovie'),
		RandVec=randperm(SizeMovieLogMat(1));
		MovieLogMat(:,2:SizeMovieLogMat(2))=MovieLogMat(RandVec,2:SizeMovieLogMat(2));
		WriteMovieLogFile([FilePath,'Rand'],GenderVal,MovieFunction,NCycle,NPicPerCycle,...
		SortByValStatus,SortByAroStatus,SortByRGBHSVStatus,ColorBlackWhite,BrightStatus,...
	 	UseRandPermStatus,UseExtraRatingStatus,StartPic,SizeMovieLogMat,MovieLogMat);
	end
	set(hIAPSMovieList(27),'Userdata',MovieLogMat);	
	ReadMovieStatus=get(hIAPSMovieList(27),'Value')
   	IAPSMovie('RunMovie');
% % 	set(hIAPSMovieList(27),'Value',0); %Reset ReadMovieStatus

elseif strcmp(action,'SetMovieFunction'),	

	IAPSMovie('SetNCycle');
	IAPSMovie('SetNPicPerCycle');

elseif strcmp(action,'SetRateMenu'),	

	hIAPSMovieList=get(hMenuFig,'Userdata');
	set(hIAPSMovieList(24),'Value',1);	%RatePictureStatus
	%============== figure with graphs =========================		
   	if strcmp(computer,'MAC2')	
		RateMenuFigPosVec=[.8 0 .2 .7];
		RateMenuAxesPosVec=[0 0 1 1];  
   	elseif strcmp(computer,'PCWIN') 
		RateMenuFigPosVec=[.8 0 .2 .7];
		RateMenuAxesPosVec=[0 0 1 1];  
	 elseif strcmp(computer,'SOL2')
		RateMenuFigPosVec=[.8 0 .2 .7];
		RateMenuAxesPosVec=[0 0 1 1];  
	end;
    ColorMat=jet(256);
   	%============== figure with menu ===========================		
	RateMenuFigString=['Rate IAPS picture:'];
  	hRateMenuFig=figure('Units','normal','Position',RateMenuFigPosVec, ...
        'Name',RateMenuFigString,'Color',[.99 .99 .99], ...
        'NumberTitle','off');

    	% Information for all buttons (and menus)
    	labelColor=[0 0 0];
    	yInitPos=0.90;
    	menutop=0.955;
	btnTop = 0.6;
	top=0.75;
	left=0.125;
	btnWid=0.8;
	btnHt=0.06;
	btnHt_edit=0.1;
	textHeight = 0.05;			% not used !!!!!!!!!!!
	textWidth = 0.06;
	% Spacing between the button and the next command's label
	spacing=0.007;

	%====================================
	% The CONSOLE frame
	
	frmBorder=0.05; 
	frmLeft=left-frmBorder;
	frmBottom=0.010; 
    	frmHeight = 1-3.*frmBottom; 
	frmWidth = btnWid+2*frmBorder;
    	yPos=frmBottom-frmBorder;
    	frmPos=[frmLeft frmBottom frmWidth frmHeight];
	ConsoleRGBColor=[.4 .2 .6];
    	hConsolFrame=uicontrol( ...
        	'Style','frame', ...
        	'Units','normalized', ...
        	'Position',frmPos, ...
		'BackgroundColor',ConsoleRGBColor);
		
	
 	%==============================================================
	% Valence
	%==============================================================
	btnNumber=1;
	
	% RateValTxt
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos=[left yPos-btnHt 2.*btnWid./3 btnHt_edit./2];    
	hRateValTxt = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','Rate Valence:');
	
	btnPos=[left+2.*btnWid./3 yPos-btnHt btnWid./3 btnHt_edit./2];
	callbackStr = 'IAPSMovie(''RateValEdit'')';
    
	hRateValEdit = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','0',...
	'Value',0, ...
        'callback',callbackStr);

	btnNumber=2;
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
  	btnPos=[left yPos-btnHt btnWid btnHt_edit];
	callbackStr='IAPSMovie(''RateValSlider'')';

	hRateValSlider=uicontrol( ...
        'Style','slider', ...
        'Units','normalized', ...
        'Position',btnPos, ...
	'Value',1,...
	'Min',0,...
	'Max',10,...
	'SliderStep',[.01,.1],...
        'Callback',callbackStr,...
        'Enable','on');
	
	btnNumber=3;
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
  	btnPos=[left yPos-btnHt btnWid btnHt_edit];
	callbackStr='IAPSMovie(''RateValColor'')';

	hRateValColor=uicontrol( ...
        'Style','pushbutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
	'Value',0,...
	'Userdata',ColorMat,...
	'BackgroundColor', ColorMat(128,:),...
        'Callback',callbackStr,...
        'Enable','off');

	%==============================================================
	% Arousal
	%==============================================================
	btnNumber=4;
	
	% RateAroTxt
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos=[left yPos-btnHt 2.*btnWid./3 btnHt_edit./2];    
	hRateAroTxt = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','Rate Arousal:');
	
	% RateAroEdit
	btnPos=[left+2.*btnWid./3 yPos-btnHt btnWid./3 btnHt_edit./2];
	callbackStr = 'IAPSMovie(''RateAroEdit'')';
	hRateAroEdit = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','5',...
	'Value',5, ...
        'callback',callbackStr);

	% RateAroSlider
	btnNumber=6;
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
  	btnPos=[left yPos-btnHt btnWid btnHt_edit];
	callbackStr='IAPSMovie(''RateAroSlider'')';

	hRateAroSlider=uicontrol( ...
        'Style','slider', ...
        'Units','normalized', ...
        'Position',btnPos, ...
	'Value',5,...
	'Min',0,...
	'Max',10,...
	'SliderStep',[.01,.1],...
        'Callback',callbackStr,...
        'Enable','on');

	% RateAroColor
	btnNumber=7;
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
  	btnPos=[left yPos-btnHt btnWid btnHt_edit];
	callbackStr='IAPSMovie(''RateAroColor'')';

	hRateAroColor=uicontrol( ...
        'Style','pushbutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
	'Value',0,...
	'Userdata',ColorMat,...
	'BackgroundColor', ColorMat(128,:),...
        'Callback',callbackStr,...
        'Enable','off');

	%==============================================================
	% RateExtra
	%==============================================================
	btnNumber=8;
	
	% RateExtTxt
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
	btnPos=[left yPos-btnHt 2.*btnWid./3 btnHt_edit./2];    
	hRateExtTxt = uicontrol( ...
        'Style','text', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','left', ...
        'Foreground','black', ...
        'String','Rate Extra:');
	
	% RateExtEdit
	btnPos=[left+2.*btnWid./3 yPos-btnHt btnWid./3 btnHt_edit./2];
	callbackStr = 'IAPSMovie(''RateExtEdit'')';
	hRateExtEdit = uicontrol( ...
        'Style','edit', ...
        'Units','normalized', ...
	'Position',btnPos, ...
        'Horiz','center', ...
        'Background','white', ...
        'Foreground','black', ...
        'String','10',...
	'Value',10, ...
        'callback',callbackStr);

	% RateExtSlider
	btnNumber=9;
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
  	btnPos=[left yPos-btnHt btnWid btnHt_edit];
	callbackStr='IAPSMovie(''RateExtSlider'')';

	hRateExtSlider=uicontrol( ...
        'Style','slider', ...
        'Units','normalized', ...
        'Position',btnPos, ...
	'Value',10,...
	'Min',0,...
	'Max',10,...
	'SliderStep',[.01,.1],...
        'Callback',callbackStr,...
        'Enable','on');

	% RateExtColor
	btnNumber=10;
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
  	btnPos=[left yPos-btnHt btnWid btnHt_edit];
	callbackStr='IAPSMovie(''RateExtColor'')';

	hRateExtColor=uicontrol( ...
        'Style','pushbutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
	'Value',0,...
	'Userdata',ColorMat,...
	'BackgroundColor', ColorMat(128,:),...
        'Callback',callbackStr,...
        'Enable','off');


	% RateExtMin
	btnNumber=12;
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
  	btnPos=[left yPos-1.6.*btnHt btnWid./2 btnHt_edit];
	callbackStr='IAPSMovie(''RateExtMin'')';

	hRateExtMin=uicontrol( ...
        'Style','pushbutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String','Minimum', ...
	'Value',0,...
        'Callback',callbackStr,...
        'Enable','on');

	% RateExtMax
	btnNumber=12;
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
  	btnPos=[left+btnWid./2 yPos-1.6.*btnHt btnWid./2 btnHt_edit];
	callbackStr='IAPSMovie(''RateExtMax'')';

	hRateExtMax=uicontrol( ...
        'Style','pushbutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
        'String','Maximum', ...
	'Value',0,...
        'Callback',callbackStr,...
        'Enable','on');

	btnNumber=13;
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
  	btnPos=[left yPos-2.35.*btnHt btnWid./2 btnHt_edit];
	callbackStr='IAPSMovie(''SetRateMat'')';

	hSetRateMat=uicontrol( ...
        'Style','pushbutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
	'Value',0,...
	'String','Set Rating',...
        'Callback',callbackStr,...
        'Enable','on');

	btnNumber=12;
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
  	btnPos=[left+btnWid./2 yPos-2.35.*btnHt btnWid./2 btnHt_edit];
	callbackStr='IAPSMovie(''GetRateMat'')';

	hGetRateMat=uicontrol( ...
        'Style','pushbutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
	'Value',0,...
	'String','Get Rating',...
        'Callback',callbackStr,...
        'Enable','on');

	btnNumber=13;
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
  	btnPos=[left yPos-3.1.*btnHt btnWid./2 btnHt_edit];
	callbackStr='IAPSMovie(''SaveRateMat'')';

	hSaveRateMat=uicontrol( ...
        'Style','pushbutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
	'Value',0,...
	'String','Save Rating',...
        'Callback',callbackStr,...
        'Enable','on');

	btnNumber=13;
	yPos=menutop-(btnNumber-1)*(btnHt+spacing);
  	btnPos=[left+btnWid./2 yPos-3.1.*btnHt btnWid./2 btnHt_edit];
	callbackStr='IAPSMovie(''ReadRateMat'')';

	hReadRateMat=uicontrol( ...
        'Style','pushbutton', ...
        'Units','normalized', ...
        'Position',btnPos, ...
	'Value',0,...
	'String','Read Rating',...
        'Callback',callbackStr,...
        'Enable','on');

	MatMat=get(hIAPSMovieList(2),'Userdata');
	[NPic,NonUse]=size(MatMat);
	RateMat=MatMat(:,1:4);			%Row 1 => PicVec (File numbers); Row 2 => Used Value (Valence or/and arousal)
	RateMat(:,3)=MatMat(:,8);
	RateMat(:,4)=10.*ones(NPic,1);		%Special Rate
	hRateMat=uicontrol('Visible','off','Userdata',RateMat);	%19
	NonUse=0;

	hRateMenuList=[hRateValTxt hRateValEdit hRateValSlider NonUse NonUse ...
				hRateAroTxt hRateAroEdit hRateAroSlider NonUse NonUse ...
				hRateExtTxt hRateExtEdit hRateExtSlider hRateExtMin hRateExtMax ...
				hRateValColor hRateAroColor hRateExtColor hRateMat NonUse ...
				hSetRateMat hGetRateMat hSaveRateMat hReadRateMat];

	set(hRateMenuFig,'Userdata',hRateMenuList);
	hIAPSMovieList(25)=hRateMenuFig;
	set(hMenuFig,'Userdata',hIAPSMovieList);
	IAPSMovie('RunMovie')

elseif strcmp(action,'SetRateMat'),	

	hIAPSMovieList=get(hMenuFig,'Userdata');
	hRateMenuFig=hIAPSMovieList(25);
	hRateMenuList=get(hRateMenuFig,'Userdata');
	hPicFig=hIAPSMovieList(18);
	PicInd=get(hPicFig,'Userdata');
	RateMat=get(hRateMenuList(19),'Userdata');
	ValVal=get(hRateMenuList(3),'Value');
	AroVal=get(hRateMenuList(8),'Value');
	ExtVal=get(hRateMenuList(13),'Value');
	RateMat(PicInd,2)=ValVal;
	RateMat(PicInd,3)=AroVal;
	RateMat(PicInd,4)=ExtVal;
	set(hRateMenuList(19),'Userdata',RateMat);
	uiresume;

elseif strcmp(action,'GetRateMat'),	

	hIAPSMovieList=get(hMenuFig,'Userdata');
	hRateMenuFig=hIAPSMovieList(25);
	hRateMenuList=get(hRateMenuFig,'Userdata');
	hPicFig=hIAPSMovieList(18);
	PicInd=get(hPicFig,'Userdata');
	RateMat=get(hRateMenuList(19),'Userdata');
	ValVal=RateMat(PicInd,2);
	AroVal=RateMat(PicInd,3);
	ExtVal=RateMat(PicInd,4);
	set(hRateMenuList(3),'Value',ValVal);
	set(hRateMenuList(8),'Value',AroVal);
	set(hRateMenuList(13),'Value',ExtVal);
	IAPSMovie('RateValSlider')
	IAPSMovie('RateAroSlider')
	IAPSMovie('RateExtSlider')

elseif strcmp(action,'SaveRateMat'),	

	hIAPSMovieList=get(hMenuFig,'Userdata');
	hRateMenuFig=hIAPSMovieList(25);
	hRateMenuList=get(hRateMenuFig,'Userdata');
	[RateFile,RatePath,RateFilePath]=WriteFilePath('Untitled.Rate','Save rating to file:');
	if RateFile==0; return; end
	RateMat=get(hRateMenuList(19),'Userdata');
	SaveData(RateMat,RateFilePath,1,[],'ascii','ascii');

elseif strcmp(action,'ReadRateMat'),	

	hIAPSMovieList=get(hMenuFig,'Userdata');
	hRateMenuFig=hIAPSMovieList(25);
	hRateMenuList=get(hRateMenuFig,'Userdata');
	[File,Path]=uigetfile('*.Rate','Look for IAPS15 file:');
	if File==0; return; end
	FilePath=[Path,File];
	RateMat=ReadData(FilePath,1,[],'ascii','ascii');
	set(hRateMenuList(19),'Userdata',RateMat);

elseif strcmp(action,'RateValEdit'),	

	hIAPSMovieList=get(hMenuFig,'Userdata');
	hRateMenuFig=hIAPSMovieList(25);
	hRateMenuList=get(hRateMenuFig,'Userdata');
	v=get(hRateMenuList(2),'Value');
	str=get(hRateMenuList(2),'String');
	
   	ind = find(abs(str)<32);
    	str(ind) = 32*ones(size(ind));
   	str = str';	
    	vv = eval(['[' str(:)' ']'],'-1')';
	vv=round(vv);
	if length(vv)~=1; vv=v; end
    	if vv<-10
		vv=-10;
	elseif vv>10
		vv=10;
	end
	set(hRateMenuList(2),'Value',vv,'String',sprintf('%g',vv)); 
	set(hRateMenuList(3),'Value',vv); 
	IAPSMovie('RateValColor')

elseif strcmp(action,'RateValSlider'),	
	
	hIAPSMovieList=get(hMenuFig,'Userdata');
	hRateMenuFig=hIAPSMovieList(25);
	hRateMenuList=get(hRateMenuFig,'Userdata');
	v=get(hRateMenuList(3),'Value');
	set(hRateMenuList(2),'Value',v,'String',sprintf('%g',v));
	IAPSMovie('RateValColor')

elseif strcmp(action,'RateValColor'),	

	hIAPSMovieList=get(hMenuFig,'Userdata');
	hRateMenuFig=hIAPSMovieList(25);
	hRateMenuList=get(hRateMenuFig,'Userdata');
	ColorMat=get(hRateMenuList(16),'Userdata');
	ColorVal=get(hRateMenuList(3),'Value');
	MinColorVal=get(hRateMenuList(3),'Min');
	MaxColorVal=get(hRateMenuList(3),'Max');
	ColorMatInd=round(256.*(ColorVal-MinColorVal)./(MaxColorVal-MinColorVal));
	if ColorMatInd<1; ColorMatInd=1; elseif ColorMatInd>256; ColorMatInd=256; end
	set(hRateMenuList(16),'BackGroundColor',ColorMat(ColorMatInd,:));


elseif strcmp(action,'RateAroEdit'),	

	hIAPSMovieList=get(hMenuFig,'Userdata');
	hRateMenuFig=hIAPSMovieList(25);
	hRateMenuList=get(hRateMenuFig,'Userdata');
	v=get(hRateMenuList(7),'Value');
	str=get(hRateMenuList(7),'String');
	
   	ind = find(abs(str)<32);
    	str(ind) = 32*ones(size(ind));
   	str = str';	
    	vv = eval(['[' str(:)' ']'],'-1')';
	vv=round(vv);
	if length(vv)~=1; vv=v; end
    	if vv<-10
		vv=-10;
	elseif vv>10
		vv=10;
	end
	set(hRateMenuList(7),'Value',vv,'String',sprintf('%g',vv)); 
	set(hRateMenuList(8),'Value',vv); 
	IAPSMovie('RateAroColor')

elseif strcmp(action,'RateAroSlider'),	
	
	hIAPSMovieList=get(hMenuFig,'Userdata');
	hRateMenuFig=hIAPSMovieList(25);
	hRateMenuList=get(hRateMenuFig,'Userdata');
	v=get(hRateMenuList(8),'Value');
	set(hRateMenuList(7),'Value',v,'String',sprintf('%g',v)); 
	IAPSMovie('RateAroColor')

elseif strcmp(action,'RateAroColor'),	

	hIAPSMovieList=get(hMenuFig,'Userdata');
	hRateMenuFig=hIAPSMovieList(25);
	hRateMenuList=get(hRateMenuFig,'Userdata');
	ColorMat=get(hRateMenuList(17),'Userdata');
	ColorVal=get(hRateMenuList(8),'Value');
	MinColorVal=get(hRateMenuList(8),'Min');
	MaxColorVal=get(hRateMenuList(8),'Max');
	ColorMatInd=round(256.*(ColorVal-MinColorVal)./(MaxColorVal-MinColorVal));
	if ColorMatInd<1; ColorMatInd=1; elseif ColorMatInd>256; ColorMatInd=256; end
	set(hRateMenuList(17),'BackGroundColor',ColorMat(ColorMatInd,:));

elseif strcmp(action,'RateExtEdit'),	

	hIAPSMovieList=get(hMenuFig,'Userdata');
	hRateMenuFig=hIAPSMovieList(25);
	hRateMenuList=get(hRateMenuFig,'Userdata');
	v=get(hRateMenuList(12),'Value');
	str=get(hRateMenuList(12),'String');
	
   	ind = find(abs(str)<32);
    	str(ind) = 32*ones(size(ind));
   	str = str';	
    	vv = eval(['[' str(:)' ']'],'-1')';
	vv=round(vv);
	if length(vv)~=1; vv=v; end
    	if vv<-10
		vv=-10;
	elseif vv>10
		vv=10;
	end
	set(hRateMenuList(12),'Value',vv,'String',sprintf('%g',vv)); 
	set(hRateMenuList(13),'Value',vv); 
	IAPSMovie('RateExtColor')

elseif strcmp(action,'RateExtSlider'),	
	
	hIAPSMovieList=get(hMenuFig,'Userdata');
	hRateMenuFig=hIAPSMovieList(25);
	hRateMenuList=get(hRateMenuFig,'Userdata');
	v=get(hRateMenuList(13),'Value');
	set(hRateMenuList(12),'Value',v,'String',sprintf('%g',v)); 
	IAPSMovie('RateExtColor')

elseif strcmp(action,'RateExtColor'),	

	hIAPSMovieList=get(hMenuFig,'Userdata');
	hRateMenuFig=hIAPSMovieList(25);
	hRateMenuList=get(hRateMenuFig,'Userdata');
	ColorMat=get(hRateMenuList(18),'Userdata');
	ColorVal=get(hRateMenuList(13),'Value');
	MinColorVal=get(hRateMenuList(13),'Min');
	MaxColorVal=get(hRateMenuList(13),'Max');
	ColorMatInd=round(256.*(ColorVal-MinColorVal)./(MaxColorVal-MinColorVal));
	if ColorMatInd<1; ColorMatInd=1; elseif ColorMatInd>256; ColorMatInd=256; end
	set(hRateMenuList(18),'BackGroundColor',ColorMat(ColorMatInd,:));

elseif strcmp(action,'RateExtMin'),	
	
	hIAPSMovieList=get(hMenuFig,'Userdata');
	hRateMenuFig=hIAPSMovieList(25);
	hRateMenuList=get(hRateMenuFig,'Userdata');
	MinExt=get(hRateMenuList(13),'Min');
	set(hRateMenuList(12),'Value',MinExt,'String',sprintf('%g',MinExt)); 
	set(hRateMenuList(13),'Value',MinExt); 
	IAPSMovie('RateExtColor')

elseif strcmp(action,'RateExtMax'),	
	
	hIAPSMovieList=get(hMenuFig,'Userdata');
	hRateMenuFig=hIAPSMovieList(25);
	hRateMenuList=get(hRateMenuFig,'Userdata');
	MaxExt=get(hRateMenuList(13),'Max');
	set(hRateMenuList(12),'Value',MaxExt,'String',sprintf('%g',MaxExt)); 
	set(hRateMenuList(13),'Value',MaxExt); 
	IAPSMovie('RateExtColor')

elseif strcmp(action,'SetGender'),	

	IAPSMovie('ReadData');
	
elseif strcmp(action,'ReadData'),	

	global Mat MatMat ValVec IdPicVec TakeVec
	hIAPSMovieList=get(hMenuFig,'Userdata');
	GenderVal=get(hIAPSMovieList(1),'Value');
	UseMultiplesVal=get(hIAPSMovieList(48),'Userdata');

	File= 'IAPS_15_716';
	Path='Geo';
	PathTmp=what(Path)
	if length(PathTmp)==0
		[File,Path]=uigetfile('*IAPS15','Look for IAPS15 file:');
		FilePath=[Path,File];
	else
		Path=getfield(PathTmp,'path');
		if strcmp(Path(length(Path)),FileSep); Path=Path(1:length(Path)-1); end
		FilePath=[Path,FileSep,File];
	end
	Message=char('Read data from file:');
	Message=char(Message,'');
	Message=char(Message,FilePath);
	Message=char(Message,'');
	hmsgbox=msgbox(Message,'Info','help'); 		
	pause(.1)
	MatMat=ReadData(FilePath,1,[],'ascii','ascii');
	[NPic,NonUse]=size(MatMat);
	PicVec=MatMat(:,1);
	if UseMultiplesVal
		PicVecTmp=PicVec;			%inclusive changed doubles like 6570.1; 6570.2 etc.
	else
		PicVecTmp=round(PicVec);	%exclusive changed doubles like 6570.1; 6570.2 etc.
	end
	NDiffPic=0;
	NIdPic=0;
	NNoUseInd=0;
	TakeIndVec=[1:NPic];
	while ~isempty(PicVecTmp)	%Welche Bilder mehrfach vorkommen
		NDiffPic=NDiffPic+1;
		DiffPicVec(NDiffPic)=PicVecTmp(1); 
		k=find(PicVecTmp~=PicVecTmp(1));
		l=find(PicVecTmp==PicVecTmp(1));
		if length(l)>1;
			NNoUseInd=NNoUseInd+length(l)-1;
			NIdPic=NIdPic+1;
			IdPicVec(NIdPic)=PicVecTmp(l(1));
			disp(PicVecTmp(l)'); 
		end
		PicVecTmp=PicVecTmp(k);
	end
	if ~isempty(IdPicVec)
		Tmp=1;
		NoUseIndVec=zeros(NNoUseInd,1);
		if UseMultiplesVal
			PicVecTmp=PicVec;			%inclusive changed doubles like 6570.1; 6570.2 etc.
		else
			PicVecTmp=round(PicVec);	%exclusive changed doubles like 6570.1; 6570.2 etc.
		end
		for i=1:length(IdPicVec)
			a=find(PicVecTmp==IdPicVec(i));
			NoUseIndVec(Tmp:Tmp+length(a)-2)=a(2:length(a));
			Tmp=Tmp+length(a)-1;
		end
		TakeInd=0;
		TakeVec=zeros(NPic-NNoUseInd,1);
		for i=1:NPic
			if ~any(NoUseIndVec==i)
				TakeInd=TakeInd+1;
				TakeVec(TakeInd)=i;
			end
		end
		MatMat=MatMat(TakeVec,:);
		[NPic,NonUse]=size(MatMat);
	end
	if GenderVal==1;		%All
		Mat=MatMat(:,1:5);
	elseif GenderVal==2;	%Females
		Mat=MatMat(:,6:10);
	elseif GenderVal==3;	%Males
		Mat=MatMat(:,11:15);
	end
	UseExtraRatingStatus=get(hIAPSMovieList(29),'Value');
	if UseExtraRatingStatus
		ExtRateVec=get(hIAPSMovieList(29),'Userdata');
		GoodExtRateIndVec=find(ExtRateVec>5);
		NPic=length(GoodExtRateIndVec);
	else
		GoodExtRateIndVec=[1:NPic];
	end
	global PicVec AroVec
	PicVec=Mat(GoodExtRateIndVec,1);
	ValVec=Mat(GoodExtRateIndVec,2);
	ValStdVec=Mat(GoodExtRateIndVec,3);
	AroVec=Mat(GoodExtRateIndVec,4);
	AroStdVec=Mat(GoodExtRateIndVec,5);

	[SortValVec,SortValIndVec]=sort(ValVec);
	[SortValStdVec,SortValStdIndVec]=sort(ValStdVec);
	[SortAroVec,SortAroIndVec]=sort(AroVec);
	[SortAroStdVec,SortAroStdIndVec]=sort(AroStdVec);
	
	MatMat=zeros(NPic,13);
	MatMat(:,1)=PicVec;
	
	MatMat(:,2)=ValVec;
	MatMat(:,3)=SortValVec;
 	MatMat(:,4)=SortValIndVec;
	
	MatMat(:,5)=ValStdVec;
	MatMat(:,6)=SortValStdVec;
 	MatMat(:,7)=SortValStdIndVec;
	
	MatMat(:,8)=AroVec;
	MatMat(:,9)=SortAroVec;
 	MatMat(:,10)=SortAroIndVec;
	
	MatMat(:,11)=AroStdVec;
	MatMat(:,12)=SortAroStdVec;
 	MatMat(:,13)=SortAroStdIndVec;
	
	set(hIAPSMovieList(2),'Userdata',MatMat);
	set(hIAPSMovieList(9),'Value',1,'String','1');

elseif strcmp(action,'UseExtraRating'),	

	hIAPSMovieList=get(hMenuFig,'Userdata');
	UseExtraRatingStatus=get(hIAPSMovieList(29),'Value');
	if ~UseExtraRatingStatus; 
		IAPSMovie('ReadData')
		return; 
	end
	[File,Path]=uigetfile('*.Rate','Look for IAPS rating file:');
	if File==0; return; end
	FilePath=[Path,File];
	RateMat=ReadData(FilePath,1,[],'ascii','ascii');
	set(hIAPSMovieList(29),'Userdata',RateMat(:,4));
	IAPSMovie('ReadData')

elseif strcmp(action,'ReadImage'),	

	hIAPSMovieList=get(hMenuFig,'Userdata');
	hPicFig=hIAPSMovieList(18);
	ImPath=get(hIAPSMovieList(4),'Userdata');
	[ImFile,ImPath,ImFilePath]=ReadFilePath([],[ImPath '*.jpg'],'Choose a jpg file:');
	if ImFile==0; return; end
	Tmp=ImFile(1:4);
	FileNo=Tmp(4)-48;
	FileNo=FileNo+(Tmp(3)-48).*10;
	FileNo=FileNo+(Tmp(2)-48).*100;
	FileNo=FileNo+(Tmp(1)-48).*1000;
	set(hIAPSMovieList(9),'Value',FileNo,'String',sprintf('%g',FileNo)); %StartPic
	set(hIAPSMovieList(10),'Value',FileNo);
	
	IAPSMovie('PlotImage')

elseif strcmp(action,'PlotImage'),	

	hIAPSMovieList=get(hMenuFig,'Userdata');
	hPicFig=hIAPSMovieList(18);
	hFuncFig=hIAPSMovieList(19);
	hMenuFig=hIAPSMovieList(20);
   	ImPath=get(hIAPSMovieList(4),'Userdata');
	PicVec=get(hIAPSMovieList(21),'Userdata');
	StartPic=get(hIAPSMovieList(9),'Value');%StartPic

	if ~isempty(PicVec)
		PicInd=find(PicVec==StartPic)
		NPic=length(PicVec);
		figure(hFuncFig);
   		clf;
		plot(PicVec);
		hold on
		plot(PicInd,PicVec(PicInd),'*r')
		xlabel('Movie Index');
		ylabel('Picture Number')
		axis([1 NPic min(PicVec) max(PicVec)])
		fprintf(['Picture Index: ',int2str(StartPic) '\n']);
	else
		fprintf(['Picture Index: ',int2str(StartPic) '\n']);
	end
	ImMat=imread([ImPath int2str(StartPic) '.jpg'],'jpg');
    figure(hPicFig);
	image(ImMat)
	axis('off');
   	pause(.01);

elseif strcmp(action,'ReadImagePath'),	

	hIAPSMovieList=get(hMenuFig,'Userdata');
	ImPath=get(hIAPSMovieList(4),'Userdata')
	if strcmp(ImPath,'0')
		if strcmp(computer,'MAC2')
     	 		ImPath=['IAPS_1-12' FileSep 'IAPS1_12' FileSep 'images' FileSep];
   		elseif strcmp(computer,'PCWIN')
      			ImPath=['D:\Iaps1_12' FileSep 'images' FileSep];
   		else
      			ImPath=[];
  		end
		if ~isdir(ImPath)
			ImPath=['Data:IAPS:AllPics:'];
			if ~isdir(ImPath)
				[ImFile,ImPath,ImFilePath]=ReadFilePath([],'*.jpg','Choose an image file:');
			end
		end
	else
		[ImFile,ImPath,ImFilePath]=ReadFilePath([],'*.jpg','Choose an image file:');
	end
	Message=char('Image Path:');
	Message=char(Message,'');
	Message=char(Message,ImPath);
	Message=char(Message,'');
	hmsgbox=msgbox(Message,'Info','help'); 		
	set(hIAPSMovieList(4),'Userdata',ImPath)
	
elseif strcmp(action,'SortByVal') | ...
		strcmp(action,'SortByAro')  | ...
		strcmp(action,'SortByRGBHSV') ,	

	hIAPSMovieList=get(hMenuFig,'Userdata');
	SortByValStatus=get(hIAPSMovieList(6),'Value');
	SortByAroStatus=get(hIAPSMovieList(7),'Value');
	SortByRGBHSVStatus=get(hIAPSMovieList(46),'Value');
	if SortByValStatus | SortByAroStatus
		SortByRGBHSVStatus=1;
		set(hIAPSMovieList(46),'Value',SortByRGBHSVStatus);
	end
	if SortByRGBHSVStatus~=1
		set(hIAPSMovieList(6),'Value',0);
		set(hIAPSMovieList(7),'Value',0);
		IAPSMovie('EasyMovie')
	end

elseif strcmp(action,'SetNCycle') | ...
		strcmp(action,'SetNPicPerCycle') | ...
		strcmp(action,'NIdentPic') | ...
		strcmp(action,'NRowCheck') | ...
		strcmp(action,'NColCheck') | ...
		strcmp(action,'SetNBasePic') | ...
		strcmp(action,'FileNumberOffset'),	

	hIAPSMovieList=get(hMenuFig,'Userdata');
	if strcmp(action,'SetNCycle')
		ListNo=14;
		MinNo=1;
	elseif strcmp(action,'SetNPicPerCycle')
		ListNo=16;
		MinNo=1;
	elseif strcmp(action,'NIdentPic')
		ListNo=38;
		MinNo=1;
	elseif strcmp(action,'NRowCheck')
		ListNo=43;
		MinNo=1;
	elseif strcmp(action,'NColCheck')
		ListNo=45;
		MinNo=1;
	elseif strcmp(action,'SetNBasePic')
		ListNo=50;
		MinNo=0;
	elseif strcmp(action,'FileNumberOffset')
		ListNo=52;
		MinNo=0;
	end
	v=get(hIAPSMovieList(ListNo),'Value');
	str=get(hIAPSMovieList(ListNo),'String');
	ind = find(abs(str)<32);
    	str(ind) = 32*ones(size(ind));
    	str = str';	
    	vv = eval(['[' str(:)' ']'],'-1')';
	vv=round(vv);
	if length(vv)~=1; vv=v; end
    	if vv<MinNo
		vv=v;
	end
	if strcmp(action,'SetNPicPerCycle') | strcmp(action,'SetNPicPerCycle')
		MovieFunction=get(hIAPSMovieList(12),'Value');
		if MovieFunction==4
			vv=round(vv./2).*2;
		end
	end
	set(hIAPSMovieList(ListNo),'Value',vv,'String',sprintf('%g',vv)); 

elseif strcmp(action,'StartPic'),	
	
	hIAPSMovieList=get(hMenuFig,'Userdata');
	StartPic=get(hIAPSMovieList(9),'Value');
	str=get(hIAPSMovieList(9),'String');
	Min=get(hIAPSMovieList(10),'Min');
	Max=get(hIAPSMovieList(10),'Max');

   	ind = find(abs(str)<32);
    	str(ind) = 32*ones(size(ind));
    	str = str';	
    	vv = eval(['[' str(:)' ']'],'-1')';
	vv=round(vv);
	if length(vv)~=1; vv=v; end
    	if vv<Min
		vv=Min;
	elseif vv>Max
		vv=Max;
	end
	set(hIAPSMovieList(9),'Value',vv,'String',sprintf('%g',vv)); 
	set(hIAPSMovieList(10),'Value',vv);

elseif strcmp(action,'StartPicSlider'),	
	
	hIAPSMovieList=get(hMenuFig,'Userdata');
	StartPic=get(hIAPSMovieList(10),'Value');
	StartPic=round(StartPic);
	set(hIAPSMovieList(10),'Value',StartPic);
	set(hIAPSMovieList(9),'Value',StartPic,'String',sprintf('%g',StartPic)); 

    
elseif strcmp(action,'MovieDir'),	

	hIAPSMovieList=get(hMenuFig,'Userdata');
	MovieDirVal=get(hIAPSMovieList(11),'Userdata');
	if MovieDirVal==1
		set(hIAPSMovieList(11),'Userdata',-1,'String','Direction: Down');
	else
		set(hIAPSMovieList(11),'Userdata',1,'String','Direction: Up');
   	end

elseif strcmp(action,'UseMultiples'),	

	hIAPSMovieList=get(hMenuFig,'Userdata');
	UseMultiplesVal=get(hIAPSMovieList(48),'Userdata')
	if UseMultiplesVal==1
		set(hIAPSMovieList(48),'Userdata',0,'String','No Multiples');
	else
		set(hIAPSMovieList(48),'Userdata',1,'String','Use Multiples');
   	end
 
elseif strcmp(action,'PauseMovie'),	
   
  	hIAPSMovieList=get(hMenuFig,'Userdata');
   	PauseMovieStatus=get(hIAPSMovieList(23),'Value'); 
	pause

elseif strcmp(action,'StopMovie'),	
   
   hIAPSMovieList=get(hMenuFig,'Userdata');
   set(hIAPSMovieList(22),'Value',1); %StopMovieStatus
      
elseif strcmp(action,'EasyMovie'),	
   
	hIAPSMovieList=get(hMenuFig,'Userdata');
	set(hIAPSMovieList(22),'Value',0); %StopMovieStatus
	StartPic=get(hIAPSMovieList(10),'Value');
	MovieDirVal=get(hIAPSMovieList(11),'Userdata');
	hPicFig=hIAPSMovieList(18);
	hFuncFig=hIAPSMovieList(19);
	hMenuFig=hIAPSMovieList(20);
   	ImPath=get(hIAPSMovieList(4),'Userdata');
	PicVec=get(hIAPSMovieList(21),'Userdata');
    [DefFilePath]=SetDefPath('r','*')
	[PicVec,File,Path,FilePath]=ReadAscii([],'Choose a pic number ascii file:',[],[],DefFilePath,'*');
	if File==0; return; end
	SetDefPath('w',Path);
	set(hIAPSMovieList(21),'Userdata',PicVec);
 	if isempty(PicVec)
		ImFilesStruct=dir(ImPath);
		[NPic,NonUse]=size(ImFilesStruct);
		if strcmp(computer,'PCWIN')
			StartInd=3,
			EndInd=NPic;
			NPic=NPic-2;
		else
			StartInd=1,
			EndInd=NPic;
		end
		PicVec=zeros(1,NPic);
		for i=StartInd:EndInd
			Tmp=getfield(ImFilesStruct(i),'name');
			Tmp=Tmp(1:4);
			FileNo=Tmp(4)-48;
			FileNo=FileNo+(Tmp(3)-48).*10;
			FileNo=FileNo+(Tmp(2)-48).*100;
			FileNo=FileNo+(Tmp(1)-48).*1000;
			PicVec(i-StartInd+1)=FileNo;
		end
         set(hIAPSMovieList(21),'Userdata',PicVec);
  	 end
  	 if MovieDirVal==1
     	PicIndVec=find(PicVec>=StartPic);
   	else
      	PicIndVec=find(PicVec<=StartPic);
	end
	if isempty(PicIndVec)
		Message=char('Sorry,');
		Message=char(Message,'no remaining pictures using the given parameters.');
		Message=char(Message,'');
		Message=char(Message,'Change "Movie direction" or "Start at file number" ');
		hmsgbox=msgbox(Message,'Info','help'); 
		return;
	end
   	PicVecTmp=PicVec(PicIndVec)
  	NPic2Show=length(PicVecTmp)
	set(hIAPSMovieList(12),'Value',1); %MovieFunction==linear
	set(hIAPSMovieList(14),'Value',1,'String','1'); %Number of cycles
	set(hIAPSMovieList(16),'Value',NPic2Show,'String',int2str(NPic2Show)); %Pictures per cycle
	set(hIAPSMovieList(6),'Value',0); %SortByValStatus
	set(hIAPSMovieList(7),'Value',0); %SortByAroStatus
	IAPSMovie('RunMovie');
 
elseif strcmp(action,'SaveMovie'),	

	hIAPSMovieList=get(hMenuFig,'Userdata');
	[File,Path,FilePath]=WriteFilePath('Untitled.PNV','Save movie to file:');
	if File==0; return; end
	PicNameVec=get(hIAPSMovieList(26),'Userdata');
	SaveData(round(PicNameVec'),FilePath,1,[],'ascii','ascii',[],[],[],[],[],0);

elseif strcmp(action,'setPrint2FileStatus'),

	hIAPSMovieList=get(hMenuFig,'Userdata');
	Print2FileStatus=get(hIAPSMovieList(30),'Value');
	Print2FileMethodString=get(hIAPSMovieList(31),'Userdata');

	if Print2FileStatus		
		[Print2File,Print2Path,Print2FilePath]=WriteFilePath([],['Choose path (No blanks):']);
		if Print2File==0; 
			set(hIAPSMovieList(30),'Value',0);
			return;
		end
		BlankVec=findstr(Print2Path,' ');
		if ~isempty(BlankVec)
			set(hIAPSMovieList(30),'Value',0);
			Message=char('Sorry,');
			Message=char(Message,'');
			Message=char(Message,'your chosen path:');
			Message=char(Message,Print2Path);
			Message=char(Message,'contains one or more blanks.');
			Message=char(Message,'');
			Message=char(Message,'Using the Matlab function "print"');
			Message=char(Message,'blanks in the path are not permitted.');
			Message=char(Message,'');
			hmsgbox=msgbox(Message,'Info','help'); 
			return;
		end	
		set(hIAPSMovieList(30),'Userdata',Print2Path); 
	end
	
elseif strcmp(action,'setPrint2FileMethod'),

	hIAPSMovieList=get(hMenuFig,'Userdata');
	Print2FileMethod=get(hIAPSMovieList(31),'Value');
	if Print2FileMethod==1; 	Print2FileMethodString='EPS';
		Print2FileCompVal=100;
	elseif Print2FileMethod==2; Print2FileMethodString='EPSTIFF';
		Print2FileCompVal=100;
	elseif Print2FileMethod==3; Print2FileMethodString='JPEG';
		Print2FileCompVal=80;
	elseif Print2FileMethod==4; Print2FileMethodString='TIFF';
		Print2FileCompVal=150; 	
	end
	set(hIAPSMovieList(31),'Userdata',Print2FileMethodString);

elseif strcmp(action,'CalEyeTrack'),	

	hIAPSMovieList=get(hMenuFig,'Userdata');
	set(hIAPSMovieList(56),'Value',0); %EyeTrackStatus
	EyeTrackCalStatus=get(hIAPSMovieList(53),'Value');
	if EyeTrackCalStatus
		set(hIAPSMovieList(6),'Value',0);				%SortByVal
		set(hIAPSMovieList(7),'Value',0);				%SortByAro
		set(hIAPSMovieList(14),'Value',1,'String','1');	%NCycle
		set(hIAPSMovieList(38),'Value',1,'String','1');	%NIdentPic
		
		DefFilePath=SetDefPath('r','*.xy.*');
		[xy,xyFile,xyPath,xyFilePath]=ReadAscii([],'Read xy from file',[],[],[],DefFilePath);%'Paul:Data:EEG:ET:C1:ET00C1.xy.txt'
		xy=xy';
		SetDefPath('w',xyPath);
		DefFilePath=SetDefPath('r','*.et.mat');
		[ETMat,ETFilePath,SizeETMat,NDim,Version]=ReadNDimData([],'float32',DefFilePath,'Choose an .et.mat file:');%'Paul:Data:EEG:ET:C1:ET00C1.et.mat'
		NTrials=SizeETMat(1)
		TrialVec=[1:2:NTrials];
		ETMat=ETMat(TrialVec,:,:);
		xy=xy(TrialVec,:);
		NTrials=length(TrialVec)
		NChan=SizeETMat(2)
		NPoints=SizeETMat(3)
		TrigPoint=50;
		x=xy(:,1);
		y=xy(:,2);
		x=x./640;
		y=y./480;
		
		EtBaseStart=11;
		EtBaseEnd=  40;		
		ETMatTmp=ETMat;
		for i=1:NTrials
			ETMatTmp(i,:,:)=CalcBaseline(squeeze(ETMat(i,:,:)),EtBaseStart,EtBaseEnd);
		end
		XPlotVec=[-TrigPoint+1:NPoints-TrigPoint];
		ETMat=ETMatTmp;
		
		ETMatX=squeeze(ETMat(:,1,:));
		ETMatY=squeeze(ETMat(:,2,:));
		ETStart=350;
		ETEnd=  450;
		hETFig=figure('Units','normal','Position',[.5 0 .5 1], 'Name','Calibration of Eye Tracking:', 'NumberTitle','off');
		subplot(2,1,1)
		
		plot(XPlotVec,ETMatX')
		hold on
		plot([0 0],[-2000 2000],'--k'); %TrigPoint
		plot([EtBaseStart-TrigPoint EtBaseStart-TrigPoint],[-2000 2000],'--g')
		plot([EtBaseEnd-TrigPoint EtBaseEnd-TrigPoint],[-2000 2000],'--g')
		plot([ETStart-TrigPoint ETStart-TrigPoint],[-2000 2000],'--r')
		plot([ETEnd-TrigPoint ETEnd-TrigPoint],[-2000 2000],'--r')
		axis([XPlotVec(1) XPlotVec(end) -1500 1500])
		hold off
		xlabel('Time []')
		ylabel('Potential []')
		title('Eye movement in horzontal (x) direction')
		
		subplot(2,1,2)
		plot(XPlotVec,ETMatY')
		hold on
		plot([0 0],[-2000 2000],'--k'); %TrigPoint
		plot([EtBaseStart-TrigPoint EtBaseStart-TrigPoint],[-2000 2000],'--g')
		plot([EtBaseEnd-TrigPoint EtBaseEnd-TrigPoint],[-2000 2000],'--g')
		plot([ETStart-TrigPoint ETStart-TrigPoint],[-2000 2000],'--r')
		plot([ETEnd-TrigPoint ETEnd-TrigPoint],[-2000 2000],'--r')
		axis([XPlotVec(1) XPlotVec(end) -750 750])
		hold off
		xlabel('Time []')
		ylabel('Potential []')
		title('Eye movement in vertical (y) direction')
		
		MeanETVecX=mean(ETMatX(:,ETStart:ETEnd),2);
		StdETVecX=std(ETMatX(:,ETStart:ETEnd),0,2);
		MeanStdETVecX=mean(StdETVecX);
		StdStdETVecX=std(StdETVecX);
		StdUpLimX=MeanStdETVecX+2.*StdStdETVecX;
		ETVecStdXUpLimInd=find(StdETVecX>StdUpLimX)
		
		MeanETVecY=mean(ETMatY(:,ETStart:ETEnd),2);
		StdETVecY=std(ETMatY(:,ETStart:ETEnd),0,2);
		MeanStdETVecY=mean(StdETVecY);
		StdStdETVecY=std(StdETVecY);
		StdUpLimY=MeanStdETVecY+2.*StdStdETVecY;
		ETVecStdYUpLimInd=find(StdETVecY>StdUpLimY)
		
		hETFig=figure('Units','normal','Position',[0 0 .5 1], 'Name','Calibration of Eye Tracking:', 'NumberTitle','off');
		
		subplot(4,1,1)
		plot(StdETVecX)
		hold on
		plot([1 NTrials],[MeanStdETVecX MeanStdETVecX],'b--')
		plot([1 NTrials],[StdUpLimX StdUpLimX],'r--')
		if length(ETVecStdXUpLimInd)>0
			plot(ETVecStdXUpLimInd,StdETVecX(ETVecStdXUpLimInd),'*r')
		end
		axis([1 NTrials 0 1.1.*max(StdETVecX)])
		xlabel('Trial #')
		ylabel('Std of x-ET within time interval') 
		
		subplot(4,1,2)
		plot(StdETVecY)
		hold on
		plot([1 NTrials],[MeanStdETVecY MeanStdETVecY],'b--')
		plot([1 NTrials],[StdUpLimY StdUpLimY],'r--')
		if length(ETVecStdYUpLimInd)>0
			plot(ETVecStdYUpLimInd,StdETVecY(ETVecStdYUpLimInd),'*r')
		end
		axis([1 NTrials 0 1.1.*max(StdETVecY)])
		xlabel('Trial #')
		ylabel('Std of y-ET within time interval') 
		
		TakeVecX=ones(NTrials,1);
		TakeVecX(ETVecStdXUpLimInd)=zeros(size(ETVecStdXUpLimInd));
		TakeVecX=find(TakeVecX);
		
		TakeVecY=ones(NTrials,1);
		TakeVecY(ETVecStdYUpLimInd)=zeros(size(ETVecStdYUpLimInd));
		TakeVecY=find(TakeVecY);
		
		x=x(TakeVecX);
		y=y(TakeVecY);
		MeanETVecX=MeanETVecX(TakeVecX);
		MeanETVecY=MeanETVecY(TakeVecY);
		[xs,xsi]=sort(x);
		[ys,ysi]=sort(y);
		PolyFitDegree=2;
		rx=polyfit(MeanETVecX,x,PolyFitDegree);
		ry=polyfit(MeanETVecY,y,PolyFitDegree);
		
		Pfx=polyval(rx,MeanETVecX);
		Pfy=polyval(ry,MeanETVecY);
		Diffx=Pfx-x;
		Diffy=Pfy-y;
		
		subplot(4,1,3)
		plot(TakeVecX,x(xsi),'g')
		hold on
		plot(TakeVecX,Pfx(xsi),'b--')
		plot(TakeVecX,Diffx(xsi),'r')
		xlabel('Trial #')
		ylabel('Polyfit of x') 
		
		subplot(4,1,4)
		plot(TakeVecY,y(ysi),'g')
		hold on
		plot(TakeVecY,Pfy(ysi),'b--')
		plot(TakeVecY,Diffy(ysi),'r')
		xlabel('Trial #')
		ylabel('Polyfit of y')		
		
		set(hIAPSMovieList(54),'Userdata',rx)
		set(hIAPSMovieList(55),'Userdata',ry)
 		set(hIAPSMovieList(57),'Userdata',ETMat)
	else
		set(hIAPSMovieList(54),'Userdata',[])
		set(hIAPSMovieList(55),'Userdata',[])
		set(hIAPSMovieList(57),'Userdata',[])
	end

elseif strcmp(action,'EyeTrack'),	

	hIAPSMovieList=get(hMenuFig,'Userdata');
	EyeTrackStatus=get(hIAPSMovieList(56),'Value');
	if EyeTrackStatus
		set(hIAPSMovieList(6),'Value',0);			%SortByVal
		set(hIAPSMovieList(7),'Value',0);			%SortByAro
		set(hIAPSMovieList(14),'Value',1,'String','1');	%NCycle
		set(hIAPSMovieList(38),'Value',1,'String','1');	%NIdentPic
		rx=get(hIAPSMovieList(54),'Userdata')
		ry=get(hIAPSMovieList(55),'Userdata')
		
		DefFilePath=SetDefPath('r','*.IAPS.txt')	
		[AllPicVec,File,Path,FilePath]=ReadAscii([],'Read IAPS # vector from file:',[],[],[],DefFilePath); %'Paul:Data:EEG:ET:R1:ET00R1.IAPS.txt'
		if File==0; return; end
		NPic=length(AllPicVec);
		set(hIAPSMovieList(16),'Value',NPic,'String',int2str(NPic));	%NPicPerCycle
		set(hIAPSMovieList(21),'Userdata',AllPicVec);
		SetDefPath('w',Path);
		DefFilePath=SetDefPath('r','*.et.mat');
		[ETMat,ETFilePath,SizeETMat,NDim,Version]=ReadNDimData([],'float32',DefFilePath,'Choose an .et.mat file:');%'Paul:Data:EEG:ET:R1:ET00R1.et.mat'
		if isempty(ETMat); return; end
		[ETFile,ETPath]=SepFilePath(ETFilePath);
		NTrials=SizeETMat(1);
		NChan=SizeETMat(2);
 		NPoints=SizeETMat(3);
		SacMat=zeros(NTrials,13); %Index; IAPSPicNo; Val; Aro; StdBase; StdTime; TimeFirstSac; AmpFirstSac; NSac; SumSac; MaxSac; RadFirstSac; PhiFirstSac
		RatMat=[];
		if all(AllPicVec>999) 	%No Calibration
			ImPath='Data:IAPS:AllPics:'
			NEyeTrackPoints=1500
			NEyeTrackBasePoints=99;
			RatMat=GetIAPSRatings(AllPicVec);
			SacMat(:,1)=[1:NTrials]';
			SacMat(:,2:4)=RatMat;
			EtBaseStart=60;
			EtBaseEnd= 90;	
		else					%Calibration
			ImPath=[ETPath,'Jpg',filesep]
			TrialVec=[1:2:NTrials];
			ETMat=ETMat(TrialVec,:,:);
			NTrials=length(TrialVec);
			NEyeTrackPoints=450; 
			NEyeTrackBasePoints=49;
			EtBaseStart=1;
			EtBaseEnd= 49;	
		end
		set(hIAPSMovieList(4),'Userdata',ImPath);
		ETMatTmp=ETMat;
		for i=1:NTrials
			ETMatTmp(i,:,:)=CalcBaseline(squeeze(ETMat(i,:,:)),EtBaseStart,EtBaseEnd);
		end
		ETMat=ETMatTmp;
% 		hETFig=figure('Units','normal','Position',[0 0 .5 1], 'Name','Eye Tracking:', 'NumberTitle','off');
		for i=1:NTrials
% 			subplot(2,1,1)
			Tmpx=squeeze(ETMat(i,1,:));
			Tmpy=squeeze(ETMat(i,2,:));
% 			plot(Tmpx)
% 			hold on
% 			plot(Tmpy,'r')
% 			hold off
			Tmpx=polyval(rx,Tmpx);
			Tmpy=polyval(ry,Tmpy);
% 			subplot(2,1,2)
% 			plot(Tmpx)
% 			hold on
% 			plot(Tmpy,'r')
% 			hold off
% 			pause
			ETMatTmp(i,1,:)=Tmpx;
			ETMatTmp(i,2,:)=Tmpy;
		end
		ETMat=ETMatTmp;
		set(hIAPSMovieList(58),'Userdata',ETMat);
		%======================================================================
		SampRate=500;
		Nyquist=SampRate./2;
		LowN=6;
		[BLow,ALow]=butter(LowN,.1,'low');
		for Ind=1:NTrials
			EyeTrackMat=zeros(6,size(ETMat,3));
			EyeTrackMat(1:2,:)=squeeze(ETMat(Ind,:,:));
			a=find(EyeTrackMat(2,:)>0.5);
			EyeTrackMat(1,a)=EyeTrackMat(1,a)+.5.*(EyeTrackMat(2,a)-0.5);
			EyeTrackMat(3,:)=filtfilt(BLow,ALow,gradient(EyeTrackMat(1,:)));
			EyeTrackMat(4,:)=filtfilt(BLow,ALow,gradient(EyeTrackMat(2,:)));
			EyeTrackMat(5,:)=sqrt(EyeTrackMat(3,:).^2+EyeTrackMat(4,:).^2);
			EyeTrackMat(6,:)=sqrt(EyeTrackMat(1,:).^2+EyeTrackMat(2,:).^2);
			
			StdBase=std(EyeTrackMat(6,1:NEyeTrackBasePoints));
			StdTime=std(EyeTrackMat(6,NEyeTrackBasePoints+1:end));
			%SacMat: Index IAPSPicNo; Val; Aro; StdBase; StdTime; TimeFirstSac; AmpFirstSac; NSac; SumSac; MaxSac; RadFirstSac; PhiFirstSac
			SacMat(Ind,5)=StdBase; 				%StdBase
			SacMat(Ind,6)=StdTime;					%StdTime
			SacMat(Ind,11)=max(EyeTrackMat(6,:));	%MaxSac
			
			LimX=0.004;
			LimY=0.004;
			LimXY=sqrt(LimX.^2+LimY.^2);
			
			SupLimX=find(abs(EyeTrackMat(3,:))>LimX);
			TmpX=find(SupLimX>NEyeTrackBasePoints);
			SupLimX=SupLimX(TmpX);
			IndX2=find(diff(SupLimX)-1);
			IndX1=[1,IndX2+1];
			for i=1:length(IndX2)
				[NonUse,RelMaxIndX(i)]=max(abs(EyeTrackMat(3,SupLimX(IndX1(i)):SupLimX(IndX2(i)))));
				RelMaxIndX(i)=RelMaxIndX(i)+SupLimX(IndX1(i))-1;
			end
		
			SupLimY=find(abs(EyeTrackMat(4,:))>LimY);
			TmpY=find(SupLimY>NEyeTrackBasePoints);
			SupLimY=SupLimY(TmpY);
			IndY2=find(diff(SupLimY)-1);
			IndY1=[1,IndY2+1];
			for i=1:length(IndY2)
				[NonUse,RelMaxIndY(i)]=max(abs(EyeTrackMat(4,SupLimY(IndY1(i)):SupLimY(IndY2(i)))));
				RelMaxIndY(i)=RelMaxIndY(i)+SupLimY(IndY1(i))-1;
			end
		
			SupLimXY=find(EyeTrackMat(5,:)>LimXY);
			TmpXY=find(SupLimXY>NEyeTrackBasePoints);
			SupLimXY=SupLimXY(TmpXY);
			IndXY2=find(diff(SupLimXY)-1);
			IndXY1=[1,IndXY2+1];
			RelMaxAmpXY=[];
			RelMaxIndXY=[];
			FirstSacTime=[];
			for i=1:length(IndXY2)
				[RelMaxAmpXY(i),RelMaxIndXY(i)]=max(EyeTrackMat(5,SupLimXY(IndXY1(i)):SupLimXY(IndXY2(i))));
				RelMaxIndXY(i)=RelMaxIndXY(i)+SupLimXY(IndXY1(i))-1;
			end
			NSac=length(RelMaxIndXY);
			if NSac>0
				TimeFirstSac=(RelMaxIndXY(1)-NEyeTrackBasePoints+1).*2;
				SacMat(Ind,7)=TimeFirstSac;			%TimeFirstSac
				SacMat(Ind,8)=RelMaxAmpXY(1);	%AmpFirstSac
				SacMat(Ind,9)=NSac;				%NSac
				SacMat(Ind,10)=sum(RelMaxAmpXY); 	%SumSac
				FirstSacStart=RelMaxIndXY(1)+10;
				FirstSacEnd=FirstSacStart+60;
				if length(RelMaxIndXY)>2
					FirstSacEnd=min([RelMaxIndXY(2),FirstSacEnd]);
				end
				FirstSacMean=mean(EyeTrackMat(1:2,FirstSacStart:FirstSacEnd),2)-0.5;
				FirstSacMeanX=FirstSacMean(1);
				FirstSacMeanY=FirstSacMean(2);
				SacMat(Ind,12)=sqrt(sum(FirstSacMean.^2));
				SacMat(Ind,13)=atan2(FirstSacMean(2),FirstSacMean(1)); %PhiFirstSac; Four quadrant inverse tangent
				SacMat(Ind,13)=(SacMat(Ind,13)./pi).*180;
			end	
		end
		AroVec=SacMat(:,4);
		NSacVec=SacMat(:,9);
		SumSacVec=SacMat(:,10);
		MaxSacVec=SacMat(:,11);
		MedMaxSac=median(MaxSacVec);
		StdMaxSac=std(MaxSacVec);
		LimMaxSac=MedMaxSac+0.5.*StdMaxSac;
		TakeIndVec=find(MaxSacVec<=LimMaxSac);
		NotTakeIndVec=find(MaxSacVec>LimMaxSac);
		TakeNTrials=length(TakeIndVec);
		TakeNTrials3=floor(TakeNTrials./3);
		
		hEyeTrack=figure('Units','normal','Position',[0 .5 .5 .5], 'Name','Artifacts based on maximum saccade amplitude:', 'NumberTitle','off')
		plot(MaxSacVec)
		hold on
		plot([1 NTrials],[LimMaxSac LimMaxSac],'r--')
		if length(NotTakeIndVec)>0
			plot(NotTakeIndVec,MaxSacVec(NotTakeIndVec),'*')
		end
		axis([1 NTrials 0 1.1.*max(MaxSacVec)])
		title(['TakeNTrials: ',int2str(TakeNTrials),'; NotTakeNTrials: ',int2str(NTrials-TakeNTrials),'; TakeNTrials3: ',int2str(TakeNTrials3)])
		xlabel('Trial number')
		ylabel('Amplitude')
		hold off
		
		TakeAroVec=AroVec(TakeIndVec);
		[SortTakeAroVec,SortTakeAroIndVec]=sort(TakeAroVec);
		SortTakeAroIndVec=TakeIndVec(SortTakeAroIndVec);
		AroConVec=10.*ones(NTrials,1);
		AroConVec(SortTakeAroIndVec)=12.*ones(TakeNTrials,1);
		AroConVec(SortTakeAroIndVec(1:TakeNTrials3))=11.*ones(TakeNTrials3,1);
		AroConVec(SortTakeAroIndVec(TakeNTrials-TakeNTrials3+1:TakeNTrials))=13.*ones(TakeNTrials3,1);
		AroConFilePath=[ETPath,ETFile(1:6),'.Aro.con'];
		SaveAscii(AroConVec,AroConFilePath);
		
		TakeNSacVec=NSacVec(TakeIndVec);
		[SortTakeNSacVec,SortTakeNSacIndVec]=sort(TakeNSacVec);
		SortTakeNSacIndVec=TakeIndVec(SortTakeNSacIndVec);
		NSacConVec=20.*ones(NTrials,1);
		NSacConVec(SortTakeAroIndVec)=22.*ones(TakeNTrials,1);
		NSacConVec(SortTakeNSacIndVec(1:TakeNTrials3))=21.*ones(TakeNTrials3,1);
		NSacConVec(SortTakeNSacIndVec(TakeNTrials-TakeNTrials3+1:TakeNTrials))=23.*ones(TakeNTrials3,1);
		NSacConFilePath=[ETPath,ETFile(1:6),'.NSac.con'];
		SaveAscii(NSacConVec,NSacConFilePath);
		
		TakeSumSacVec=SumSacVec(TakeIndVec);
		[SortTakeSumSacVec,SortTakeSumSacIndVec]=sort(TakeSumSacVec);
		SortTakeSumSacIndVec=TakeIndVec(SortTakeSumSacIndVec);
		SumSacConVec=30.*ones(NTrials,1);
		SumSacConVec(SortTakeSumSacIndVec)=32.*ones(TakeNTrials,1);
		SumSacConVec(SortTakeSumSacIndVec(1:TakeNTrials3))=31.*ones(TakeNTrials3,1);
		SumSacConVec(SortTakeSumSacIndVec(TakeNTrials-TakeNTrials3+1:TakeNTrials))=33.*ones(TakeNTrials3,1);
		SumSacConFilePath=[ETPath,ETFile(1:6),'.SumSac.con'];
		SaveAscii(SumSacConVec,SumSacConFilePath);
		
		TakeSumSacInvAroVec=TakeSumSacVec.*(max(TakeAroVec)-TakeAroVec);
		[SortTakeSumSacInvAroVec,SortTakeSumSacInvAroIndVec]=sort(TakeSumSacInvAroVec);
		SortTakeSumSacInvAroIndVec=TakeIndVec(SortTakeSumSacInvAroIndVec);
		SumSacInvAroConVec=40.*ones(NTrials,1);
		SumSacInvAroConVec(SortTakeSumSacInvAroIndVec)=42.*ones(TakeNTrials,1);
		SumSacInvAroConVec(SortTakeSumSacInvAroIndVec(1:TakeNTrials3))=41.*ones(TakeNTrials3,1);
		SumSacInvAroConVec(SortTakeSumSacInvAroIndVec(TakeNTrials-TakeNTrials3+1:TakeNTrials))=43.*ones(TakeNTrials3,1);
		SumSacInvAroConFilePath=[ETPath,ETFile(1:6),'.SumSacInvAro.con'];
		SaveAscii(SumSacInvAroConVec,SumSacInvAroConFilePath);
		%===============================================================================
		
		SacFilePath=[ETPath,ETFile(1:6),'.SacMat.txt']
		Header='Index IAPS Val Aro StdBase StdTime FOT FOA NSac SumSac MaxSac RadFirstSac PhiFirstSac';
		SaveAscii(SacMat,SacFilePath,[],0,Header)		
	else
		set(hIAPSMovieList(58),'Userdata',[]);
	end

		
elseif strcmp(action,'RunMovie'),	

	hIAPSMovieList=get(hMenuFig,'Userdata');
	ImPath=get(hIAPSMovieList(4),'Userdata');
	GenderVal=get(hIAPSMovieList(1),'Value');
	SortByValStatus=get(hIAPSMovieList(6),'Value');
	SortByAroStatus=get(hIAPSMovieList(7),'Value');
	SortByRGBHSVStatus=get(hIAPSMovieList(46),'Value');
	RGBHSVStrMat=get(hIAPSMovieList(46),'Userdata');
	StartPic=get(hIAPSMovieList(10),'Value');
	MovieDirVal=get(hIAPSMovieList(11),'Userdata');
	MovieFunction=get(hIAPSMovieList(12),'Value');
	hPicFig=hIAPSMovieList(18);
	hFuncFig=hIAPSMovieList(19);
	hMenuFig=hIAPSMovieList(20);
	hRateMenuFig=hIAPSMovieList(25);
	RatePictureStatus=get(hIAPSMovieList(24),'Value');
	ReadMovieStatus=get(hIAPSMovieList(27),'Value')
	MovieLogMat=get(hIAPSMovieList(27),'Userdata');
	UseExtraRatingStatus=get(hIAPSMovieList(29),'Value');
	Print2FileStatus=get(hIAPSMovieList(30),'Value');
	ColorStatus=get(hIAPSMovieList(32),'Value');
	BrightStatus=get(hIAPSMovieList(33),'Value');
    RandPixelInd=get(hIAPSMovieList(35),'Value');
	RandPixelVec=get(hIAPSMovieList(35),'Userdata');
    RandPixelVal=RandPixelVec(RandPixelInd);
	CheckStatus=get(hIAPSMovieList(41),'Value');
	NRowCheck=get(hIAPSMovieList(43),'Value');
	NColCheck=get(hIAPSMovieList(45),'Value');
	Print2Path=get(hIAPSMovieList(30),'Userdata');
	CorrectValAroStatus=get(hIAPSMovieList(47),'Value');
	NBasePic=get(hIAPSMovieList(50),'Value');
	EyeTrackCalStatus=get(hIAPSMovieList(53),'Value');
	EyeTrackStatus=get(hIAPSMovieList(56),'Value');

	if EyeTrackStatus | EyeTrackCalStatus
		
		SampRate=500;
		Nyquist=SampRate./2;
		ETMat=get(hIAPSMovieList(58),'Userdata');
		NTrials=size(ETMat,1)
		NChan=size(ETMat,2)
 		NPoints=size(ETMat,3)
		if NPoints==500
	 		NEyeTrackPoints=450; %1500
			NEyeTrackBasePoints=49;
		else
			NEyeTrackPoints=1500
			NEyeTrackBasePoints=99;
		end
		xPlotVec=[-NEyeTrackBasePoints:NEyeTrackPoints].*2;
		NEyeTrackPoints2Show=NEyeTrackPoints+NEyeTrackBasePoints+1;
		ColorMat=flipud(jet(NEyeTrackPoints-50));
		ColorMatOnes=ones(NEyeTrackBasePoints+51,3);
		ColorMat=[ColorMatOnes;ColorMat];
		hEyeTrack=figure('Units','normal','Position',[.8 0 .2 .8], 'Name','Eye Tracking:', 'NumberTitle','off');
		NEyeTrackHorPix=1200;
		NEyeTrackVertPix=901;
		ColorPointFak=1;
		LowN=6;
		[BLow,ALow]=butter(LowN,.1,'low');
	end
	if Print2FileStatus
		Print2FileMethodString=get(hIAPSMovieList(31),'Userdata');
		Print2FileCompVal=100;
	end
	
	if (~SortByValStatus & ~SortByAroStatus) | EyeTrackStatus | EyeTrackCalStatus %EasyMovie

		AllPicVec=get(hIAPSMovieList(21),'Userdata');
		NAllPic=length(AllPicVec);
		PicVec=AllPicVec;
		NPic=NAllPic;

	elseif SortByValStatus | SortByAroStatus

		MatMat=get(hIAPSMovieList(2),'Userdata');
		[NAllPic,NRow]=size(MatMat)
		AllPicVec=MatMat(:,1);
		NPic=NAllPic;

		NCycle=get(hIAPSMovieList(14),'Value');
		NPicPerCycle=get(hIAPSMovieList(16),'Value');
		UseRandPermStatus=get(hIAPSMovieList(28),'Value');

		PicVec=MatMat(:,1);
		ValVec=MatMat(:,2);
		SortValVec=MatMat(:,3);
		SortValIndVec=MatMat(:,4);

		ValStdVec=MatMat(:,5);
		SortValStdVec=MatMat(:,6);
		SortValStdIndVec=MatMat(:,7);
	
		AroVec=MatMat(:,8);
		SortAroVec=MatMat(:,9);
		SortAroIndVec=MatMat(:,10);

		AroStdVec=MatMat(:,11);
		SortAroStdVec=MatMat(:,12);
		SortAroStdIndVec=MatMat(:,13);
		
		%======================================================================================
		if GenderVal~=1 & CorrectValAroStatus & ~ReadMovieStatus
			Message=char('Change Valence and Arousal values of erotic ');
			if GenderVal==2
				Message=char(Message,'females to mean values of erotic males.');
			elseif GenderVal==3
				Message=char(Message,'males to mean values of erotic females.');
			end
			Message=char(Message,'');
			Message=char(Message,'Select the file "IAPSAllPicNames" to get the picture names.');
			hmsgbox=msgbox(Message,'Info:','help'); pause(.1)
	 		[NameFile,NamePath,NameFilePath]=ReadFilePath([],['IAPSAllPicNames'],'Select name file:');
			if NameFile==0; return; end
			fid=fopen(NameFilePath,'r');
			for i=1:716
				[Tmp,Count]=fscanf(fid,'%s',1); 
				if i==1
					Name=char(Tmp);
				else
					Name=char(Name,Tmp);
				end
			end
			PicVecTmp=fscanf(fid,'%g',[716,1]);
			fclose(fid);
			Name=lower(Name);
			MInd=0;MIndVec=[];
			FInd=0; FIndVec=[];
			for i=1:716
				a=findstr(Name(i,:),'eroticmale');
				if ~isempty(a)
					MInd=MInd+1;
					MIndVec(MInd)=i;
				end
				a=findstr(Name(i,:),'attractiveman');
				if ~isempty(a)
					MInd=MInd+1;
					MIndVec(MInd)=i;
				end
				a=findstr(Name(i,:),'maledancer');
				if ~isempty(a)
					MInd=MInd+1;
					MIndVec(MInd)=i;
				end
				a=findstr(Name(i,:),'eroticfemale');
				if ~isempty(a)
					FInd=FInd+1;
					FIndVec(FInd)=i;
				end
				a=findstr(Name(i,:),'attractivefem');
				if ~isempty(a)
					FInd=FInd+1;
					FIndVec(FInd)=i;
				end
			end
			TestVec=PicVecTmp(MIndVec)
			for Ind=1:length(FIndVec)
				FemIndVec(Ind)=find(PicVec==PicVecTmp(FIndVec(Ind)));
			end
			for Ind=1:length(MIndVec)
				MalIndVec(Ind)=find(PicVec==PicVecTmp(MIndVec(Ind)));
			end	

			if GenderVal==2		%Female
				fprintf('Female erotic picture names:\n\n'); disp(Name(FIndVec,:));fprintf('\n\n')
				fprintf('Female erotic picture IAPS numbers:\n\n');disp(PicVec(FemIndVec)');fprintf('\n\n')
				fprintf('Female erotic picture valence values:\n\n'); disp(ValVec(FemIndVec)');fprintf('\n\n')
				fprintf('Female erotic picture arousal values:\n\n');disp(AroVec(FemIndVec)');fprintf('\n\n')
				ValVec(FemIndVec)=mean(ValVec(MalIndVec)).*ones(size(ValVec(FemIndVec)));
				ValStdVec(FemIndVec)=mean(ValStdVec(MalIndVec)).*ones(size(ValStdVec(FemIndVec)));
				AroVec(FemIndVec)=mean(AroVec(MalIndVec)).*ones(size(AroVec(FemIndVec)));
				AroStdVec(FemIndVec)=mean(AroStdVec(MalIndVec)).*ones(size(AroStdVec(FemIndVec)));
				fprintf('Corrected female erotic picture valence values:\n\n'); disp(ValVec(FemIndVec)');fprintf('\n\n')
				fprintf('Corrected female erotic picture arousal values:\n\n');disp(AroVec(FemIndVec)')
			elseif GenderVal==3		%Male
				fprintf('Male erotic picture names:\n\n'); disp(Name(MIndVec,:));fprintf('\n\n')
				fprintf('Male erotic picture IAPS numbers:\n\n');disp(PicVec(MalIndVec)');fprintf('\n\n')
				fprintf('Male erotic picture valence values:\n\n'); disp(ValVec(MalIndVec)');fprintf('\n\n')
				fprintf('Male erotic picture arousal values:\n\n');disp(AroVec(MalIndVec)');fprintf('\n\n')
				ValVec(MalIndVec)=mean(ValVec(FemIndVec)).*ones(size(ValVec(MalIndVec)));
				ValStdVec(MalIndVec)=mean(ValStdVec(FemIndVec)).*ones(size(ValStdVec(MalIndVec)));
				AroVec(MalIndVec)=mean(AroVec(FemIndVec)).*ones(size(AroVec(MalIndVec)));
				AroStdVec(MalIndVec)=mean(AroStdVec(FemIndVec)).*ones(size(AroStdVec(MalIndVec)));	
				fprintf('Corrected male erotic picture valence values:\n\n'); disp(ValVec(MalIndVec)');fprintf('\n\n')
				fprintf('Corrected male erotic picture arousal values:\n\n');disp(AroVec(MalIndVec)')
			end
			[SortValVec,SortValIndVec]=sort(ValVec);
			[SortValStdVec,SortValStdIndVec]=sort(ValStdVec);
			[SortAroVec,SortAroIndVec]=sort(AroVec);
			[SortAroStdVec,SortAroStdIndVec]=sort(AroStdVec);
			close(hmsgbox);
		end
		%======================================================================================
	end
	if EyeTrackStatus | EyeTrackCalStatus 
		TitleString='Eye Tracking Mode'
	else
		TitleString=[];
		if MovieFunction==1
			TitleString=[TitleString 'Linear;  '];
		elseif MovieFunction==2
			TitleString=[TitleString 'Sinus;  '];
		elseif MovieFunction==3
			TitleString=[TitleString 'Cosinus;  '];
		elseif MovieFunction==4
			TitleString=[TitleString 'Rectangular;  '];
		end
		if GenderVal==1;
			TitleString=[TitleString 'All'];
		elseif GenderVal==2;
			TitleString=[TitleString 'Females'];
		elseif GenderVal==3;
			TitleString=[TitleString 'Males'];
		end
		TitleString=[TitleString ';  Sort by:  '];
	end
	if SortByValStatus & ~SortByAroStatus

figure('Units','normal','Position',[0 0 1 1])
ValDist=.1;
AroDist=.1;
ValLimNeutral=5;
ValLimHigh=ValLimNeutral+1;
ValLimLow=ValLimNeutral-1;
AroLimNeutral=4.5;
AroLimHigh=AroLimNeutral+1;
AroLimLow=AroLimNeutral-1;

%axes('Units','normal','Position',[0 0 1 1])
plot(ValVec,AroVec,'k.')
hold on
plot([ValLimNeutral ValLimNeutral],[1 8],'--k')
plot([ValLimHigh+ValDist ValLimHigh+ValDist],[1 8],'k')
plot([ValLimHigh-ValDist ValLimHigh-ValDist],[1 8],'k')
plot([ValLimLow+ValDist ValLimLow+ValDist],[1 8],'k')
plot([ValLimLow-ValDist ValLimLow-ValDist],[1 8],'k')
plot([1 9],[AroLimNeutral AroLimNeutral],'--k')
plot([1 9],[AroLimHigh+AroDist AroLimHigh+AroDist],'k')
plot([1 9],[AroLimHigh-AroDist AroLimHigh-AroDist],'k')
plot([1 9],[AroLimLow+AroDist AroLimLow+AroDist],'k')
plot([1 9],[AroLimLow-AroDist AroLimLow-AroDist],'k')
%  Pos=get(gca,'Position')
% for PicInd=1:25:NPic
% 	Pos=	[(ValVec(PicInd)-1)/7 (AroVec(PicInd)-1)/6.5 .05 .05]
% 	haxes=axes('Units','normal','Position',Pos)
% 	ImMat=imread([ImPath int2str(PicVec(PicInd)) '.jpg'],'jpg');
% 	image(ImMat); 
% 	axis('off');
% 	pause(.01)
% end
% xlabel('Valence')
% ylabel('Arousal')
% pause
global PicVec NeutralIndVec LowValLowAroIndVec  LowValHighAroIndVec HighValLowAroIndVec HighValHighAroIndVec
NeutralIndVec=find(ValVec>ValLimLow+ValDist & ValVec<ValLimHigh-ValDist & AroVec<AroLimLow-AroDist)

LowValLowAroIndVec=find(ValVec<ValLimLow-ValDist & AroVec>AroLimLow+AroDist & AroVec<AroLimHigh-AroDist)

LowValHighAroIndVec=find(ValVec<ValLimLow-ValDist & AroVec>AroLimHigh+AroDist)

HighValLowAroIndVec=find(ValVec>ValLimHigh+ValDist & AroVec>AroLimLow+AroDist & AroVec<AroLimHigh-AroDist)

HighValHighAroIndVec=find(ValVec>ValLimHigh+ValDist & AroVec>AroLimHigh+AroDist)

NNeutralPic=length(NeutralIndVec)
NLowValLowAroPic=length(LowValLowAroIndVec)
NLowValHighAroPic=length(LowValHighAroIndVec)
NHighValLowAroPic=length(HighValLowAroIndVec)
NHighValHighAroPic=length(HighValHighAroIndVec)

[MinAllPic MinAllInd]=min([NNeutralPic NLowValLowAroPic NLowValHighAroPic NHighValLowAroPic NHighValHighAroPic])

RandVec=randperm(NNeutralPic);
% NeutralIndVec=NeutralIndVec(RandVec(1:MinAllPic));
plot(ValVec(NeutralIndVec),AroVec(NeutralIndVec),'sg')

RandVec=randperm(NLowValLowAroPic);
% LowValLowAroIndVec=LowValLowAroIndVec(RandVec(1:MinAllPic));
plot(ValVec(LowValLowAroIndVec),AroVec(LowValLowAroIndVec),'db')

RandVec=randperm(NLowValHighAroPic);
% LowValHighAroIndVec=LowValHighAroIndVec(RandVec(1:MinAllPic));
plot(ValVec(LowValHighAroIndVec),AroVec(LowValHighAroIndVec),'dr')

RandVec=randperm(NHighValLowAroPic);
% HighValLowAroIndVec=HighValLowAroIndVec(RandVec(1:MinAllPic));
plot(ValVec(HighValLowAroIndVec),AroVec(HighValLowAroIndVec),'ob')

RandVec=randperm(NHighValLowAroPic);
% HighValHighAroIndVec=HighValHighAroIndVec(RandVec(1:MinAllPic));
plot(ValVec(HighValHighAroIndVec),AroVec(HighValHighAroIndVec),'or')
%===============
% IndVec=[NeutralIndVec',LowValLowAroIndVec']';
% IndVec=[HighValHighAroIndVec',HighValLowAroIndVec',LowValHighAroIndVec',LowValLowAroIndVec'];
%===============
% PicVec=PicVec(IndVec);
% ValAroVec=[ValVec(IndVec)]

[SortValAroVec,SortValAroIndVec]=sort(ValAroVec);
		ValAroStdVec=ValStdVec.*AroStdVec;
		SortValAroStdVec=ValAroStdVec(SortValAroIndVec);
		PicSortIndVec=SortValAroIndVec;
length(SortValAroVec)

NPic=length(SortValAroIndVec)
NAllPic=NPic
PicSortIndVec=[1:NPic];

		ValAroVec=ValVec;
		ValAroStdVec=ValStdVec;
		SortValAroVec=SortValVec;

		SortValAroStdVec=SortValStdVec;
		PicSortIndVec=SortValIndVec;
		ValAroString='Valence';
		TitleString=[TitleString,ValAroString];
	elseif ~SortByValStatus & SortByAroStatus
		ValAroVec=AroVec;
		ValAroStdVec=AroStdVec;
		SortValAroVec=SortAroVec;
		SortValAroStdVec=SortAroStdVec;
		PicSortIndVec=SortAroIndVec;
		ValAroString='Arousal';
		TitleString=[TitleString,ValAroString];
	elseif SortByValStatus & SortByAroStatus
		ValAroVec=ValVec.*AroVec;
		ValAroStdVec=ValStdVec.*AroStdVec;
		[SortValAroVec,SortValAroIndVec]=sort(ValAroVec);
		[SortValAroStdVec,SortValAroStdIndVec]=sort(ValAroStdVec);
		PicSortIndVec=SortValAroIndVec';
		ValAroString='Valence x Arousal';
		TitleString=[TitleString,ValAroString];
	else
		ValAroVec=ones(length(PicVec),1);
		ValAroStdVec=zeros(length(PicVec),1);
		DiffVec=zeros(length(PicVec),1);
		ValAroString='File number';
		if ~EyeTrackStatus & ~EyeTrackCalStatus
			TitleString=[TitleString,ValAroString];
		end
	end
	if CheckStatus
		ValAroString='Brightness';
		TitleString='Checkerboard';
	end
	if MovieDirVal==1
		ValStart=0;
		ValEnd=10;
		PhiStart=-pi;
		PhiEnd=pi;
	else
		ValStart=10;
		ValEnd=0;
		PhiStart=0;
		PhiEnd=2.*pi;
	end

	NPic2Show=NPic-StartPic+1
	NInt=10;	
	fprintf('\n');clc;
	if SortByValStatus | SortByAroStatus
		NPic2Show=min(NPic,NPicPerCycle.*NCycle);
		if MovieFunction==1
			ValVec=linspace(ValStart,ValEnd,NPicPerCycle);
			ValVecTmp=zeros(1,NPic2Show);
			for CycleInd=1:NCycle
				ValVecTmp(1,(CycleInd-1).*NPicPerCycle+1:CycleInd.*NPicPerCycle)=ValVec;
			end
			ValVec=ValVecTmp;
		elseif MovieFunction==2
			ValVec=sin(linspace(pi+PhiStart,pi+PhiEnd+2.*pi.*(NCycle-1),NPic2Show+1))+ones(1,NPic2Show+1);
			ValVec=ValVec(1:NPic2Show);
		elseif MovieFunction==2  | MovieFunction==3
			if  MovieFunction==2
				ValVecTmp=sin(linspace(PhiStart,PhiEnd,NPicPerCycle+1))+ones(1,NPicPerCycle+1);
			elseif  MovieFunction==3
				ValVecTmp=cos(linspace(PhiStart,PhiEnd,NPicPerCycle+1))+ones(1,NPicPerCycle+1);
			end
			ValVecTmp=ValVecTmp(1:NPicPerCycle);
			ValVec=[];
			for i=1:NCycle
				ValVec=[ValVec,ValVecTmp];
			end
			ValVecTmp=[];
		elseif MovieFunction==4
			ValVec1=ones(1,NPicPerCycle./2);
			ValVecTmp1=zeros(1,NPicPerCycle);
			if MovieDirVal==1
				ValVecTmp1(NPicPerCycle./2+1:NPicPerCycle)=ValVec1;
			else
				ValVecTmp1(1:NPicPerCycle./2)=ValVec1;
			end
			ValVecTmp2=zeros(1,NPic2Show);
			for CycleInd=1:NCycle
				ValVecTmp2(1,(CycleInd-1).*NPicPerCycle+1:CycleInd.*NPicPerCycle)=ValVecTmp1;
			end
			ValVec=ValVecTmp2;	
		end
		if ~CheckStatus
			MinSortValAroVec=min(SortValAroVec);
			MaxSortValAroVec=max(SortValAroVec);
			MeanSortValAroVec=mean([MinSortValAroVec MaxSortValAroVec]);
		else
			MinSortValAroVec=2;
			MaxSortValAroVec=10;
			MeanSortValAroVec=6;
		end
		[ValVec]=norm_1(ValVec,4,[],MinSortValAroVec,MaxSortValAroVec);
	else
		NPic2Show=length(PicVec)
StartPic=StartPic
% 		if ~EyeTrackStatus & ~EyeTrackCalStatus
% 			[NonUse,StartPicInd]=min(abs(PicVec-ones(size(PicVec)).*StartPic))
% 			if MovieDirVal==1
% 				PicVec=PicVec(StartPicInd:length(PicVec));
% 			else
% 				PicVec=PicVec(1:StartPicInd);
% 			end
% 		end
		ValVec=PicVec;
	end
	NPic2Show=length(ValVec);

	if (SortByValStatus | SortByAroStatus) & ~CheckStatus

		SortValAroVecTmp=SortValAroVec;
		DiffVec=zeros(NPic2Show,1);
		PicIndVec=zeros(NPic2Show,1);	

		ValVecTmp=ValVec;
		hFigTmp=figure('Units','normal','Position',[0 .5 .5 .5], 'Name','Choose indices:', 'NumberTitle','off');
		plot(ValVec); 
		title('Distribute indices');
		xlabel('Pattern #');
		ylabel('Value'); 
		axis([1 length(ValVec) min([min(ValVec),0]) max([max(ValVec),10])]);
		hold on; 
		pause(1)
		
		if MovieFunction==1 & NCycle==1
			[NoUse,PicIndVec]=sort(ValAroVec);
			if MovieDirVal==-1		%Down	
				PicIndVecTmp=PicIndVec;
				for i=1:length(PicIndVec)
					PicIndVecTmp(length(PicIndVec)-i+1)=PicIndVec(i);
				end
				PicIndVec=PicIndVecTmp;
			end
			PicIndVec=PicIndVec(1:NPic2Show);
		elseif MovieFunction==4		%Rectangular
			MaxIndVec=find(ValVec==max(ValVec));
			MinIndVec=find(ValVec==min(ValVec));
			NMaxInd=length(MaxIndVec)
			NMinInd=length(MinIndVec)
			if UseRandPermStatus
				RandMaxIndVec=MaxIndVec(randperm(length(MaxIndVec)));
				RandMinIndVec=MinIndVec(randperm(length(MinIndVec)));
			else
				RandMaxIndVec=MaxIndVec;
				RandMinIndVec=MinIndVec;
			end
			for Ind=1:NCycle./2
				IndVec=[(Ind-1).*NPicPerCycle+1:Ind.*NPicPerCycle];
				MaxIndTmpVec=RandMaxIndVec(IndVec);
				MinIndTmpVec=RandMinIndVec(IndVec);
				NMaxInd=length(MaxIndTmpVec);
				NMinInd=length(MinIndTmpVec);
 				TmpMaxIndVec=[NAllPic-(Ind-1).*NPicPerCycle:-1:NAllPic-NMaxInd+1-(Ind-1).*NPicPerCycle]
				TmpMinIndVec=[(Ind-1).*NPicPerCycle+1:NMinInd+(Ind-1).*NPicPerCycle];
				PicIndVec(MaxIndTmpVec)=PicSortIndVec(TmpMaxIndVec);
				PicIndVec(MinIndTmpVec)=PicSortIndVec(TmpMinIndVec);
			end
		else
			NPicPerCycle2=NPicPerCycle./2;
			IndStart=1;
			for Ind=1:NPicPerCycle2+1
				Tmp1IndVec=find(ValVec>ValVec(Ind)-.05 & ValVec<ValVec(Ind)+.05);
				plot(Tmp1IndVec,ValVec(Tmp1IndVec),'*');
				axis([1 50 0 8])
				IndEnd=IndStart+length(Tmp1IndVec)-1;
				if MovieDirVal==1		%Up:	Start to choose indices of PicSortIndVec at lowest values
					Tmp2IndVec=[IndStart:IndEnd];
				elseif MovieDirVal==-1	%Down
					Tmp2IndVec=[NAllPic-IndStart+1:-1:NAllPic-IndEnd+1];
				end
				if UseRandPermStatus
					Tmp3IndVec=randperm(length(Tmp1IndVec));
					Tmp2IndVec=Tmp2IndVec(Tmp3IndVec);
				end
				PicIndVec(Tmp1IndVec)=PicSortIndVec(Tmp2IndVec);
				IndStart=IndEnd+1;
				pause
			end
			pause
		end
%ValVecSt=ValVec
%PicIndVecStr=PicIndVec'
%ValAroVecStr=ValAroVec
		DiffVec=ValVec-ValAroVec(PicIndVec)';
		set(hIAPSMovieList(26),'Enable','on','Userdata',PicVec(PicIndVec));
		if NBasePic>0
			MeanValAroVec=mean(ValAroVec(PicIndVec));
			Tmp=abs(ValAroVec-MeanValAroVec);
			[SortAmpDiff,SortIndDiff]=sort(Tmp);
			BaseIndVec=SortIndDiff(1:NBasePic);
			if UseRandPermStatus
				BaseIndVec=BaseIndVec(randperm(NBasePic));
			end
			DiffBaseVec=ValAroVec(BaseIndVec)-MeanValAroVec;
			set(hIAPSMovieList(50),'Userdata',BaseIndVec);
		end
		close(hFigTmp);
	else
		PicSortIndVec=[1:NPic2Show];
		PicIndVec=PicSortIndVec
		ValAroVec=PicVec(PicSortIndVec)';
	end

	ReadMovieStatus=ReadMovieStatus
	CheckStatus=CheckStatus
	
    
	if ReadMovieStatus & ~CheckStatus &  ~EyeTrackStatus & ~EyeTrackCalStatus
		ValVec=MovieLogMat(:,1)';
		NPic2Show=length(ValVec);
		PicIndVec=MovieLogMat(:,2);	
  		PicVec=MovieLogMat(:,3);
 		ValAroVec=MovieLogMat(:,4);
 		ValAroStdVec=MovieLogMat(:,5);
 		DiffVec=MovieLogMat(:,6)';
 		ParaParaMat=MovieLogMat(:,11:63);
		[PicSortIndVal,PicSortIndVec]=sort(ValVec);
 	elseif ~CheckStatus &  ~EyeTrackStatus & ~EyeTrackCalStatus
		ParaMat=get(hIAPSMovieList(34),'Userdata');
        %ParaMat=[]
		%1=IAPSNumber; 2=Red; 3=Green; 4=Blue; 5=Hue; 6=Sat; 7=Val;
		%8=RedStd; 9=GreenStd; 10=BlueStd; 11=HueStd; 12=SatStd; 13=ValStd;
		%14=Hor. Half PFFT Red; 15=Hor. Half PFFT Green; 16=Hor. Half PFFT Blue;
		%17=Hor. Half PFFT Hue; 18=Hor. Half PFFT Sat; 19=Hor. Half PFFT Val;
		%20=Vert. Half PFFT Red; 21=Vert. Half PFFT Green; 22=Vert. Half PFFT Blue;
		%23=Vert. Half PFFT Hue; 24=Vert. Half PFFT Sat; 25=Vert. Half PFFT Val;
		%global ParaMat HorPFFTMat VertPFFTMat HorPFFTMat1 HorPFFTMat2 VertPFFTMat1 VertPFFTMat2 SvdMat1 SvdMat2 SvdMat3 SvdMat4 FileSizeVec
%		ParaMat=[]
%		=========File Size============================
% 		PicStart=1;
% 		FileSizeVec=zeros(NAllPic,1);
% 		FileSizeVec=[];
% 		for PicInd=PicStart:NAllPic	
% 			fid=fopen(['Jaz 2GB:JPG100RGB:Blue:', int2str(AllPicVec(PicInd)) '.jpg']);
% 			fseek(fid,0,1);
% 			FileSizeVec(PicInd)=ftell(fid);
% 			fclose(fid);
% 		end
% 		FileSizeVec=FileSizeVec'
% 		return
%		=============================================
		if isempty(ParaMat)
 			if strcmp(computer,'MAC2')
      			[ParaFilePath]=[pwd 'IAPSParaMat_' int2str(NAllPic)]
      			[SvdFilePath1]=[pwd 'IAPSSVD1_' int2str(NAllPic)];
				[SvdFilePath2]=[pwd 'IAPSSVD2_' int2str(NAllPic)];
				[SvdFilePath3]=[pwd 'IAPSSVD3_' int2str(NAllPic)];
				[SvdFilePath4]=[pwd 'IAPSSVD4_' int2str(NAllPic)];
				[HorPFFTFilePath1]=[pwd 'IAPSHorPFFTMat1_' int2str(NAllPic)];
				[VertPFFTFilePath1]=[pwd 'IAPSVertPFFTMat1_' int2str(NAllPic)];
				[HorPFFTFilePath2]=[pwd 'IAPSHorPFFTMat2_' int2str(NAllPic)];
				[VertPFFTFilePath2]=[pwd 'IAPSVertPFFTMat2_' int2str(NAllPic)];
   			elseif strcmp(computer,'PCWIN')
      			[ParaFilePath]=[pwd,filesep,'IAPSParaMat_' int2str(NAllPic)];
				[SVDFilePath1]=[pwd,filesep,'IAPSSVD1_' int2str(NAllPic)];
				[SVDFilePath2]=[pwd,filesep,'IAPSSVD2_' int2str(NAllPic)];
				[SvdFilePath3]=[pwd,filesep,'IAPSSVD3_' int2str(NAllPic)];
				[SvdFilePath4]=[pwd,filesep,'IAPSSVD4_' int2str(NAllPic)];
				[HorPFFTFilePath1]=[pwd,filesep,'IAPSHorPFFTMat1_' int2str(NAllPic)];
				[VertPFFTFilePath1]=[pwd,filesep,'IAPSVertPFFTMat1_' int2str(NAllPic)];
				[HorPFFTFilePath2]=[pwd,filesep,'IAPSHorPFFTMat2_' int2str(NAllPic)];
				[VertPFFTFilePath2]=[pwd,filesep,'IAPSVertPFFTMat2_' int2str(NAllPic)];
   			else
     	 		ParaFilePath=[]; HorPFFTFilePath=[]; VertPFFTFilePath=[]; 
   			end
            ParaFilePath='Paul:Matlab:Geo:IAPSParaMat_704'
			%ParaFilePath='Paul:Matlab:Geo:IAPSParaMat_692'
			ParaFilePathTmp=ParaFilePath;
			if ~exist(ParaFilePath)
				[ParaFileTmp,ParaPathTmp]=uigetfile('*IAPSParaMat','Look for IAPSParaMat file:');
				ParaFilePathTmp=[ParaPathTmp,ParaFileTmp];
			else
				ParaFileTmp=['IAPSParaMat_',int2str(NAllPic)];
			end
			if ParaFileTmp~=0
				[ParaMat,PicName,VarName] = ReadIAPSParaMat(ParaFilePathTmp,NAllPic)
                pause
			else
%  		 		ParaMat=zeros(NAllPic,300);	
% 				SvdMat1=zeros(NAllPic,300);	
% 				SvdMat2=zeros(NAllPic,300);	
% 				SvdMat3=zeros(NAllPic,300);	
% 				SvdMat4=zeros(NAllPic,300);	
% 				HorPFFTMat1=zeros(NAllPic,101);
% 				VertPFFTMat1=zeros(NAllPic,101);	
% 				HorPFFTMat2=zeros(NAllPic,101);
% 				VertPFFTMat2=zeros(NAllPic,101);	
% 				ParaMat(:,1)=AllPicVec(1:NAllPic);
				MinColorInd=1;
				MaxColorInd=4;
				set(hPicFig,'Position',[0 .6 .4 .4]);
				HorSpatFrequFigPosVec=[0 0 .5 .5];  
				hHorSpatFrequFig=figure('Units','normal','Position',HorSpatFrequFigPosVec,'Name','Horizontal Spatial Frequ.: ','NumberTitle','off');
				VertSpatFrequFigPosVec=[.5 0 .5 .5];  
				hVertSpatFrequFig=figure('Units','normal','Position',VertSpatFrequFigPosVec,'Name','Vertical Spatial Frequ.: ','NumberTitle','off');
% 				PicStart=min(find(AllPicVec>4000));
% 				PicStart=291;
				PicStart=1;
				for PicInd=PicStart:NAllPic	
					fprintf(['# ',int2str(PicInd),' of ',int2str(NAllPic), ' ; Name: ' int2str(AllPicVec(PicInd)) '\n']);
					UInt8ImMat=imread([ImPath int2str(AllPicVec(PicInd)) '.jpg'],'jpg');	
					[p,q,r]=size(UInt8ImMat);
					p2=floor(p./2);
					q2=floor(q./2);
					%========Calculate Real Picture Size (without black frame)===============
					[QInd]=find(sum(UInt8ImMat(p2,:,:),3));%Hor Pix; Vert Pix
					MinQInd=min(QInd);
					MaxQInd=max(QInd);
					[PInd]=find(sum(UInt8ImMat(:,q2,:),3));%Hor Pix; Vert Pix
					MinPInd=min(PInd);
					MaxPInd=max(PInd);
					LRel=(MinQInd-1)./q;
					RRel=MaxQInd./q;
					TRel=(MinPInd-1)./p;
					BRel=MaxPInd./p;
					Width=(MaxQInd-MinQInd+1);
					Height=(MaxPInd-MinPInd+1);	
					FullPicStatus=1;
					if Width~=q | Height~=p
						FullPicStatus=2;	
					end
					Height2Width=Height./Width;
					Land2Port=0;			%Quadrat
					if Height2Width>1
						Land2Port=-1;		%Portrait
					elseif Height2Width<1
						Land2Port=1;		%Landscape
					end
					ParaMat(PicInd,[11:24])=[p q MinPInd MaxPInd MinQInd MaxQInd LRel RRel TRel BRel Width Height Height2Width Land2Port];
					FullPicStatus=1
					for PicStatusInd=1:FullPicStatus
						if PicStatusInd==1; 
							ImMatTmp=zeros(p,q,r);
							FFTImMat=zeros(p,q);
						elseif  PicStatusInd==2; 
							p=Height;
							q=Width;
							p2=floor(p./2);
							q2=floor(q./2);
							ImMatTmp=zeros(p,q,r);
							FFTImMat=zeros(p,q);
						end
						for ColorInd=MinColorInd:MaxColorInd
							if PicStatusInd==1; 
								PicFigName1='All Visible; ';
							elseif  PicStatusInd==2; 
								PicFigName1='No Border; ';
							end
							figure(hPicFig); clf;
							if ColorInd==1; 
								ColorStr='All';
							elseif ColorInd==2; 
								ColorStr='Red';
							elseif ColorInd==3; 
								ColorStr='Green';
							elseif ColorInd==4; 
								ColorStr='Blue';
							elseif ColorInd==5; 
								ColorStr='Hue';
								UInt8ImMat=rgb2hsv(UInt8ImMat);
							elseif ColorInd==6; 
								ColorStr='Sat.';
							elseif ColorInd==7; 
								ColorStr='Value';
							end
							if ColorInd==1	%All
								TmpInd=1;
								if PicStatusInd==1; 
									ImMatTmp(:,:,1)=mean(UInt8ImMat(:,:,:),3);
								elseif  PicStatusInd==2; 
									ImMatTmp(:,:,1)=mean(UInt8ImMat(MinPInd:MaxPInd,MinQInd:MaxQInd,:),3);
								end
								ImMatTmp(:,:,2)=ImMatTmp(:,:,1);
								ImMatTmp(:,:,3)=ImMatTmp(:,:,1);
							else
								if ColorInd<5
									TmpInd=ColorInd-1;
								else
									TmpInd=ColorInd-4;
								end
								if PicStatusInd==1; 
									ImMatTmp(:,:,TmpInd)=UInt8ImMat(:,:,TmpInd);
								elseif  PicStatusInd==2; 
									ImMatTmp(:,:,TmpInd)=UInt8ImMat(MinPInd:MaxPInd,MinQInd:MaxQInd,TmpInd);
								end
							end
%							=========JPEG File Size============================
% 							Print2File=[int2str(AllPicVec(PicInd)) '.jpg'];
% 							Print2Path=['Jaz 2GB:JPG100RGB:',ColorStr,':'];
% 							Print2FilePath=[Print2Path,Print2File]
% 							imwrite(ImMatTmp(:,:,TmpInd),Print2FilePath,'Quality',100);
%							===================================================
%							====================SVD============================
 							FFTImMat(:,:)=ImMatTmp(:,:,TmpInd);
							S=svd(FFTImMat);
							MinNS=min(300,length(S));
							CumSumS=cumsum(S);
							SumS=sum(S);
							Svd5=min(find(CumSumS>.5.*SumS));
							Svd9=min(find(CumSumS>.9.*SumS));
%							===================================================
% 							%=============ParaMat==============================
							ParaMatIndex=250+(ColorInd-1).*2;
							ParaMat(PicInd,ParaMatIndex+1)=Svd5;
							ParaMat(PicInd,ParaMatIndex+2)=Svd9;
							if ColorInd==1
								SvdMat1(PicInd,1:MinNS)=S(1:MinNS)';
							elseif ColorInd==2
								SvdMat2(PicInd,1:MinNS)=S(1:MinNS)';
							elseif ColorInd==3
								SvdMat3(PicInd,1:MinNS)=S(1:MinNS)';
							elseif ColorInd==4
								SvdMat4(PicInd,1:MinNS)=S(1:MinNS)';
							end
							%============================================================
% 							if ColorInd<5
% 								ImMatTmp=ImMatTmp./255;
% 							end
% 							MeanVal=mean(mean(ImMatTmp(:,:,TmpInd)));	
% 							StdVal=std(std(ImMatTmp(:,:,TmpInd)));
% 							%=============ParaMat=====================================
% 							ParaMatIndex=50+(ColorInd-1).*2;
% 							if PicStatusInd==1
% 								ParaMat(PicInd,ParaMatIndex+1)=MeanVal;
% 								ParaMat(PicInd,ParaMatIndex+15)=StdVal;
% 							end
% 							ParaMat(PicInd,ParaMatIndex+2)=MeanVal;	%If PicStatusInd does not become 2 (because it is a full size pic) => Brightnes and Contrast of border pic is the same as the full size pic
% 							ParaMat(PicInd,ParaMatIndex+16)=StdVal;	%If PicStatusInd does  become 2 (border pic) => Brightnes and Contrast of border pic overwrites the full size pic values		
% 							%============================================================
% 							PicFigName=[];
% 							PicFigName=[PicFigName1,'Mean ( ',num2str(round(MeanVal.*100)./100),') and Std. ( ',num2str(round(StdVal.*100)./100),') of ' ColorStr ' ; # ',int2str(PicInd),' of ',int2str(NAllPic), ' ; File: ' int2str(AllPicVec(PicInd))];
% 							set(hPicFig,'Name',PicFigName);
% 							image(ImMatTmp);
% 							axis('off');
% 							pause(.001)
%  							FFTImMat(:,:)=ImMatTmp(:,:,TmpInd);
%  							FFTImMat=fft2(FFTImMat);
%  							FFTImMat=abs(FFTImMat.*conj(FFTImMat));
% 							clf;
% 							PicFigName=[];
% 							PicFigName=[PicFigName1,'2 dim. PFFT of ' ColorStr ' ; # ',int2str(PicInd),' of ',int2str(NAllPic), ' ; File: ' int2str(AllPicVec(PicInd))];
% 							set(hPicFig,'Name',PicFigName)
%  							image(FFTImMat);
%  							axis('off')
% 							pause(.001)
% 							Tmp2=100;
% 							xVec=[2:Tmp2];
% 							xIntVec=[.01:.01:Tmp2];
% 							MinPlot=inf;MaxPlot=1;
% 							for HorVertInd=1:2
% 								if HorVertInd==1
% 									HorVertVec=sum(FFTImMat)./q;	
% 									figure(hHorSpatFrequFig);	
% 									HorTitleString='Hor. FFT;  ';
% 									if ColorInd==1
% 										if PicStatusInd==1
% 											HorPFFTMat1(PicInd,:)=HorVertVec(1:101);
% 										end
% 										HorPFFTMat2(PicInd,:)=HorVertVec(1:101);
% 									end
% 								
% 								else			
% 									HorVertVec=sum(FFTImMat')./p;
% 									figure(hVertSpatFrequFig);
% 									VertTitleString='Vert. FFT;  ';
% 									if ColorInd==1
% 										if PicStatusInd==1
% 											VertPFFTMat1(PicInd,:)=HorVertVec(1:101);
% 										end
% 										VertPFFTMat2(PicInd,:)=HorVertVec(1:101);
% 									end
% 								end		
% 								HorVertVec=HorVertVec(xVec);	%Except mean
% 								IntHorVertVec=interp1(xVec,HorVertVec,xIntVec,'spline');
% 								NegIndVec=find(IntHorVertVec<0);
% 								IntHorVertVec(NegIndVec)=zeros(size(NegIndVec));
% 								for xInd=1:2			
% 									if xInd==2
% 										HorVertVec=HorVertVec./xVec.^-1;
% 										IntHorVertVec=IntHorVertVec./xIntVec.^-1;
% 									end
% 									MaxHorVertVec=max(HorVertVec);
% 									HorVertVec=HorVertVec./MaxHorVertVec;	%Normalize
% 									MaxHorVertVec=1;
% 									MaxIntHorVertVec=max(IntHorVertVec);
% 									IntHorVertVec=IntHorVertVec./MaxIntHorVertVec;	%Normalize
% 									MinHorVertVec=min(HorVertVec);
% 									if MinHorVertVec<MinPlot
% 										MinPlot=MinHorVertVec;
% 									end
% 									
% 									%=============Half Cut Frequency==========================
% 									SumVec=sum(IntHorVertVec);			
% 									CumSumVec=cumsum(IntHorVertVec);		
% 									DiffVec=CumSumVec-SumVec./2;
% % plot(IntHorVertVec);pause 
% % plot(CumSumVec,'r'); hold on; plot(SumVec.*ones(size(CumSumVec))); plot(DiffVec,'k'); pause
% 									[NonUse,MinInd]=min(abs(DiffVec));
% 									MinInd=xIntVec(MinInd);
% 									if HorVertInd==1
% 										HorHalfCut=MinInd;	
% 										HorTitleString=[HorTitleString,sprintf('%g',MinInd),'; '];
% 									else			
% 										VertHalfCut=MinInd;
% 										VertTitleString=[VertTitleString,sprintf('%g',MinInd),'; '];
% 									end
% 									%=============Best x^-a fit==========================
% 									epsilon=.1;
% 									a=-0.3;
% 									FitValOld=inf;
% 									for i=1:3
% 										a=a+2.*epsilon;
% 										epsilon=10.^(-i);
% 										a=a+epsilon;
% 										NextStatus=1;
% 										while NextStatus
% 											a=a-epsilon;
% 											FitHorVertVec=xVec.^a;
%  											FitValNew=sum(abs(FitHorVertVec-HorVertVec));
% 											if FitValNew>FitValOld
% 												NextStatus=0;
% 												FitValOld=inf;
% 											else
% 												FitValOld=FitValNew;
% 											end
% 										end
% 									end
% 									if HorVertInd==1
% 										HorFita=a;
% 										HorTitleString=[HorTitleString,sprintf('%g',round(a.*100)./100),'; '];	
% 									else			
% 										VertFita=a;	
% 										VertTitleString=[VertTitleString,sprintf('%g',round(a.*100)./100),'; '];	
% 									end
% 									%=============ParaMat=====================================
% 									ParaMatIndex=100+(ColorInd-1).*16+(HorVertInd-1).*8+(xInd-1).*4;
% 									if PicStatusInd==1
% 										ParaMat(PicInd,ParaMatIndex+1)=MinInd;
% 										ParaMat(PicInd,ParaMatIndex+2)=MinInd;
% 										ParaMat(PicInd,ParaMatIndex+3)=a;
% 										ParaMat(PicInd,ParaMatIndex+4)=a;
% 									end
% 									ParaMat(PicInd,ParaMatIndex+2)=MinInd;
% 									ParaMat(PicInd,ParaMatIndex+4)=a;
% 									%==============Plot======================================
% 									if xInd==1
% 										ColStr1='b'; ColStr2='r'; ColStr3='k';  
% 									else
% 										ColStr1='b--'; ColStr2='r--'; ColStr3='k--';  
% 									end
% 								
% 									semilogy(HorVertVec,ColStr1); 
% 									hold on; 
% 									semilogy(FitHorVertVec,ColStr2);	
% 									semilogy(round([MinInd MinInd]),[MinHorVertVec MaxHorVertVec],ColStr3)	
% 		
% 									xlabel('Spatial Frequ. [1/m]')
% 									ylabel('Amplitude []')
% 									axis([1 100 MinPlot MaxPlot])
% 									pause(0.001)
% 								end	%for xInd=1:2
% 								if HorVertInd==1
% 									set(hHorSpatFrequFig,'Name',HorTitleString)
% 								else
% 									set(hVertSpatFrequFig,'Name',VertTitleString)
% 								end
% 								hold off
% 							end	%for HorVertInd=1:2
						end	%for ColorInd=1:MaxColorInd
					end
				end
 				SaveData(ParaMat,ParaFilePath,1);
				SaveData(SvdMat1,SvdFilePath1,1);
				SaveData(SvdMat2,SvdFilePath2,1); 
				SaveData(SvdMat3,SvdFilePath3,1);
				SaveData(SvdMat4,SvdFilePath4,1); return
				SaveData(HorPFFTMat1,HorPFFTFilePath1,1);
				SaveData(VertPFFTMat1,VertPFFTFilePath1,1);
				SaveData(HorPFFTMat2,HorPFFTFilePath2,1);
				SaveData(VertPFFTMat2,VertPFFTFilePath2,1);
			end
			set(hIAPSMovieList(34),'Userdata',ParaMat);
		end
		%===============================================
		ParaParaMat=zeros(NPic2Show,53);
		size(ParaMat)
		PicIndVec
		ParaParaMat(:,2)=sum(ParaMat(PicIndVec,2:4)')';
		ParaParaMat(:,3)=sum(ParaMat(PicIndVec,8:10)')';
		ParaParaMat(:,4)=sum(ParaMat(PicIndVec,[14 15 16 20 21 22])')';
		ParaParaMat(:,5)=sum(ParaMat(PicIndVec,[14 15 16])')';
		ParaParaMat(:,6)=sum(ParaMat(PicIndVec,[20 21 22])')';
		ParaParaMat(:,7)=sum(ParaMat(PicIndVec,5:7)')';			
		ParaParaMat(:,8)=sum(ParaMat(PicIndVec,11:13)')';
		ParaParaMat(:,9)=sum(ParaMat(PicIndVec,[16 17 18 23 24 25])')';
		ParaParaMat(:,10)=sum(ParaMat(PicIndVec,[14 15 16])')';
		ParaParaMat(:,11)=sum(ParaMat(PicIndVec,[20 21 22])')';
		ParaParaMat(:,12)=ParaMat(PicIndVec,2);
		ParaParaMat(:,13)=ParaMat(PicIndVec,2)./sum(ParaMat(PicIndVec,[2:4])')';
		ParaParaMat(:,14)=ParaMat(PicIndVec,8);
		ParaParaMat(:,15)=ParaMat(PicIndVec,8)./sum(ParaMat(PicIndVec,[8:10])')';
		ParaParaMat(:,16)=sum(ParaMat(PicIndVec,[14 20])')';
		ParaParaMat(:,17)=ParaMat(PicIndVec,14);
		ParaParaMat(:,18)=ParaMat(PicIndVec,20);
		ParaParaMat(:,19)=ParaMat(PicIndVec,3);	
		ParaParaMat(:,20)=ParaMat(PicIndVec,3)./sum(ParaMat(PicIndVec,[2:4])')';
		ParaParaMat(:,21)=ParaMat(PicIndVec,9);
		ParaParaMat(:,22)=ParaMat(PicIndVec,9)./sum(ParaMat(PicIndVec,[8:10])')';
		ParaParaMat(:,23)=sum(ParaMat(PicIndVec,[15 21])')';
		ParaParaMat(:,24)=ParaMat(PicIndVec,15);
		ParaParaMat(:,25)=ParaMat(PicIndVec,21);
		ParaParaMat(:,26)=ParaMat(PicIndVec,4);		
		ParaParaMat(:,27)=ParaMat(PicIndVec,4)./sum(ParaMat(PicIndVec,[2:4])')';
		ParaParaMat(:,28)=ParaMat(PicIndVec,10);
		ParaParaMat(:,29)=ParaMat(PicIndVec,10)./sum(ParaMat(PicIndVec,[8:10])')';
		ParaParaMat(:,30)=sum(ParaMat(PicIndVec,[16 22])')';
		ParaParaMat(:,31)=ParaMat(PicIndVec,16);
		ParaParaMat(:,32)=ParaMat(PicIndVec,22);
		ParaParaMat(:,33)=ParaMat(PicIndVec,5);
		ParaParaMat(:,34)=ParaMat(PicIndVec,5)./sum(ParaMat(PicIndVec,[5:7])')';
		ParaParaMat(:,35)=ParaMat(PicIndVec,11);
		ParaParaMat(:,36)=ParaMat(PicIndVec,11)./sum(ParaMat(PicIndVec,[11:13])')';
		ParaParaMat(:,37)=sum(ParaMat(PicIndVec,[17 23])')';
		ParaParaMat(:,38)=ParaMat(PicIndVec,17);
		ParaParaMat(:,39)=ParaMat(PicIndVec,23);
		ParaParaMat(:,40)=ParaMat(PicIndVec,6);
		ParaParaMat(:,41)=ParaMat(PicIndVec,6)./sum(ParaMat(PicIndVec,[5:7])')';
		ParaParaMat(:,42)=ParaMat(PicIndVec,12);
		ParaParaMat(:,43)=ParaMat(PicIndVec,12)./sum(ParaMat(PicIndVec,[11:13])')';
		ParaParaMat(:,44)=sum(ParaMat(PicIndVec,[18 24])')';
		ParaParaMat(:,45)=ParaMat(PicIndVec,18);
		ParaParaMat(:,46)=ParaMat(PicIndVec,24);
		ParaParaMat(:,47)=ParaMat(PicIndVec,7);
		ParaParaMat(:,48)=ParaMat(PicIndVec,7)./sum(ParaMat(PicIndVec,[5:7])')';
		ParaParaMat(:,49)=ParaMat(PicIndVec,13);
		ParaParaMat(:,50)=ParaMat(PicIndVec,13)./sum(ParaMat(PicIndVec,[11:13])')';
		ParaParaMat(:,51)=sum(ParaMat(PicIndVec,[19 25])')';
		ParaParaMat(:,52)=ParaMat(PicIndVec,19);
		ParaParaMat(:,53)=ParaMat(PicIndVec,25);
 	end
	if SortByRGBHSVStatus~=1 & ~CheckStatus & ~EyeTrackStatus & ~EyeTrackCalStatus
		ValAroVec=ParaParaMat(:,SortByRGBHSVStatus);
		ParaParaMat(:,1)=ValAroVec;
		ValAroString=deblank(RGBHSVStrMat(SortByRGBHSVStatus,:));
		TitleString=['Sort by ',ValAroString];
		[ValVec,PicSortIndVec]=sort(ValAroVec);
		if MovieDirVal~=1
			PicSortIndVec=PicSortIndVec([length(PicSortIndVec):-1:1]);
			ValVec=ValVec([length(ValVec):-1:1]);
			TitleString=[TitleString ' Descending order'];
		else
			TitleString=[TitleString '  Ascending order'];	
		end
		PicIndVec=PicSortIndVec;
		ParaParaMat=ParaParaMat(PicSortIndVec,:);
		SortValAroVec=ParaParaMat(:,1);
	elseif  ~CheckStatus & ~EyeTrackStatus & ~EyeTrackCalStatus
% 		ParaParaMat(:,1)=ValAroVec(PicIndVec);
		SortValAroVec=ValAroVec(PicSortIndVec);
	end
	MirrorStatus=0;
	if MirrorStatus
		NPic2ShowTmp=NPic2Show.*2;
	else
		NPic2ShowTmp=NPic2Show;
	end
	figure(hFuncFig);
	clf;
	if NBasePic>0
		ValVecPlot=ones(NPic2ShowTmp+NBasePic,1);
		ValVecPlot(1:NBasePic)=MeanSortValAroVec.*ValVecPlot(1:NBasePic);
		ValVecPlot(NBasePic+1:NPic2ShowTmp+NBasePic)=ValVec;
	else
		if MirrorStatus
			ValVecPlotTmp=zeros(NPic2ShowTmp,1);
			ValVecPlotTmp([1:2:NPic2ShowTmp-1])=ValVec;
			ValVecPlotTmp([2:2:NPic2ShowTmp])=ValVec;
			ValVecPlot=ValVecPlotTmp;
			clear ValVecPlotTmp
		else
			ValVecPlot=ValVec;
		end	
	end
	plot(ValVecPlot);
	hold on
	if SortByValStatus | SortByAroStatus
		plot([1 NPic2Show+NBasePic],[MeanSortValAroVec MeanSortValAroVec],'--g')
		axis([1 NPic2Show+NBasePic MinSortValAroVec MaxSortValAroVec]);
	else
		axis([1 NPic2ShowTmp min(ValVec) max(ValVec)]);
	end
	xlabel('Picture');
	ylabel(ValAroString)
	if ~CheckStatus & ~EyeTrackStatus & ~EyeTrackCalStatus
		hParaFig=figure('Units','normal','Position',[.5 0 .5 1],'Name','Movie Parameter','NumberTitle','off');
		
		subplot(2,4,1)
		plot(ValAroVec(PicIndVec),'b')
		axis([1 NPic2Show min(ValAroVec(PicIndVec)) max(ValAroVec(PicIndVec))]);
		xlabel('Picture #')
		ylabel('Sort Value []')
	
		subplot(2,4,2)
		plot(ValAroStdVec(PicIndVec),'g')
		MinValAroStdVec=min(ValAroStdVec);
		MaxValAroStdVec=max(ValAroStdVec);
		if MinValAroStdVec == MaxValAroStdVec
			axis([1 NPic2Show MinValAroStdVec-1 MinValAroStdVec+1])
		else
			axis([1 NPic2Show MinValAroStdVec MaxValAroStdVec])
		end
		xlabel('Picture #')
		ylabel('Std. of Sort Value []')	
		subplot(2,4,3)
		plot(DiffVec,'r')
		xlabel('Picture #')
		ylabel('Difference []')
		MinDiffVec=min(DiffVec);
		MaxDiffVec=max(DiffVec);
		if min(DiffVec) == max(DiffVec)
			axis([1 NPic2Show MinDiffVec-1 MinDiffVec+1])
		else
			axis([1 NPic2Show MinDiffVec MaxDiffVec])
		end	
		subplot(2,4,5)
		plot(ParaParaMat(:,2),'k')
		axis([1 NPic2Show 0 1.1.*max(ParaParaMat(:,2))])
		xlabel('Picture #')
		ylabel('Brightness []')
		subplot(2,4,6)
		plot(ParaParaMat(:,13),'r')
		axis([1 NPic2Show 0 1])
		xlabel('Picture #')
		ylabel('Red []')
		subplot(2,4,7)
		plot(ParaParaMat(:,20),'g')
		axis([1 NPic2Show 0 1])
		xlabel('Picture #')
		ylabel('Green []')
		subplot(2,4,8)
		plot(ParaParaMat(:,27),'b')
		axis([1 NPic2Show 0 1])
		xlabel('Picture #')
		ylabel('Blue []')
		
		IndVec=[2 3 4 5 6 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32];
		StartInd=1;
		EndInd=NPic2Show;
%  		StartInd=650;
		CorParaParaMat=CorrCoef(ParaParaMat(StartInd:EndInd,:));
		FigInd=0;
		[SortParaValVec,SortParaIndVec]=sort(ParaParaMat(:,1));
		SortValAroVec=ParaParaMat(SortParaIndVec,1);

		for IndInd=1:length(IndVec)
			if IndInd==1 | IndInd==13  | IndInd==25
				SubPlotInd=0;
				FigInd=FigInd+1;
				hLinFitFig(FigInd)=figure('Units','normal','Position',[0 0 1 1], ...
				'Name',['Linear Fit of RGB and HSV Parameters with ' ValAroString '.'],...
        			'NumberTitle','off');
			end
			SubPlotInd=SubPlotInd+1;
			Ind=IndVec(IndInd);
			ParaVec=ParaParaMat(SortParaIndVec(StartInd:EndInd),Ind);
			yLabelStr=deblank(RGBHSVStrMat(Ind,:));
			[p1,s1]=polyfit(SortValAroVec(StartInd:EndInd),ParaVec,1);
			[y1,delta1]=polyval(p1,SortValAroVec(StartInd:EndInd),s1);
			[p2,s2]=polyfit(SortValAroVec(StartInd:EndInd),ParaVec,2);
			[y2,delta2]=polyval(p2,SortValAroVec(StartInd:EndInd),s2);
			[p3,s3]=polyfit(SortValAroVec(StartInd:EndInd),ParaVec,3);
			[y3,delta3]=polyval(p3,SortValAroVec(StartInd:EndInd),s3);
 			subplot(3,4,SubPlotInd)
			if p1(1)>=0
				TitleStr=['y = ' num2str(p1(2)) ' + '  num2str(p1(1)) '  x '];
			else
				TitleStr=['y = ' num2str(p1(2)) ' - '  num2str(abs(p1(1))) '  x '];
			end
			TitleStr=char(TitleStr,['Cor.: ',num2str(CorParaParaMat(1,Ind))]);
			plot(SortValAroVec(StartInd:EndInd),ParaVec,'.k'); 
			hold on
			plot(SortValAroVec(StartInd:EndInd),y1)
% 			plot(ValAroVec,y2,'r')
% 			plot(ValAroVec,y3,'g')
			hold off
			xlabel(ValAroString)
			ylabel(yLabelStr)
			title(TitleStr)
			if IndInd==12 | IndInd==24  | IndInd==length(IndVec)
				pause
			end
		end
		close(hParaFig)
		close(hLinFitFig);
	end	%CheckStatus

	if (SortByValStatus | SortByAroStatus) & ~ReadMovieStatus	& ~EyeTrackStatus & ~EyeTrackCalStatus
		if isempty(Print2Path)
			Print2Path=pwd;
		end
		Print2File=['MovLog' int2str(NCycle) '.' int2str(NPicPerCycle)];
		if GenderVal==1
			Print2File=[Print2File 'All']; 
		elseif GenderVal==2
			Print2File=[Print2File 'Fem']; 
		elseif GenderVal==3
			Print2File=[Print2File 'Mal']; 
		end
		if SortByValStatus; Print2File=[Print2File 'Val']; end
		if SortByAroStatus; Print2File=[Print2File 'Aro']; end
		if MovieFunction==1;
			Print2File=[Print2File 'Lin']; 
		elseif MovieFunction==2;
			Print2File=[Print2File 'Sin']; 
		elseif MovieFunction==3;
			Print2File=[Print2File 'Cos']; 
		elseif MovieFunction==4;
			Print2File=[Print2File 'Rec']; 
		end
		if MovieDirVal==1; 
			Print2File=[Print2File 'Up']; 
		else
			Print2File=[Print2File 'Do']; 
		end
		if UseRandPermStatus
			Print2File=[Print2File 'Ra']; 
		end
		Print2FilePath=[Print2Path,Print2File];
		if ~CheckStatus
			MovieLogMat=zeros(NPic2Show,63);
			MovieLogMat(:,1)=ValVec';
			MovieLogMat(:,2)=PicIndVec;
			MovieLogMat(:,3)=PicVec(PicIndVec);
			MovieLogMat(:,4)=ValAroVec(PicIndVec);
			MovieLogMat(:,5)=ValAroStdVec(PicIndVec);
			MovieLogMat(:,6)=DiffVec';
			MovieLogMat(:,11:63)=ParaParaMat;
			MLFid=fopen(Print2FilePath,'w');
			if MLFid==-1;
				[Print2File,Print2Path,Print2FilePath]=WriteFilePath(Print2File,'Choose Movie Log file name:');
				if Print2File==0; return; end
				MLFid=fopen(Print2FilePath,'w');
			end
			Message=char('Save movie log to file:');
			Message=char(Message,' ');
			Message=char(Message,Print2FilePath);
			hmsgbox=msgbox(Message,'Info:','help');
			fprintf(MLFid,'%g\n',GenderVal); 
			fprintf(MLFid,'%g\n',MovieFunction); 
			fprintf(MLFid,'%g\n',NCycle); 
			fprintf(MLFid,'%g\n',NPicPerCycle); 
			fprintf(MLFid,'%g\n',SortByValStatus); 
			fprintf(MLFid,'%g\n',SortByAroStatus); 
			fprintf(MLFid,'%g\n',SortByRGBHSVStatus); 
			fprintf(MLFid,'%g\n',ColorBlackWhite); 
			fprintf(MLFid,'%g\n',BrightStatus); 
			fprintf(MLFid,'%g\n',UseRandPermStatus); 
			fprintf(MLFid,'%g\n',UseExtraRatingStatus);
			fprintf(MLFid,'%g\n',StartPic);	
			fprintf(MLFid,'%g\n',CorrectValAroStatus);		
			fprintf(MLFid,'%g\n',zeros(87,1));
			fprintf(MLFid,'%g\n',size(MovieLogMat));
			fprintf(MLFid,'%g\n',MovieLogMat);
			fclose(MLFid);	
		else
			MovieLogMat=ValVec';
		end
	end
% 	SaveData(ValAroVec(PicIndVec),[],1,[],'ascii','ascii')
% 	ColorStatus=0
% 	Print2FileStatus=1
% 	Print2FileMethodString='JPEG'
% 	Print2Path='Movie:BWPic:'
	MirrorStatus=0

	if MirrorStatus
		RandPermVec=RandPerm(NPic2Show);
		PicIndVecTmp=zeros(NPic2ShowTmp,1);
		DiffVecTmp=zeros(NPic2ShowTmp,1);
		PicIndVecTmp([1:2:NPic2ShowTmp-1])=PicIndVec(RandPermVec);
		DiffVecTmp([1:2:NPic2ShowTmp-1])=DiffVec(RandPermVec);
		MirrorRandPermVec=RandPerm(NPic2Show);
		PicIndVecTmp(2:2:NPic2ShowTmp)=PicIndVec(MirrorRandPermVec);
		DiffVecTmp(2:2:NPic2ShowTmp)=DiffVec(MirrorRandPermVec);
		PicIndVec=PicIndVecTmp;
		SaveAscii(PicIndVec,[pwd,'MirrorPicInd'])
		SaveAscii(PicVec(PicIndVec),[pwd,'MirrorIAPS#'])
		SaveAscii(ValAroVec(PicIndVec),[pwd,'MirrorValAro'])
		DiffVec=DiffVecTmp;
		NPic2Show=NPic2ShowTmp;
		clear PicIndVecTmp DiffVecTmp
	end

	FixCrossStatus=1;
	afix=11;
	bfix=11;
	NFixCrossColorChange=0;
	RandFixInd=randperm(200);
% 	LowValAroIndVec=[22 46 150]+10		%Rotes Fixationskreuz
% 	HighValAroIndVec=[75  93 117 181]+10
%	LowValAroIndVec=[100 200 300 400 500]+10		%Rotes Fixationskreuz
%	HighValAroIndVec=[151  351 551]+10			%15per30
% 	LowValAroIndVec=[24 122]+10
% 	HighValAroIndVec=[53 95 159]+10
	LowValAroIndVec=0
	HighValAroIndVec=0
% 	MeanValAroVec=mean(ValAroVec(PicIndVec));
% 	LowValAroIndVec=find(ValAroVec(PicIndVec)<MeanValAroVec);
% 	HighValAroIndVec=find(ValAroVec(PicIndVec)>MeanValAroVec);
% 	LowRandPermVec=randperm(length(LowValAroIndVec));
% 	HighRandPermVec=randperm(length(HighValAroIndVec));
% 	LowValAroIndVec=LowValAroIndVec(LowRandPermVec(1:NFixCrossColorChange))
%  	LowValAroIndVec=[]
% 	HighValAroIndVec=HighValAroIndVec(HighRandPermVec(1:NFixCrossColorChange))
% 	c=[0 36 72 108 144 180 216 252]
% 	d=[4 8 12 16 20 24 28 32];
% 	e=c(randperm(length(c)))+d
% 	HighValAroIndVec=HighValAroIndVec(e);
% 	SaveAscii(LowValAroIndVec,[pwd,'MirrorLowFixCross'])
% 	SaveAscii(HighValAroIndVec,[pwd,'MirrorHighFixCross'])
	global SacMat
	if EyeTrackStatus | EyeTrackCalStatus
		SacMat=zeros(NPic2Show,12); %IAPSPicNo; Val; Aro; StdBase; StdTime; TimeFirstSac; AmpFirstSac; NSac; SumSac; MaxSac; RadFirstSac; PhiFirstSac
		if all(PicVec>999)
			RatMat=GetIAPSRatings(PicVec);
			SacMat(:,1:3)=RatMat;
		end
	end
	
	IndTmpStart=1;
	for IndTmp=IndTmpStart:NPic2Show+NBasePic
		if IndTmp<=NBasePic
			PicInd=BaseIndVec(IndTmp);
		else
			PicInd=PicIndVec(IndTmp-NBasePic);
		end
		Ind=IndTmp-NBasePic;
		figure(hPicFig);
 		if ~CheckStatus
			IAPSPicNo=int2str(PicVec(PicInd));
			if IndTmp<=NBasePic
				ComStr=['# ',int2str(IndTmp),' of ',int2str(NBasePic),' Base Pics ; IAPS #: ',IAPSPicNo,'; IAPS Index: ',int2str(PicInd)];
				ComStr=[ComStr,'; Sort Value: ' num2str(ValAroVec(BaseIndVec(IndTmp))) ' ;  Diff.: ' num2str(round(DiffBaseVec(IndTmp).*1000)./1000)];
			else
				ComStr=['# ',int2str(Ind),' of ',int2str(NPic2Show), ' ; IAPS #: ',IAPSPicNo,'; IAPS Index: ',int2str(PicInd)];
				if SortByValStatus | SortByAroStatus
					ComStr=[ComStr,'; Sort Value: ',num2str(ValVec(Ind)),' ; Act. Value: ',num2str(ValAroVec(PicIndVec(Ind))),' ;  Diff.:,' num2str(DiffVec(Ind))];
				end
			end
% 			if PicVec(PicInd)<1000
% 				ImPathTmp='Paul:Movies:SmallMirrorGrid:';
% 				CountStr=AddZeros2CountStr(PicVec(PicInd),2);
% 				ImMat=imread([ImPath,CountStr,'.jpg'],'jpg');
% 			else
				CountStr=AddZeros2CountStr(PicVec(PicInd),3);
% 			end
			ImMat=imread([ImPath,CountStr,'.jpg'],'jpg');
            
			SizeImMat=size(ImMat);
			fprintf([ComStr,'\n']);
			if ~ColorStatus | BrightStatus
				MeanMat=mean(ImMat,3);
				for i=1:3
					if BrightStatus
						ImMat(:,:,i)=MeanMat./PicBrightVec(Ind);
					elseif ~ColorStatus
						ImMat(:,:,i)=MeanMat;
                    end
                end
            end
            if RandPixelVal>1
                %========Calculate Real Picture Size (without black frame)===============
                [p,q,r]=size(ImMat); %p = vertical i.A. 768; q = horizontal i.A. 1024
				SumImMat=sum(ImMat,3);
				VertSumImMat=sum(SumImMat,1);
				HorSumImMat=sum(SumImMat,2);
				[QInd]=find(VertSumImMat);		
				MinQInd=min(QInd)
				MaxQInd=max(QInd)
				[PInd]=find(HorSumImMat);
				MinPInd=min(PInd)
				MinPInd=10
				MaxPInd=max(PInd)
				MaxPInd=230
                ImMatNoBorder=ImMat(MinPInd:MaxPInd,MinQInd:MaxQInd,:);
                [VertSizeImMatNoBorder,HorSizeImMatNoBorder,NonUse]=size(ImMatNoBorder)
                RelVert=VertSizeImMatNoBorder/p
                RelHor=HorSizeImMatNoBorder/q
                VertHorSizeImMatNoBorder=VertSizeImMatNoBorder.*HorSizeImMatNoBorder
                ParVert=floor(p/RandPixelVal)
                ParHor=floor(q/RandPixelVal)
				VertRandPixelVal=floor(RelVert.*RandPixelVal)
				HorRandPixelVal=floor(RelHor.*RandPixelVal)
				LRandPixelVec=VertRandPixelVal.*HorRandPixelVal
                if RandPixelVal==2
                    RandPixelVec=[1 3 2 4];
                elseif  RandPixelVal==4
                    if round(IndTmp./2)==IndTmp./2 
                        RandPixelVec=[6 12 2 10 14 1 13 9 8 4 16 3 7 15 5 11];
                    else
                        RandPixelVec=[6 2 12 10 8 1 13 3 14 4 16 9 7 5 15 11];
                    end
                else
                    Test=1;
                    while ~isempty(Test)
                        RandPixelVec=[1:LRandPixelVec];
                        RandPixelVec=RandPixelVec(randperm(LRandPixelVec));
                        Test=find((RandPixelVec(2:LRandPixelVec)-1)-RandPixelVec(1:LRandPixelVec-1)==0);
                        if isempty(Test)
                            Test=find((RandPixelVec(RandPixelVal+1:LRandPixelVec)-RandPixelVal)-RandPixelVec(1:LRandPixelVec-RandPixelVal)==0);
                        end
                    end
                end
                ImMatNoBorderTmp=ImMatNoBorder;
                for i=1:VertRandPixelVal
                    for j=1:HorRandPixelVal
                         k=(i-1).*HorRandPixelVal+j;
                         Ind1=ceil(RandPixelVec(k)./HorRandPixelVal);
                         Ind2=RandPixelVec(k)-(Ind1-1).*HorRandPixelVal;
                         Tmp=ImMatNoBorder((Ind1-1).*ParVert+1:Ind1.*ParVert,(Ind2-1).*ParHor+1:Ind2*ParHor,:);
%                         if round(k./2)==k./2 %if k==2 %| k==4
%                           for m=1:SizeImMat(3)
%                              Tmp(:,:,m)=fliplr(Tmp(:,:,m));
%                           end
%                         end
                       ImMatNoBorderTmp((i-1).*ParVert+1:i*ParVert,(j-1).*ParHor+1:j*ParHor,:)=Tmp;
					end
				end
                ImMat(MinPInd:MaxPInd,MinQInd:MaxQInd,:)=ImMatNoBorderTmp;
                ImMatNoBorderTmp=[];
			end
            UpSideDownStatus=0
            if UpSideDownStatus
                for i=1:SizeImMat(3)
					ImMat(:,:,i)=flipud(ImMat(:,:,i));
				end
            end
			if MirrorStatus & IndTmp./2==round(IndTmp./2)
				for i=1:SizeImMat(3)
					ImMat(:,:,i)=fliplr(ImMat(:,:,i));
				end
			end
			if FixCrossStatus %& IndTmp>139
				XCenterPic=round(SizeImMat(1)./2);
				YCenterPic=round(SizeImMat(2)./2);
% 				ImMat(:,:,:)=zeros(size(ImMat));
				ImMat(XCenterPic-afix:XCenterPic+afix,YCenterPic-bfix:YCenterPic+bfix,:)=zeros(2*afix+1,2*bfix+1,3);
				for i=-1:1%0:0%-1:1
					if any(LowValAroIndVec==Ind) | any(HighValAroIndVec==Ind)
						ImMat(XCenterPic-afix:XCenterPic+afix,YCenterPic+i,1)=255.*ones(2*afix+1,1,1);
					else
						ImMat(XCenterPic-afix:XCenterPic+afix,YCenterPic+i,:)=255.*ones(2*afix+1,1,3);
					end
				end
				for i=-1:1%0:0%-1:1
					if any(LowValAroIndVec==Ind) | any(HighValAroIndVec==Ind)
						ImMat(XCenterPic+i,YCenterPic-bfix:YCenterPic+bfix,1)=255.*ones(1,2*bfix+1,1);	
					else
						ImMat(XCenterPic+i,YCenterPic-bfix:YCenterPic+bfix,:)=255.*ones(1,2*bfix+1,3);	
					end
				end
			end
			set(hPicFig,'Userdata',PicSortIndVec(PicInd),'Name',[TitleString,';    ',ComStr]);
		else		
			NCheckColPix=50;
			NCheckRowPix=50;
			NTotColPix=NCheckColPix.*NColCheck;
			NTotRowPix=NCheckRowPix.*NRowCheck;
			if floor(Ind./2)==Ind./2
				CkeckKind=1;
				ImMat=ValVec(Ind)./10.*ones(NTotColPix,NTotRowPix,3);
				for i=1:NColCheck
					for j=1:NRowCheck
						if floor((i+j)./2)==(i+j)./2 
							ImMat((i-1).*NCheckColPix+1:i.*NCheckColPix,(j-1).*NCheckRowPix+1:j*NCheckRowPix,:)=zeros(NCheckColPix,NCheckRowPix,3);
						end
					end
				end
% 				Tmp1=size(find(ImMat~=0))	
			else
				CkeckKind=2;
				ImMat=zeros(NTotColPix,NTotRowPix,3);
				for i=1:NColCheck
					for j=1:NRowCheck
						if floor((i+j)./2)==(i+j)./2 
							ImMat((i-1)*NCheckColPix+1:i*NCheckColPix,(j-1)*NCheckRowPix+1:j*NCheckRowPix,:)=ValVec(Ind)./10.*ones(NCheckColPix,NCheckRowPix,3);
						end
					end
				end
% 				Tmp2=size(find(ImMat~=0))
			end	
			set(hPicFig,'Name',[TitleString,' ;  Kind: ',int2str(CkeckKind),' ;  Brightness: ',num2str(ValVec(Ind))]);
		end
		image(ImMat); 
		axis('off');
		hold off
		if EyeTrackStatus | EyeTrackCalStatus
			EyeTrackMat=zeros(6,size(ETMat,3));
			EyeTrackMat(1:2,:)=squeeze(ETMat(Ind,:,:));
			%EyeTrackMat(2,:)=EyeTrackMat(2,:).*1.25;  
			a=find(EyeTrackMat(2,:)>0.5);
			EyeTrackMat(1,a)=EyeTrackMat(1,a)+.5.*(EyeTrackMat(2,a)-0.5);
			EyeTrackMat(3,:)=filtfilt(BLow,ALow,gradient(EyeTrackMat(1,:)));
			EyeTrackMat(4,:)=filtfilt(BLow,ALow,gradient(EyeTrackMat(2,:)));
			EyeTrackMat(5,:)=sqrt(EyeTrackMat(3,:).^2+EyeTrackMat(4,:).^2);
			EyeTrackMat(6,:)=sqrt(EyeTrackMat(1,:).^2+EyeTrackMat(2,:).^2);
			
			StdBase=std(EyeTrackMat(6,1:NEyeTrackBasePoints));
			StdTime=std(EyeTrackMat(6,NEyeTrackBasePoints+1:end));
			%SacMat: IAPSPicNo; Val; Aro; StdBase; StdTime; TimeFirstSac; AmpFirstSac; NSac; SumSac; MaxSac; RadFirstSac; PhiFirstSac
			SacMat(Ind,4)=StdBase; 				%StdBase
			SacMat(Ind,5)=StdTime;					%StdTime
			SacMat(Ind,10)=max(EyeTrackMat(6,:));	%MaxSac
			
			LimX=0.004;
			LimY=0.004;
			LimXY=sqrt(LimX.^2+LimY.^2);
			
			SupLimX=find(abs(EyeTrackMat(3,:))>LimX);
			TmpX=find(SupLimX>NEyeTrackBasePoints);
			SupLimX=SupLimX(TmpX);
			IndX2=find(diff(SupLimX)-1);
			IndX1=[1,IndX2+1];
			for i=1:length(IndX2)
				[NonUse,RelMaxIndX(i)]=max(abs(EyeTrackMat(3,SupLimX(IndX1(i)):SupLimX(IndX2(i)))));
				RelMaxIndX(i)=RelMaxIndX(i)+SupLimX(IndX1(i))-1;
			end
			
			SupLimY=find(abs(EyeTrackMat(4,:))>LimY);
			TmpY=find(SupLimY>NEyeTrackBasePoints);
			SupLimY=SupLimY(TmpY);
			IndY2=find(diff(SupLimY)-1);
			IndY1=[1,IndY2+1];
			for i=1:length(IndY2)
				[NonUse,RelMaxIndY(i)]=max(abs(EyeTrackMat(4,SupLimY(IndY1(i)):SupLimY(IndY2(i)))));
				RelMaxIndY(i)=RelMaxIndY(i)+SupLimY(IndY1(i))-1;
			end
		
			SupLimXY=find(EyeTrackMat(5,:)>LimXY);
			TmpXY=find(SupLimXY>NEyeTrackBasePoints);
			SupLimXY=SupLimXY(TmpXY);
			IndXY2=find(diff(SupLimXY)-1)
			IndXY1=[1,IndXY2+1];
			RelMaxAmpXY=[];
			RelMaxIndXY=[];
			FirstSacTime=[];
			for i=1:length(IndXY2)
				[RelMaxAmpXY(i),RelMaxIndXY(i)]=max(EyeTrackMat(5,SupLimXY(IndXY1(i)):SupLimXY(IndXY2(i))));
				RelMaxIndXY(i)=RelMaxIndXY(i)+SupLimXY(IndXY1(i))-1;
			end
			NSac=length(RelMaxIndXY);
			if NSac>0
				TimeFirstSac=(RelMaxIndXY(1)-NEyeTrackBasePoints+1).*2;
				SacMat(Ind,6)=TimeFirstSac;			%TimeFirstSac
				SacMat(Ind,7)=RelMaxAmpXY(1);	%AmpFirstSac
				SacMat(Ind,8)=NSac;				%NSac
				SacMat(Ind,9)=sum(RelMaxAmpXY); 	%SumSac
				FirstSacStart=RelMaxIndXY(1)+10;
				FirstSacEnd=FirstSacStart+60;
				if length(RelMaxIndXY)>2
					FirstSacEnd=min([RelMaxIndXY(2),FirstSacEnd]);
				end
				FirstSacMean=mean(EyeTrackMat(1:2,FirstSacStart:FirstSacEnd),2)-0.5;
				FirstSacMeanX=FirstSacMean(1);
				FirstSacMeanY=FirstSacMean(2);
				SacMat(Ind,11)=sqrt(sum(FirstSacMean.^2));
				SacMat(Ind,12)=atan2(FirstSacMean(2),FirstSacMean(1)); %PhiFirstSac; Four quadrant inverse tangent
				SacMat(Ind,12)=(SacMat(Ind,12)./pi).*180;
			end	
			NDistPoint=25;
			for PointInd=1:NDistPoint:NEyeTrackPoints2Show
				HorPos=median(EyeTrackMat(1,PointInd:PointInd+NDistPoint-1));
				VertPos=median(EyeTrackMat(2,PointInd:PointInd+NDistPoint-1));
				HorGrad=median(EyeTrackMat(3,PointInd:PointInd+NDistPoint-1));
				VertGrad=median(EyeTrackMat(4,PointInd:PointInd+NDistPoint-1));
				ColorTmp=ColorMat(PointInd.*ColorPointFak,1:3);
				Pos=[HorPos VertPos];
				Rot=180+(atan2(HorGrad,VertGrad).*180)./pi;
				FontSize=30+round(sqrt(HorGrad.^2+VertGrad.^2));
				hText1=text('Units','Normal','Color',ColorTmp,'Position',Pos,'String','>','Rotation',Rot,'FontSize',FontSize,'FontWeight','Bold');
			end		
			hText2=text('Units','Normal','Color',[1 0 0],'Position',[FirstSacMean+0.5],'String','','FontSize',50,'FontWeight','Bold');
			SacVec=SacMat(Ind,:);
			SacVec([4,5,9,10,11])=SacVec([4,5,9,10,11]).*1000;
			SacVec(7)=SacVec(7).*10000;
			Tmp1=['IAPS #: ',int2str(SacVec(1)),'; Val: ',num2str(SacVec(2)),'; Aro: ',num2str(SacVec(3)),'; Std.: ',int2str(SacVec(4:5)),'; FOT: ',int2str(SacVec(6))];
			Tmp2=['; FOA: ',int2str(SacVec(7)),'; NSac: ',int2str(SacVec(8)),'; SumSac:',int2str(SacVec(9)),'; MaxSac:',int2str(SacVec(10)),'; FOR: ',int2str(SacVec(11)),'; FOP: ',int2str(SacVec(12))];
			set(hPicFig,'Name',[Tmp1,Tmp2]);
			
			figure(hEyeTrack)
			clf;

			axes('Units','Normal','Position',[.1 .725 .85 .25])
			plot(xPlotVec,EyeTrackMat(1,:),'b')
			hold on
			plot(xPlotVec,EyeTrackMat(2,:),'k')
			if NSac>0
				plot(xPlotVec(FirstSacStart:FirstSacEnd),EyeTrackMat(1,FirstSacStart:FirstSacEnd),'xb')
				plot(xPlotVec(FirstSacStart:FirstSacEnd),EyeTrackMat(2,FirstSacStart:FirstSacEnd),'xk')
			end
			axis([min(xPlotVec) max(xPlotVec) 0 1])
			title('Movement: Blue: x - Horizontal; Black: y - Vertical')
			hold off
			
			axes('Units','Normal','Position',[.1 .425 .85 .25])
			plot(xPlotVec,EyeTrackMat(3,:),'b')
			hold on
			plot(xPlotVec(RelMaxIndX),EyeTrackMat(3,RelMaxIndX),'*b')
			plot(xPlotVec,EyeTrackMat(4,:),'k')
			plot(xPlotVec(RelMaxIndY),EyeTrackMat(4,RelMaxIndY),'*k')
			plot([xPlotVec(1) xPlotVec(end)],[LimX LimX],'--b')
			plot([xPlotVec(1) xPlotVec(end)],[-LimX -LimX],'--b')
% 			plot([xPlotVec(1) xPlotVec(end)],[LimY LimY],'--k')
% 			plot([xPlotVec(1) xPlotVec(end)],[-LimY -LimY],'--k')
			axis([min(xPlotVec) max(xPlotVec) -.025 .025])
			title('Gradient: Blue: x - Horizontal; Black: y - Vertical')
			hold off
			
			axes('Units','Normal','Position',[.1 .125 .85 .25])
			plot(xPlotVec,EyeTrackMat(5,:),'b')
			hold on
			plot(xPlotVec(RelMaxIndXY),EyeTrackMat(5,RelMaxIndXY),'*r')
  			plot([xPlotVec(1) xPlotVec(end)],[LimXY LimXY],'--r')
			axis([min(xPlotVec) max(xPlotVec) 0 .04])
			title(['Length of Gradient Vector'])
			hold off
			
			axes('Units','Normal','Position',[.1 .05 .85 .03])
 			pcolor(xPlotVec,[0 1],ones(2,1)*xPlotVec); 
			shading interp;
			set(gca,'YTick',[],'YTickLabel',[]);
			xlabel('Time [ms]')
			colormap(ColorMat);
			hold off
			pause(1)
		end
		figure(hFuncFig);
		if any(LowValAroIndVec==Ind) | any(HighValAroIndVec==Ind)
			PlotStr='*r';
		else
			PlotStr='*k';
		end
 		if~CheckStatus
			if SortByValStatus | SortByAroStatus 
				plot(IndTmp,ValAroVec(PicInd),PlotStr)
				plot([IndTmp,IndTmp],[ValAroVec(PicInd)-ValAroStdVec(PicInd)./2,ValAroVec(PicInd)+ValAroStdVec(PicInd)./2],'-')
			elseif SortByRGBHSVStatus
				plot(Ind,ValVec(Ind),PlotStr)
			else
				plot(Ind,PicVec(Ind),PlotStr)
			end
		else
			plot(Ind,ValVec(Ind),PlotStr)
		end
		if RatePictureStatus; 
			IAPSMovie('GetRateMat')
			figure(hRateMenuFig);
			uiwait(hRateMenuFig); 
		else
			pause(.01);
		end
		figure(hPicFig);
		if Print2FileStatus
			SaveInd=Ind;
			IndStr=AddZeros2CountStr(SaveInd,3);
			Print2FilePath=[Print2Path,IndStr];
			if strcmp(Print2FileMethodString,'EPS')
				Print2FileString=['print -deps ' Print2FilePath];
			elseif strcmp(Print2FileMethodString,'EPSTIFF')
				Print2FileString=['print -deps -tiff ' Print2FilePath];
			elseif strcmp(Print2FileMethodString,'JPEG')
				Print2FileString=['print -djpeg',int2str(Print2FileCompVal),' ',Print2FilePath];
			elseif strcmp(Print2FileMethodString,'TIFF')
				Print2FileString=['print -dtiff -r',int2str(Print2FileCompVal),' ',Print2FilePath];
			end
			eval(Print2FileString)
		end
	end	%for Ind=1:NPic2Show
end
