function [Data,File,Path,FilePath,SizeData]=ReadMauData.m(FilePath)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%==================================================================
%
%	ReadMauData.m
%
%	Markus Junghoefer	[2003]
%
%
%	
% 	Function definition
% 
% 			  
%=================================================================
if nargin<1;FilePath=[];end

FilePath='Tim:Data:EEG:Bologna:Mau.dat'

[DefPath]=SetDefPath(1,FilePath);
[File,Path,FilePath]=ReadFilePath(FilePath,DefPath);
SetDefPath(2,Path);
if File==0; Data=[]; File=[]; Path=[]; FilePath=[]; SizeData=[]; return; end
fid=fopen(FilePath,'r');
fprintf('Start reading data from file\n\n'); 
disp(FilePath);
fprintf('\n\n'); 
tline=fgetl(fid);

% fseek(fid,16302810,'bof')
% fseek(fid,16302000,'bof')
%fseek(fid,27554200,'bof')
%fseek(fid,71486135,'bof')
 
% line=fgetl(fid)
% a=ftell(fid)
% line=fgetl(fid)
% a=ftell(fid)
% fclose(fid);
% return;
% SubStr=fscanf(fid,'%s',1)
% SubStr=fscanf(fid,'%s',1)
% SubStr=fscanf(fid,'%s',1)
% SubStr=fscanf(fid,'%s',1)
% SubStr=fscanf(fid,'%s',1)
% return
% line=fgetl(fid)
% b=ftell(fid)
% line=fgetl(fid)
% return
% line=[]
% while isempty(findstr(line,'s12 bl4 c1'))
% 	a=ftell(fid)
% 	line=fgetl(fid);
% end
% b=ftell(fid)
% return

NChan=60;
NPoints=600;
DataMat=zeros(NChan,NPoints);
for CondInd=1:40
	for ChanInd=1:NChan
		SubStr=fscanf(fid,'%s',1)
		Sub=str2num(SubStr(2:end));
		BlockStr=fscanf(fid,'%s',1);
		Block=str2num(BlockStr(3:end));
		cStr=fscanf(fid,'%s',1);
		c=str2num(cStr(2:end));
		NoUse=fscanf(fid,'%s',5);
		ChanNameStr=fscanf(fid,'%s',1);
		ChanNumberStr=fscanf(fid,'%s',1);
		if ChanInd<22 | (ChanInd>25 & ChanInd<27) | (ChanInd>30 & ChanInd<59)
			NoUse=fscanf(fid,'%s',4);
		elseif ChanInd==59 | ChanInd==60
			NoUse=fscanf(fid,'%s',1);
		else
			NoUse=fscanf(fid,'%s',3);
		end
		if ChanInd==1
			SensorNames=char(ChanNameStr);
			SensorNumbers=char(ChanNumberStr);
			if strcmp(SubStr(1),'s')
				SaveFile=[SubStr(2:end),'.1.',int2str(Block),'.at',int2str(c)];
				SavePath='Tim:Data:EEG:Bologna:01:';
			elseif strcmp(SubStr(2),'s')
				SaveFile=[SubStr(3:end),'.2.',int2str(Block),'.at',int2str(c)];
				SavePath='Tim:Data:EEG:Bologna:02:';
			else
				error('SaveFile')
			end
			fprintf('\n\n ')
			disp(SaveFile)
			fprintf('\n')
		else
			SensorNames=char(SensorNames,ChanNameStr);
			SensorNumbers=char(SensorNumbers,ChanNumberStr);
		end
		for PointInd=1:NPoints
			DataMat(ChanInd,PointInd)=str2num(fscanf(fid,'%s',1));
		end
		NoUseStr=fscanf(fid,'%s',26);
		fprintf('.')
	end
	SaveFilePath=[SavePath,SaveFile];
	SaveAvgFile(SaveFilePath,DataMat,[],zeros(size(DataMat)),1000,[],[],1,2);
	fseek(fid,-800,'cof')
	line=fgetl(fid)
	a=ftell(fid)
end
fclose(fid);
return
