function [OutFileMat]=ResampleAvgFiles(InFileMat,SampRateNew,AddFileExt)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%==================================================================
%
%	ResampleAvgFiles.m
%
%	Markus Junghoefer	[1999]
%
%
%	Function definition
%
%	[OutFileMat]=ResampleAvgFiles(InFileMat,SampRateNew,AddFileExt)
%
%
%
%=================================================================
if nargin<3; AddFileExt=1; end
if nargin<2; SampRateNew=250; end
if nargin<1; InFileMat=[]; end

DefFilePath=SetDefPath(1,'*.at*');
[NFilesIn,InFileMat,NonUse,BatchFilePath]=ReadFileNames(InFileMat,DefFilePath,'Choose SCADS *.at* avg file(s) or batch file:');
[BatchFile,BatchPath]=SepFilePath(BatchFilePath);
SetDefPath(2,BatchPath);

for FileIndex=1:NFilesIn
	[InFile,InPath,InFilePath]=GetFileNameOfMat(InFileMat,FileIndex);
	[AvgMat,File,Path,FilePath,NTrialAvgVec,StdMat,...
	SampRate,AvgRef,Version,MedMedRawVec,MedMedAvgVec,EegMegStatus,NChanExtra]=ReadAvgFile(InFilePath);
    [NChan,NPoints]=size(AvgMat);
    SampRate=round(SampRate)
    SampRateNew=round(SampRateNew)
    AvgMatSample=resample(AvgMat',SampRateNew,SampRate)';
    StdMatSample=resample(StdMat',SampRateNew,SampRate)';
    [NChan,NPointsSample]=size(AvgMatSample);
    if AddFileExt
        OutFilePath=[InFilePath '.s',int2str(SampRateNew)];
    else
        OutFilePath=InFilePath;
    end
    SampRateNew=678.17
	SaveAvgFile(OutFilePath,AvgMatSample,NTrialAvgVec,StdMatSample,SampRateNew,MedMedRawVec,MedMedAvgVec,EegMegStatus,NChanExtra);
    if FileIndex==1
        OutFileMat=char(OutFilePath);
    else
        OutFileMat=char(OutFileMat,OutFilePath);
    end
end
return;

