%==================================================================
%
%	SaveAscii.m
%
%	Markus Junghoefer	[1996]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%	
%	Function definition

	function [SaveFilePath]=SaveAscii123(DataMat,FilePath,DefFileName,WriteSizeStatus)
	
%=================================================================
if nargin<4;WriteSizeStatus=0;end;
if nargin<3;DefFileName='Untitled';end;
if nargin<2;FilePath=[];end;
if nargin<1;DataMat=[];return; end;

if isempty(FilePath)
	[File,Path,FilePath]=WriteFilePath(DefFileName,'Choose a file name:');
	if File==0; FilePath=[]; return; end
end
fid=fopen(FilePath,'w','b');
if WriteSizeStatus
	fprintf(fid,'%g\t',size(DataMat));
end
SizeDataMat=size(DataMat);
for i=1:SizeDataMat(1)
	for j=1:SizeDataMat(3)
		for k=1:SizeDataMat(2)
			fprintf(fid,'%g\t',DataMat(i,k,j));
		end
	end
end
fclose(fid);	
return;
