function[OutFilePath]=ScadsX(InFileMat,Fac,Ext)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%==================================================================
%
%	ScadsX
%
%	Markus Junghoefer	[2002]
%
%
%	Function definition
%
%
%
%==================================================================
if nargin<3; Ext=[]; end;
if nargin<2; Fac=[]; end;
if nargin<1; InFileMat=[]; end;

global BaseMat
%==================================================================
if isempty(Fac); Fac=2; end
if isempty(Ext); Ext=['.x',num2str(Fac)]; end

[DefFilePath] = SetDefPath(1,'*');
[NFiles,InFileMat,NonUse,BatchFilePath]=ReadFileNames(InFileMat,DefFilePath,'Choose Avg files:');
[BatchFile,BatchPath]=SepFilePath(BatchFilePath);
SetDefPath(2,BatchPath);
if NFiles==0
	fprintf(1,'Sorry, no file in InFileMat !\n'); 
	fprintf(1,'Running file: AddSubPoints2AvgFiles');
	return;
end
	
for FileIndex=1:NFiles
	[File,Path,FilePath]=GetFileNameOfMat(InFileMat,FileIndex);
	[AvgMat,File,Path,FilePath,NTrialAvgVec,StdMat,...
	SampRate,AvgRef,Version,MedMedRawVec,MedMedAvgVec,EegMegStatus,NChanExtra]=ReadAvgFile(FilePath);
	[NChan,NPoints]=size(AvgMat);
	AvgMat=CalcBaseline(AvgMat,1,NPoints);
	NPointsNew=NPoints.*Fac;
	
    fprintf(1,'\n\n');
    fprintf(1,'Original number of points: %g\n',NPoints);
    fprintf(1,'New number of points:      %g\n',NPointsNew);
    AvgMatNew=zeros(NChan,NPointsNew);
	for FacInd=1:Fac
		AvgMatNew(:,(FacInd-1).*NPoints+1:FacInd.*NPoints)=AvgMat;
		StdMatNew(:,(FacInd-1).*NPoints+1:FacInd.*NPoints)=StdMat;
	end
    SaveAvgFile([FilePath,Ext],AvgMatNew,NTrialAvgVec,StdMatNew,SampRate,MedMedRawVec,MedMedAvgVec,EegMegStatus,NChanExtra);
end



return;
