function[LongEGISFileMat,ShortEGISFileMat]=TransNetGeoGamma(FileMat,TRStatus,
LongPreTrig,LongPostTrig,ShortPreTrig,ShortPostTrig,LongReTrig,ShortReTrig,
GainFilePath,ZeroFilePath,GivenNLongTrials,GivenNShortTrials)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%==================================================================
%
%	TransNetGeoGamma.m
%
%	Markus Junghoefer	[1997]
%
%
%	Function definition
%
%
%
%==================================================================
if nargin<12; GivenNShortTrials=[]; end;
if nargin<11; GivenNLongTrials=[]; end;
if nargin<10; ZeroFilePath=[]; end;
if nargin<9; ShortReTrig=[]; end;
if nargin<8; LongReTrig=[]; end;
if nargin<7; ShortPreTrig=[]; end;
if nargin<6; ShortPostTrig=[]; end;
if nargin<5; ShortPreTrig=[]; end;
if nargin<4; LongPostTrig=[]; end;
if nargin<3; LongPreTrig=[]; end;
if nargin<2; TRStatus=[]; end;
if nargin<1; FileMat=[]; end;

%==================================================================
fprintf('\n');clc;
[TRStatus]=IfEmptyInputSpecVal(TRStatus,[-1 1],1,...
'Please insert the file status:\n',...
'RAW                   [ 1]',...
'TAW                   [-1]');

if TRStatus==1; Mask='*.RAW'; elseif TRStatus==-1; Mask='*.TAW' ; end

[NFiles,FileMat]=ReadFileNames(FileMat,Mask,'Choose NetStation file:');
if NFiles==0; return; end

LongEGISFileMat=FileNameExt2Mat(FileMat,'E1',3);
ShortEGISFileMat=FileNameExt2Mat(FileMat,'E2',3);
[LongCondFileMat]=FileNameExt2Mat(LongEGISFileMat,'.CON');
[ShortCondFileMat]=FileNameExt2Mat(ShortEGISFileMat,'.CON');


%=========EGIS Header======================
global BytOrd; 					BytOrd=[0 0 0 0];
global HdrVer; 				
global LData;					
global LHeader;					LHeader=[];
global ExptNam;					ExptNam=zeros(80,1);
global RunDate;		
global RunTime; 		
global SubjID;					SubjID=0;
global Handed;					Handed=0;
global Sex;						Sex=0;
global Age;						Age=0;
global ExperID;					ExperID=0;
global EdVer;				
global CalFlag;					CalFlag=0;
global NChan;				
global LComment;				LComment=0;
global LText;					
global LPad;						
global BrdGain;			
global ChanGain;		
global ChanZero;		
global CellName;				CellName=zeros(80,1);
global LHeader;					LHeader=[];
global NCells;					NCells=1;
global CellID;					CellID=0;
global NTrials;			
global NPoints;		    
global SampRate;		
global LSpec	;		
global LSpecCell1;		
global LCellHdr;		
%===============================



for FileIndex=1:NFiles
	
	TimeMsVec=[];
	TrigBitMat=[];
	CondVec=[];
	LongCondVec=[];
	ShortCondVec=[];
	LongTimeMsVec=[];
	LongTrialVec=[];
	LongIndVec=[];
	LongTrialStatusVec=[];
	ShortTimeMsVec=[];
	ShortTrialVec=[];
	ShortIndVec=[];
	ShortTrialStatusVec=[];
	OkTrialsIndVec=[];
	
	[NetFile,NetPath,NetFilePath]=GetFileNameOfMat(FileMat,FileIndex)
	
	fprintf('\n')
	fprintf('TransNetGeoGamma\n')
	fprintf(NetFilePath)
	fprintf('\n')
	clc;
	fprintf('Start reading data file...\n\n');
	fprintf(NetFilePath);
	fprintf('\n\n');

	NetFid=fopen(NetFilePath,'r');

	%=========NetStation Header===============

	Version=fread(NetFid,1,'long');
	Year=fread(NetFid,1,'short');
	Month=fread(NetFid,1,'short');
	Day=fread(NetFid,1,'short');
	Hour=fread(NetFid,1,'short');
	Minute=fread(NetFid,1,'short');
	Sec=fread(NetFid,1,'short');
	MSec=fread(NetFid,1,'long');
	SampRate=fread(NetFid,1,'short');
	NChan=fread(NetFid,1,'short');
	BrdGain=fread(NetFid,1,'short');
	Bits=fread(NetFid,1,'short');
	Range=fread(NetFid,1,'short');
	NNetPoints=fread(NetFid,1,'long');
	NNetEvents=fread(NetFid,1,'short');
	EventCodes=fread(NetFid,[NNetEvents,4],'char');
	LNetHeader=ftell(NetFid);
	
	[LongPreTrig]  =IfEmptyInputValInt(['Please insert the long'],['pre trigger intervall:'],LongPreTrig,1500,-(NNetPoints-1),NNetPoints-1,1);
	[LongPostTrig]=IfEmptyInputValInt(['Please insert the long'],['post trigger intervall:'],LongPostTrig,200,-(NNetPoints-LongPreTrig),NNetPoints-LongPreTrig);
	LongDistTrig=LongPreTrig+LongPostTrig+1;

	[ShortPreTrig]  =IfEmptyInputValInt(['Please insert the short'],['pre trigger intervall:'],ShortPreTrig,1500,-(NNetPoints-1),NNetPoints-1,1);
	[ShortPostTrig]=IfEmptyInputValInt(['Please insert the short'],['post trigger intervall:'],ShortPostTrig,200,-(NNetPoints-ShortPreTrig),NNetPoints-ShortPreTrig);
	ShortDistTrig=ShortPreTrig+ShortPostTrig+1;

	
	TimeMsStart=MSec+Sec.*1000+Minute.*60000+Hour.*3600000;

	LNetFile=length(NetFile);
	if isempty(GainFilePath) 
		if LNetFile>4
			if strcmp(NetFile(LNetFile-5:LNetFile-4),'.f')	%filtered data
				GainFilePath=[NetPath,NetFile(1:LNetFile-5) 'Gain'];
			else
				GainFilePath=[NetPath,NetFile(1:LNetFile-3) 'Gain'];
			end
		else
			GainFilePath=[NetPath,NetFile(1:LNetFile-3) 'Gain'];
		end
	end
	if isempty(ZeroFilePath) 
		if LNetFile>4
			if strcmp(NetFile(LNetFile-5:LNetFile-4),'.f')	%filtered data
				ZeroFilePath=[NetPath,NetFile(1:LNetFile-5) 'Zero'];
			else
				ZeroFilePath=[NetPath,NetFile(1:LNetFile-3) 'Zero'];
			end
		else
			ZeroFilePath=[NetPath,NetFile(1:LNetFile-3) 'Zero'];
		end	
	end
	[ChanGain,ChanZero,...
	GainYear,GainMonth,GainDay,GainHour,GainMinute,GainSec,GainMSec,...
	ZeroYear,ZeroMonth,ZeroDay,ZeroHour,ZeroMinute,ZeroSec,ZeroMSec,OldVersion]=...
	ReadNetGainZero(NChan,GainFilePath,ZeroFilePath);	
	fprintf('Time dist between data file and gain file:\n\n')
	TimeDiffInfo([Year Month Day Hour Minute Sec MSec; GainYear GainMonth GainDay GainHour GainMinute GainSec GainMSec],1,.5);
	fprintf('Time dist between data file and zero file:\n\n')
	TimeDiffInfo([Year Month Day Hour Minute Sec MSec; ZeroYear ZeroMonth ZeroDay ZeroHour ZeroMinute ZeroSec ZeroMSec],1,.5);

	if isempty(NNetEvents) | NNetEvents==0
		fprintf('Sorry, no trigger channel in this file !\n')
		pause(4)
	else
		fprintf('Number of trigger channels in this file : %g\n\n',NNetEvents); again=0;
		fprintf('End reading data header...\n');
		pause(.5)
		%===============================================================================
		
		HistFilePath=[NetPath,NetFile(1:LNetFile-3) 'HIST'];
			
		[HistFile,HistPath,HistFilePath]=ReadFilePath(HistFilePath,'*.HIST',['Choose the HIST file:']);
		fprintf('\n\n'); clc;
		fprintf('Read Hist file:\n\n')
		fprintf(HistFilePath)
		
		HistFid=fopen(HistFilePath,'r');
		
		Tmp=fscanf(HistFid,'%s',1);	%Event
		Tmp=fscanf(HistFid,'%s',1);	%History
		StartTimeTest=fscanf(HistFid,'%s',1);
		StartMsTest=StartTimeTest(19)-48;
		StartMsTest=StartMsTest+(StartTimeTest(18)-48).*10;
		StartMsTest=StartMsTest+(StartTimeTest(17)-48).*100;
		StartMsTest=StartMsTest+(StartTimeTest(15)-48).*1000;
		StartMsTest=StartMsTest+(StartTimeTest(14)-48).*10000;
		StartMsTest=StartMsTest+(StartTimeTest(12)-48).*60000;
		StartMsTest=StartMsTest+(StartTimeTest(11)-48).*600000;
		StartMsTest=StartMsTest+(StartTimeTest(9)-48).*3600000;
		StartMsTest=StartMsTest+(StartTimeTest(8)-48).*36000000;

		if TimeMsStart~=StartMsTest;
			fprintf('WARNING:\n\n')
			fprintf('Start time in file:\n')
			fprintf(NetFilePath)
			fprintf('\n')
			fprintf('differs from start time in file:\n')
			fprintf(HistFilePath)
			fprintf('\n\n')
			fprintf('Take start time from HIST file for further calculations:')
			pause(2)
			TimeMsStart=StartMsTest;
		end
		
		Index=0;
		Tmp='Blodsinn';
		fseek(HistFid,0,'bof');
		while ~strcmp(Tmp,'Stimulus')
			Tmp=fscanf(HistFid,'%s',1);
			Index=Index+1;
		end
		Index=Index-3;
		fseek(HistFid,0,'bof');
		Tmp=fscanf(HistFid,'%s',Index);

		Index=0;
		Count=1;
		Tell1=ftell(HistFid);
		while Count==1
			Index=Index+1;
			[Tmp1,Count]=fscanf(HistFid,'%s',1);
			[Tmp2,Count]=fscanf(HistFid,'%s',1);
			[Tmp3,Count]=fscanf(HistFid,'%s',1);
			[Tmp4,Count]=fscanf(HistFid,'%s',1);
			[Tmp5,Count]=fscanf(HistFid,'%s',1);
		end
		NTrig=Index-1;
		NRowTrigDateTimeMat=19;
		TrigDateTimeMat=zeros(NTrig,NRowTrigDateTimeMat);
		TrigCodeMat=zeros(NTrig,6);
		TrigBitMat=zeros(NTrig,4);

		fseek(HistFid,Tell1,'bof');
		for Index=1:NTrig
			[Tmp1,Count]=fscanf(HistFid,'%s',1);
			[Tmp2,Count]=fscanf(HistFid,'%s',1);
			[Tmp3,Count]=fscanf(HistFid,'%s',1);
			[Tmp4,Count]=fscanf(HistFid,'%s',1);
			[Tmp5,Count]=fscanf(HistFid,'%s',1);
			TrigDateTimeMat(Index,:)=Tmp1;
			TrigCodeMat(Index,:)=Tmp5;
		end
		
		
		TmpOld=0;
		Index2=0;
		
		
		for Index1=1:NTrig
			TmpNew=TrigDateTimeMat(Index1,19)-48;									
			TmpNew=TmpNew+(TrigDateTimeMat(Index1,18)-48).*10;			
			TmpNew=TmpNew+(TrigDateTimeMat(Index1,17)-48).*100;		
			TmpNew=TmpNew+(TrigDateTimeMat(Index1,15)-48).*1000;	
			TmpNew=TmpNew+(TrigDateTimeMat(Index1,14)-48).*10000;
			TmpNew=TmpNew+(TrigDateTimeMat(Index1,12)-48).*60000;
			TmpNew=TmpNew+(TrigDateTimeMat(Index1,11)-48).*600000;
			TmpNew=TmpNew+(TrigDateTimeMat(Index1,9)-48).*3600000;
			TmpNew=TmpNew+(TrigDateTimeMat(Index1,8)-48).*36000000;
			
			if 	TmpNew-TmpOld>3	
				Index2=Index2+1;
				TimeMsVec(Index2)=TmpNew;
			end
				
			Tmp=TrigCodeMat(Index1,5);
			if strcmp(Tmp,'1')
				TrigBitMat(Index2,1)=1;
			elseif strcmp(Tmp,'2')
				TrigBitMat(Index2,2)=1;
			elseif strcmp(Tmp,'3')
				TrigBitMat(Index2,3)=1;
			elseif strcmp(Tmp,'4')
				TrigBitMat(Index2,4)=1;
			end
			TmpOld=TmpNew;
		end
		
		NTrig=Index2;
		TimeMsVec=TimeMsVec-TimeMsStart.*ones(size(TimeMsVec)); 
		TrigBitMat=TrigBitMat(1:NTrig,:);
		
		for Index=1:NTrig
			if TrigBitMat(Index,:)==[0 0 0 0];
				CondVec(Index)=0;
			elseif TrigBitMat(Index,:)==[1 0 0 0];
				CondVec(Index)=1;
			elseif TrigBitMat(Index,:)==[0 1 0 0];
				CondVec(Index)=2;
			elseif TrigBitMat(Index,:)==[1 1 0 0];
				CondVec(Index)=3;
			elseif TrigBitMat(Index,:)==[0 0 1 0];
				CondVec(Index)=4;
			elseif TrigBitMat(Index,:)==[1 0 1 0];
				CondVec(Index)=5;
			elseif TrigBitMat(Index,:)==[0 1 1 0];
					CondVec(Index)=6;
			elseif TrigBitMat(Index,:)==[1 1 1 0];
					CondVec(Index)=7;
			elseif TrigBitMat(Index,:)==[0 0 0 1];
					CondVec(Index)=8;
			elseif TrigBitMat(Index,:)==[1 0 0 1];
					CondVec(Index)=9;
			elseif TrigBitMat(Index,:)==[0 1 0 1];
					CondVec(Index)=10;
			elseif TrigBitMat(Index,:)==[1 1 0 1];
					CondVec(Index)=11;
			elseif TrigBitMat(Index,:)==[0 0 1 1];
					CondVec(Index)=12;
			elseif TrigBitMat(Index,:)==[1 0 1 1];
					CondVec(Index)=13;
			elseif TrigBitMat(Index,:)==[0 1 1 1];
					CondVec(Index)=14;
			elseif TrigBitMat(Index,:)==[1 1 1 1];
					CondVec(Index)=15;
			end
		end
		%=================================================================================
		%============Negiere Bedingungen 9 und 10=========================================
		
		NoCond9_10IndVec=find(CondVec~=9 & CondVec~=10);
		NTrig=length(NoCond9_10IndVec);
		CondVec=CondVec(NoCond9_10IndVec);
		TimeMsVec=TimeMsVec(NoCond9_10IndVec);
		
		%=================================================================================
		%=============================Suche Bedingungen===================================
		%=================================================================================
		ActLongCond=0;			
		LongIndex=0;
		ShortIndex=0;
		for Index=1:NTrig		%Alle Marker
			if CondVec(Index)>0 & CondVec(Index)<9
				LongIndex=LongIndex+1;
				LongIndVec(LongIndex)=Index;
				LongCondVec(LongIndex)=CondVec(Index);
				ActLongCond=CondVec(Index);
			elseif CondVec(Index)>8 & CondVec(Index)<16
				ShortIndex=ShortIndex+1;
				ShortIndVec(ShortIndex)=Index;
				if CondVec(Index)==11 & (ActLongCond==5 | ActLongCond==6)
					ShortCondVec(ShortIndex)=1;									%Target, rechts, stehend, beachtet
				elseif CondVec(Index)==12 & (ActLongCond==1 | ActLongCond==2)
					ShortCondVec(ShortIndex)=2;									%Target, rechts, stehend, unbeachtet
				elseif CondVec(Index)==11 & (ActLongCond==7 | ActLongCond==8)
					ShortCondVec(ShortIndex)=3;									%Target, rechts, bewegt, beachtet
				elseif CondVec(Index)==12 & (ActLongCond==3 | ActLongCond==4)
					ShortCondVec(ShortIndex)=4;									%Target, rechts, bewegt, unbeachtet
				elseif CondVec(Index)==11 & (ActLongCond==3 | ActLongCond==4)
					ShortCondVec(ShortIndex)=5;									%Target, links, stehend, beachtet
				elseif CondVec(Index)==12 & (ActLongCond==7 | ActLongCond==8)
					ShortCondVec(ShortIndex)=6;									%Target, links, stehend, unbeachtet
				elseif CondVec(Index)==11 & (ActLongCond==1 | ActLongCond==2)
					ShortCondVec(ShortIndex)=7;									%Target, links, bewegt, beachtet
				elseif CondVec(Index)==12 & (ActLongCond==5 | ActLongCond==6)
					ShortCondVec(ShortIndex)=8;									%Target, links, bewegt, unbeachtet
				elseif CondVec(Index)==13 & (ActLongCond==5 | ActLongCond==6)
					ShortCondVec(ShortIndex)=9;									%Standart, rechts, stehend, beachtet
				elseif CondVec(Index)==14 & (ActLongCond==1 | ActLongCond==2)
					ShortCondVec(ShortIndex)=10;								%Standart, rechts, stehend, unbeachtet
				elseif CondVec(Index)==13 & (ActLongCond==7 | ActLongCond==8)
					ShortCondVec(ShortIndex)=11;								%Standart, rechts, bewegt, beachtet
				elseif CondVec(Index)==14 & (ActLongCond==3 | ActLongCond==4)
					ShortCondVec(ShortIndex)=12;								%Standart, rechts, bewegt, unbeachtet
				elseif CondVec(Index)==13 & (ActLongCond==3 | ActLongCond==4)
					ShortCondVec(ShortIndex)=13;								%Standart, links, stehend, beachtet
				elseif CondVec(Index)==14 & (ActLongCond==7 | ActLongCond==8)
					ShortCondVec(ShortIndex)=14;								%Standart, links, stehend, unbeachtet
				elseif CondVec(Index)==13 & (ActLongCond==1 | ActLongCond==2)
					ShortCondVec(ShortIndex)=15;								%Standart, links, bewegt, beachtet
				elseif CondVec(Index)==14 & (ActLongCond==5 | ActLongCond==6)
					ShortCondVec(ShortIndex)=16;								%Standart, links, bewegt, unbeachtet
				end
			end
		end
		
		%=================================================================================
		%=================================================================================
		
		%============Save LongCond to file======================================
		if ~isempty(GivenNLongTrials)
			if NLongTrials~=GivenNLongTrials; error('Bad number of trials.');end
		end
		
		NLongTrials=length(LongCondVec);
		fprintf('\n'); clc;
		fprintf('Number of long trials: %g ',NLongTrials); pause(.5)
		
		LongTimeMsVec=TimeMsVec(LongIndVec);
		LongTrialVec=ceil(LongTimeMsVec./(1000./SampRate))+ones(size(LongTimeMsVec));
		
		LongTrialStatusVec=ones(NLongTrials,1);
		if LongTrialVec(1)<LongPreTrig; LongTrialStatusVec(1)=0; end
		if ~LongReTrig
			for TrialInd=2:NLongTrials
				if LongTrialVec(TrialInd)-LongTrialVec(TrialInd-1)<LongDistTrig; LongTrialStatusVec(TrialInd)=0; LongTrialStatusVec(TrialInd-1)=0; end
			end
		end
		if NNetPoints-LongTrialVec(NLongTrials)<LongPostTrig; LongTrialStatusVec(NLongTrials)=0; end
		OkTrialsIndVec=find(LongTrialStatusVec==1);
		NLongTrials=length(OkTrialsIndVec);
		fprintf('Number of long trials to save: %g ',NLongTrials);
		LongCondVec=LongCondVec(OkTrialsIndVec);
		LongTrialVec=LongTrialVec(OkTrialsIndVec);
		LongTimeMsVec=LongTimeMsVec(OkTrialsIndVec);
		
		[NoUse,NoUse,CondFilePath]=GetFileNameOfMat(LongCondFileMat,FileIndex);
		
		[CondFilePath,CondEndPos] = SaveData(LongCondVec,CondFilePath,1,[],'ascii','ascii',[],[],[],1,1,0);
		[CondFilePath,CondEndPos] = SaveData(LongTimeMsVec,CondFilePath,1,[],'ascii','ascii',1,CondEndPos,[],1,1,0);
		[CondFilePath,CondEndPos] = SaveData(LongTrialVec,CondFilePath,1,[],'ascii','ascii',1,CondEndPos,[],1,1,0);
		
		%=================================================================================
		%=================================================================================
		
		%============Save ShortCond to file======================================
		
		if ~isempty(GivenNShortTrials)
			if NShortTrials~=GivenNShortTrials; error('Bad number of trials.');end
		end
		
		NShortTrials=length(ShortCondVec);
		fprintf('\n'); clc;
		fprintf('Number of short trials: %g ',NShortTrials); pause(.5)
		
		ShortTimeMsVec=TimeMsVec(ShortIndVec);
		ShortTrialVec=ceil(ShortTimeMsVec./(1000./SampRate))+ones(size(ShortTimeMsVec));
		
			
			
		ShortTrialStatusVec=ones(NShortTrials,1);
		if ShortTrialVec(1)<ShortPreTrig; ShortTrialStatusVec(1)=0; end	
		if ~ShortReTrig
			for TrialInd=2:NShortTrials
				if ShortTrialVec(TrialInd)-ShortTrialVec(TrialInd-1)<ShortDistTrig; ShortTrialStatusVec(TrialInd)=0; ShortTrialStatusVec(TrialInd-1)=0; end
			end
		end
		if NNetPoints-ShortTrialVec(NShortTrials)<ShortPostTrig; ShortTrialStatusVec(NShortTrials)=0; end
		OkTrialsIndVec=find(ShortTrialStatusVec==1);
		NShortTrials=length(OkTrialsIndVec);
		fprintf('Number of Short trials to save: %g ',NShortTrials);
		ShortCondVec=ShortCondVec(OkTrialsIndVec);
		ShortTrialVec=ShortTrialVec(OkTrialsIndVec);
		ShortTimeMsVec=ShortTimeMsVec(OkTrialsIndVec);
		
		[NoUse,NoUse,CondFilePath]=GetFileNameOfMat(ShortCondFileMat,FileIndex);
		
		[CondFilePath,CondEndPos] = SaveData(ShortCondVec,CondFilePath,1,[],'ascii','ascii',[],[],[],1,1,0);
		[CondFilePath,CondEndPos] = SaveData(ShortTimeMsVec,CondFilePath,1,[],'ascii','ascii',1,CondEndPos,[],1,1,0);
		[CondFilePath,CondEndPos] = SaveData(ShortTrialVec,CondFilePath,1,[],'ascii','ascii',1,CondEndPos,[],1,1,0);

		
		%=================================================================================
		%=========Long EGIS Header========================================================
		%=================================================================================

		HdrVer=Version;
		LData=NNetPoints.*NChan;
		LHeader=[];
		RunDate=[Day,Month,Year];
		RunTime=[Hour,Minute,Sec];			
		EdVer=Version;
		LText=Bits;				%Muss noch geaendert werden
		LPad=Range;				%Muss noch geaendert werden
		NTrials=length(LongTrialVec);
		NLongTrials=NTrials;
		NPoints=LongDistTrig;
		LSpec=4;
		LSpecCell1=zeros(NLongTrials,LSpec./2);
		LCellHdr=NCells.*90+NTrials.*LSpec;   %2.*(LSpec./2)
		
		%==================================================================================
		
		LengthNetFilePath=length(NetFilePath);
		LSpecCell1(:,1)=-1.*ones(NLongTrials,1);
		LSpecCell1(:,2)=zeros(NLongTrials,1);
		[NoUse,NoUse,EGISFilePath]=GetFileNameOfMat(LongEGISFileMat,FileIndex);
		[EGISFile,EGISPath,EGISFilePath]=WriteEGISHeader(EGISFilePath);
		
		
		%=========Long EGIS Data========================================================

		EGISFid=fopen(EGISFilePath,'r+');
		fseek(EGISFid,LHeader,-1);
		fprintf(1,'Write %g trials to file:\n\n',NLongTrials)
	
		for TrialInd=1:NLongTrials
			fprintf(1,'%g\n',TrialInd)
			if TRStatus==1										%RAW
				status=fseek(NetFid,LNetHeader+(NChan+NNetEvents).*(LongTrialVec(TrialInd)-LongPreTrig-1).*2,-1);
				if status==-1; error('fseek error'); end
				Tmp=fread(NetFid,[NChan+NNetEvents,LongDistTrig],'int16');
				Tmp=Tmp(1:NChan,:);
				fwrite(EGISFid,Tmp,'int16'); 
			elseif TRStatus==-1									%TAW
				Tmp=zeros(LongDistTrig,NChan);
				status=fseek(NetFid,LNetHeader+(LongTrialVec(TrialInd)-LongPreTrig-1).*2,-1);
				if status==-1; error('fseek error'); end
				for ChanInd=1:NChan	
					Tmp(:,ChanInd)=fread(NetFid,LongDistTrig,'int16');
					if ChanInd~=NChan
						SeekStatus=fseek(NetFid,(NNetPoints-LongDistTrig).*2,0);
						if SeekStatus==-1; error('fseek error'); end
					end
				end
				fwrite(EGISFid,Tmp','int16'); 	
			end
		end
		fclose(EGISFid);
		
		
		%=================================================================================
		%=========Short EGIS Header========================================================
		%=================================================================================	
		
		HdrVer=Version;
		LData=NNetPoints.*NChan;
		LHeader=[];
		RunDate=[Day,Month,Year];
		RunTime=[Hour,Minute,Sec];			
		EdVer=Version;
		LText=Bits;						%Muss noch geaendert werden
		LPad=Range;						%Muss noch geaendert werden
		NTrials=length(ShortTrialVec);
		NShortTrials=NTrials;
		NPoints=ShortDistTrig;
		LSpec=4;
		LSpecCell1=zeros(NShortTrials,LSpec./2);
		LCellHdr=NCells.*90+NTrials.*LSpec;   %2.*(LSpec./2)
		
		%==========================================
		
		LengthNetFilePath=length(NetFilePath);

		LSpecCell1(:,1)=-1.*ones(NShortTrials,1);
		LSpecCell1(:,2)=zeros(NShortTrials,1);
		
		[NoUse,NoUse,EGISFilePath]=GetFileNameOfMat(ShortEGISFileMat,FileIndex);
		
		[EGISFile,EGISPath,EGISFilePath]=WriteEGISHeader(EGISFilePath);
		EGISFid=fopen(EGISFilePath,'r+');
		fseek(EGISFid,LHeader,-1);
		fprintf(1,'Write %g trials to file:\n\n',NShortTrials)
	
		for TrialInd=1:NShortTrials
			fprintf(1,'%g\n',TrialInd)
			if TRStatus==1										%RAW
				status=fseek(NetFid,LNetHeader+(NChan+NNetEvents).*(ShortTrialVec(TrialInd)-ShortPreTrig-1).*2,-1);
				if status==-1; error('fseek error'); end
				Tmp=fread(NetFid,[NChan+NNetEvents,ShortDistTrig],'int16');
				Tmp=Tmp(1:NChan,:);
				fwrite(EGISFid,Tmp,'int16'); 
			elseif TRStatus==-1									%TAW
				Tmp=zeros(ShortDistTrig,NChan);
				status=fseek(NetFid,LNetHeader+(ShortTrialVec(TrialInd)-ShortPreTrig-1).*2,-1);
				if status==-1; error('fseek error'); end
				for ChanInd=1:NChan	
					Tmp(:,ChanInd)=fread(NetFid,ShortDistTrig,'int16');
					if ChanInd~=NChan
						SeekStatus=fseek(NetFid,(NNetPoints-ShortDistTrig).*2,0);
						if SeekStatus==-1; error('fseek error'); end
					end
				end
				fwrite(EGISFid,Tmp','int16'); 	
			end
		end
		
		fclose(EGISFid);

		%=================================================================================
		%=================================================================================
		%=================================================================================
	
	end	
	fclose(NetFid);
end	%FileIndex
who
return;
