%==================================================================
%
%	WriteFastWordSce.m
%
%
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%	
%	Function definition

function [PicFilePath,SaveFilePath]=WriteFastWordsTem
%=================================================================
SavePath='Paul:TEM:'
BlockOrderMat=[
1 2 3 4 5 2 1 4 3 5 1 2 3 4 5 2 1 4 3 5 1 2 3 4 5;
3 4 1 2 5 4 3 2 1 5 3 4 1 2 5 4 3 2 1 5 3 4 1 2 5;
2 1 5 4 3 1 2 5 3 4 2 1 5 4 3 1 2 5 3 4 2 1 5 4 3;
4 3 5 2 1 3 4 5 1 2 4 3 5 2 1 3 4 5 1 2 4 3 5 2 1];

[NSess,NBlock]=size(BlockOrderMat);
% NSess=1
% NBlock=2
WordVecTmp=[];
for SessInd=1:NSess
	BlockOrder=BlockOrderMat(SessInd,:);
	NWordTot=32;
	NBaseWords=10;
	NWordInBlock=20;
	NBlockPerCond=5;
	NCond=5;
	WordMat=zeros(NBlockPerCond,NWordInBlock);
	for i=1:NBlockPerCond
		WordVecTmp=[WordVecTmp,1:NWordTot];
		d=length(WordVecTmp)
		a=(SessInd-1).*NBlockPerCond.*NWordInBlock+(i-1).*NWordInBlock+1
		b=(SessInd-1).*NBlockPerCond.*NWordInBlock+i.*NWordInBlock
		WordMat(i,:)=WordVecTmp((SessInd-1).*NBlockPerCond.*NWordInBlock+(i-1).*NWordInBlock+1:(SessInd-1).*NBlockPerCond.*NWordInBlock+i.*NWordInBlock);
	end
	WordMat=WordMat
	pause
	StrMat=char('Inha','Pseu','Funk','Stri'); %2 1 5 4 3 1 2 5 3 4 2 1 5 4 3 1 2 5 3 4 2 1 5 4 3;
	TimeVec=[0:1000:19000];
	for BlockInd=1:NBlock
		Block=BlockOrder(BlockInd);
		BlockCount=length(find(BlockOrder(1:BlockInd)==Block));
		WordVec=WordMat(BlockCount,:);
		WordVec=WordVec(randperm(NWordInBlock));
		if BlockInd<10
			BlockStr=['0',int2str(BlockInd)];
		else
			BlockStr=int2str(BlockInd);
		end
		SaveFilePath=[SavePath,'FW-S',int2str(SessInd),'-B',BlockStr,'.tem'];
		fid=fopen(SaveFilePath,'w');
		fprintf(fid,'trial{\ntrial_duration=20000;\n');
		for WordInd=1:NWordInBlock
			if WordInd<10
				WordStr=['0',int2str(WordInd)];
			else
				WordStr=int2str(WordInd);
			end
			if Block==5
				fprintf(fid,'picture bFix;\n');
				if WordInd==1
					fprintf(fid,'code = "Fix";\n');
				end
			else
				CondStr=StrMat(Block,:);
				i=WordVec(WordInd);
				if i<10
					iStr=['00',int2str(i)];
				elseif i>9 & i<100
					iStr=['0',int2str(i)];
				else
					iStr=int2str(i);
				end
				fprintf(fid,['picture b',CondStr,iStr,';\n']);
				if WordInd==1
					fprintf(fid,['code = "',CondStr,'";\n']);
				end
			end
			fprintf(fid,['time=',int2str(TimeVec(WordInd)),';\n']);
		end
		fprintf(fid,['duration=next_picture;\n};']);
		fclose(fid);
	end
end
return;
