function [PmgOut,CotOut,FidOut,SfpOut]=AdjustPmgCotSfp(PmgIn,CotIn,FidIn,SfpIn,RotDegVal);
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<5; RotDegVal=0; end 
if nargin<4; SfpIn=[]; end
if nargin<3; FidIn=[]; end
if nargin<2; CotIn=[0 0 0]; end
if nargin <1; return; end

FidOut=[];
SfpOut=[];

CotOut=CotIn;
CotOut(1)=-1.*CotIn(2);
CotOut(2)=CotIn(1);

%============Rotate around z axis==========================
PmgOut=PmgIn;
PmgOut(:,1)=-1.*PmgIn(:,2);
PmgOut(:,2)=PmgIn(:,1);
PmgOut(:,4)=-1.*PmgIn(:,5);
PmgOut(:,5)=PmgIn(:,4);
%=============Subtract center of sphere=====
for Ind=1:size(PmgIn,1)
    PmgOut(Ind,1:3)=PmgOut(Ind,1:3)-CotOut;
end

if ~isempty(FidIn)
    %============Rotate around z axis==========================
    FidOut=FidIn;
    FidOut(:,1)=-1.*FidIn(:,2);
    FidOut(:,2)=FidIn(:,1);
    %=============Subtract center of sphere=====
    for Ind=1:size(FidOut,1)
        FidOut(Ind,1:3)=FidOut(Ind,1:3)-CotOut;
    end
end

if ~isempty(SfpIn)
    %============Rotate around z axis==========================
    SfpOut=SfpIn;
    SfpOut(:,1)=-1.*SfpIn(:,2);
    SfpOut(:,2)=SfpIn(:,1);
    %=============Subtract center of sphere=====
    for Ind=1:size(SfpOut,1)
        SfpOut(Ind,1:3)=SfpOut(Ind,1:3)-CotOut;
    end
end

for FidInd=1:size(FidIn,1)
    FidOut(FidInd,1:3)=FidIn(FidInd,1:3)-CotOut;
end  
%=============Rotate RotDegVal degrees backward around x-axis (LPA-RPA)==
if RotDegVal~=0
    PmgOut(:,1:3)=XRotation(PmgOut(:,1:3),RotDegVal);
    PmgOut(:,4:6)=XRotation(PmgOut(:,4:6),RotDegVal);
    if ~isempty(FidOut)
        FidOut=XRotation(FidOut,RotDegVal);
    end
    if ~isempty(SfpOut)
        SfpOut=XRotation(SfpOut,RotDegVal);
    end
end
%=================================================================

return;
