
function BatchAppTStat(InFileMat)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<1; InFileMat=[]; end

[DefFilePath]=SetDefPath(1,'*.app*');
StrTmp='Choose pairs of app files or a batch file:'
[NFilesIn,InFileMat,NonUse,BatchFilePath]=ReadFileNames(InFileMat,DefFilePath,StrTmp,[],[],[],[],2);
if NFilesIn==0; return; end
NPairs=NFilesIn./2;
if floor(NPairs)-NPairs
    fprintf(1,'Please choose an even number of files (pairs) ...')
    return;
end
CalcBaseStatus=1;
MinBase=1;
MaxBase=452;
SaveStatus=1;
for i=1:NPairs
    CalcAppScadsTStat(InFileMat((i-1).*2+1:i.*2,:),CalcBaseStatus,MinBase,MaxBase,SaveStatus)
end
