global ParentDir StatDir Folder0 Folder1 Folder2 Folder3 Folder4 Folder5 Folder6 Smooth SmoothStr MaskStr

%---------------------------------------------------------------
% model(1) Low-Off vs High Off
%---------------------------------------------------------------
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
Mask=[MaskStr,'*.img']
F1=spm_get('Files',Folder1,Mask);
NFiles1=size(F1,1)
F2=spm_get('Files',Folder2,Mask);
NFiles2=size(F2,1)
F3=spm_get('Files',Folder3,Mask);
NFiles3=size(F3,1)
F4=spm_get('Files',Folder4,Mask);
NFiles4=size(F4,1)
F5=spm_get('Files',Folder5,Mask);
NFiles5=size(F5,1)
F6=spm_get('Files',Folder6,Mask);
NFiles6=size(F6,1)
NFilesVec=[NFiles1 NFiles2 NFiles3 NFiles4 NFiles5 NFiles6]
NFiles=sum(NFilesVec)
OnVec=[0,cumsum(NFilesVec)]
F=[F1;F2;F3;F4;F5;F6]
%---------------------------------------------------------------
% batch variables defined here for analysis 'model'
%---------------------------------------------------------------

model(1) = struct( ...
 'types',          4, ...
 'global_effects', {'None'}, ...
 'burst_mode',     0, ...
 'HF_fil',         'none',  ...
 'HF_cut',         [], ...
 'LF_fil',         'none', ...
 'LF_cut',         [], ...
 'int_corr',       'none', ... 
 'now_later',      1, ...
 'stop_writing',   0, ...
 'trial_fcon',     0, ...
 'RT',             1, ...
 'replicated',     0, ...
 'same_time_param',0, ...
 'nsess',          1, ...
 'nscans',         [NFiles], ...
 'files',          {{F}}, ...
 'conditions_nb',  [6], ...     
 'conditions',     [1], ...
 'regressors_nb',  [0], ...
 'regressors',     [], ...
 'parametrics_type',{{'none'}}, ...
 'parametrics',    [], ...
 'stochastics_flag',[0], ...
 'stochastics',    []);
 
conditions(1) = struct( ...
 'names',   {{'BasePos','ExtPos','BaseNeg','ExtNeg','BaseNeut','ExtNeut'}}, ...
 'onsets',{{OnVec(1),OnVec(2),OnVec(3),OnVec(4),OnVec(5),OnVec(6)}}, ...   
 'types',    {{'epochs','epochs','epochs','epochs','epochs','epochs'}}, ... 
 'bf_ep',   [1 2 3 4 5 6], ...                                      
 'volterra',  0, ...
 'variable_dur',0);

%-------------------------------------------
bf_ep(1) = struct( ...
  'ep_type',4, ...
  'length',NFiles1, ...
  'conv',0, ...  
  'deriv',0);
%-------------------------------------------
bf_ep(2) = struct( ...
  'ep_type',4, ...
  'length',NFiles2, ...
  'conv',0, ...  
  'deriv',0);
%-------------------------------------------
bf_ep(3) = struct( ...
  'ep_type',4, ...
  'length',NFiles3, ...
  'conv',0, ...  
  'deriv',0);
%-------------------------------------------
bf_ep(4) = struct( ...
  'ep_type',4, ...
  'length',NFiles4, ...
  'conv',0, ...  
  'deriv',0);
%-------------------------------------------
bf_ep(5) = struct( ...
  'ep_type',4, ...
  'length',NFiles5, ...
  'conv',0, ...  
  'deriv',0);
%-------------------------------------------
bf_ep(6) = struct( ...
  'ep_type',4, ...
  'length',NFiles6, ...
  'conv',0, ...  
  'deriv',0);

ExtGTBaseAll=[-1 1 -1 1 -1 1 0];
ExtLTBaseAll=-ExtGTBaseAll;

ExtGTBasePos=[-1 1 0 0 0 0 0];
ExtLTBasePos=-ExtGTBasePos;

ExtGTBaseNeg=[0 0 -1 1 0 0 0];
ExtLTBaseNeg=-ExtGTBaseNeg;

ExtGTBaseNeut=[0 0 0 0 -1 1 0];
ExtLTBaseNeut=-ExtGTBaseNeut;

PosGTNeutBase=[1 0 0 0 -1 0 0];
PosLTNeutBase=-PosGTNeutBase;

NegGTNeutBase=[0 0 1 0 -1 0 0];
NegLTNeutBase=-NegGTNeutBase;

PosGTNegBase=[1 0 -1 0 0 0 0];
PosLTNegBase=-PosGTNegBase;

PosGTNeutExt=[0 1 0 0 0 -1 0];
PosLTNeutExt=-PosGTNeutExt;

NegGTNeutExt=[0 0 0 1 0 -1 0];
NegLTNeutExt=-NegGTNeutExt;

PosGTNegExt=[0 1 0 -1 0 0 0];
PosLTNegExt=-PosGTNegExt;

PosGTNeutBaseExt=[-1 1 0 0 1 -1 0];
PosLTNeutBaseExt=-PosGTNeutBaseExt;

NegGTNeutBaseExt=[0 0 -1 1 1 -1 0];
NegLTNeutBaseExt=-NegGTNeutBaseExt;

PosGTNegBaseExt=[-1 1 1 -1 0 0 0];
PosLTNegBaseExt=-PosGTNegBaseExt;

contrasts(1) = struct('names',{{...
            'ExtGTBaseAll','ExtLTBaseAll', ...
            'ExtGTBasePos','ExtLTBasePos', ...
            'ExtGTBaseNeg','ExtLTBaseNeg', ...
            'ExtGTBaseNeut','ExtLTBaseNeut', ...
            'PosGTNeutBase','PosLTNeutBase', ...
            'NegGTNeutBase','NegLTNeutBase', ...
            'PosGTNegBase','PosLTNegBase', ...
            'PosGTNeutExt','PosLTNeutExt', ...
            'NegGTNeutExt','NegLTNeutExt', ...
            'PosGTNegExt','PosLTNegExt', ...
            'PosGTNeutBaseExt','PosLTNeutBaseExt', ...
            'NegGTNeutBaseExt','NegLTNeutBaseExt', ...
            'PosGTNegBaseExt','PosLTNegBaseExt', ...
        }},'types', {{...
            'T','T',...
            'T','T',...
            'T','T',...
            'T','T',...
            'T','T',...
            'T','T',...
            'T','T',...
            'T','T',...
            'T','T',...
            'T','T',...
            'T','T',...
            'T','T',...
            'T','T',...
        }},'values',{{...
            ExtGTBaseAll,ExtLTBaseAll, ...
            ExtGTBasePos,ExtLTBasePos, ...
            ExtGTBaseNeg,ExtLTBaseNeg, ...
            ExtGTBaseNeut,ExtLTBaseNeut, ...
            PosGTNeutBase,PosLTNeutBase, ...
            NegGTNeutBase,NegLTNeutBase, ...
            PosGTNegBase,PosLTNegBase, ...
            PosGTNeutExt,PosLTNeutExt, ...
            NegGTNeutExt,NegLTNeutExt, ...
            PosGTNegExt,PosLTNegExt, ...
            PosGTNeutBaseExt,PosLTNeutBaseExt, ...
            NegGTNeutBaseExt,NegLTNeutBaseExt, ...
            PosGTNegBaseExt,PosLTNegBaseExt, ...
            }});