function BatfMEEG(DirMatIn,MaskStrIn,SmoothIn,BatchModel,BatchPath)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
global ParentDir StatDir DirMat Smooth SmoothStr MaskStr
global Folder0 Folder1 Folder2 Folder3 Folder4 Folder5 Folder6
if nargin<5; BatchPath=[]; end
if nargin<4; BatchModel=5; end
if nargin<3; SmoothIn=[]; end
if nargin<2; MaskStrIn=[]; end
if nargin<1; DirMatIn=[]; end


[NoUse,DefPath]=SetDefPath('r');
fprintf('Change SPM working directory\n')
if ~exist(DefPath); 
    DefPath=pwd; 
    DefPath='F:\Data\EEG\FPB\01';
end
eval(['cd ',DefPath])
fprintf('SPM present working directory:\n\t%s\n',pwd)

if isempty(DirMatIn)
    DirMat=['F:\Data\EEG\FPB\01\01fastpic2.1.ses.1';...
			'F:\Data\EEG\FPB\01\01fastpic2.1.ses.2';...
			'F:\Data\EEG\FPB\01\01fastpic2.1.ses.3';...
			'F:\Data\EEG\FPB\01\01fastpic2.1.ses.4';...
			'F:\Data\EEG\FPB\01\01fastpic2.1.ses.5']
    NDir=5;
else
    DirMat=DirMatIn;
    NDir=size(DirMat,1);
end
DefFilePath=SetDefPath(1,'*.fMEG');
%[NDir,DirMat,VersionString,BatchFilePath]=ReadFileNames(DirMat,DefFilePath,'Please choose a fMEEG batch file:')
if isempty(MaskStrIn)
    MaskStr=['s88.108']
else
    MaskStr=MaskStrIn;
end
if isempty(SmoothIn)
    Smooth=16;
else
    Smooth=SmoothIn;
end
SmoothStr=int2str(Smooth);
BatchModel=BatchModel
if BatchModel==1 %Fixed
    if isempty(BatchPath)
        [BatchFile,BatchPath]=SepFilePath(BatchFilePath);
    end  
    ParentDir=BatchPath
    StatDir='00FixStats'
    spm_bch('BatchAnaFixModelfMEEG')
 elseif BatchModel==2 %One Sample
    for DirInd=1:NDir
        Folder0=DirMat(DirInd,:);
        if strcmp(Folder0(end),filesep)
            Folder0=Folder0(1:end-1);
        end
        Tmp=findstr(Folder0,filesep)
        ParentDir=Folder0(1:Tmp(end))
        StatDir=[Folder0(Tmp(end)+1:length(Folder0)-2)]
        spm_bch('BatchAnaModelOneSamplefMEEG')
    end
elseif BatchModel==3 %Paired
    for DirInd=1:NDir/2
        DirInd.*2-1
        Folder1=DirMat(DirInd.*2-1,:);
        if strcmp(Folder1(end),filesep)
            Folder1=Folder1(1:end-1);
        end
        Folder1=Folder1
        Folder0=DirMat(DirInd.*2,:);
        if strcmp(Folder0(end),filesep)
            Folder0=Folder0(1:end-1);
        end
        Folder0=Folder0
        Tmp=findstr(Folder1,filesep)
        ParentDir=Folder1(1:Tmp(end))
        StatDir=[Folder1(Tmp(end)+1:length(Folder1)-2)]
        spm_bch('BatchAnaModelfMEEG')
    end
elseif BatchModel==4 %FaceCond
    for DirInd=1:NDir/6
        Folder1=DirMat(DirInd.*6-5,:);  %Base Pos
        if strcmp(Folder1(end),filesep)
            Folder1=Folder1(1:end-1);
        end
        Folder2=DirMat(DirInd.*6-4,:);  %Ext Pos
        if strcmp(Folder2(end),filesep)
            Folder2=Folder2(1:end-1);
        end
        Folder3=DirMat(DirInd.*6-3,:);  %Base Neg
        if strcmp(Folder3(end),filesep)
            Folder3=Folder3(1:end-1);
        end
        Folder4=DirMat(DirInd.*6-2,:);  %Ext Neg
        if strcmp(Folder4(end),filesep)
            Folder4=Folder4(1:end-1);
        end
        Folder5=DirMat(DirInd.*6-1,:);  %Base Neut
        if strcmp(Folder5(end),filesep)
            Folder5=Folder5(1:end-1);
        end
        Folder6=DirMat(DirInd.*6,:);    %Ext Neut
        if strcmp(Folder6(end),filesep)
            Folder6=Folder6(1:end-1);
        end
    end
    Tmp=findstr(Folder1,filesep)
    ParentDir=Folder1(1:Tmp(end-1))
    StatDir=['Stat']
    spm_bch('BatchAnaModelFaceCondfMEEG')
elseif BatchModel==5 %ValAro
    for DirInd=1:NDir/5
        Folder1=DirMat(DirInd.*6-5,:);  %High Pos
        if strcmp(Folder1(end),filesep)
            Folder1=Folder1(1:end-1);
        end
        Folder2=DirMat(DirInd.*6-4,:);  %Low Pos
        if strcmp(Folder2(end),filesep)
            Folder2=Folder2(1:end-1);
        end
        Folder3=DirMat(DirInd.*6-3,:);  %Neut
        if strcmp(Folder3(end),filesep)
            Folder3=Folder3(1:end-1);
        end
        Folder4=DirMat(DirInd.*6-2,:);  %Low Neg
        if strcmp(Folder4(end),filesep)
            Folder4=Folder4(1:end-1);
        end
        Folder5=DirMat(DirInd.*6-1,:);  %High Neg
        if strcmp(Folder5(end),filesep)
            Folder5=Folder5(1:end-1);
        end
    end
    Tmp=findstr(Folder1,filesep)
    ParentDir=Folder1(1:Tmp(end))
    StatDir=['Stat']
    spm_bch('BatchAnaModelValArofMEEG')
end
return