function [OutFilePath,MiCsAvgMat,NTrialAvgVec1,MiCsStdMat,SampRate1,AvgRef1,Version1,MedMedRawVec1,MedMedAvgVec1,EegMegStatus1,NChanExtra1]=
CalcAvgScadsTStat(InFileMat,CalcBaseStatus,MinBase,MaxBase,SaveStatus,OutFilePath,AddFileExt,TStatus,AbsStatus,FlipMat)
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%==================================================================
%
%	CalcScadsTStat.m
%
%	Markus Junghoefer [2001]
%
%
%	Function definition
%	
%	[OutFilePath,MiCsAvgMat,NTrialAvgVec1,MiCsStdMat,SampRate1,MedMedRawVec1,MedMedAvgVec1,EegMegStatus1,NChanExtra1]=...
%	CalcAvgScadsTStat(InFileMat,CalcBaseStatus,MinBase,MaxBase,SaveStatus,OutFilePath,AddFileExt,TStatus,AbsStatus,FlipMat)
%
%
%
%=================================================================
if nargin<10; FlipMat=[]; end
if nargin<9; AbsStatus=[]; end
if nargin<8; TStatus=[]; end
if nargin<7; AddFileExt=[]; end
if nargin<6; OutFilePath=[]; end
if nargin<5; SaveStatus=[]; end
if nargin<4; MaxBase=[]; end
if nargin<3; MinBase=[]; end
if nargin<2; CalcBaseStatus=[]; end
if nargin<1; InFileMat=[]; end

if isempty(SaveStatus); SaveStatus=1; end
if isempty(AbsStatus); AbsStatus=0; end
if isempty(TStatus); TStatus=1; end

[CalcBaseStatus]=IfEmptyInputBo('Do you want to subtract a baseline ?',[],CalcBaseStatus,1,1);
if CalcBaseStatus & (isempty(MinBase) | isempty(MaxBase))
	fprintf('\n')
	[NPointsBaseStatus]=IfEmptyInputBo('Do you want to use','the whole interval as baseline ?',[],1,0);
	if NPointsBaseStatus; 
		MinBase=[]; MaxBase=[]; 
	else
		[MinBase]=IfEmptyInputVal('Please insert the baseline start point:',[],MinBase,1,0);
		[MaxBase]=IfEmptyInputVal('Please insert the baseline start point:',[],MaxBase,1,0);
	end
end
DefFilePath=SetDefPath(1,'*.at*');
if TStatus==3 %Paired
	StrTmp='Choose pairs of avg files or batch file:'
else
	StrTmp='Choose avg files or batch file:'
end
[NFilesIn,InFileMat,NonUse,BatchFilePath]=ReadFileNames(InFileMat,DefFilePath,StrTmp);
if NFilesIn==0; return; end
[BatchFile,BatchPath]=SepFilePath(BatchFilePath);
SetDefPath(2,BatchPath);
if TStatus==3
	if round(NFilesIn./2)~=NFilesIn./2; 
		return; 
	else
		NFilesIn2=NFilesIn./2;
	end
else
	NFilesIn2=NFilesIn;
end
if TStatus==1
    FileExt='.ott';
elseif TStatus==2
    FileExt='.ttt';
elseif TStatus==3
	FileExt='.ptt';
elseif TStatus==4 %Symmetry
	FileExt='.stt';
end
if CalcBaseStatus
	FileExt=[FileExt,'b'];
end
if ~isempty(AddFileExt)
	FileExt=[FileExt,AddFileExt];
end
SetNumber1=[];
[InFile1,InPath1,InFilePath1]=GetFileNameOfMat(InFileMat,1);
Message=char(' ');
Message=char(Message,'Calculate t-test:');
Message=char(Message,' ');
MessageTmp=char(Message,InFilePath1);
MessageTmp=char(MessageTmp,' ');
MessageTmp=char(MessageTmp,' ');
MessageTmp=char(MessageTmp,' ');
hmsgbox=msgbox(MessageTmp,'Info:','help'); 
hChildMsgbox=get(hmsgbox,'Children');
hChild2Msgbox=get(hChildMsgbox(2),'Children');
set(hChildMsgbox(length(hChildMsgbox)),'Visible','off');
pause(.01);
for FileInd=1:NFilesIn2
	FileIndTmp=FileInd;
	if TStatus==3; FileIndTmp=FileInd.*2-1; end
	[InFile1,InPath1,InFilePath1]=GetFileNameOfMat(InFileMat,FileIndTmp);
	[AvgMat1,File1,Path1,FilePath1,NTrialAvgVec1,StdMat1,...
	SampRate1,AvgRef1,Version1,MedMedRawVec1,MedMedAvgVec1,...
	EegMegStatus1,NChanExtra1]=ReadAvgFile(InFilePath1);
	if CalcBaseStatus
		if isempty(MinBase); MinBase=1; end
		if isempty(MaxBase); MaxBase=NPoints1; end
		fprintf('AvgMat1: Subtract baseline interval of points %g - %g\n\n\n',MinBase,MaxBase);
		[AvgMat1]=CalcBaseline(AvgMat1,MinBase,MaxBase,CalcBaseStatus);
	else
		fprintf('AvgMat1: No baseline subtraction\n\n\n');
	end
	if AbsStatus; AvgMat1=abs(AvgMat1); StdMat1=abs(StdMat1); end
	[NChan1,NPoints1]=size(AvgMat1);
	if FileInd==1; 
		AllAvgMat1=zeros(NFilesIn2,NChan1,NPoints1);
		AllStdMat1=zeros(NFilesIn2,NChan1,NPoints1);
		AllNTrialAvgVec1=zeros(NFilesIn2,length(NTrialAvgVec1));
		AllMedMedRawVec1=zeros(NFilesIn2,length(MedMedRawVec1));
		AllMedMedAvgVec1=zeros(NFilesIn2,length(MedMedAvgVec1));
	end
	if TStatus==3 %Paired
        FileIndTmp=FileInd.*2;
		[InFile2,InPath2,InFilePath2]=GetFileNameOfMat(InFileMat,FileIndTmp);
		[AvgMat2,File2,Path2,FilePath2,NTrialAvgVec2,StdMat2,...
		SampRate2,AvgRef2,Version2,MedMedRawVec2,MedMedAvgVec2,...
		EegMegStatus2,NChanExtra2]=ReadAvgFile(InFilePath2);
		if CalcBaseStatus
			if isempty(MinBase); MinBase=1; end
			if isempty(MaxBase); MaxBase=NPoints1; end
			fprintf('AvgMat2: Subtract baseline interval of points %g - %g\n\n\n',MinBase,MaxBase);
			[AvgMat2]=CalcBaseline(AvgMat2,MinBase,MaxBase,CalcBaseStatus);
		else
			fprintf('AvgMat2: No baseline subtraction\n\n\n');
		end
		if AbsStatus; AvgMat2=abs(AvgMat2); StdMat2=abs(StdMat2); end
		[NChan2,NPoints2]=size(AvgMat2);
		if FileInd==1; 
			AllAvgMat2=zeros(NFilesIn2,NChan2,NPoints2);
			AllStdMat2=zeros(NFilesIn2,NChan2,NPoints2);
			AllNTrialAvgVec2=zeros(NFilesIn2,length(NTrialAvgVec2));
			AllMedMedRawVec2=zeros(NFilesIn2,length(MedMedRawVec2));
			AllMedMedAvgVec2=zeros(NFilesIn2,length(MedMedAvgVec2));
		end	
    elseif TStatus==4 %Symmetry
		InFile2=InFile1;
		InPath2=InPath1;
		InFilePath2=InFilePath1;
		AvgMat2=AvgMat1;
		NTrialAvgVec2=NTrialAvgVec1;
		StdMat2=StdMat1;
		SampRate2=SampRate1;
		AvgRef2=AvgRef1;
		Version2=Version1;
		MedMedRawVec2=MedMedRawVec1;
		MedMedAvgVec2=MedMedAvgVec1;
		EegMegStatus2=EegMegStatus1;
		NChanExtra2=NChanExtra1;
		NChan2=NChan1;
		NPoints2=NPoints1;
		for i=1:size(FlipMat,1)
			AvgMat2(FlipMat(i,1),:)=AvgMat1(FlipMat(i,2),:);
			AvgMat2(FlipMat(i,2),:)=AvgMat1(FlipMat(i,1),:);
			StdMat2(FlipMat(i,1),:)=StdMat1(FlipMat(i,2),:);
			StdMat2(FlipMat(i,2),:)=StdMat1(FlipMat(i,1),:);
		end
		if FileInd==1; 
			AllAvgMat2=zeros(NFilesIn2,NChan2,NPoints2);
			AllStdMat2=zeros(NFilesIn2,NChan2,NPoints2);
			AllNTrialAvgVec2=zeros(NFilesIn2,length(NTrialAvgVec2));
			AllMedMedRawVec2=zeros(NFilesIn2,length(MedMedRawVec2));
			AllMedMedAvgVec2=zeros(NFilesIn2,length(MedMedAvgVec2));
		end	
	end
	MessageTmp=char(Message,InFilePath1);
	MessageTmp=char(MessageTmp,InFilePath2);
	MessageTmp=char(MessageTmp,' ');
	MessageTmp=char(MessageTmp,[int2str(FileInd),' of ',int2str(NFilesIn2),' pairs done ...']);
	MessageTmp=char(MessageTmp,' ');
	if strcmp(computer,'MAC2')
		set(hChildMsgbox(2),'String',MessageTmp);
	else
		set(hChild2Msgbox,'String',MessageTmp);
	end
    pause(.01)
	AllAvgMat1(FileInd,:,:)=AvgMat1;
	AllStdMat1(FileInd,:,:)=StdMat1;
	AllNTrialAvgVec1(FileInd,1:length(NTrialAvgVec1))=NTrialAvgVec1';
	AllMedMedRawVec1(FileInd,1:length(MedMedRawVec1))=MedMedRawVec1';
	AllMedMedAvgVec1(FileInd,1:length(MedMedAvgVec1))=MedMedAvgVec1';
	AllAvgMat2(FileInd,:,:)=AvgMat2;
	AllStdMat2(FileInd,:,:)=StdMat2;
	AllNTrialAvgVec2(FileInd,1:length(NTrialAvgVec2))=NTrialAvgVec2';
	AllMedMedRawVec2(FileInd,1:length(MedMedRawVec2))=MedMedRawVec2';
	AllMedMedAvgVec2(FileInd,1:length(MedMedAvgVec2))=MedMedAvgVec2';
end

fprintf('\n\n');

MeanAvgMat1=mean(AllAvgMat1,1);
MeanStdMat1=mean(AllStdMat1,1);

MeanNTrialAvgVec1=mean(AllNTrialAvgVec1,1);
MeanMedMedRawVec1=mean(AllMedMedRawVec1,1);
MeanMedMedAvgVec1=mean(AllMedMedAvgVec1,1);

MeanAvgMat2=mean(AllAvgMat2,1);
MeanStdMat2=mean(AllStdMat2,1);
MeanNTrialAvgVec2=mean(AllNTrialAvgVec2,1);
MeanMedMedRawVec2=mean(AllMedMedRawVec2,1);
MeanMedMedAvgVec2=mean(AllMedMedAvgVec2,1);

StdAvgMat1=std(AllAvgMat1,0,1);
StdStdMat1=std(AllStdMat1,0,1);
StdNTrialAvgVec1=std(AllNTrialAvgVec1,0,1);
StdMedMedRawVec1=std(AllMedMedRawVec1,0,1);
StdMedMedAvgVec1=std(AllMedMedAvgVec1,0,1);

StdAvgMat2=std(AllAvgMat2,0,1);
StdStdMat2=std(AllStdMat2,0,1);
StdNTrialAvgVec2=std(AllNTrialAvgVec2,0,1);
StdMedMedRawVec2=std(AllMedMedRawVec2,0,1);
StdMedMedAvgVec2=std(AllMedMedAvgVec2,0,1);

Vari=sqrt((StdAvgMat1.^2+StdAvgMat2.^2)./NFilesIn2);
ZeroVari=Vari==0;
Vari=Vari+ZeroVari;									%Set Vari=1 if Vari=0
MiCsAvgMat=(MeanAvgMat1-MeanAvgMat2)./Vari;
MiCsAvgMat=MiCsAvgMat-MiCsAvgMat.*ZeroVari;			%Set Vari=0 if Vari=0
	
Vari=sqrt((StdStdMat1.^2+StdStdMat2.^2)./NFilesIn2);
ZeroVari=Vari==0;
Vari=Vari+ZeroVari;									%Set Vari=1 if Vari=0
MiCsStdMat=(MeanStdMat1-MeanStdMat2)./Vari;
MiCsStdMat=MiCsStdMat-MiCsStdMat.*ZeroVari;			%Set Vari=0 if Vari=0
	
MiCsAvgMat=squeeze(MiCsAvgMat);
MiCsStdMat=squeeze(MiCsStdMat);
if SaveStatus
	[OutFile,OutPath,OutFilePath]=SaveAvgFile([BatchFilePath,FileExt],MiCsAvgMat,NTrialAvgVec1,MiCsStdMat,SampRate1,MedMedRawVec1,MedMedAvgVec1,EegMegStatus1,NChanExtra1);
end
close(hmsgbox);
return;
