%==================================================================
%
%	CalcBox.m
%
%	Markus Junghoefer	[1995]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%	Function definition
%
	
function[M]=CalcBox(center,box_width,box_iter);

%
%
%=================================================================

x=box_width(1);y=box_width(2);z=box_width(3);
l=box_iter(1);m=box_iter(2);n=box_iter(3);
x_v=linspace(-x,x,l)+center(1);
y_v=linspace(-y,y,m)+center(2);
z_v=linspace(-z,z,n)+center(3);

M=zeros(l*m*n,3);
for i=1:l
	for j=1:m
		for k=1:n
			M((i-1)*l*m+(j-1)*m+k,:)=[x_v(i),y_v(j),z_v(k)];
		end
	end
end
return;
