function[GainVec]=CalcGainVec(ChanGain,Bits,Range);
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%==================================================================
%
%	CalcGainVec.m
%
%	Markus Junghoefer	[1996]
%
%
%	Function definition
%
%
%=================================================================
if nargin<3; Range=[]; end
if nargin<2; Bits=[]; end
if nargin<1; ChanGain=[]; NChan=[]; return; end
[Range]=IfEmptyInputVal('Please insert the Range:',[],Range,1,1);
[Bits]=IfEmptyInputVal('Please insert the Bits:',[],Bits,12,1);

if all(ChanGain==0); 
	Message=char('All gain values are zero in this file !!!');
	Message=char(Message,'');
	Message=char(Message,'All gain values will be set to 1 !!!');
	hmsgbox=msgbox(Message,'Warning:','warn');
	uiwait(hmsgbox);
	ChanGain=ones(size(ChanGain));
end
RefGain=mean(ChanGain);
Fac=Range./(2.^Bits);
GainVec=Fac.*RefGain./ChanGain;
return;
