%==================================================================
%
%	CalcPolDir.m
%
%	Markus Junghoefer	[1995]
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
%
%
%	Function definition
%
	function[DataOutSphere]=CalcPolDir(DataInSphere,ENames);
%
%=================================================================

[m,n]=size(DataInSphere);
clc;
fprintf('Now you have to define the direction !\n');
[ch_UseExistFile]=IfEmptyInputBo(['Do you want to use an existing direction file ?'],[],[],1);

if ch_UseExistFile
	[ThetaPhiMat,DirFile,DirPath] = ReadData([],1,['Get File: Direction Data']);
	fprintf('This is the read in Theta-Phi Matrix:\n\n')
	disp(ThetaPhiMat)
	pause(1)
else 
	
	ThetaPhiMat=zeros(m,4);
	for i=1:m
		fprintf('\n')
		clc;
		fprintf(1,'Do you want to take the %g position named ',i);
		fprintf(1,ENames(i,:));
		fprintf(1,' to define the direction ?\n');
		[ch_Take]=IfEmptyInputBo(['Please insert your choice:'],[],[],0);
		
		if  ch_Take
			clc;
			[theta_weight]=IfEmptyInputValInt(['Please insert the'],['theta weight of this position:'],[],[1],0,1);
			ThetaPhiMat(i,1)=theta_weight;	
			if theta_weight>0
				[theta_val]=IfEmptyInputValInt(['Please insert the'],['theta value of this position:'],[],[],0,90);
				if theta_val>=0
					ThetaPhiMat(i,3)=theta_val;
				else
					ThetaPhiMat(i,3)=360+theta_val;
				end
			end
			clc;
			[phi_weight]=IfEmptyInputValInt(['Please insert the'],['phi weight of this position:'],[],[1],0,1);
			ThetaPhiMat(i,2)=phi_weight;	
			if phi_weight>0
				[phi_val]=IfEmptyInputValInt(['Please insert the'],['phi value of this position:'],[],[],0,360);
				if phi_val>=0
					ThetaPhiMat(i,4)=phi_val;
				else
					ThetaPhiMat(i,4)=360+phi_val;
				end
			end			
		end
	end
	ThetaPhiMat(:,3:4)=ThetaPhiMat(:,3:4)./180.*pi;
	fprintf('Theta-Phi Matrix:\n\n')
	disp(ThetaPhiMat)
	pause(1)
	[ch_save]=IfEmptyInputBo(['Do you want to save this matrix ?'],[],[],1);
	if ch_save
		SaveData(ThetaPhiMat,[],1,['Save direction matrix to file:']);
	end
end


ChangeCart=change_sphere_cart(DataInSphere, 1, 1);
ThetaPhiMatSphere=ThetaPhiMat(:,3:4);
ThetaPhiMatCart=change_sphere_cart(ThetaPhiMatSphere, 1, 1);
ThetaPhiMatWeight=ThetaPhiMat(:,1:2);

iter=30;
for i=1:iter
	
	change_sphere=change_sphere_cart(ChangeCart, [], -1);
	mini(1)=sum(sqrt(sum((ThetaPhiMatWeight.*((ThetaPhiMatSphere-change_sphere(:,1:2)).^2))')));
	
	xPlus=XRotation(ChangeCart,180/i^2);
	change_sphere=change_sphere_cart(xPlus, [], -1);
	mini(2)=sum(sqrt(sum((ThetaPhiMatWeight.*((ThetaPhiMatSphere-change_sphere(:,1:2)).^2))')));
	
	xMinus=XRotation(ChangeCart,-180/i^2);
	change_sphere=change_sphere_cart(xMinus, [], -1);
	mini(3)=sum(sqrt(sum((ThetaPhiMatWeight.*((ThetaPhiMatSphere-change_sphere(:,1:2)).^2))')));
	
	yPlus=YRotation(ChangeCart,180/i^2);
	change_sphere=change_sphere_cart(yPlus, [], -1);
	mini(4)=sum(sqrt(sum((ThetaPhiMatWeight.*((ThetaPhiMatSphere-change_sphere(:,1:2)).^2))')));
	
	yMinus=YRotation(ChangeCart,-180/i^2);
	change_sphere=change_sphere_cart(yMinus, [], -1);
	mini(5)=sum(sqrt(sum((ThetaPhiMatWeight.*((ThetaPhiMatSphere-change_sphere(:,1:2)).^2))')));
			
	zPlus=ZRotation(ChangeCart,180/i^2);
	change_sphere=change_sphere_cart(zPlus, [], -1);
	mini(6)=sum(sqrt(sum((ThetaPhiMatWeight.*((ThetaPhiMatSphere-change_sphere(:,1:2)).^2))')));
	
	zMinus=ZRotation(ChangeCart,-180/i^2);
	change_sphere=change_sphere_cart(zMinus, [], -1);
	mini(7)=sum(sqrt(sum((ThetaPhiMatWeight.*((ThetaPhiMatSphere-change_sphere(:,1:2)).^2))')));
		
	xPlusyPlus=YRotation(xPlus,180/i^2);
	change_sphere=change_sphere_cart(xPlusyPlus, [], -1);
	mini(8)=sum(sqrt(sum((ThetaPhiMatWeight.*((ThetaPhiMatSphere-change_sphere(:,1:2)).^2))')));
			
	xPlusyMinus=YRotation(xPlus,-180/i^2);
	change_sphere=change_sphere_cart(xPlusyMinus, [], -1);
	mini(9)=sum(sqrt(sum((ThetaPhiMatWeight.*((ThetaPhiMatSphere-change_sphere(:,1:2)).^2))')));
	
	xMinusyPlus=YRotation(xMinus,180/i^2);
	change_sphere=change_sphere_cart(xMinusyPlus, [], -1);
	mini(10)=sum(sqrt(sum((ThetaPhiMatWeight.*((ThetaPhiMatSphere-change_sphere(:,1:2)).^2))')));
		
	xMinusyMinus=YRotation(xMinus,-180/i^2);
	change_sphere=change_sphere_cart(xMinusyMinus, [], -1);
	mini(11)=sum(sqrt(sum((ThetaPhiMatWeight.*((ThetaPhiMatSphere-change_sphere(:,1:2)).^2))')));
		
	xPluszPlus=ZRotation(xPlus,180/i^2);
	change_sphere=change_sphere_cart(xPluszPlus, [], -1);
	mini(12)=sum(sqrt(sum((ThetaPhiMatWeight.*((ThetaPhiMatSphere-change_sphere(:,1:2)).^2))')));
			
	xPluszMinus=ZRotation(xPlus,-180/i^2);
	change_sphere=change_sphere_cart(xPluszMinus, [], -1);
	mini(13)=sum(sqrt(sum((ThetaPhiMatWeight.*((ThetaPhiMatSphere-change_sphere(:,1:2)).^2))')));
		
	xMinuszPlus=ZRotation(xMinus,180/i^2);
	change_sphere=change_sphere_cart(xMinuszPlus, [], -1);
	mini(14)=sum(sqrt(sum((ThetaPhiMatWeight.*((ThetaPhiMatSphere-change_sphere(:,1:2)).^2))')));
		
	xMinuszMinus=ZRotation(xMinus,-180/i^2);
	change_sphere=change_sphere_cart(xMinuszMinus, [], -1);
	mini(15)=sum(sqrt(sum((ThetaPhiMatWeight.*((ThetaPhiMatSphere-change_sphere(:,1:2)).^2))')));
			
	yPluszPlus=ZRotation(yPlus,180/i^2);
	change_sphere=change_sphere_cart(yPluszPlus, [], -1);
	mini(16)=sum(sqrt(sum((ThetaPhiMatWeight.*((ThetaPhiMatSphere-change_sphere(:,1:2)).^2))')));
		
	yPluszMinus=ZRotation(yPlus,-180/i^2);
	change_sphere=change_sphere_cart(yPluszMinus, [], -1);
	mini(17)=sum(sqrt(sum((ThetaPhiMatWeight.*((ThetaPhiMatSphere-change_sphere(:,1:2)).^2))')));
		
	yMinuszPlus=ZRotation(yMinus,180/i^2);
	change_sphere=change_sphere_cart(yMinuszPlus, [], -1);
	mini(18)=sum(sqrt(sum((ThetaPhiMatWeight.*((ThetaPhiMatSphere-change_sphere(:,1:2)).^2))')));
		
	yMinuszMinus=ZRotation(yMinus,-180/i^2);
	change_sphere=change_sphere_cart(yMinuszMinus, [], -1);
	mini(19)=sum(sqrt(sum((ThetaPhiMatWeight.*((ThetaPhiMatSphere-change_sphere(:,1:2)).^2))')));
		
	[minivalue,minindex]=min(mini);
	
	if minindex==2
		ChangeCart=xPlus;
	elseif minindex==3
		ChangeCart=xMinus;
	elseif minindex==4
		ChangeCart=yPlus;
	elseif minindex==5
		ChangeCart=yMinus;
	elseif minindex==6
		ChangeCart=zPlus;
	elseif minindex==7
		ChangeCart=zMinus;
	elseif minindex==8
		ChangeCart=xPlusyPlus;
	elseif minindex==9
		ChangeCart=xPlusyMinus;
	elseif minindex==10
		ChangeCart=xMinusyPlus;
	elseif minindex==11
		ChangeCart=xMinusyMinus;
	elseif minindex==12
		ChangeCart=xPluszPlus;
	elseif minindex==13
		ChangeCart=xPluszMinus;
	elseif minindex==14
		ChangeCart=xMinuszPlus;
	elseif minindex==15
		ChangeCart=xMinuszMinus;
	elseif minindex==16
		ChangeCart=yPluszPlus;
	elseif minindex==17
		ChangeCart=yPluszMinus;
	elseif minindex==18
		ChangeCart=yMinuszPlus;
	elseif minindex==19
		ChangeCart=yMinuszMinus;
	end
	
end
DataOutSphere=change_sphere_cart(ChangeCart, [], -1);
return;
