function [val] = CalcSymmetry(matrix, pairs, NormFlag);
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      
% Compute a measure of symmetry for every columns of a given data matrix, when a list of
% pairs of channels is provided
% Depending on "NormFlag", this measure is either the sum of differences of absolute values at
% corresponding electrodes divided by norm of the data vector ('abs'), or the sum of differences of
% the values at the corresponding electrodes, divided by the norm of the data vector ('sign'), or
% the sum of differences of the values at the corresponding electrodes, each divided by the sum
% of the absolute values at the corresponding electrodes ('lat' => lateralization index)
% OH 27.11.97, 14.12.97, MJ 31.03.98

% uses NormCol

pairs1=pairs(1,:);
pairs2=pairs(2,:);

if strcmp(NormFlag, 'abs'),			% Sum of differences of absolute values / L2-norm
   diffmat = abs(matrix(pairs1,:)) - abs(matrix(pairs2,:));
   quot = sqrt(NormCol(matrix(pairs1,:), 2) + NormCol(matrix(pairs2,:), 2));
   diffnorm = diffmat'*ones(length(diffmat(:,1)),1);
   val = diffnorm./quot;
   return;
end;

if strcmp(NormFlag, 'sign'),			% Sum of differences / L2-norm
   diffmat = matrix(pairs1,:) - matrix(pairs2,:);
   quot = sqrt(NormCol(matrix(pairs1,:), 2) + NormCol(matrix(pairs2,:), 2));
   diffnorm = diffmat'*ones(length(diffmat(:,1)),1);
   val = diffnorm./quot;
   return;
end;

if strcmp(NormFlag, 'lat'),			% Sum of (differences/(Sum of absolute values))
   diffsum = sum( matrix(pairs1,:) - matrix(pairs2,:) );
   sumsum = sum( abs(matrix(pairs1,:)) + abs(matrix(pairs2,:)) );
   val = (diffsum./sumsum)';
   return;
end;

if strcmp(NormFlag, 'znormlat') | strcmp(NormFlag, 'znormabslat'),	% Sum of (differences/(Sum of absolute values)) of z-normalized data
   matrix=matrix';
   [a,b]=size(matrix);
   matrixn=matrix;
   for i=1:a
   		mean_data=mean(matrix(i,:));
		matrixn(i,:)=matrix(i,:)-mean_data;
		std_data=std(matrixn(i,:));
		matrixn(i,:)=matrixn(i,:)./std_data;
	end
	%figure
    %subplot(2,1,1)	
	%surf(matrix)
	%subplot(2,1,2)
	%surf(matrixn)
	%pause
   matrix=matrixn';
  
   if strcmp(NormFlag, 'znormlat')
   		diffsum = sum(matrix(pairs1,:) - matrix(pairs2,:));
   elseif strcmp(NormFlag, 'znormabslat')
		diffsum = sum(abs(matrix(pairs1,:) - matrix(pairs2,:)));
   end
   sumsum = sum(abs(matrix(pairs1,:)) + abs(matrix(pairs2,:)));
   val = (diffsum./sumsum)';
   return;
end;
